/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.payhelper.FinPayTradeHelper;
import kd.occ.ocbase.business.payhelper.PayTradeHelper;
import kd.occ.ocbase.business.payhelper.PaymentFlowHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.pay.config.CheckOutCounterInfo;
import kd.occ.ocbase.common.pay.config.MiniPayResult;
import kd.occ.ocbase.common.pay.config.RefundInfo;
import kd.occ.ocbase.common.pay.config.RefundResult;
import kd.occ.ocbase.common.pay.config.TradeStatus;
import kd.occ.ocbase.common.pay.finpay.util.ResponseEnum;
import kd.occ.ocbase.common.util.ButtonFastClickUtil;
import kd.occ.ocdbd.business.helper.ticket.TicketPayHelper;
import kd.occ.ocepfp.common.entity.CallBackArgu;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.MessageCallBackEvent;
import kd.occ.ocepfp.core.form.event.PayBackEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class PosTicketOrderInfoPlugin
extends ExtBillViewPlugin {
    private static final int MIN_CLICK_DELAY_TIME = 12000;
    private static Log logger = LogFactory.getLog(PosTicketOrderInfoPlugin.class);
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ocpos-olstore-cache");
    private static final String ticketentrys = "ticketlist";
    private static final String cid_ordernumber = "ordernumber";
    private static final String cid_storename = "storename";
    private static final String cid_ordertime = "ordertime";
    private static final String cid_allqty = "allqty";
    private static final String cid_realprice = "realprice";
    private static final String cid_olinvitation = "olinvitation";
    private static final String cid_refund = "refund";

    public void afterDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        long ticketOrderId = Long.parseLong(event.getCustomParam().getString("billId"));
        ((BillFormData)this.billData).updateValue("ticketorderid", (Object)ticketOrderId);
        if (ticketOrderId != 0L) {
            logger.info("PosTicketOrderInfoPlugin afterDataLoad \u793c\u5238\u53d1\u552e\u5355\u8be6\u60c5 \u53c2\u6570\uff1a" + ticketOrderId);
            DynamicObject ticketOrder = this.queryTicketOrderDetail(ticketOrderId);
            data.set(cid_ordernumber, (Object)ticketOrder.getString("billno"));
            data.set(cid_ordertime, (Object)new SimpleDateFormat("yyyy-MM-dd").format(ticketOrder.getDate("createtime")));
            data.set(cid_olinvitation, (Object)ticketOrder.getString("olinvitateid.name"));
            data.set(cid_storename, (Object)ticketOrder.getString("branchid.name"));
            data.set(cid_allqty, (Object)("\u5171" + ticketOrder.getString("publishqty") + "\u5f20 \u9700\u4ed8\u6b3e:"));
            data.set(cid_realprice, (Object)ticketOrder.getBigDecimal("amount"));
            DynamicObjectCollection ticketInfoList = ticketOrder.getDynamicObjectCollection("entryentity");
            if (ticketOrder.get("billstatus").equals("B")) {
                ((ExtBillView)this.view).hide("paymoneybuttonpanel", false);
                ((ExtBillView)this.view).hide("buttonpanel", true);
                ((ExtBillView)this.view).hide("nobuttonpanel", true);
            } else {
                if (OlstoreTicketHelper.isHaveRecoveryTicket((DynamicObjectCollection)ticketInfoList)) {
                    ((ExtBillView)this.view).hide("buttonpanel", true);
                    ((ExtBillView)this.view).hide("nobuttonpanel", false);
                } else {
                    ((ExtBillView)this.view).hide("buttonpanel", false);
                    ((ExtBillView)this.view).hide("nobuttonpanel", true);
                }
                if (OlstoreTicketHelper.isHaveCancelTicket((DynamicObjectCollection)ticketInfoList)) {
                    ((ExtBillView)this.view).hide("buttonpanel", true);
                    ((ExtBillView)this.view).hide("nobuttonpanel", true);
                }
                ((ExtBillView)this.view).hide("paymoneybuttonpanel", true);
            }
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (int i = 0; i < ticketInfoList.size(); ++i) {
                DynamicObject ticket = ((DynamicObject)ticketInfoList.get(i)).getDynamicObject("ticketid");
                DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(ticketentrys);
                if (i == 0) {
                    ((BillFormData)this.billData).updateValue("ticketid", (Object)ticket.getString("id"));
                }
                dataObject.set("id", ticket.get("id"));
                dataObject.set("number", ticket.get("number"));
                dataObject.set("starttime", (Object)DateUtils.formatDate((Date)ticket.getDate("starttime"), (Object[])new Object[]{"yyyy-MM-dd"}));
                dataObject.set("endtime", (Object)DateUtils.formatDate((Date)ticket.getDate("endtime"), (Object[])new Object[]{"yyyy-MM-dd"}));
                dataObject.set("limitname", (Object)OlstoreUtil.getTicketApplyTerminal((int)ticket.getInt("ticketapplyterminal")));
                dataObject.set("ticketvalue", (Object)ticket.getBigDecimal("ticketvalue").setScale(2).stripTrailingZeros().toPlainString());
                long ticketTypeId = ticket.getLong("tickettypeid.id");
                DynamicObject ticketTypeDyn = BusinessDataServiceHelper.loadSingle((Object)ticketTypeId, (String)"ocdbd_ticketstype");
                dataObject.set("minconsumeamount", (Object)("\u6ee1" + ticketTypeDyn.getBigDecimal("minconsumeamount").setScale(2).stripTrailingZeros().toPlainString() + "\u5143\u4f7f\u7528"));
                collection.add((Object)dataObject);
                if (ticketTypeDyn.getInt("usagemode") == 0) {
                    ((ExtBillView)this.view).hide("cashticketpanel", false, i);
                    ((ExtBillView)this.view).hide("giftticketpanel", true, i);
                    continue;
                }
                ((ExtBillView)this.view).hide("cashticketpanel", true, i);
                ((ExtBillView)this.view).hide("giftticketpanel", false, i);
            }
            data.set(ticketentrys, (Object)collection);
        }
    }

    private DynamicObject queryTicketOrderDetail(long ticketOrderId) {
        return BusinessDataServiceHelper.loadSingle((Object)ticketOrderId, (String)"ocgcm_ticketspublish");
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        switch (eventId) {
            case "refund": {
                Long ticketorderid = ((BillFormData)this.billData).getLong("ticketorderid");
                DynamicObject ticketOrder = this.queryTicketOrderDetail(ticketorderid);
                String recyclebillno = ticketOrder.getString("recyclebillno");
                if (StringUtils.isNotBlank((CharSequence)recyclebillno)) {
                    ((ExtBillView)this.view).showMessage("\u5df2\u7ecf\u53d1\u8d77\u8fc7\u7533\u8bf7\u9000\u6b3e\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u8fdb\u884c\u9000\u6b3e");
                    return;
                }
                if (!ButtonFastClickUtil.isFastClickByTime((long)12000L)) {
                    ((ExtBillView)this.view).showMessage("\u786e\u5b9a\u8981\u5bf9\u793c\u5238\u8ba2\u5355\u53d1\u8d77\u9000\u6b3e\u5417\uff1f", MessageBoxType.YesNO, new CallBackArgu());
                    break;
                }
                ((ExtBillView)this.view).showMessage("\u5df2\u63d0\u4ea4\u7533\u8bf7\uff0c\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
                ((ExtBillView)this.view).disable(cid_refund, true);
                break;
            }
            case "paymoney": {
                String memberIdKey = "PosTicketOrderInfoPlugin_payMoneyKey" + memberId;
                if (CACHE.contains(memberIdKey)) {
                    ((ExtBillView)this.view).showMessage("\u8bf7\u52ff\u9891\u7e41\u70b9\u51fb", MessageBoxType.Toast);
                    return;
                }
                CACHE.put(memberIdKey, (Object)memberIdKey, 5);
                this.payMoney(event);
                break;
            }
        }
        super.onClick(event);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void payMoney(ClickEvent event) {
        String outTradeNo;
        long payWay;
        HashMap<String, String> map;
        BigDecimal totalrealamount;
        DynamicObject ticketOrder;
        Long customerId;
        block9: {
            CheckOutCounterInfo checkOutCounterInfo;
            block7: {
                JSONObject paramJson;
                block8: {
                    JSONObject jsonObject;
                    block6: {
                        Long ticketorderid = ((BillFormData)this.billData).getLong("ticketorderid");
                        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
                        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
                        customerId = currentStore.getLong("id");
                        ticketOrder = this.queryTicketOrderDetail(ticketorderid);
                        String saleStatus = ticketOrder.getString("salestatus");
                        if (StringUtils.equals((CharSequence)saleStatus, (CharSequence)"S")) {
                            ((ExtBillView)this.view).showMessage("\u5df2\u652f\u4ed8\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
                            return;
                        }
                        checkOutCounterInfo = new CheckOutCounterInfo();
                        checkOutCounterInfo.setBillNo(ticketOrder.getString("id") + System.currentTimeMillis());
                        checkOutCounterInfo.setBody("\u8d2d\u4e70\u4e86");
                        checkOutCounterInfo.setOperaTime(new Date());
                        checkOutCounterInfo.setSpbillCreateIp("172.0.0.1");
                        checkOutCounterInfo.setStoreId(customerId.longValue());
                        checkOutCounterInfo.setOperatorId(memberId);
                        totalrealamount = ticketOrder.getBigDecimal("amount");
                        DynamicObject olstoreCogInfo = OlstoreConfigHelper.getOlstoreConfig();
                        String appId = olstoreCogInfo.getString("appid");
                        jsonObject = OlstoreMemberHelper.queryWechatUserById((String)appId, (long)memberId);
                        paramJson = new JSONObject();
                        logger.info("queryWechatUserById\u67e5\u8be2openid\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)jsonObject));
                        if (jsonObject == null || jsonObject.getInteger("code") != 0) break block6;
                        JSONObject data = jsonObject.getJSONObject("data");
                        checkOutCounterInfo.setOpenId(data.getString("openId"));
                        map = new HashMap<String, String>(5);
                        payWay = PayTradeHelper.getOlStorePayWay((long)customerId);
                        if (PaymentModeEnum.getKey((String)"wechatpayment") != payWay) break block7;
                        break block8;
                    }
                    if (jsonObject == null) {
                        ((ExtBillView)this.view).showMessage("\u652f\u4ed8\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u662f\uff1ajsonObject is null");
                        return;
                    }
                    ((ExtBillView)this.view).showMessage("\u652f\u4ed8\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u662f\uff1a" + jsonObject.getString("message"));
                    return;
                }
                MiniPayResult miniPayData = PayTradeHelper.getMiniPayData((CheckOutCounterInfo)checkOutCounterInfo, (BigDecimal)totalrealamount);
                logger.info("PosTicketOrderPayPlugin getMiniPayData result :" + JSON.toJSONString((Object)miniPayData));
                if (!TradeStatus.SUCCESS.equals((Object)miniPayData.getTradeStatus())) {
                    ((ExtBillView)this.view).showMessage("\u5fae\u4fe1\u652f\u4ed8\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u662f\uff1a" + miniPayData.getErrorMessage());
                    return;
                }
                JSONObject payResponse = miniPayData.getPayResponse();
                paramJson.put("payResponse", (Object)payResponse);
                outTradeNo = payResponse.getString("out_trade_no");
                String tradeNo = payResponse.getString("trade_no");
                map.put("timeStamp", miniPayData.getTimeStamp());
                map.put("nonceStr", miniPayData.getNonceStr());
                map.put("package", miniPayData.getPackages());
                map.put("signType", miniPayData.getSignType());
                map.put("paySign", miniPayData.getPaySign());
                break block9;
            }
            if (PaymentModeEnum.getKey((String)"kingdeefinancepay") != payWay) {
                ((ExtBillView)this.view).showMessage("\u7ebf\u4e0a\u652f\u4ed8\u5f53\u524d\u4ec5\u652f\u6301\u5fae\u4fe1\u652f\u4ed8\u6216\u91d1\u8776\u91d1\u878d\u652f\u4ed8\uff0c\u4e14\u9700\u52fe\u9009'\u9002\u7528\u7ebf\u4e0a\u652f\u4ed8'\uff0c\u8bf7\u524d\u5f80\u540e\u53f0\u914d\u7f6e\u3002");
                return;
            }
            MiniPayResult finPayData = FinPayTradeHelper.finPay((CheckOutCounterInfo)checkOutCounterInfo, (BigDecimal)totalrealamount);
            logger.info("PosTicketOrderPayPlugin finPayData result :" + JSON.toJSONString((Object)finPayData));
            JSONObject finPay = finPayData.getPayResponse();
            logger.info("PosTicketOrderPayPlugin finPay result :" + JSON.toJSONString((Object)finPay));
            if (finPay == null) {
                ((ExtBillView)this.view).showMessage("\u91d1\u8776\u91d1\u878d\u652f\u4ed8\u63a5\u53e3\u54cd\u5e94\u5931\u8d25\uff1a");
                return;
            }
            if (!ResponseEnum.TRADE_SUCCESS.getCode().equals(finPay.getString("bizCode"))) {
                ((ExtBillView)this.view).showMessage("\u91d1\u8776\u91d1\u878d\u652f\u4ed8\u63a5\u53e3\u652f\u4ed8\u5931\u8d25\uff1a" + finPay.getString("bizMsg"));
                return;
            }
            map.put("timeStamp", finPay.getString("timeStamp"));
            map.put("nonceStr", finPay.getString("nonceStr"));
            map.put("package", finPay.getString("packages"));
            map.put("signType", finPay.getString("signType"));
            map.put("paySign", finPay.getString("paySign"));
            outTradeNo = finPay.getString("bizNo");
        }
        logger.info("payMoney prepay :" + JSON.toJSONString(map));
        List<JSONObject> params = this.buildPaySuccessParam(String.valueOf(totalrealamount), outTradeNo, "", customerId, BusinessDataServiceHelper.loadSingle((Object)payWay, (String)"ocdbd_paymode"));
        TicketPayHelper.afterPayTicketSuccess((DynamicObject)ticketOrder, params, (String)"1");
        ((ExtBillView)this.view).wxPay(map);
        logger.info("\u8ba4\u7b79\u9080\u7ea6\u652f\u4ed8- \u62c9\u8d77\u5fae\u4fe1\u652f\u4ed8");
    }

    private List<JSONObject> buildPaySuccessParam(String totalrealamount, String outTradeNo, String TradeNo, long storeId, DynamicObject payWay) {
        logger.info("\u751f\u6210\u8ba4\u7b79\u9080\u7ea6\u652f\u4ed8\u6d41\u6c34\u53c2\u6570, storeId\uff1a" + storeId);
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        if (StringUtil.isNotNull((String)outTradeNo)) {
            DynamicObject payWayType = BusinessDataServiceHelper.loadSingle((Object)960797054941170688L, (String)"ocdbd_paywaytype");
            JSONObject params = new JSONObject();
            params.put("amount", (Object)totalrealamount);
            params.put("payWay", (Object)payWay);
            params.put("orderNo", (Object)outTradeNo);
            params.put("payWayType", (Object)payWayType);
            params.put("bankExchangeNo", (Object)TradeNo);
            params.put("salebranchid", (Object)storeId);
            result.add(params);
        }
        return result;
    }

    public void onPayBack(PayBackEvent event) {
        Object payStatus = ((Map)event.getEventParam().get((Object)"pay")).get("result");
        boolean isPaysuccess = (Boolean)payStatus;
        if (isPaysuccess) {
            String ticketorderid = ((BillFormData)this.billData).getString("ticketorderid");
            String ticketid = ((BillFormData)this.billData).getString("ticketid");
            OpenParam openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setShowTitle(Boolean.TRUE);
            openParam.addCustomParam("billId", ticketorderid);
            openParam.addCustomParam("ticketId", ticketid);
            openParam.setViewId("ocpos_ticketorder_filpay");
            ((ExtBillView)this.view).showView(openParam);
        }
        super.onPayBack(event);
    }

    public void onMessageCallBack(MessageCallBackEvent event) {
        ((ExtBillView)this.view).disable(cid_refund, true);
        ((ExtBillView)this.view).showMessage("\u6b63\u5728\u9000\u6b3e\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
        Map messageBackMap = (Map)event.getEventParam().get((Object)"messageback");
        int result = messageBackMap.getOrDefault("result", 0);
        if (result == 1) {
            this.refund();
        }
        super.onMessageCallBack(event);
    }

    private void refund() {
        long start = System.currentTimeMillis();
        long ticketOrderId = ((BillFormData)this.billData).getLong("ticketorderid");
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        DynamicObject ticketOrder = this.queryTicketOrderDetail(ticketOrderId);
        if (ticketOrder != null) {
            DynamicObjectCollection ticketInfoList = ticketOrder.getDynamicObjectCollection("entryentity");
            boolean isHaveCancelTicket = OlstoreTicketHelper.isHaveCancelTicket((DynamicObjectCollection)ticketInfoList);
            if (isHaveCancelTicket) {
                ((ExtBillView)this.view).showMessage("\u9000\u6b3e\u5931\u8d25, \u539f\u56e0: \u8ba2\u5355\u4e2d\u542b\u6709\u5df2\u6838\u9500\u7684\u793c\u5238\u3002");
                return;
            }
            JSONObject jsonObject = this.buildRecycleTicketParam(ticketOrder);
            logger.info("PosTicketOrderInfoPlugin refund \u8c03\u7528\u793c\u5238\u56de\u6536\u63a5\u53e3\u53c2\u6570\uff1a" + JSON.toJSONString((Object)jsonObject));
            String memberIdKey = "PosTicketOrderInfoPlugin_refund" + memberId;
            if (CACHE.contains(memberIdKey)) {
                logger.info("PosTicketOrderInfoPlugin refund \u9632\u6b62\u91cd\u590d\u521b\u5efa\u56de\u6536\u5355\uff1a" + ticketOrderId);
                return;
            }
            CACHE.put(memberIdKey, (Object)memberIdKey, 10);
            JSONObject result = OlstoreTicketHelper.recycleTicketOrder((JSONObject)jsonObject);
            logger.info("PosTicketOrderInfoPlugin refund \u8c03\u7528\u793c\u5238\u56de\u6536\u63a5\u53e3\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)result));
            if (result != null) {
                if (result.get((Object)"code").toString().equals("success")) {
                    RefundInfo refundInfo = new RefundInfo();
                    refundInfo.setBillNo(ticketOrder.getString("billno"));
                    refundInfo.setOperaTime(new Date());
                    long storeId = ticketOrder.getLong("branchid.id");
                    refundInfo.setStoreId(storeId);
                    refundInfo.setOperatorId(memberId);
                    DynamicObjectCollection dynamicObjectCollection = ticketOrder.getDynamicObjectCollection("paymodeentry");
                    DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
                    String tradeReferenceNo = dynamicObject.getString("tradereference");
                    String outOrderNumber = dynamicObject.getString("outorderno");
                    BigDecimal refundAmount = ticketOrder.getBigDecimal("amount");
                    long payWay = PayTradeHelper.getOlStorePayWay((long)storeId);
                    if (PaymentModeEnum.getKey((String)"wechatpayment") == payWay) {
                        RefundResult refundData = PayTradeHelper.getRefundData((RefundInfo)refundInfo, (long)PaymentModeEnum.getKey((String)"wechatpayment"), (String)tradeReferenceNo, (String)outOrderNumber, (BigDecimal)refundAmount);
                        logger.info("PosTicketOrderInfoPlugin refund \u8c03\u7528\u9000\u6b3e\u63a5\u53e3\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)refundData));
                        if (TradeStatus.SUCCESS.equals((Object)refundData.getTradeStatus())) {
                            tradeReferenceNo = refundData.getRefundResponse().getString("transaction_id");
                            ((ExtBillView)this.view).showMessage("\u9000\u6b3e\u6210\u529f\u3002", MessageBoxType.Toast);
                            this.updateSaleStatus(ticketOrder, result, outOrderNumber, tradeReferenceNo);
                            this.goPage("ocpos_ticketlistm");
                        } else {
                            this.updateReturnPayInfo(ticketOrder, result, outOrderNumber, tradeReferenceNo);
                            ((ExtBillView)this.view).showMessage("\u9000\u6b3e\u5931\u8d25, \u539f\u56e0:" + refundData.getErrorMessage() + ", billId\uff1a" + result.get((Object)"billId"));
                        }
                    } else if (PaymentModeEnum.getKey((String)"kingdeefinancepay") == payWay) {
                        refundInfo.setOutTradeNo(outOrderNumber);
                        RefundResult refundResult = FinPayTradeHelper.kingDeeRefund((RefundInfo)refundInfo, (BigDecimal)refundAmount.abs());
                        logger.info("\u8ba4\u7b79\u9080\u7ea6\u9000\u6b3erefundResult :" + JSON.toJSONString((Object)refundResult));
                        TradeStatus tradestatus = refundResult.getTradeStatus();
                        StringBuilder errorMessage = new StringBuilder();
                        if (TradeStatus.SUCCESS.equals((Object)tradestatus)) {
                            JSONObject refundResponse = refundResult.getRefundResponse();
                            tradeReferenceNo = refundResponse.getString("oriPayOrgTransNo");
                            if (StringUtils.isEmpty((CharSequence)tradeReferenceNo)) {
                                tradeReferenceNo = refundResponse.getString("thirdNo");
                            }
                            logger.info("\u8ba4\u7b79\u9080\u7ea6\u9000\u6b3erefundResponse :" + JSON.toJSONString((Object)refundResponse));
                            if (ResponseEnum.TRADE_PROCESSING.getCode().equals(refundResponse.getString("bizCode"))) {
                                String tradeNo = refundResponse.getString("bizNo");
                                JSONObject tradeQuery = FinPayTradeHelper.loopQueryResult((String)tradeNo, (String)"12", (long)refundInfo.getStoreId());
                                logger.info("\u8ba4\u7b79\u9080\u7ea6\u9000\u6b3e\u67e5\u8be2tradeQuery :" + JSON.toJSONString((Object)tradeQuery) + tradeNo);
                                if (ResponseEnum.TRADE_SUCCESS.getCode().equals(tradeQuery.getString("bizCode"))) {
                                    if (StringUtils.isEmpty((CharSequence)tradeReferenceNo)) {
                                        tradeReferenceNo = refundResponse.getString("outNo");
                                    }
                                    this.updateSaleStatus(ticketOrder, result, outOrderNumber, tradeReferenceNo);
                                    ((ExtBillView)this.view).showMessage("\u9000\u6b3e\u6210\u529f\u3002", MessageBoxType.Toast);
                                    this.goPage("ocpos_ticketlistm");
                                } else {
                                    errorMessage.append(tradeQuery.get((Object)"bizMsg"));
                                    this.updateReturnPayInfo(ticketOrder, result, outOrderNumber, tradeReferenceNo);
                                    ((ExtBillView)this.view).showMessage("\u9000\u6b3e\u5931\u8d25, \u539f\u56e0:" + errorMessage + ", billId\uff1a" + result.get((Object)"billId"));
                                }
                            } else if (ResponseEnum.TRADE_SUCCESS.getCode().equals(refundResponse.getString("bizCode"))) {
                                this.updateSaleStatus(ticketOrder, result, outOrderNumber, tradeReferenceNo);
                                ((ExtBillView)this.view).showMessage("\u9000\u6b3e\u6210\u529f\u3002", MessageBoxType.Toast);
                                this.goPage("ocpos_ticketlistm");
                            } else {
                                errorMessage.append(refundResponse.get((Object)"bizMsg"));
                                this.updateReturnPayInfo(ticketOrder, result, outOrderNumber, tradeReferenceNo);
                                ((ExtBillView)this.view).showMessage("\u9000\u6b3e\u5931\u8d25, \u539f\u56e0:" + errorMessage + ", billId\uff1a" + result.get((Object)"billId"));
                            }
                        }
                    } else {
                        ((ExtBillView)this.view).showMessage("\u7ebf\u4e0a\u652f\u4ed8\u5f53\u524d\u4ec5\u652f\u6301\u5fae\u4fe1\u652f\u4ed8\u6216\u91d1\u8776\u91d1\u878d\u652f\u4ed8\uff0c\u4e14\u9700\u52fe\u9009'\u9002\u7528\u7ebf\u4e0a\u652f\u4ed8'\uff0c\u8bf7\u524d\u5f80\u540e\u53f0\u914d\u7f6e\u3002");
                        return;
                    }
                    Object billId = result.getJSONObject("data").get((Object)"id");
                    PaymentFlowHelper.afterPayTicketSuccess((Object)billId, (BigDecimal)refundAmount, (String)outOrderNumber, (String)tradeReferenceNo, (long)storeId, (long)payWay);
                } else {
                    ((ExtBillView)this.view).showMessage("\u9000\u6b3e\u5931\u8d25, \u539f\u56e0:" + result.getString("message"));
                }
            } else {
                ((ExtBillView)this.view).showMessage("\u9000\u6b3e\u5931\u8d25, \u539f\u56e0:result is null");
            }
        } else {
            ((ExtBillView)this.view).showMessage("\u8ba2\u72b6\u6001\u5355\u4e0d\u662f\u5f85\u4ed8\u6b3e\uff0c\u53d6\u6d88\u5931\u8d25\uff01");
        }
        logger.info("\u8ba4\u7b79\u9080\u7ea6\u9000\u6b3e\u8017\u65f6\u7edf\u8ba1  refund " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
    }

    private void updateSaleStatus(DynamicObject ticketOrder, JSONObject result, String outOrderNumber, String tradeReferenceNo) {
        JSONObject data = result.getJSONObject("data");
        DynamicObject ticketsReturn = BusinessDataServiceHelper.loadSingle((Object)data.getLong("id"), (String)"ocgcm_ticketsreturn");
        ticketOrder.set("recyclebillno", (Object)ticketsReturn.getString("billno"));
        ticketOrder.set("salestatus", (Object)"S");
        ticketsReturn.set("salestatus", (Object)"S");
        DynamicObjectCollection dynamicObjectCollection = ticketsReturn.getDynamicObjectCollection("ticrreturnentry");
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
        dynamicObject.set("outorderno", (Object)outOrderNumber);
        dynamicObject.set("tradereference", (Object)tradeReferenceNo);
        dynamicObject.set("paytime", (Object)new Date());
        ticketsReturn.set("ticrreturnentry", (Object)dynamicObjectCollection);
        SaveServiceHelper.update((DynamicObject)ticketOrder);
        SaveServiceHelper.update((DynamicObject)ticketsReturn);
    }

    private void updateReturnPayInfo(DynamicObject ticketOrder, JSONObject result, String outOrderNumber, String tradeReferenceNo) {
        JSONObject data = result.getJSONObject("data");
        DynamicObject ticketsReturn = BusinessDataServiceHelper.loadSingle((Object)data.getLong("id"), (String)"ocgcm_ticketsreturn");
        DynamicObjectCollection dynamicObjectCollection = ticketsReturn.getDynamicObjectCollection("ticrreturnentry");
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
        dynamicObject.set("outorderno", (Object)outOrderNumber);
        dynamicObject.set("tradereference", (Object)tradeReferenceNo);
        dynamicObject.set("paytime", (Object)TimeServiceHelper.now());
        ticketsReturn.set("ticrreturnentry", (Object)dynamicObjectCollection);
        SaveServiceHelper.update((DynamicObject)ticketsReturn);
    }

    private void goPage(String pageName) {
        OpenParam openParam = new OpenParam();
        openParam.setViewId(pageName);
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        ((ExtBillView)this.view).showView(openParam);
    }

    private JSONObject buildRecycleTicketParam(DynamicObject ticketOrder) {
        long branchId = ticketOrder.getLong("branchid.id");
        logger.info("PosTicketOrderInfoPlugin buildRecycleTicketParam \u95e8\u5e97branchId\uff1a" + branchId);
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo((long)branchId);
        Long orgId = storeInfo.getLong("saleorg");
        DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"wechatpayment"), (String)"ocdbd_paymode");
        JSONObject param = new JSONObject();
        param.put("publishbillid", (Object)((BillFormData)this.billData).getLong("ticketorderid"));
        param.put("billtypeid", (Object)1043537744187706368L);
        param.put("org", (Object)orgId);
        param.put("branchid", (Object)branchId);
        param.put("settlecurrencyid", (Object)1L);
        param.put("settleorgid", (Object)orgId);
        param.put("localcurrencyid", (Object)1);
        param.put("amount", (Object)ticketOrder.getBigDecimal("realamount"));
        ArrayList<JSONObject> ticketInfoList = new ArrayList<JSONObject>();
        DynamicObjectCollection ticketOrderList = ticketOrder.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : ticketOrderList) {
            JSONObject ticketInfo = new JSONObject();
            ticketInfo.put("ticketId", (Object)object.getLong("ticketid.id"));
            ticketInfo.put("returnAmount", (Object)ticketOrder.getBigDecimal("realamount"));
            ticketInfoList.add(ticketInfo);
        }
        param.put("ticketInfoList", ticketInfoList);
        ArrayList<JSONObject> payinfolist = new ArrayList<JSONObject>();
        JSONObject payinfo = new JSONObject();
        payinfo.put("retmodeid", payWay.getPkValue());
        payinfo.put("exchangerateid", (Object)0);
        payinfo.put("retcurrencyid", (Object)1);
        payinfo.put("retamount", (Object)ticketOrder.getBigDecimal("realamount"));
        payinfolist.add(payinfo);
        param.put("payinfolist", payinfolist);
        return param;
    }
}

