/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.text.SimpleDateFormat;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;

public class PosTicketOrderListPlugin
extends ExtListViewPlugin {
    private static final String cid_ticketorderlist = "ticketorderlist";
    private static final String cid_ordernumber = "ordernumber";
    private static final String cid_storename = "storename";
    private static final String cid_ordertime = "ordertime";
    private static final String cid_allqty = "allqty";
    private static final String cid_realprice = "realprice";
    private static final String cid_olinvitation = "olinvitation";

    public ListDataSet<DynamicObjectCollection> onDataLoad(LoadDataEvent event) {
        ListDataSet listDataSet = super.onDataLoad(event);
        String keyword = event.getFilterParam() != null && event.getFilterParam().containsKey("search") ? event.getFilterParam().get("search").toString() : event.getEventParam().getString("search");
        DynamicObjectCollection pageData = this.getTicketOrderlist(keyword);
        if (pageData != null && pageData.size() > 0) {
            listDataSet.setRows((Object)pageData);
            ((ExtListView)this.view).hide(cid_ticketorderlist, false);
            ((ExtListView)this.view).hide("order_none_panel", true);
        } else {
            ((ExtListView)this.view).hide(cid_ticketorderlist, true);
            ((ExtListView)this.view).hide("order_none_panel", false);
        }
        return listDataSet;
    }

    private DynamicObjectCollection getTicketOrderlist(String keyword) {
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        DynamicObject[] ticketOrderList = this.queryTicketOrderList(memberId);
        if (ticketOrderList != null && ticketOrderList.length > 0) {
            for (int i = 0; i < ticketOrderList.length; ++i) {
                DynamicObject ticketOrder = ticketOrderList[i];
                DynamicObject entryData = ((ListFormData)this.billData).createNewEntryDynamicObject(cid_ticketorderlist);
                entryData.set(cid_ordernumber, (Object)ticketOrder.getString("billno"));
                entryData.set(cid_ordertime, (Object)new SimpleDateFormat("yyyy-MM-dd").format(ticketOrder.getDate("createtime")));
                DynamicObjectCollection ticketInfoList = ticketOrder.getDynamicObjectCollection("entryentity");
                if (ticketOrder.get("billstatus").equals("B")) {
                    ((ExtListView)this.view).hide("paypanel", false, i);
                    ((ExtListView)this.view).hide("refundpanel", true, i);
                    ((ExtListView)this.view).hide("paidpanel", true, i);
                } else if (OlstoreTicketHelper.isHaveRecoveryTicket((DynamicObjectCollection)ticketInfoList)) {
                    ((ExtListView)this.view).hide("paypanel", true, i);
                    ((ExtListView)this.view).hide("refundpanel", false, i);
                    ((ExtListView)this.view).hide("paidpanel", true, i);
                } else {
                    ((ExtListView)this.view).hide("paypanel", true, i);
                    ((ExtListView)this.view).hide("refundpanel", true, i);
                    ((ExtListView)this.view).hide("paidpanel", false, i);
                }
                entryData.set(cid_olinvitation, (Object)ticketOrder.getString("olinvitateid.name"));
                entryData.set("id", (Object)ticketOrder.getLong("id"));
                entryData.set(cid_storename, (Object)ticketOrder.getString("branchid.name"));
                entryData.set(cid_allqty, (Object)("\u5171" + ticketOrder.getString("publishqty") + "\u5f20 \u5b9e\u4ed8\u6b3e:"));
                entryData.set(cid_realprice, (Object)ticketOrder.getBigDecimal("amount"));
                entryList.add((Object)entryData);
            }
        }
        return entryList;
    }

    private DynamicObject[] queryTicketOrderList(long memberId) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocgcm_ticketspublish");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        QFilter filter = new QFilter("entryentity.vipid", "=", (Object)memberId);
        return BusinessDataServiceHelper.load((String)"ocgcm_ticketspublish", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray(), (String)"createtime desc");
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        List selectRows = event.getSelections(cid_ticketorderlist);
        DynamicObjectCollection selectEntrys = ((ListFormData)this.getBillData()).getEntryRowData(cid_ticketorderlist, selectRows);
        switch (eventId) {
            case "todetail": 
            case "ticketpanel": {
                if (selectEntrys == null || selectEntrys.size() <= 0) break;
                OpenParam openParam = new OpenParam();
                String ticketOrderId = ((DynamicObject)selectEntrys.get(0)).getString("id");
                openParam.addCustomParam("billId", ticketOrderId);
                openParam.setViewId("ocpos_ticketorder_info");
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                ((ExtListView)this.view).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }
}

