/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.OlinvitationHelper;
import kd.occ.ocbase.common.enums.ActivityTypeEnum;
import kd.occ.ocbase.common.enums.ticket.TicketUsageModeEnum;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.BigDecimalUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class PosTicketOrderPayPlugin
extends ExtListViewPlugin
implements IBillWebApiPlugin {
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ocpos-olstore-cache");
    private static final int WAIKTING_SECONDS = 15;
    private static Log logger = LogFactory.getLog(PosTicketOrderPayPlugin.class);
    private static final int MIN_CLICK_DELAY_TIME = 8000;
    private static final String cid_activitytype = "activitytype";
    private static final String ASYN_POSTICKETPAY = "asynPosTicketPay";
    private static final String cid_tickettypelist = "tickettypelist";
    private static final String cid_thumbnail = "thumbnail";
    private static final String cid_ticketname = "ticketname";
    private static final String cid_retailprice = "retailprice";
    private static final String cid_retailpricename = "retailpricename";
    private static final String cid_ticketvalue = "ticketvalue";
    private static final String cid_currency = "currency";
    private static final String cid_ticketvaluename = "ticketvaluename";
    private static final String cid_qty = "qty";
    private static final String cid_billno = "billno";
    private static final String cid_tickettypeid = "tickettypeid";
    private static final String cid_invitationtype = "invitationtype";
    private static final String cid_olinvitationid = "olinvitationid";
    private static final String cid_amount = "amount";
    private static final String cid_name = "name";

    public ApiResult doCustomService(Map<String, Object> params) {
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u56de\u8c03\u901a\u77e5\u5f02\u5e38\u3002", (String)"MiniPayApiService_3", (String)"occ-ocdbd-webapi", (Object[])new Object[0]));
    }

    public ListDataSet<?> onDataLoad(LoadDataEvent event) {
        ListDataSet listDataSet = super.onDataLoad(event);
        String olinvitationId = event.getCustomParam().getString(cid_olinvitationid);
        String activityType = event.getCustomParam().getString(cid_activitytype);
        logger.info("\u9884\u5b58\u5238\u4e0b\u5355onDataLoad\uff1aolinvitationId\uff1a" + olinvitationId + ", activityType:" + activityType);
        ((ListFormData)this.billData).updateValue("memberid", (Object)event.getCustomParam().getString("memberid"));
        ((ListFormData)this.billData).updateValue("guideid", (Object)event.getCustomParam().getString("guideid"));
        ((ListFormData)this.billData).updateValue(cid_olinvitationid, (Object)olinvitationId);
        ((ListFormData)this.billData).updateValue(cid_invitationtype, (Object)activityType);
        ((ListFormData)this.billData).updateValue("totalamount", (Object)BigDecimal.ZERO);
        DynamicObjectCollection pageData = this.getOlinvitationById(olinvitationId, activityType);
        if (pageData.size() == 0) {
            ((ExtListView)this.view).hide("cart_none_panel", false);
            ((ExtListView)this.view).hide(cid_tickettypelist, true);
        } else {
            ((ExtListView)this.view).hide("cart_none_panel", true);
            ((ExtListView)this.view).hide(cid_tickettypelist, false);
        }
        if (pageData != null && pageData.size() > 0) {
            listDataSet.setRows((Object)pageData);
        }
        return listDataSet;
    }

    private DynamicObjectCollection getOlinvitationById(String olinvitationId, String invitationType) {
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        DynamicObject olinvitation = OlinvitationHelper.getOlinvitationById((long)Long.parseLong(olinvitationId));
        ((ListFormData)this.billData).updateValue(cid_name, (Object)olinvitation.getString(cid_name));
        DynamicObjectCollection tickettypeentry = olinvitation.getDynamicObjectCollection("tickettypeentry");
        for (int i = 0; i < tickettypeentry.size(); ++i) {
            DynamicObject entryData = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(cid_tickettypelist);
            DynamicObject ticketType = (DynamicObject)tickettypeentry.get(i);
            entryData.set(cid_ticketname, (Object)ticketType.getString("tickettypeid.name"));
            entryData.set(cid_ticketvalue, (Object)ticketType.getBigDecimal("tickettypeid.ticketvalue").stripTrailingZeros().toPlainString());
            if (TicketUsageModeEnum.ITEM_CONVERT.getName().equals(ticketType.getString("tickettypeid.usagemode"))) {
                ((ExtListView)this.view).hide(cid_ticketvalue, true, i);
                ((ExtListView)this.view).hide(cid_currency, true, i);
                ((ExtListView)this.view).hide(cid_ticketvaluename, true, i);
            } else {
                ((ExtListView)this.view).hide(cid_ticketvalue, false, i);
                ((ExtListView)this.view).hide(cid_currency, false, i);
                ((ExtListView)this.view).hide(cid_ticketvaluename, false, i);
            }
            entryData.set("id", (Object)ticketType.getString("tickettypeid.id"));
            entryData.set(cid_qty, (Object)BigDecimal.ONE);
            DynamicObject ticketTypeDyn = BusinessDataServiceHelper.loadSingle((Object)ticketType.getString("tickettypeid.id"), (String)"ocdbd_ticketstype");
            String ticketstyle = ticketTypeDyn.getString("ticketstyle");
            if (StringUtils.isNotBlank((CharSequence)ticketstyle)) {
                entryData.set(cid_thumbnail, (Object)ticketstyle);
            } else {
                entryData.set(cid_thumbnail, (Object)"/static/image/olstore/ticketstyle.png");
            }
            if (!invitationType.equals(ActivityTypeEnum.CASHORGIFTTICKET.getValue())) {
                entryData.set(cid_billno, (Object)(cid_billno + i));
                entryData.set(cid_amount, (Object)ticketType.getBigDecimal("saleamount"));
            } else {
                entryData.set(cid_billno, (Object)cid_billno);
                entryData.set(cid_amount, (Object)olinvitation.getBigDecimal("tickettotalprice"));
            }
            entryList.add((Object)entryData);
        }
        return entryList;
    }

    protected void onRowSelected(SelectAllEvent event) {
        DynamicObjectCollection selectdata = ((ListFormData)this.getBillData()).getEntryRowData(cid_tickettypelist, event.getSelections());
        if (selectdata != null && selectdata.size() > 0) {
            this.countTotalAmount((List<DynamicObject>)selectdata);
            return;
        }
        ((ListFormData)this.getBillData()).updateValue("totalamount", (Object)BigDecimal.ZERO);
        super.onRowSelected(event);
    }

    private void countTotalAmount(List<DynamicObject> selectedArray) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        String invitationType = ((ListFormData)this.billData).getString(cid_invitationtype);
        for (DynamicObject object : selectedArray) {
            BigDecimal qty;
            BigDecimal amount;
            if (!invitationType.equals(ActivityTypeEnum.CASHORGIFTTICKET.getValue())) {
                amount = object.getBigDecimal(cid_amount);
                qty = object.getBigDecimal(cid_qty);
                totalAmount = totalAmount.add(amount.multiply(qty));
                continue;
            }
            amount = ((ListFormData)this.getBillData()).getCurrentSelectedRowData().getBigDecimal(cid_amount);
            qty = ((ListFormData)this.getBillData()).getCurrentSelectedRowData().getBigDecimal(cid_qty);
            totalAmount = amount.multiply(qty);
        }
        ((ListFormData)this.getBillData()).updateValue("totalamount", (Object)totalAmount);
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "qty": {
                int row = event.getRow();
                ((ExtListView)this.view).setRowSelection(cid_tickettypelist, row, true);
                DynamicObject currentRow = ((ListFormData)this.getBillData()).getEntryRowData(cid_tickettypelist, row);
                BigDecimal qty = BigDecimalUtil.toBigDecimal((Object)event.getValue());
                Map selections = (Map)event.getEventParam().get((Object)"selections");
                if (selections == null || selections.size() <= 0) break;
                List selectMap = (List)selections.get(cid_tickettypelist);
                ArrayList<DynamicObject> selectEntry = new ArrayList<DynamicObject>();
                for (Map select : selectMap) {
                    row = Integer.parseInt(select.get("row").toString());
                    if (row != event.getRow()) {
                        selectEntry.add(((ListFormData)this.getBillData()).getEntryRowData(cid_tickettypelist, row));
                        continue;
                    }
                    currentRow.set(cid_qty, (Object)qty);
                    selectEntry.add(currentRow);
                }
                this.countTotalAmount(selectEntry);
                break;
            }
        }
        super.onDataChange(event);
    }

    protected void onClick(ClickEvent event) {
        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
        Long customerId = currentStore.getLong("id");
        String eventId = event.getId();
        logger.info("\u8ba4\u7b79\u9080\u7ea6\u95e8\u5e97id\uff1a" + customerId);
        switch (eventId) {
            case "thumbnail": {
                break;
            }
            case "settleaccount": {
                long olinvitationId = ((ListFormData)this.billData).getLong(cid_olinvitationid);
                String invitationType = ((ListFormData)this.billData).getString(cid_invitationtype);
                DynamicObject olinvitation = OlinvitationHelper.getOlinvitationById((long)olinvitationId);
                String suMemberId = ((ListFormData)this.billData).getString("memberid");
                long memberId = StringUtils.isNotBlank((CharSequence)suMemberId) ? Long.parseLong(suMemberId) : ((ExtListView)this.getView()).getExtCtx().getMemberId();
                QFilter publishFilter = new QFilter("olinvitateid.id", "=", (Object)olinvitationId);
                publishFilter.and("entryentity.ticketid.vipid", "=", (Object)memberId);
                DynamicObjectCollection publishDynArr = QueryServiceHelper.query((String)"ocgcm_ticketspublish", (String)"id,billstatus,billno,entryentity.ticketid.id,entryentity.ticketid.ticketstatus", (QFilter[])publishFilter.toArray());
                if (publishDynArr != null && publishDynArr.size() > 0) {
                    ((ExtListView)this.view).showMessage("\u60a8\u5df2\u53c2\u4e0e\u8be5\u8ba4\u7b79\u9080\u7ea6\u6d3b\u52a8\u3002", MessageBoxType.Toast);
                    return;
                }
                String olinvitationIdKey = String.valueOf(memberId) + String.valueOf(olinvitationId);
                String memberIdKey = "PosTicketOrderPayPlugin_payMoneyKey" + memberId;
                if (CACHE.contains(memberIdKey)) {
                    ((ExtListView)this.view).showMessage("\u8bf7\u52ff\u9891\u7e41\u70b9\u51fb", MessageBoxType.Toast);
                    return;
                }
                CACHE.put(memberIdKey, (Object)memberIdKey, 4);
                if (CACHE.contains(olinvitationIdKey)) {
                    return;
                }
                CACHE.put(olinvitationIdKey, (Object)olinvitationIdKey, 30);
                DynamicObjectCollection ticketTypes = ((ListFormData)this.getBillData()).getEntryRowData(cid_tickettypelist, event.getSelections());
                List selectionRowIds = event.getSelectionRowIds();
                if (ticketTypes == null || ticketTypes.size() == 0) {
                    ((ExtListView)this.view).showMessage("\u8bf7\u52fe\u9009\u9700\u8d2d\u4e70\u7684\u793c\u5238\u3002");
                    return;
                }
                HashMap<String, BigDecimal> priceMap = new HashMap<String, BigDecimal>(10);
                DynamicObjectCollection tickettypeentry = olinvitation.getDynamicObjectCollection("tickettypeentry");
                for (int i = 0; i < tickettypeentry.size(); ++i) {
                    DynamicObject ticketType = (DynamicObject)tickettypeentry.get(i);
                    priceMap.put(ticketType.getString("tickettypeid.id"), ticketType.getBigDecimal("saleamount"));
                }
                BigDecimal totalrealamount = BigDecimal.ZERO;
                if (invitationType.equals(ActivityTypeEnum.CASHORGIFTTICKET.getValue())) {
                    totalrealamount = olinvitation.getBigDecimal("tickettotalprice");
                } else {
                    for (DynamicObject object : ticketTypes) {
                        BigDecimal amount = (BigDecimal)priceMap.get(object.getString("id"));
                        if (amount == null) {
                            ((ExtListView)this.view).showMessage("\u8be5\u793c\u5238\u6ca1\u6709\u914d\u7f6e\u4ef7\u683c\u3002", MessageBoxType.Toast);
                            return;
                        }
                        totalrealamount = totalrealamount.add(amount);
                    }
                }
                String guideId = ((ListFormData)this.billData).getString("guideid");
                JSONObject paramJson = new JSONObject();
                paramJson.put("memberId", (Object)memberId);
                paramJson.put("suMemberId", (Object)suMemberId);
                paramJson.put("guideId", (Object)guideId);
                paramJson.put("olinvitationId", (Object)olinvitationId);
                paramJson.put("customerId", (Object)customerId);
                paramJson.put("totalrealamount", (Object)totalrealamount);
                long startTime = System.currentTimeMillis();
                JSONObject result = OlstoreTicketHelper.afterTicketPaySuccess((JSONObject)paramJson, (DynamicObjectCollection)this.getTicketType(selectionRowIds));
                logger.info("\u8ba4\u7b79\u9080\u7ea6\u652f\u4ed8\u8017\u65f6afterTicketPaySuccess\uff1a" + (System.currentTimeMillis() - startTime) + " \u6beb\u79d2");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_ticketorder_info");
                String billId = result.getString("billId");
                openParam.addCustomParam("billId", billId);
                openParam.setEnabelHistory(false);
                ((ExtListView)this.view).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    private DynamicObjectCollection getTicketType(List<Integer> selectionRowIds) {
        if (selectionRowIds != null) {
            DynamicObjectCollection result = new DynamicObjectCollection();
            for (Integer row : selectionRowIds) {
                DynamicObject entryRowData = ((ListFormData)this.getBillData()).getEntryRowData(cid_tickettypelist, row.intValue());
                result.add((Object)entryRowData);
            }
            return result;
        }
        return new DynamicObjectCollection();
    }

    private void putCacheFactory(JSONObject paramJson, Long customerId, String outTradeNo, String tradeNo, String totalrealamount, long payWay) {
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        String suMemberId = ((ListFormData)this.billData).getString("memberid");
        String guideId = ((ListFormData)this.billData).getString("guideid");
        long olinvitationId = ((ListFormData)this.billData).getLong(cid_olinvitationid);
        paramJson.put("memberId", (Object)memberId);
        paramJson.put("suMemberId", (Object)suMemberId);
        paramJson.put("guideId", (Object)guideId);
        paramJson.put("olinvitationId", (Object)olinvitationId);
        paramJson.put("customerId", (Object)customerId);
        paramJson.put("outTradeNo", (Object)outTradeNo);
        paramJson.put("tradeNo", (Object)tradeNo);
        paramJson.put("totalrealamount", (Object)totalrealamount);
        paramJson.put("payWay", (Object)payWay);
    }
}

