/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.business.helper.OlinvitationHelper;
import kd.occ.ocbase.common.enums.TicketStatusEnum;
import kd.occ.ocdbd.business.helper.ticket.TicketPayHelper;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.CustomEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;
import org.apache.commons.lang3.StringUtils;

public class PosTicketOrderPayWaitingPlugin
extends ExtBillViewPlugin {
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ocpos-olstore-cache");
    private static Log logger = LogFactory.getLog(PosTicketOrderPayWaitingPlugin.class);
    private static final String cid_activitytype = "activitytype";
    private static final String cid_invitationtype = "invitationtype";
    private static final String cid_olinvitationid = "olinvitationid";

    public DynamicObject onDataLoad(LoadDataEvent event) {
        String olinvitationId = event.getCustomParam().getString(cid_olinvitationid);
        String activityType = event.getCustomParam().getString(cid_activitytype);
        ((BillFormData)this.billData).updateValue("memberid", (Object)event.getCustomParam().getString("memberid"));
        ((BillFormData)this.billData).updateValue("guideid", (Object)event.getCustomParam().getString("guideid"));
        ((BillFormData)this.billData).updateValue(cid_olinvitationid, (Object)olinvitationId);
        ((BillFormData)this.billData).updateValue(cid_invitationtype, (Object)activityType);
        ((BillFormData)this.billData).updateValue("totalamount", (Object)BigDecimal.ZERO);
        logger.info("\u9884\u5b58\u5238\u4e0b\u5355\u7b49\u5f85onDataLoad\uff1aolinvitationId\uff1a" + olinvitationId + ", activityType:" + activityType);
        PageCache pageCache = new PageCache(((ExtBillView)this.view).getPageId());
        pageCache.put(cid_olinvitationid, olinvitationId);
        pageCache.put(cid_invitationtype, activityType);
        pageCache.put("memberid", event.getCustomParam().getString("memberid"));
        pageCache.put("guideid", event.getCustomParam().getString("guideid"));
        ((ExtBillView)this.view).addCustomEvent(new CustomEvent("asynInventory"));
        return super.onDataLoad(event);
    }

    protected void onCustomEvent(CustomEvent event) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
        String customerId = currentStore.getString("id");
        String outTradeNoKey = memberId + "outTradeNo";
        String tradeNoKey = memberId + "tradeNo";
        String selectionStrKey = memberId + "ticketypeids";
        String totalrealamountKey = memberId + "totalrealamount";
        String payWayKey = memberId + "payWay";
        String outTradeNo = (String)CACHE.get(outTradeNoKey);
        String tradeNo = (String)CACHE.get(tradeNoKey);
        String tickeTypeIds = (String)CACHE.get(selectionStrKey);
        String totalrealamount = (String)CACHE.get(totalrealamountKey);
        String payWay = (String)CACHE.get(payWayKey);
        logger.info("\u9884\u5b58\u5238\u4e0b\u5355\u7b49\u5f85\uff1aoutTradeNoKey\uff1a" + outTradeNoKey + ", customerId:" + customerId + ",outTradeNo:" + outTradeNo + ",tradeNo:" + tradeNo + ",tickeTypeIds:" + tickeTypeIds + ",totalrealamount:" + totalrealamount + ",payWay:" + payWay);
        this.afterTicketPaySuccess(Long.parseLong(customerId), outTradeNo, tradeNo, tickeTypeIds, totalrealamount, Long.parseLong(payWay));
        super.onCustomEvent(event);
    }

    protected void afterTicketPaySuccess(long storeId, String outTradeNo, String tradeNo, String tickeTypeIdsStr, String totalrealamount, long payWayId) {
        List<String> tickeTypeIds = Arrays.asList(tickeTypeIdsStr.split(","));
        DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)payWayId, (String)"ocdbd_paymode");
        HashMap hashMap = this.buildTicketInfoParam(storeId, tickeTypeIds);
        logger.info("\u5236\u5238OlstoreTicketHelper.buildTicketInfo\u53c2\u6570\uff1a" + hashMap);
        long start = System.currentTimeMillis();
        JSONObject jsonObject = OlstoreTicketHelper.buildTicketInfo((HashMap)hashMap);
        logger.info("\u8ba4\u7b79\u9080\u7ea6\u4e0b\u5355\u8017\u65f6\u7edf\u8ba1  \u5236\u5238 OlstoreTicketHelper.buildTicketInfo consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        logger.info("\u5236\u5238OlstoreTicketHelper.buildTicketInfo ticketInfos\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)jsonObject));
        if (jsonObject.getBoolean("success").booleanValue()) {
            JSONArray ticketInfos = jsonObject.getJSONArray("data");
            JSONObject publicParam = this.buildPublicParam(storeId, ticketInfos, (Long)payWay.getPkValue(), outTradeNo, tradeNo, totalrealamount);
            logger.info("\u521b\u5efa\u793c\u5238\u53d1\u552e\u5355OlstoreTicketHelper.buildPublicParam\u53c2\u6570\uff1a" + publicParam);
            start = System.currentTimeMillis();
            JSONObject ticketResult = OlstoreTicketHelper.publish((JSONObject)publicParam);
            logger.info("\u8ba4\u7b79\u9080\u7ea6\u4e0b\u5355\u8017\u65f6\u7edf\u8ba1  \u521b\u5efa\u53d1\u8d27\u5355 OlstoreTicketHelper.publish consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            logger.info("\u521b\u5efa\u793c\u5238\u53d1\u552e\u5355OlstoreTicketHelper.publish\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)ticketResult));
            if (ticketResult.get((Object)"code").toString().equals("success")) {
                String billId = ticketResult.getJSONArray("data").getJSONObject(0).getString("publishBillID");
                logger.info("\u8ba4\u7b79\u9080\u7ea6\u4e0b\u5355\u9875\u9762,\u793c\u5238\u53d1\u552e\u5355 billId:" + billId);
                List<JSONObject> params = this.buildPaySuccessParam(totalrealamount, outTradeNo, tradeNo, storeId, payWay);
                DynamicObject ticketOrder = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocgcm_ticketspublish");
                start = System.currentTimeMillis();
                TicketPayHelper.afterPayTicketSuccess((DynamicObject)ticketOrder, params, (String)"1");
                logger.info("\u8ba4\u7b79\u9080\u7ea6\u4e0b\u5355\u8017\u65f6\u7edf\u8ba1  \u652f\u4ed8\u540e\u751f\u6210\u6b63\u5411\u6d41\u7a0b TicketPayHelper.afterPayTicketSuccess consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
                this.openPaySuccessView(billId, ticketInfos.getJSONObject(0).getString("id"));
            } else {
                ((ExtBillView)this.view).showMessage("\u521b\u5efa\u793c\u5238\u53d1\u552e\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + ticketResult.getString("message"));
            }
        } else {
            logger.info("\u5236\u5238OlstoreTicketHelper.buildTicketInfo\u7ed3\u679c\u662f\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + jsonObject.get((Object)"message"));
            ((ExtBillView)this.view).showMessage("\u5236\u4f5c\u793c\u5238\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + jsonObject.get((Object)"message"));
        }
    }

    private List<JSONObject> buildPaySuccessParam(String totalrealamount, String outTradeNo, String TradeNo, long storeId, DynamicObject payWay) {
        logger.info("\u751f\u6210\u8ba4\u7b79\u9080\u7ea6\u652f\u4ed8\u6d41\u6c34\u53c2\u6570, storeId\uff1a" + storeId);
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        if (StringUtil.isNotNull((String)outTradeNo)) {
            DynamicObject payWayType = BusinessDataServiceHelper.loadSingle((Object)960797054941170688L, (String)"ocdbd_paywaytype");
            JSONObject params = new JSONObject();
            params.put("amount", (Object)totalrealamount);
            params.put("payWay", (Object)payWay);
            params.put("orderNo", (Object)outTradeNo);
            params.put("payWayType", (Object)payWayType);
            params.put("bankExchangeNo", (Object)TradeNo);
            params.put("salebranchid", (Object)storeId);
            result.add(params);
        }
        return result;
    }

    private JSONObject buildPublicParam(long customerId, JSONArray ticketInfos, Long payModeId, String outTradeNo, String tradeNo, String totalrealamount) {
        ArrayList<JSONObject> ticketInfoList;
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        PageCache pageCache = ((ExtBillView)this.view).getPageCache();
        String suMemberId = pageCache.get("memberid");
        String guideId = pageCache.get("guideid");
        JSONObject object = new JSONObject();
        logger.info("buildPublicParam\u4ee3\u8ba4\u7b79suMemberId\uff1a" + suMemberId + ",guideId:" + guideId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{suMemberId})) {
            memberId = Long.parseLong(suMemberId);
            object.put("billtypeid", (Object)"1150528958178174976");
        } else {
            object.put("billtypeid", (Object)"1150524802763761664");
        }
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo((long)customerId);
        String orgId = storeInfo.getString("saleorg");
        long olinvitationId = ((BillFormData)this.billData).getLong(cid_olinvitationid);
        logger.info("buildPublicPaoram olinvitationId:" + olinvitationId);
        object.put("org", (Object)orgId);
        object.put("localcurrencyid", (Object)1);
        object.put("settlecurrencyid", (Object)1);
        object.put("settleorgid", (Object)orgId);
        object.put("branchid", (Object)customerId);
        object.put("olinvitateid", (Object)olinvitationId);
        object.put("salesmanid", (Object)guideId);
        if (!CollectionUtils.isEmpty((Collection)ticketInfos)) {
            ticketInfoList = new ArrayList(ticketInfos.size());
            BigDecimal realsaleamount = new BigDecimal(totalrealamount).divide(new BigDecimal(ticketInfos.size()));
            for (int i = 0; i < ticketInfos.size(); ++i) {
                JSONObject ticketInfo = new JSONObject();
                ticketInfo.put("ticketid", (Object)ticketInfos.getJSONObject(i).getString("id"));
                ticketInfo.put("vipid", (Object)memberId);
                ticketInfo.put("realsaleamount", (Object)realsaleamount);
                ticketInfo.put("tickettypeid", (Object)ticketInfos.getJSONObject(i).getString("ticketTypeID"));
                ticketInfoList.add(ticketInfo);
            }
        } else {
            ticketInfoList = new ArrayList<JSONObject>();
        }
        object.put("ticketInfoList", ticketInfoList);
        ArrayList<JSONObject> payinfolist = new ArrayList<JSONObject>();
        JSONObject pay = new JSONObject();
        pay.put("paymodeid", (Object)payModeId);
        pay.put("payamount", (Object)new BigDecimal(totalrealamount));
        pay.put("outorderno", (Object)outTradeNo);
        pay.put("tradereferenceno", (Object)tradeNo);
        payinfolist.add(pay);
        object.put("payinfolist", payinfolist);
        return object;
    }

    private HashMap buildTicketInfoParam(long customerId, List<String> tickeTypeIds) {
        HashMap resultMap = new HashMap();
        PageCache pageCache = ((ExtBillView)this.view).getPageCache();
        String olinvitationId = pageCache.get(cid_olinvitationid);
        String suMemberId = pageCache.get("memberid");
        logger.info("buildTicketInfoParam\u4ee3\u8ba4\u7b79suMemberId\uff1a" + suMemberId + ", olinvitationId:" + olinvitationId);
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{suMemberId})) {
            memberId = Long.parseLong(suMemberId);
        }
        DynamicObject olinvitation = OlinvitationHelper.getOlinvitationById((long)Long.parseLong(olinvitationId));
        DynamicObjectCollection tickettypeentry = olinvitation.getDynamicObjectCollection("tickettypeentry");
        HashMap<String, BigDecimal> saleAmountMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < tickettypeentry.size(); ++i) {
            DynamicObject ticketType = (DynamicObject)tickettypeentry.get(i);
            saleAmountMap.put(ticketType.getString("tickettypeid.id"), ticketType.getBigDecimal("saleamount"));
        }
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo((long)customerId);
        String orgId = storeInfo.getString("saleorg");
        for (String ticketTypeID : tickeTypeIds) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("tickettypeid", Long.parseLong(ticketTypeID));
            hashMap.put("qty", BigDecimal.ONE);
            hashMap.put("ticketstatus", TicketStatusEnum.NO_MAKE.getName());
            hashMap.put("realsaleamount", saleAmountMap.get(ticketTypeID));
            hashMap.put("vipid", memberId);
            hashMap.put("bizorgid", orgId);
            hashMap.put("comment", "\u7ebf\u4e0a\u95e8\u5e97-\u8ba4\u7b79\u9080\u7ea6");
            hashMap.put("olinvitateid", olinvitationId);
            resultMap.put("ticketinfo_" + ticketTypeID, hashMap);
        }
        return resultMap;
    }

    protected void openPaySuccessView(String billId, String ticketid) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId("ocpos_ticketorder_filpay");
        openParam.addCustomParam("billId", billId);
        openParam.addCustomParam("ticketId", ticketid);
        openParam.setEnabelHistory(false);
        ((ExtBillView)this.getView()).showView(openParam);
    }
}

