/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class PosWindowItemListPlugin
extends ExtListViewPlugin {
    private static final String itementrys = "goodslist";

    public ListDataSet<DynamicObjectCollection> onDataLoad(LoadDataEvent event) {
        ListDataSet listDataSet = super.onDataLoad(event);
        Long customerId = OlstoreUtil.getCurrentStore((ClientEvent)event).getLong("id");
        String windowName = event.getCustomParam().getString("windowname");
        String[] split = windowName.split("_");
        Date olsWindowEndTime = OlstoreConfigHelper.getOlsWindowEndTime((String)split[0]);
        ((ListFormData)this.getBillData()).updateValue("windowname", (Object)split[1]);
        if (olsWindowEndTime.getTime() < new Date().getTime()) {
            ((ExtListView)this.view).startCountDown("countdowntime", 0L);
        } else {
            long reTime = olsWindowEndTime.getTime() - new Date().getTime();
            ((ExtListView)this.view).startCountDown("countdowntime", reTime / 1000L);
        }
        Map itemWindowMap = OlstoreConfigHelper.getOlsWindowList((long)customerId, (int)(event.getPage() - 1), (int)event.getPageSize());
        List itemlist = (List)itemWindowMap.get(windowName);
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        for (JSONObject jsonObject : itemlist) {
            DynamicObject dataObject = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            dataObject.set("id", (Object)jsonObject.getLong("itemid"));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + jsonObject.get((Object)"thumbnail")));
            dataObject.set("itemname", jsonObject.get((Object)"itemname"));
            dataObject.set("barcodeid", jsonObject.get((Object)"barcodeid"));
            dataObject.set("taxprice", (Object)jsonObject.getBigDecimal("memberprice"));
            entryList.add((Object)dataObject);
        }
        if (entryList != null && entryList.size() > 0) {
            listDataSet.setRows((Object)entryList);
        }
        return listDataSet;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "itempanel": {
                DynamicObject entryRowData = ((ListFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_itemdetails");
                openParam.addCustomParam("itemid", String.valueOf(entryRowData.get("id")));
                openParam.addCustomParam("barcodeid", String.valueOf(entryRowData.get("barcodeid")));
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
            case "searchpanel": {
                ((ExtListView)this.view).hide("searchhistory", false);
                ((ExtListView)this.view).hide(itementrys, true);
                break;
            }
        }
        super.onClick(event);
    }
}

