/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import kd.occ.ocpos.common.util.StringUtil;

public class PurchaseInfoListMobPlugin
extends ExtListViewPlugin {
    private static final String cid_purchaselist = "purchaselist";
    private static final String cid_storename = "storename";
    private static final String cid_totalqty = "totalqty";
    private static final String cid_totalamount = "totalamount";
    private static final String cid_billno = "billno";
    private static final String cid_id = "id";
    private static final String cid_thumbnail = "thumbnail";
    private static final int maximgindex = 20;

    public ListDataSet<?> onDataLoad(LoadDataEvent event) {
        boolean isHaveData;
        ListDataSet listDataSet = super.onDataLoad(event);
        String startdate = event.getCustomParam().getString("startdate");
        String enddate = event.getCustomParam().getString("enddate");
        DynamicObjectCollection pageDate = this.getPurchaseInfoList(event.getPage(), event.getPageSize(), startdate, enddate);
        boolean bl = isHaveData = pageDate.size() > 0;
        if (isHaveData) {
            listDataSet.setRows((Object)pageDate);
        }
        ((ExtListView)this.view).hide(cid_purchaselist, !isHaveData);
        ((ExtListView)this.view).hide("purchaselist_none_panel", isHaveData);
        return listDataSet;
    }

    private DynamicObjectCollection getPurchaseInfoList(int page, int pageSize, String startDate, String endDate) {
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        dataMap.put("member", memberId);
        dataMap.put("orderStatus", "E");
        dataMap.put("startTime", StringUtil.isNotNull((String)startDate) ? startDate : LocalDate.now().minusYears(1L).format(DateTimeFormatter.ISO_LOCAL_DATE));
        dataMap.put("endTime", StringUtil.isNotNull((String)endDate) ? endDate : LocalDate.now().plusDays(1L).format(DateTimeFormatter.ISO_LOCAL_DATE));
        dataMap.put("pageSize", pageSize);
        dataMap.put("pageIndex", page - 1);
        DynamicObject[] orderList = SaleOrderDBHelper.querySaleOrderList(dataMap);
        if (orderList == null || orderList.length == 0) {
            return new DynamicObjectCollection();
        }
        AtomicInteger autoRow = new AtomicInteger(0);
        for (DynamicObject data : orderList) {
            int rowid = autoRow.getAndIncrement();
            BigDecimal totalqty = BigDecimal.ZERO;
            BigDecimal totalamount = BigDecimal.ZERO;
            DynamicObjectCollection itemList = data.getDynamicObjectCollection("goodsentryentity");
            if (itemList == null || itemList.size() == 0) continue;
            String billno = data.getString(cid_billno);
            String storeName = data.getString("salebranchid.name");
            String id = data.getString(cid_id);
            AtomicInteger autoIndex = new AtomicInteger(1);
            DynamicObject entryData = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(cid_purchaselist);
            for (DynamicObject item : itemList) {
                int index = autoIndex.getAndIncrement();
                if (index <= 20) {
                    entryData.set(cid_thumbnail + index, (Object)item.getString("goodsid.thumbnail"));
                    ((ExtListView)this.view).hide(cid_thumbnail + index, false, rowid);
                }
                totalqty = totalqty.add(item.getBigDecimal("saleqty"));
                totalamount = totalamount.add(item.getBigDecimal("saleqty").multiply(item.getBigDecimal("discountprice")));
            }
            entryData.set(cid_id, (Object)id);
            entryData.set(cid_storename, (Object)storeName);
            entryData.set(cid_billno, (Object)billno);
            entryData.set(cid_totalqty, (Object)totalqty.stripTrailingZeros().toPlainString());
            entryData.set(cid_totalamount, (Object)totalamount.stripTrailingZeros().toPlainString());
            entryList.add((Object)entryData);
        }
        return entryList;
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        if ("imggroup1".equals(eventId)) {
            OpenParam openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setShowTitle(Boolean.TRUE);
            openParam.setViewId("ocpos_orderdetail");
            DynamicObject entryRowData = ((ListFormData)this.getBillData()).getEntryRowData(cid_purchaselist, event.getCurrentRow());
            openParam.addCustomParam("billId", String.valueOf(entryRowData.get(cid_id)));
            openParam.addCustomParam("sourceviewid", "ocpos_purchaseinfolistm");
            ((ExtListView)this.getView()).showView(openParam);
        }
        super.onClick(event);
    }
}

