/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.common.util.DateUtil;

public class PurchaseSearchMobPlugin
extends ExtBillViewPlugin {
    private static final String searchbtn = "searchbtn";
    private static final String startdate = "startdate";
    private static final String enddate = "enddate";

    public DynamicObject onDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        data.set(startdate, (Object)DateUtil.asDate((LocalDate)LocalDate.now()));
        data.set(enddate, (Object)DateUtil.asDate((LocalDate)LocalDate.now()));
        return data;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "searchbtn": {
                Date searchStart = ((BillFormData)this.getBillData()).getDate(startdate);
                Date searchEnd = DateUtil.getBeforeDay((Date)new Date(), (int)-1);
                if (searchStart == null || searchEnd == null) break;
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                openParam.addCustomParam(startdate, simpleDateFormat.format(searchStart));
                openParam.addCustomParam(enddate, simpleDateFormat.format(searchEnd));
                openParam.setViewId("ocpos_purchaseinfolistm");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }
}

