/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.service.admindivision.AdminDivisionHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class StoreInfoMobPlugin
extends ExtBillViewPlugin {
    private static final String cid_storepic = "storepic";
    private static final String cid_storeid = "storeid";
    private static final String cid_storename = "storename";
    private static final String cid_storeaddress = "storeaddress";
    private static final String cid_storetime = "storetime";
    private static final String cid_phone = "phone";
    private static final String cid_longitude = "longitude";
    private static final String cid_latitude = "latitude";

    public DynamicObject onDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        long storeid = event.getCustomParam().getLong(cid_storeid);
        DynamicObject store = OlstoreStoreInfoHelper.getStoreInfo((long)storeid);
        if (store != null) {
            data.set(cid_storepic, (Object)PictureUtil.getServerPictureUrl((String)store.getString("logo")));
            data.set(cid_storeid, (Object)(storeid + ""));
            data.set(cid_storename, store.get("name"));
            long districtid = store.getLong("area");
            String districtName = AdminDivisionHelper.getDivisionName((long)districtid);
            data.set(cid_storeaddress, (Object)(districtName + store.get("address")));
            data.set(cid_longitude, (Object)store.getString(cid_longitude));
            data.set(cid_latitude, (Object)store.getString(cid_latitude));
            ((ExtBillView)this.view).updateFrontValue(cid_phone, (Object)store.getString(cid_phone));
            if (StringUtils.isNotBlank((CharSequence)store.getString(cid_phone))) {
                ((ExtBillView)this.view).hide("phone_pic", false);
            } else {
                ((ExtBillView)this.view).hide("phone_pic", true);
            }
        }
        return data;
    }

    private String getStoreOpenTime(long startTime, long endTime) {
        String result = startTime > 0L ? DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.ofSecondOfDay(startTime)) : "00:00:00";
        result = result + " - ";
        result = result + (endTime > 0L && endTime <= 86399L ? DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.ofSecondOfDay(endTime)) : "23:59:59");
        return result;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "showitem": {
                JSONObject storeJson = new JSONObject();
                storeJson.put("id", (Object)((BillFormData)this.getBillData()).getString(cid_storeid));
                storeJson.put("name", (Object)((BillFormData)this.getBillData()).getString(cid_storename));
                OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_mall");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }
}

