/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SelectedRow;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;

public class StoreSelecListMobPlugin
extends ExtListViewPlugin {
    private static final String cid_storelist = "storelist";
    private static final String cid_storepic = "storepic";
    private static final String cid_storename = "storename";
    private static final String cid_storeaddress = "storeaddress";
    private static final String cid_storetime = "storetime";
    private static final String cid_storeinfo_pic = "storeinfo_pic";
    private static final String cid_longitude = "longitude";
    private static final String cid_latitude = "latitude";
    protected static Log logger = LogFactory.getLog(StoreSelecListMobPlugin.class);

    public ListDataSet<DynamicObjectCollection> onDataLoad(LoadDataEvent event) {
        BigDecimal longitude;
        SimpleMap localStorage;
        BigDecimal latitude;
        ListDataSet listDataSet = super.onDataLoad(event);
        long currentStoreId = OlstoreUtil.getStoreId((ClientEvent)event);
        DynamicObjectCollection pageData = this.getStoreList(currentStoreId, latitude = (localStorage = event.getLocalStorage()).getBigDecimal(cid_latitude), longitude = localStorage.getBigDecimal(cid_longitude), event.getPage(), event.getPageSize());
        if (StringUtils.isEmpty((CharSequence)((DynamicObject)pageData.get(0)).getString("distance"))) {
            ((ExtListView)this.view).hide("distanceicon", true);
        }
        listDataSet.setRows((Object)pageData);
        return listDataSet;
    }

    private DynamicObjectCollection getStoreList(long storeid, BigDecimal latitude, BigDecimal longitude, int page, int pageSize) {
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        List storeList = OlstoreStoreInfoHelper.getStoreList((BigDecimal)latitude, (BigDecimal)longitude, (int)page, (int)pageSize);
        if (storeList != null && storeList.size() > 0) {
            AtomicInteger index = new AtomicInteger(0);
            for (Map store : storeList) {
                int rowid = index.getAndIncrement();
                DynamicObject entryData = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(cid_storelist);
                long brachId = (Long)store.get("id");
                entryData.set("id", (Object)brachId);
                if (brachId == storeid) {
                    ((ExtListView)this.view).setRowSelection(cid_storelist, rowid, true, false);
                }
                entryData.set(cid_storepic, store.get("logo"));
                entryData.set(cid_storename, store.get("name"));
                entryData.set(cid_storeaddress, store.get("address"));
                entryData.set(cid_storeinfo_pic, (Object)"/static/image/olstore/store_red.png");
                entryData.set(cid_longitude, store.get(cid_longitude));
                entryData.set(cid_latitude, store.get(cid_latitude));
                if (store.get("distance") != null) {
                    entryData.set("distance", (Object)(store.get("distance") + "Km"));
                }
                entryList.add((Object)entryData);
            }
        }
        return entryList;
    }

    private String getStoreOpenTime(long startTime, long endTime) {
        String result = startTime > 0L ? DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.ofSecondOfDay(startTime)) : "00:00:00";
        result = result + " - ";
        result = result + (endTime > 0L && endTime <= 86399L ? DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.ofSecondOfDay(endTime)) : "23:59:59");
        return result;
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        List selectRows = event.getSelections(cid_storelist);
        DynamicObjectCollection selectEntrys = ((ListFormData)this.getBillData()).getEntryRowData(cid_storelist, selectRows);
        switch (eventId) {
            case "storepanel": {
                if (selectEntrys == null || selectEntrys.size() <= 0) break;
                JSONObject storeJson = new JSONObject();
                storeJson.put("id", (Object)(((DynamicObject)selectEntrys.get(0)).getLong("id") + ""));
                storeJson.put("name", (Object)((DynamicObject)selectEntrys.get(0)).getString(cid_storename));
                OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
                String sourceViewId = event.getCustomParam().getString("sourceviewid");
                OpenParam openParam = new OpenParam();
                if (StringUtil.isNotNull((String)sourceViewId)) {
                    openParam.setViewId(sourceViewId);
                } else {
                    String viewId = ((ExtListView)this.view).getParentPageId();
                    openParam.setViewId(StringUtil.isNotNull((String)sourceViewId) ? viewId : "ocpos_index");
                }
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                ((ExtListView)this.view).showView(openParam);
                break;
            }
            case "storeinfo_pic": {
                if (selectEntrys == null || selectEntrys.size() <= 0) break;
                OpenParam openParam = new OpenParam();
                openParam.setViewId("ocpos_storeinfo");
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("storeid", ((DynamicObject)selectEntrys.get(0)).getString("id"));
                ((ExtListView)this.view).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    protected void onRowSelected(SelectAllEvent event) {
        List selections = event.getSelections(cid_storelist);
        if (!CollectionUtils.isEmpty((Collection)selections)) {
            DynamicObject store = ((ListFormData)this.billData).getEntryRowData(cid_storelist, (SelectedRow)selections.get(0));
            JSONObject storeJson = new JSONObject();
            storeJson.put("id", (Object)(store.getLong("id") + ""));
            storeJson.put("name", (Object)store.getString(cid_storename));
            OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
            String sourceViewId = event.getCustomParam().getString("sourceviewid");
            OpenParam openParam = new OpenParam();
            if (StringUtil.isNotNull((String)sourceViewId)) {
                openParam.setViewId(sourceViewId);
            } else {
                String viewId = ((ExtListView)this.view).getParentPageId();
                openParam.setViewId(StringUtil.isNotNull((String)sourceViewId) ? viewId : "ocpos_index");
            }
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            ((ExtListView)this.view).showView(openParam);
        }
        super.onRowSelected(event);
    }
}

