/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.olstore.OlstoreCartHelper;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.common.enums.RecomItemTypeEnum;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class UserInfoMobPlugin
extends ExtBillViewPlugin {
    private static final String node_username = "username";
    private static final String node_userimage = "userimage";
    protected static Log logger = LogFactory.getLog(UserInfoMobPlugin.class);

    public void afterDataLoad(LoadDataEvent event) {
        JSONObject currentStore;
        JSONObject userInfo;
        DynamicObject olstoreCogInfo;
        String appId;
        JSONObject jsonObject;
        super.onDataLoad(event);
        ExtWebContext ext = ((ExtBillView)this.getView()).getExtCtx();
        long memberId = ext.getMemberId();
        String userImage = "/static/image/olstore/user_pic.png";
        String userName = "\u70b9\u51fb\u767b\u5f55\u8d26\u6237";
        if (memberId != 0L && (jsonObject = OlstoreMemberHelper.queryWechatUserInfo((String)(appId = (olstoreCogInfo = OlstoreConfigHelper.getOlstoreConfig()).getString("appid")), (long)memberId)) != null && jsonObject.getInteger("code") == 0 && (userInfo = jsonObject.getJSONObject("data")) != null) {
            userImage = userInfo.getString("avatarUrl");
            userName = userInfo.getString("name");
        }
        if ((currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event)) != null && memberId > 0L) {
            Long customerId = currentStore.getLong("id");
            this.initItemRecom(customerId);
        } else {
            ((ExtBillView)this.view).hide("recompanel", true);
        }
        ((BillFormData)this.billData).updateValue(node_userimage, (Object)userImage);
        ((BillFormData)this.billData).updateValue(node_username, (Object)userName);
    }

    private void initItemRecom(long customerId) {
        JSONObject result = OlstoreConfigHelper.getItemRecomList((long)customerId, (String)RecomItemTypeEnum.RECOMITEM_MYINFO.getValue());
        if (result != null) {
            JSONArray itemRecomList = result.getJSONArray("itemRecomList");
            if (itemRecomList != null && itemRecomList.size() > 0) {
                ((BillFormData)this.billData).updateValue("recompanelname", (Object)result.getString("operatingsubject"));
                for (int i = 0; i < itemRecomList.size(); ++i) {
                    JSONObject itemRecom = itemRecomList.getJSONObject(i);
                    DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject("recomitemlist");
                    dataObject.set("recomitemid", (Object)itemRecom.getLong("itemid"));
                    dataObject.set("recomauxptyid", (Object)itemRecom.getLong("auxptyid"));
                    dataObject.set("recomspuid", (Object)itemRecom.getLong("spuid"));
                    dataObject.set("recomunitid", (Object)itemRecom.getLong("unitid"));
                    dataObject.set("recombarcodeid", (Object)itemRecom.getLong("barcodeid"));
                    dataObject.set("recomitemname", (Object)itemRecom.getString("itemname"));
                    dataObject.set("recomitemthumbnail", (Object)PictureUtil.getServerPictureUrl((String)itemRecom.getString("thumbnail")));
                    dataObject.set("recomitemprice", (Object)itemRecom.getBigDecimal("minmemberprice"));
                    ((BillFormData)this.getBillData()).addEntryRow("recomitemlist", dataObject);
                }
                ((ExtBillView)this.view).hide("recompanel", false);
            } else {
                ((ExtBillView)this.view).hide("recompanel", true);
            }
        } else {
            ((ExtBillView)this.view).hide("recompanel", true);
        }
    }

    public void afterBindData(LoadDataEvent event) {
        super.afterBindData(event);
        ExtWebContext ext = ((ExtBillView)this.getView()).getExtCtx();
        long memberId = ext.getMemberId();
        ((ExtBillView)this.view).hide("exitpanel", memberId == 0L);
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        ExtWebContext ext = ((ExtBillView)this.getView()).getExtCtx();
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        switch (eventId = event.getId()) {
            case "username": 
            case "userimage": 
            case "edituserinfo": {
                openParam.setViewId("ocpos_accountsetting");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "allorderbtn": 
            case "orderall": 
            case "status_a": 
            case "status_b": 
            case "status_c": 
            case "complete_d": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_orderlistm");
                if (!"allorderbtn".equals(eventId) && !"orderall".equals(eventId)) {
                    openParam.addCustomParam("status", eventId.split("_")[1].toUpperCase());
                }
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "status_d": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_postsalelist");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "latestnews": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_latestnews_list");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "promotion": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_promotion");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "address": 
            case "address_icon": 
            case "address_right": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_deliveryaddresslistm");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "aboutus": 
            case "aboutus_icon": 
            case "aboutus_right": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_aboutinfom");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "vip": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_membercardm");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "coupon": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_ticketlistm");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "exit": {
                ((ExtBillView)this.getView()).getExtCtx().logout();
                ((ExtBillView)this.getView()).refresh();
                break;
            }
            case "service": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_service");
                ((ExtBillView)this.view).putLocalStorage("isInitSearchStatus", "1");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "giftpromotion": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_gift_marketing_list");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "getcoupons": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_receiveticket_list");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "ticketorderlist": {
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_ticketorder_list");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "recomitemthumbnail": 
            case "recomitemname": {
                DynamicObject data = ((BillFormData)this.getBillData()).getEntryRowData("recomitemlist", event.getCurrentRow());
                openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_itemdetails");
                openParam.addCustomParam("itemid", data.getString("recomitemid"));
                openParam.addCustomParam("auxptyid", data.getString("recomauxptyid"));
                openParam.addCustomParam("spuid", data.getString("recomspuid"));
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "addcart": {
                DynamicObject data = ((BillFormData)this.getBillData()).getEntryRowData("recomitemlist", event.getCurrentRow());
                this.addCart(data);
                break;
            }
        }
        super.onClick(event);
    }

    private void addCart(DynamicObject data) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        long customerId = ((BillFormData)this.billData).getLong("customerid");
        long itemId = data.getLong("recomitemid");
        long auxptyId = data.getLong("recomauxptyid");
        long unitId = data.getLong("recomunitid");
        long barcodeId = data.getLong("recombarcodeid");
        BigDecimal qty = BigDecimal.ONE;
        int preCartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        OlstoreCartHelper.addCart((long)customerId, (long)memberId, (long)itemId, (long)unitId, (long)auxptyId, (long)barcodeId, (BigDecimal)qty, (int)0);
        int cartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        if (preCartSumCount != cartSumCount) {
            ((BillFormData)this.billData).updateValue("cartcount", (Object)cartSumCount);
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", MessageBoxType.Toast);
        } else {
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u3002", MessageBoxType.Toast);
        }
    }
}

