/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class WarrantyMobPlugin
extends ExtBillViewPlugin {
    private static Log logger = LogFactory.getLog(WarrantyMobPlugin.class);

    public DynamicObject onDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        String warrantyId = event.getCustomParam().getString("warranty_id");
        DynamicObject warrantyInfo = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(warrantyId), (String)"ocpos_electwarranty");
        if (warrantyInfo != null) {
            DynamicObject salebranchid;
            DynamicObject saledepartment;
            DynamicObject sysuser;
            data.set("period", (Object)this.getWarrantyPeriod(warrantyInfo.getString("warrantyperiod")));
            data.set("effectivedate", (Object)this.changeDateFormat(warrantyInfo.getDate("effecttime")));
            Date predictTime = DynamicObjectUtils.getDate((DynamicObject)warrantyInfo, (String)"predicttime");
            data.set("cuttime", (Object)this.changeDateFormat(predictTime));
            Date nowTime = new Date();
            if (nowTime.compareTo(predictTime) <= 0) {
                data.set("state", (Object)"\u4fdd\u5185");
            } else {
                data.set("state", (Object)"\u4fdd\u5916");
            }
            DynamicObject saler = DynamicObjectUtil.getDynamicObject((DynamicObject)warrantyInfo, (String)"saler");
            if (saler != null && (sysuser = saler.getDynamicObject("sysuser")) != null) {
                data.set("saler", (Object)saler.getDynamicObject("sysuser").getString("name"));
            }
            if ((saledepartment = DynamicObjectUtil.getDynamicObject((DynamicObject)warrantyInfo, (String)"saledepartment")) != null) {
                data.set("saledepartment", (Object)saledepartment.getString("name"));
            }
            if ((salebranchid = DynamicObjectUtil.getDynamicObject((DynamicObject)warrantyInfo, (String)"salebranchid")) != null) {
                data.set("store", (Object)DynamicObjectUtil.getString((DynamicObject)salebranchid, (String)"name"));
            }
            data.set("ordernum", (Object)DynamicObjectUtil.getString((DynamicObject)warrantyInfo, (String)"billno"));
            data.set("name", (Object)DynamicObjectUtil.getString((DynamicObject)warrantyInfo, (String)"customername"));
            data.set("telephone", (Object)DynamicObjectUtil.getString((DynamicObject)warrantyInfo, (String)"customerphone"));
            data.set("address", (Object)DynamicObjectUtil.getString((DynamicObject)warrantyInfo, (String)"fulladdress"));
            data.set("note", (Object)(StringUtils.isBlank((CharSequence)DynamicObjectUtil.getString((DynamicObject)warrantyInfo, (String)"content")) ? "" : DynamicObjectUtil.getString((DynamicObject)warrantyInfo, (String)"content")));
            BigDecimal saleQty = DynamicObjectUtil.getBigDecimal((DynamicObject)warrantyInfo, (String)"saleqty");
            data.set("productinfo", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)warrantyInfo, (String)"goodsid").getString("name"));
            data.set("qty", (Object)saleQty.setScale(2, 4));
            DynamicObject invtype = DynamicObjectUtil.getDynamicObject((DynamicObject)warrantyInfo, (String)"invtype");
            if (invtype != null) {
                data.set("invtype", (Object)DynamicObjectUtil.getString((DynamicObject)invtype, (String)"name"));
            }
            data.set("totalamount", (Object)DynamicObjectUtil.getBigDecimal((DynamicObject)warrantyInfo, (String)"balamount").setScale(2, RoundingMode.DOWN));
            data.set("district", (Object)"\u4e2d\u56fd\u5927\u9646");
            DynamicObjectCollection themes = warrantyInfo.getDynamicObjectCollection("entryentity");
            int index = 0;
            if (!CollectionUtils.isEmpty((Collection)themes)) {
                for (DynamicObject theme : themes) {
                    boolean isHiddenTheme = false;
                    String scheme = DynamicObjectUtil.getString((DynamicObject)theme, (String)"scheme");
                    DynamicObjectCollection contents = theme.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject content : contents) {
                        String electtitle = DynamicObjectUtil.getString((DynamicObject)content, (String)"electtitle");
                        String elecContent = DynamicObjectUtil.getString((DynamicObject)content, (String)"schemecontent");
                        DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject("contentList");
                        dataObject.set("warrantycard", (Object)scheme);
                        dataObject.set("title", (Object)electtitle);
                        dataObject.set("content", (Object)elecContent);
                        ((BillFormData)this.getBillData()).addEntryRow("contentList", dataObject);
                        if (!isHiddenTheme) {
                            isHiddenTheme = true;
                            ++index;
                            continue;
                        }
                        ((ExtBillView)this.view).hide("warrantycard", true, index);
                        ++index;
                    }
                }
            } else {
                ((ExtBillView)this.view).hide("contentList", true);
            }
        } else {
            ((ExtBillView)this.view).showMessage("\u8be5\u5546\u54c1\u6ca1\u6709\u7535\u5b50\u4fdd\u4fee\u5355");
        }
        return data;
    }

    private String changeDateFormat(Date sourceDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String resutle = sdf.format(sourceDate);
        return resutle;
    }

    private String getWarrantyPeriod(String type) {
        String result = null;
        switch (type) {
            case "1": {
                result = "\u4e00\u4e2a\u6708";
                break;
            }
            case "3": {
                result = "\u4e09\u4e2a\u6708";
                break;
            }
            case "6": {
                result = "\u534a\u5e74";
                break;
            }
            case "12": {
                result = "\u4e00\u5e74";
                break;
            }
            case "24": {
                result = "\u4e24\u5e74";
                break;
            }
        }
        return result;
    }
}

