/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.purorder;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.formplugin.base.OcbaseListPlugin;

public class DeliveryRecordListPlugin
extends OcbaseListPlugin {
    private static final String DELIVERY_ENTITYNAME = "ocbsoc_delivery_record";
    private static final String SELECTPROPERTIES = "id,billno";
    private static final String MAINBILLNUMBER = "mainbillnumber";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List fs = e.getQFilters();
        QFilter qf = new QFilter("customer", "in", (Object)this.getAuthoriedOwnerIDs());
        fs.add(qf);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List<Object> recordList = this.getDeliveryRecords();
        String ownerFilterkey = "billno";
        List fastList = args.getFilterContainerInitEvent().getFastFilterColumns();
        if (!this.isLookup()) {
            for (FilterColumn filterColumn : fastList) {
                if (!ownerFilterkey.equals(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValues(recordList);
            }
        }
    }

    private List<Object> getDeliveryRecords() {
        Object[] ids = this.getPurOrderIds();
        if (ids.length == 0) {
            return new ArrayList<Object>(0);
        }
        QFilter[] filters = new QFilter[]{new QFilter("deliverydetail.mainbillid", "in", (Object)ids)};
        DynamicObject[] records = BusinessDataServiceHelper.load((String)DELIVERY_ENTITYNAME, (String)SELECTPROPERTIES, (QFilter[])filters);
        ArrayList<Object> idList = new ArrayList<Object>(records.length);
        for (DynamicObject record : records) {
            idList.add(record.getString("billno"));
        }
        return idList;
    }

    private Object[] getPurOrderIds() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        JSONArray ids = (JSONArray)fsp.getCustomParam("purorderIds");
        if (ids == null) {
            return new Object[0];
        }
        return ids.toArray();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (MAINBILLNUMBER.equals(fieldName)) {
            args.setCancel(true);
            QFilter qfilter = new QFilter("id", "=", this.getListView().getFocusRowPkId());
            DynamicObject delivery = QueryServiceHelper.queryOne((String)DELIVERY_ENTITYNAME, (String)"id,deliverydetail.mainbillid", (QFilter[])qfilter.toArray());
            if (delivery != null) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("ocbsoc_saleorder");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setPkId((Object)delivery.getLong("deliverydetail.mainbillid"));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }
}

