/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.purorder;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.formplugin.base.OcbaseListPlugin;

public class PurOrderListPlugin
extends OcbaseListPlugin {
    private static final String BTN_TOSIGN = "tosign1";
    private static final String POS_DELIVERY_RECORD = "ocpos_delivery_record";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BTN_TOSIGN});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "tosign1": {
                Object[] selectIds = this.checkData();
                if (selectIds == null || selectIds.length == 0) {
                    return;
                }
                ListShowParameter param = new ListShowParameter();
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setStatus(OperationStatus.VIEW);
                param.setFormId("bos_list");
                param.setBillFormId(POS_DELIVERY_RECORD);
                param.setCustomParam("purorderIds", (Object)selectIds);
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
                this.getView().showForm((FormShowParameter)param);
                break;
            }
        }
    }

    private Object[] checkData() {
        Object[] ids = this.getSelectDataIds();
        if (ids == null || ids.length == 0) {
            return null;
        }
        Map purOrderMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"ocbsoc_saleorder");
        if (purOrderMap != null) {
            Collection purOrders = purOrderMap.values();
            HashSet<Long> rightIds = new HashSet<Long>(purOrders.size());
            for (DynamicObject purOrder : purOrders) {
                String orderstatus = purOrder.getString("orderstatus");
                if (!"D".equals(orderstatus) && !"E".equals(orderstatus)) continue;
                rightIds.add(purOrder.getLong("id"));
            }
            if (rightIds.size() == 0) {
                this.getView().showErrorNotification("\u53ea\u6709\u5f85\u6536\u8d27\u548c\u90e8\u5206\u53d1\u8d27\u7684\u8ba2\u5355\u624d\u80fd\u786e\u8ba4\u6536\u8d27\u3002");
            }
            return rightIds.toArray();
        }
        this.getView().showErrorNotification("\u8ba2\u5355\u4e0d\u5b58\u5728\u5f85\u6536\u8d27\u8bb0\u5f55\u3002");
        return null;
    }

    private Object[] getSelectDataIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        int size = ids.length;
        if (size == 0) {
            this.getView().showErrorNotification("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01");
        }
        return ids;
    }
}

