/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocpos.common.consts.StoreRealInvAccConst;
import kd.occ.ocpos.formplugin.report.AbstractDetailFormPlugin;

public class InStockDetailFormPlugin
extends AbstractDetailFormPlugin {
    @Override
    public void abstractInitDetail(Map<String, Object> customsParams, DynamicObjectCollection record) {
        Object goodsid = customsParams.get("goodsid");
        DynamicObject iteminfo = BusinessDataServiceHelper.loadSingle((Object)goodsid, (String)"ocdbd_iteminfo");
        QFilter filter = this.getRealBalanceFilter(customsParams);
        DataSet invAccDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)StoreRealInvAccConst.getBalTb(), (String)String.join((CharSequence)",", this.buildSelectorAcc()), (QFilter[])filter.toArray(), (String)"");
        String sinstocksourcebill = (String)customsParams.get("sinstocksourcebill");
        DataSet dataSet = this.getSInStockBaseQty(invAccDataSet);
        DynamicObjectCollection details = ORM.create().toPlainDynamicObjectCollection(dataSet);
        for (DynamicObject detail : details) {
            DynamicObject dynamicObject = new DynamicObject(record.getDynamicObjectType());
            dynamicObject.set("billno", detail.get("billno"));
            dynamicObject.set("type", detail.get("type"));
            dynamicObject.set("qty", detail.get("sinstockqty"));
            dynamicObject.set("unit", (Object)BusinessDataServiceHelper.loadSingle((Object)detail.get("unitid"), (String)"bd_measureunits"));
            dynamicObject.set("goodsid", (Object)iteminfo);
            dynamicObject.set("deliverdate", detail.get("deliverdate"));
            record.add((Object)dynamicObject);
        }
    }

    public DataSet getSInStockBaseQty(DataSet ds) {
        QFilter filter1 = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        filter1.and("billentry.rowclosestatus", "=", (Object)"A");
        DataSet purOrderDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)"billno,billentry.material.id as materialid,billentry.unit.id as unitid,billentry.baseunit.id as baseunitid,(billentry.qty - billentry.receiveqty) as sinstockqty,(billentry.baseqty - billentry.receivebaseqty) as sinstockbaseqty,billentry.auxunit.id as auxunitid,billentry.auxqty as sinstock2ndqty,billentry.entryrecorg.id as stockorgid,billentry.deliverdate as deliverdate", (QFilter[])filter1.toArray(), null);
        DataSet inStockDataSet = purOrderDataSet.select("billno,materialid,unitid,baseunitid,sinstockqty,auxunitid,stockorgid,deliverdate,'A' as type");
        List<String> invAccFields = this.getDataSetCols(ds);
        JoinHint hint = new JoinHint();
        hint.setNullAsZero(true);
        DataSet finish = ds.join(inStockDataSet, JoinType.LEFT).on("materialid", "materialid").on("unitid", "unitid").on("baseunitid", "baseunitid").on("auxunitid", "auxunitid").on("stockorgid", "stockorgid").hint(hint).select(invAccFields.toArray(new String[0]), new String[]{"billno", "type", "deliverdate", "case when sinstockqty is Null then 0 else sinstockqty end as sinstockqty"}).finish();
        return finish.groupBy(new String[]{"billno", "type", "unitid", "deliverdate"}).sum("sinstockqty").finish();
    }

    private List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        int count = fields.length;
        ArrayList<String> list = new ArrayList<String>(count);
        for (Field field : fields) {
            list.add(field.getName().toLowerCase());
        }
        return list;
    }

    private List<String> buildSelectorAcc() {
        ArrayList<String> selectorList = new ArrayList<String>(0);
        Set selectorSet = EntityMetadataCache.getDataEntityType((String)StoreRealInvAccConst.getBalTb()).getAllFields().keySet();
        selectorList.addAll(selectorSet);
        selectorList.add("'0' as summarytype");
        selectorList.add("id");
        selectorList.add("unit.id as unitid");
        selectorList.add("baseunit.id as baseunitid");
        selectorList.add("unit2nd.id as auxunitid");
        selectorList.add("location.id as flocationid");
        selectorList.add("material.number");
        selectorList.add("warehouse.id as warehouseid");
        selectorList.add("warehouse.number");
        selectorList.add("material.id as materialid");
        selectorList.add("org.id as stockorgid");
        return selectorList;
    }
}

