/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.report;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocpos.formplugin.report.AbstractDetailFormPlugin;

public class OverSaleDetailFormPlugin
extends AbstractDetailFormPlugin {
    @Override
    public void abstractInitDetail(Map<String, Object> customsParams, DynamicObjectCollection record) {
        Object goodsid = customsParams.get("goodsid");
        DynamicObject iteminfo = BusinessDataServiceHelper.loadSingle((Object)goodsid, (String)"ocdbd_iteminfo");
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("oversaletype", "=", (Object)"1");
        filter.and("policyentity.iscontrol", "=", (Object)Boolean.TRUE);
        filter.and("policyentity.rowenable", "=", (Object)"1");
        filter.and("policyentity.begindt", "<=", (Object)TimeServiceHelper.now());
        filter.and("policyentity.enddt", ">=", (Object)TimeServiceHelper.now());
        filter.and("policyentity.material", "=", customsParams.get("material"));
        filter.and("resoustockid.stock", "=", customsParams.get("warehouse"));
        filter.and("policyentity.unit", "=", customsParams.get("unit"));
        QFilter filter1 = new QFilter("shopscopeentity.shopid", "=", customsParams.get("channelid"));
        filter1.and("shopscope", "=", (Object)"1");
        QFilter filter2 = new QFilter("shopscope", "=", (Object)"0");
        String selectFields = "id, policyentity.exparrdate as exparrdate, policyentity.alwoversaleqty as alwoversaleqty, policyentity.oversaledqty as oversaledqty, policyentity.issubsaleover as issubsaleover,policyentity.unit as unit";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"ococic_oversalepolicy", (String)selectFields, (QFilter[])filter.and(filter1.or(filter2)).toArray(), (String)"policyentity.exparrdate");
        DataSet finish = dataSet.groupBy(new String[]{"id", "exparrdate", "issubsaleover", "unit"}).sum("alwoversaleqty").sum("oversaledqty").finish();
        DynamicObjectCollection details = ORM.create().toPlainDynamicObjectCollection(finish);
        for (DynamicObject detail : details) {
            DynamicObject dynamicObject = new DynamicObject(record.getDynamicObjectType());
            dynamicObject.set("billno", (Object)BusinessDataServiceHelper.loadSingle((Object)detail.get("id"), (String)"ococic_oversalepolicy"));
            dynamicObject.set("goodsid", (Object)iteminfo);
            BigDecimal alwoversaleqty = detail.getBigDecimal("alwoversaleqty");
            dynamicObject.set("alwoversaleqty", (Object)alwoversaleqty);
            dynamicObject.set("unit", (Object)BusinessDataServiceHelper.loadSingle((Object)detail.get("unit"), (String)"bd_measureunits"));
            BigDecimal oversaledqty = detail.getBigDecimal("oversaledqty");
            dynamicObject.set("oversaledqty", (Object)oversaledqty);
            dynamicObject.set("lastqty", (Object)alwoversaleqty.subtract(oversaledqty));
            dynamicObject.set("issubsaleover", detail.get("issubsaleover"));
            dynamicObject.set("exparrdate", detail.get("exparrdate"));
            record.add((Object)dynamicObject);
        }
    }
}

