/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.report;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.formplugin.report.AbstractDetailFormPlugin;

public class ReserveDetailFormPlugin
extends AbstractDetailFormPlugin {
    @Override
    public void abstractInitDetail(Map<String, Object> customsParams, DynamicObjectCollection record) {
        Object goodsid = customsParams.get("goodsid");
        DynamicObject iteminfo = BusinessDataServiceHelper.loadSingle((Object)goodsid, (String)"ocdbd_iteminfo");
        DynamicObject[] realbalance = this.getRealbalance(customsParams);
        Object unitid = customsParams.get("unit");
        DynamicObject unit = BusinessDataServiceHelper.loadSingle((Object)unitid, (String)"bd_measureunits");
        List<Long> ids = Arrays.stream(realbalance).map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a)).collect(Collectors.toList());
        DynamicObjectCollection reservation = this.getReservation(ids);
        for (DynamicObject reserve : reservation) {
            DynamicObject dynamicObject = new DynamicObject(record.getDynamicObjectType());
            dynamicObject.set("reserveno", reserve.get("reserveno"));
            dynamicObject.set("goodsid", (Object)iteminfo);
            dynamicObject.set("date", reserve.get("date"));
            dynamicObject.set("qty", reserve.get("qty"));
            dynamicObject.set("unit", (Object)unit);
            record.add((Object)dynamicObject);
        }
    }

    private DynamicObjectCollection getReservation(List<Long> id) {
        QFilter filter = new QFilter("bal_obj.id", "=", (Object)"im_inv_realbalance");
        filter.and("bal_id", "in", id);
        DataSet reserveData = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"msmod_reserve_record", (String)"bal_id as id,bill_no as reserveno,create_date as date,qty", (QFilter[])filter.toArray(), (String)"create_date").groupBy(new String[]{"reserveno", "date"}).sum("qty").finish();
        return ORM.create().toPlainDynamicObjectCollection(reserveData);
    }
}

