/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocpos.business.promotion.SaleorderPromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.enums.GiftTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;

public class SaleOrderPromotionEdit
extends AbstractBillPlugIn {
    private static final String ACTION_PROMOTESENDCLOSE = "promotesendclose";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length <= 0) {
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"execute")) {
            this.executePromotion(e.getChangeSet());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String actionId = e.getActionId();
        if (ACTION_PROMOTESENDCLOSE.equals(actionId)) {
            this.sendGoodsClose(returnData);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            SaleOrderHelper.reCalcGiftShareAmount((DynamicObject)dataEntity);
            this.getView().updateView("goodsentryentity");
        }
    }

    private void executePromotion(ChangeData[] changeData) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        DynamicObjectCollection docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"promotionentity");
        for (ChangeData itemData : changeData) {
            if (CommonUtil.checkChanged((ChangeData)itemData)) continue;
            if (CollectionUtils.isEmpty((Collection)docPromoteEntry)) {
                return;
            }
            int rowIndex = itemData.getRowIndex();
            long promoteId = CommonUtil.formatObejctToLong((Object)this.getModel().getValue("promotionid", rowIndex));
            long promoteRuleId = CommonUtil.formatObejctToLong((Object)this.getModel().getValue("promoteruleid", rowIndex));
            String promoteNo = String.valueOf(this.getModel().getValue("promotionnum", rowIndex));
            String promoteName = String.valueOf(this.getModel().getValue("promotionname", rowIndex));
            String promoteSeq = DynamicObjectUtils.getString((DynamicObject)((DynamicObject)docPromoteEntry.get(rowIndex)), (String)"seq");
            String promoteGoodSeq = DynamicObjectUtils.getString((DynamicObject)((DynamicObject)docPromoteEntry.get(rowIndex)), (String)"promotiongoodseq");
            boolean execute = CommonUtil.formatObjectToBoolean((Object)this.getModel().getValue("execute", rowIndex));
            DynamicObject doPromoteType = (DynamicObject)this.getModel().getValue("promotiontype", rowIndex);
            String promoteType = DynamicObjectUtils.getString((DynamicObject)doPromoteType, (String)"number");
            if (execute) {
                if (ObjectUtils.isEmpty((Object)doPromoteType) || promoteId <= 0L) continue;
                StringBuilder msg = new StringBuilder();
                boolean rlt = SaleorderPromotionHelper.checkTicketSexclusive((DynamicObject)dataEntity, null, null, (long)0L, (long)promoteId, (StringBuilder)msg);
                if (!rlt) {
                    if (msg.length() > 0) {
                        this.getView().showErrorNotification(msg.toString());
                    }
                    this.getView().getModel().beginInit();
                    this.getModel().setValue("execute", (Object)Boolean.FALSE, rowIndex);
                    this.getView().getModel().endInit();
                    this.getView().updateView("execute", rowIndex);
                    return;
                }
                if (StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-031") || StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-006") || StringUtils.equals((CharSequence)promoteType, (CharSequence)PromotionEnum.AMT_ITEM.getPromoteType())) {
                    this.doFullAmtOrQtySendItem(promoteId, promoteRuleId, promoteNo, promoteName, promoteType, promoteSeq, promoteGoodSeq);
                    return;
                }
            } else if (StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-031") || StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-006") || StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-020")) {
                List lstPromGift = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("promoteseq"), (CharSequence)promoteSeq) && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue())).collect(Collectors.toList());
                if (lstPromGift.size() > 0) {
                    for (DynamicObject promGift : lstPromGift) {
                        int delRowIndex = DynamicObjectUtils.getInt((DynamicObject)promGift, (String)"seq") - 1;
                        this.getModel().deleteEntryRow("goodsentryentity", delRowIndex);
                    }
                }
                for (DynamicObject doGoodsEntry : docGoodsEntry) {
                    DynamicObjectCollection docPromote = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
                    if (CollectionUtils.isEmpty((Collection)docPromote)) continue;
                    docPromote.removeIf(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promoteId);
                }
                SaleOrderHelper.reCalcGiftShareAmount((DynamicObject)dataEntity);
            }
            SaleorderPromotionHelper.executePromotionCalcRule((DynamicObject)dataEntity);
            SaleOrderHelper.sharePointSendAmount((DynamicObject)dataEntity);
            SaleOrderHelper.shareTicketSendAmount((DynamicObject)dataEntity);
            this.getView().updateView("promotionentity");
            this.getView().updateView("goodsentryentity");
            CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
        }
    }

    private void doFullAmtOrQtySendItem(long promoteId, long promoteRuleId, String promoteNo, String promoteName, String promoteType, String promoteSeq, String goodsSeq) {
        if (promoteId > 0L) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(0);
            customParams.put("promotebillid", promoteId);
            customParams.put("promoteruleid", promoteRuleId);
            customParams.put("promotionnum", promoteNo);
            customParams.put("promotionname", promoteName);
            customParams.put("promotiontype", promoteType);
            customParams.put("promoteseq", promoteSeq);
            customParams.put("goodsseq", goodsSeq);
            boolean isAllowBook = true;
            DynamicObjectCollection entryEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("goodsentryentity");
            if (!CollectionUtils.isEmpty((Collection)entryEntities)) {
                isAllowBook = entryEntities.stream().filter(p -> Arrays.asList(goodsSeq.split(",")).contains(DynamicObjectUtils.getString((DynamicObject)p, (String)"seq"))).allMatch(q -> DynamicObjectUtils.getBoolean((DynamicObject)q, (String)"isbook"));
            }
            customParams.put("isallowbook", isAllowBook);
            FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_promotesend", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_PROMOTESENDCLOSE));
            this.getView().showForm(parameter);
        }
    }

    private void sendGoodsClose(Object returnData) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        if (returnData instanceof List) {
            String promoteSeq = null;
            String promoteType = null;
            List lstReturnMap = (List)returnData;
            DynamicObject bill = this.getModel().getDataEntity(true);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("goodsentryentity");
            entry.removeIf(x -> ObjectUtils.isEmpty((Object)x.get("goodsid")));
            this.getModel().beginInit();
            for (Map returnMap : lstReturnMap) {
                String status = CommonUtil.formatStringToEmpty(returnMap.get("status"));
                if (!StringUtils.equals((CharSequence)status, (CharSequence)"SUCCESS")) continue;
                int index = this.getModel().createNewEntryRow("goodsentryentity");
                DynamicObject entryItem = (DynamicObject)entry.get(index);
                int seq = DynamicObjectUtils.getInt((DynamicObject)entryItem, (String)"seq");
                DynamicObject data = (DynamicObject)returnMap.get("data");
                if (StringUtils.isEmpty(promoteSeq)) {
                    promoteSeq = DynamicObjectUtils.getString((DynamicObject)data, (String)"promoteseq");
                }
                if (StringUtils.isEmpty(promoteType)) {
                    promoteType = DynamicObjectUtils.getString((DynamicObject)data, (String)"promotiontype");
                }
                DataEntityPropertyCollection properties = entry.getDynamicObjectType().getProperties();
                for (IDataEntityProperty property : properties) {
                    String key = property.getName();
                    if (DynamicObjectUtils.contain((DynamicObject)data, (String)key) && !StringUtils.equals((CharSequence)key, (CharSequence)"Id")) {
                        entryItem.set(key, data.get(key));
                    }
                    if (StringUtils.equals((CharSequence)key, (CharSequence)"goodssaler")) {
                        entryItem.set(key, (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)bill, (String)"saler"));
                    }
                    if (StringUtils.equals((CharSequence)key, (CharSequence)"gifttype")) {
                        entryItem.set("gifttype", (Object)GiftTypeEnum.PROMOTENEW.getValue());
                    }
                    if (!StringUtils.equals((CharSequence)key, (CharSequence)"mustretqty")) continue;
                    BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"saleqty");
                    entryItem.set("mustretqty", (Object)saleQty);
                }
                BigDecimal giftPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"promotegiftprice");
                BigDecimal giftValue = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"promotegiftvalue");
                String goodsSeq = DynamicObjectUtils.getString((DynamicObject)data, (String)"goodsseq");
                SaleOrderDeliveryInfoHelper.updatePriceAndAmount((IFormView)this.getView(), (DynamicObject)bill, (DynamicObject)entryItem, (int)index);
                Object returnInfo = returnMap.get("salesorderdelivery");
                if (returnInfo instanceof List) {
                    SaleOrderDeliveryInfoHelper.fillDeliveryDataAboutStock((IFormView)this.getView(), (DynamicObject)data, (DynamicObject)entryItem, returnInfo);
                } else {
                    SaleOrderDeliveryInfoHelper.fillDeliveryData((IFormView)this.getView(), (DynamicObject)data, (DynamicObject)entryItem);
                }
                this.setSendGoodsPromoteEntry(bill, entry, goodsSeq, promoteType, promoteSeq, entryItem, giftPrice, giftValue, seq);
            }
            entry.addNew();
            this.getModel().endInit();
            this.getView().updateView("salesorderdelivery");
            this.getView().updateView("goodsentryentity");
            this.getView().updateView("promotionentity");
        } else if (returnData instanceof String) {
            String promoteSeq = String.valueOf(returnData);
            int rowIndex = CommonUtil.formatObjectToInt((Object)promoteSeq) - 1;
            this.getView().getModel().setValue("execute", (Object)Boolean.FALSE, rowIndex);
        }
    }

    private void setSendGoodsPromoteEntry(DynamicObject bill, DynamicObjectCollection entry, String goodsSeq, String promoteType, String promoteSeq, DynamicObject doSendGoodsEntry, BigDecimal giftPrice, BigDecimal giftValue, int seq) {
        if (!StringUtils.isEmpty((CharSequence)promoteSeq)) {
            String[] goodsSeqArray;
            DynamicObjectCollection docPromoteEntry = bill.getDynamicObjectCollection("promotionentity");
            if (CollectionUtils.isEmpty((Collection)docPromoteEntry)) {
                return;
            }
            DynamicObject doPromoteEntry = docPromoteEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"), (CharSequence)promoteSeq)).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)doPromoteEntry)) {
                return;
            }
            long promoteRuleId = DynamicObjectUtils.getLong((DynamicObject)doPromoteEntry, (String)"promoteruleid");
            String itemGroup = "";
            if (promoteRuleId > 0L) {
                DynamicObject doPromoteRule = BusinessDataServiceHelper.loadSingle((Object)promoteRuleId, (String)"ocdpm_promote_rule");
                itemGroup = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"itemgroup");
            }
            if ((goodsSeqArray = goodsSeq.split(",")).length > 0) {
                for (String seqI : goodsSeqArray) {
                    DynamicObject doGoodsEntry = entry.stream().filter(x -> StringUtils.equals((CharSequence)seqI, (CharSequence)x.getString("seq"))).findFirst().orElse(null);
                    if (ObjectUtils.isEmpty((Object)doGoodsEntry)) continue;
                    DynamicObject doGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)doSendGoodsEntry, (String)"goodsid");
                    BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doSendGoodsEntry, (String)"saleqty");
                    BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)doSendGoodsEntry, (String)"retailprice");
                    SaleorderPromotionHelper.createPromoteRow((String)promoteType, (DynamicObject)doGoodsEntry, (DynamicObject)doPromoteEntry, null, null, (DynamicObject)doGoods, (BigDecimal)saleQty, (BigDecimal)retailPrice, (BigDecimal)giftPrice, (BigDecimal)giftValue, (String)itemGroup, (String)goodsSeq, (int)seq);
                }
            }
        }
    }
}

