/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocbase.common.util.pos.PosUnit;
import kd.occ.ocpos.business.commonhelper.CurrencyHelper;
import kd.occ.ocpos.business.promotion.BuildParamHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderMemberHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.GiftTypeEnum;
import kd.occ.ocpos.common.enums.PosOrderTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.FormViewUtil;
import kd.occ.ocpos.common.util.OwnerUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SalesOrderBaseEdit
extends AbstractBillPlugIn {
    private static final String ACTION_BOOKPRESTORECHOOSECLOSE = "bookprestorechooseclose";
    private static final Log LOG = LogFactory.getLog(SalesOrderBaseEdit.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        String parentFormId;
        String formId;
        Map customParams;
        long billTypeId;
        long branchId;
        super.preOpenForm(e);
        FormShowParameter parameter = e.getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW) && (branchId = this.initializeBranchId(billTypeId = CommonUtil.formatObejctToLong((Object)(customParams = parameter.getCustomParams()).getOrDefault("basebilltype", 0L)))) == 0L) {
            if (billTypeId == BillTypeEnum.STORE.getId()) {
                e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u6536\u94f6\u5458\u6216\u9500\u552e\u5458\uff0c\u65e0\u6cd5\u6267\u884c\u95e8\u5e97\u5bfc\u8d2d\u4e1a\u52a1\u3002", (String)"SalesOrderBaseEdit_0", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            } else {
                e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u6536\u94f6\u5458\uff0c\u65e0\u6cd5\u6267\u884c\u5f00\u5355\u4e1a\u52a1\u3002", (String)"SalesOrderBaseEdit_1", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            e.setCancel(true);
        }
        if (StringUtils.equals((CharSequence)(formId = parameter.getFormId()), (CharSequence)"ocpos_saleorder_cvtsale")) {
            parameter.setCaption(BillTypeEnum.CVTSALE.getName());
        } else if (StringUtils.equals((CharSequence)formId, (CharSequence)"ocpos_saleorder_return") && StringUtils.equals((CharSequence)(parentFormId = parameter.getParentFormId()), (CharSequence)"ocpos_saleorder_book")) {
            parameter.setCaption(BizTypeEnum.CANCELORDER.getName());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initializeBilType();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String formId = parameter.getFormId();
        if (StringUtils.equals((CharSequence)formId, (CharSequence)"ocpos_saleorder") || StringUtils.equals((CharSequence)formId, (CharSequence)"ocpos_saleorder_final")) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        long branchId = this.initializeBranchId(billTypeId);
        this.checkPos(branchId);
        this.getModel().setItemValueByID("salebranchid", (Object)branchId);
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"salebranchid");
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)branch, (String)"saleorg");
        this.getModel().setItemValueByID("bizorgid", (Object)orgId);
        this.updateCurrency(branch, orgId);
        Object customer = SystemParamUtil.getDefaultCustomer((long)orgId, (long)branchId);
        this.getModel().setValue("customerid", customer);
        this.initializeChannelUser(dataEntity, billTypeId, branchId, false);
        this.initializeGoodsEntry(branch);
        CommonUtils.clearFieldValue((String)"admindivisionid", (IDataModel)this.getModel());
        List<Long> billTypeIds = Arrays.asList(BillTypeEnum.GUIDE.getId(), BillTypeEnum.GROUP.getId(), BillTypeEnum.CVTSALE.getId());
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        List<String> srcReturnTypes = Arrays.asList(BizTypeEnum.REDRUSH.getValue(), BizTypeEnum.SALERETURN.getValue(), BizTypeEnum.CANCELORDER.getValue());
        if (billTypeIds.contains(billTypeId) || srcReturnTypes.contains(bizType)) {
            this.getModel().deleteEntryData("goodsentryentity");
        }
    }

    public void afterLoadData(EventObject e) {
        String entityId = this.getView().getEntityId();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)"ocpos_saleorder", (CharSequence)entityId)) {
            DynamicObjectCollection entryData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)entryData)) {
                return;
            }
            for (DynamicObject entryItem : entryData) {
                DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"goodsid");
                String operationModel = DynamicObjectUtils.getString((DynamicObject)goods, (String)"operationmodel");
                entryItem.set("operationmodel", (Object)operationModel);
            }
            this.getView().updateView("goodsentryentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"copy")) {
            this.beforeCopyOp(e);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"save") || StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"settle")) {
            boolean issaler = this.pushSaler();
            if (!issaler) {
                NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u6536\u94f6\u5458\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u63d0\u4ea4\u3002", (IFormView)this.getView());
                e.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"new")) {
            this.getView().getModel().setDataChanged(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"copy")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
            long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
            Object customer = SystemParamUtil.getDefaultCustomer((long)orgId, (long)branchId);
            this.getModel().setValue("customerid", customer);
            this.initializeChannelUser(dataEntity, billTypeId, branchId, true);
            long memberId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"member");
            if (memberId > 0L) {
                BigDecimal integralValue = SaleOrderMemberHelper.getPointValue((long)memberId);
                this.getModel().setValue("integralbalance", (Object)integralValue);
            }
            DynamicObject deliversStatus = BusinessDataServiceHelper.loadSingle((Object)DeliveryStatus.SALE_WAIT_DELIVERY, (String)"ococic_deliverstatus");
            DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
            if (!CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
                for (DynamicObject doGoodsEntry : docGoodsEntry) {
                    Map result = SaleOrderAmountHelper.getRecalculateLineAmountMap((DynamicObject)doGoodsEntry, (String)"promotiondiscount", (BigDecimal)BigDecimal.ZERO, (boolean)false);
                    SaleAmountHelper.setData((Map)result, (DynamicObject)doGoodsEntry);
                    result = SaleOrderAmountHelper.getRecalculateLineAmountMap((DynamicObject)doGoodsEntry, (String)"ticketshareamount", (BigDecimal)BigDecimal.ZERO, (boolean)false);
                    SaleAmountHelper.setData((Map)result, (DynamicObject)doGoodsEntry);
                    result = SaleOrderAmountHelper.getRecalculateLineAmountMap((DynamicObject)doGoodsEntry, (String)"giftdiscountamount", (BigDecimal)BigDecimal.ZERO, (boolean)false);
                    SaleAmountHelper.setData((Map)result, (DynamicObject)doGoodsEntry);
                    result = SaleOrderAmountHelper.getRecalculateLineAmountMap((DynamicObject)doGoodsEntry, (String)"coupondiscount", (BigDecimal)BigDecimal.ZERO, (boolean)false);
                    SaleAmountHelper.setData((Map)result, (DynamicObject)doGoodsEntry);
                    result = SaleOrderAmountHelper.getRecalculateLineAmountMap((DynamicObject)doGoodsEntry, (String)"integraldistamount", (BigDecimal)BigDecimal.ZERO, (boolean)false);
                    SaleAmountHelper.setData((Map)result, (DynamicObject)doGoodsEntry);
                    DynamicObjectCollection saleOrderPromote = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
                    saleOrderPromote.clear();
                    DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)doGoodsEntry, (String)"goodsid");
                    String operationModel = DynamicObjectUtils.getString((DynamicObject)goods, (String)"operationmodel");
                    doGoodsEntry.set("operationmodel", (Object)operationModel);
                    doGoodsEntry.set("mustretqty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"saleqty"));
                    CommonUtils.updateReceivableAmount((IDataModel)this.getModel(), (DynamicObject)doGoodsEntry);
                    DynamicObjectCollection saleOrderDelivery = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderdelivery");
                    if (CollectionUtils.isEmpty((Collection)saleOrderDelivery)) continue;
                    for (DynamicObject deliveryEntry : saleOrderDelivery) {
                        deliveryEntry.set("deliveryavareturnqty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntry, (String)"deliversaleqty"));
                        deliveryEntry.set("deliverystatus", (Object)deliversStatus);
                    }
                }
                docGoodsEntry.removeIf(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.MANUALNEW.getValue()) || StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue()));
                this.getView().updateView("salesorderdelivery");
                this.getView().updateView("goodsentryentity");
            }
            DynamicObjectCollection docTicketSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity");
            docTicketSendEntry.clear();
            this.getView().updateView("ticketsendentity");
            DynamicObjectCollection docGoodsSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
            docGoodsSendEntry.clear();
            this.getView().updateView("goodsendentity");
            DynamicObjectCollection docSendIntegralEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity");
            docSendIntegralEntry.clear();
            this.getView().updateView("sendintegralentity");
            DynamicObjectCollection useTicketEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"useticketentity");
            useTicketEntry.clear();
            this.getView().updateView("useticketentity");
            CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
            DynamicObjectCollection docFinEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"finentity");
            docFinEntry.clear();
            this.getView().updateView("finentity");
            DynamicObjectCollection docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"promotionentity");
            if (!CollectionUtils.isEmpty((Collection)docPromoteEntry)) {
                docPromoteEntry.clear();
                if (!CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
                    int rowCount = docGoodsEntry.getRowCount();
                    for (int i = 0; i < rowCount; ++i) {
                        BuildParamHelper.matchItemPromotion((IFormView)this.getView(), (DynamicObjectCollection)docGoodsEntry, (int)i);
                    }
                }
                this.getView().updateView("promotionentity");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterBindData(EventObject e) {
        String orderSource;
        super.afterBindData(e);
        this.setMustInput();
        String entityId = this.getView().getEntityId();
        LOG.info("\u5355\u636e\u5b9e\u4f53\u6807\u8bc6\uff1a" + entityId);
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder") || StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_return")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
            this.getView().setVisible(Boolean.valueOf(isInitBill), new String[]{"isinitbill"});
        }
        if (StringUtils.equals((CharSequence)(orderSource = this.getView().getModel().getDataEntity(true).getString("ordersource")), (CharSequence)"D") || StringUtils.equals((CharSequence)orderSource, (CharSequence)"E")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"promotionentity"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "saler": {
                this.salerChanged(changeSet[0]);
                break;
            }
            case "salebranchid": {
                this.branchChanged(changeSet[0]);
                break;
            }
            case "notconfirm": 
            case "member": {
                this.showBookPreStoreChooseForm(key, changeSet[0]);
                break;
            }
            case "depositamount": {
                this.depositAmountChanged(changeSet[0]);
                break;
            }
            case "changeitemtype": {
                this.getModel().deleteEntryData("goodsentryentity");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "bookprestorechooseclose": {
                if (ObjectUtils.isEmpty((Object)returnData)) {
                    this.getModel().setValue("notconfirm", (Object)Boolean.FALSE);
                    this.getModel().setValue("sourcebillid", (Object)0L);
                    this.getModel().setValue("initialbillno", (Object)"");
                    return;
                }
                if (!(returnData instanceof DynamicObject)) break;
                DynamicObject data = (DynamicObject)returnData;
                if (ObjectUtils.isEmpty((Object)data)) {
                    return;
                }
                BigDecimal depositamount = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"depositamount");
                BigDecimal depositpayamount = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"depositpayamount");
                BigDecimal saleamount = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"saleamount");
                BigDecimal diffdepositamount = depositamount.subtract(depositpayamount).subtract(saleamount.abs());
                if (diffdepositamount.compareTo(BigDecimal.ZERO) <= 0) {
                    NotificationUtil.showDefaultTipNotify((String)"\u8ba2\u91d1\u5269\u4f59\u91d1\u989d\u4e3a0\u3002", (IFormView)this.getView());
                }
                this.getModel().setValue("sourcebillid", (Object)DynamicObjectUtils.getLong((DynamicObject)data, (String)"id"));
                this.getModel().setValue("initialbillno", (Object)DynamicObjectUtils.getString((DynamicObject)data, (String)"billno"));
                break;
            }
            case "ocpos_registerpos": {
                if (ObjectUtils.isEmpty((Object)returnData)) {
                    this.getView().close();
                    return;
                }
                if (!(returnData instanceof Long)) break;
                this.getModel().setItemValueByID("pos", returnData);
                break;
            }
        }
    }

    private void showBookPreStoreChooseForm(String key, ChangeData changeData) {
        DynamicObject doBillType;
        boolean bNotConfirm = CommonUtil.formatObjectToBoolean((Object)this.getModel().getValue("notconfirm"));
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"notconfirm")) {
            this.clearGoodsEntry(changeData);
            if (!bNotConfirm) {
                this.getModel().setValue("depositamount", (Object)BigDecimal.ZERO);
                this.getModel().setValue("receivableamount", (Object)BigDecimal.ZERO);
                this.getModel().setValue("sourcebillid", (Object)0L);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"member") && bNotConfirm) {
            this.getModel().setValue("depositamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("receivableamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("sourcebillid", (Object)0L);
            this.clearGoodsEntry(changeData);
        }
        if (ObjectUtils.isEmpty((Object)(doBillType = (DynamicObject)this.getModel().getValue("basebilltype")))) {
            return;
        }
        if (BillTypeEnum.CVTSALE.getId() != DynamicObjectUtils.getPkValue((DynamicObject)doBillType)) {
            return;
        }
        DynamicObject member = (DynamicObject)this.getModel().getValue("member");
        if (ObjectUtils.isEmpty((Object)member) || !bNotConfirm) {
            return;
        }
        HashMap<String, Long> customParams = new HashMap<String, Long>(0);
        DynamicObject branch = (DynamicObject)this.getModel().getValue("salebranchid");
        if (ObjectUtils.isEmpty((Object)branch)) {
            return;
        }
        customParams.put("member", DynamicObjectUtils.getPkValue((DynamicObject)member));
        customParams.put("salebranchid", DynamicObjectUtils.getPkValue((DynamicObject)branch));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_bookprestore_choose", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_BOOKPRESTORECHOOSECLOSE));
        this.getView().showForm(parameter);
    }

    private void salerChanged(ChangeData changeData) {
        DynamicObject bill = this.getModel().getDataEntity(true);
        long baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"basebilltype");
        if (baseBillTypeId == BillTypeEnum.CREDIT.getId()) {
            return;
        }
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        DynamicObject saler = (DynamicObject)changeData.getNewValue();
        if (ObjectUtils.isEmpty((Object)saler)) {
            return;
        }
        DynamicObjectCollection entryData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)bill, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryData)) {
            return;
        }
        DynamicObject dpt = (DynamicObject)CommonUtils.getDeptObj((DynamicObject)saler);
        for (DynamicObject entryItem : entryData) {
            entryItem.set("goodssaler", (Object)saler);
            entryItem.set("saledepartment", (Object)dpt);
        }
        this.getView().updateView("goodsentryentity");
    }

    private void depositAmountChanged(ChangeData changeData) {
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        boolean isNotConfirm = CommonUtil.formatObjectToBoolean((Object)this.getModel().getValue("notconfirm"));
        if (isNotConfirm) {
            BigDecimal depositAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("depositamount"));
            this.getModel().setValue("receivableamount", (Object)depositAmount);
        }
    }

    private void clearGoodsEntry(ChangeData changeData) {
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection docGoodsEntry = dataEntity.getDynamicObjectCollection("goodsentryentity");
        DynamicObjectCollection docPromotionEntry = dataEntity.getDynamicObjectCollection("promotionentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return;
        }
        if (docPromotionEntry != null && docPromotionEntry.size() > 0) {
            docPromotionEntry.clear();
            this.getView().updateView("promotionentity");
        }
        docGoodsEntry.clear();
        this.getModel().setValue("depositamount", (Object)BigDecimal.ZERO);
        CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
        this.getView().updateView("goodsentryentity");
    }

    private void branchChanged(ChangeData changeData) {
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        DynamicObject branch = (DynamicObject)changeData.getNewValue();
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
        this.checkPos(branchId);
        if (branchId <= 0L) {
            this.getModel().setItemValueByID("bizorgid", (Object)0L);
            return;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"saleorg");
        this.getModel().setItemValueByID("bizorgid", (Object)orgId);
        Object defaultCustomer = SystemParamUtil.getDefaultCustomer((long)orgId, (long)branchId);
        long defCustomerId = 0L;
        if (defaultCustomer instanceof DynamicObject) {
            defCustomerId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)defaultCustomer));
        }
        this.getModel().setItemValueByID("customerid", (Object)defCustomerId);
        this.updateCurrency(branch, orgId);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (baseBillTypeId != BillTypeEnum.CREDIT.getId()) {
            this.getModel().deleteEntryData("goodsentryentity");
            this.getModel().createNewEntryRow("goodsentryentity");
            DynamicObject bill = this.getModel().getDataEntity();
            boolean isExist = DynamicObjectUtils.contain((DynamicObject)bill, (String)"promotionentity");
            if (isExist) {
                this.getModel().deleteEntryData("promotionentity");
            }
        } else {
            this.getModel().deleteEntryData("arentryentity");
            this.getModel().createNewEntryRow("arentryentity");
        }
        this.initializeChannelUser(dataEntity, baseBillTypeId, DynamicObjectUtils.getPkValue((DynamicObject)branch), false);
        this.getPageCache().remove("creditaccountid");
        this.setMustInput();
    }

    private void initializeBilType() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        String formId = parameter.getFormId();
        long billTypeId = this.getDefBillTypeId(formId, customParams);
        this.getModel().setItemValueByID("basebilltype", (Object)billTypeId);
        long receivingTypeId = this.getDefReceivingTypeId(formId, customParams);
        this.getModel().setItemValueByID("receivingtype", (Object)receivingTypeId);
        String bizType = this.getDefBizType(formId, customParams);
        this.getModel().setValue("biztype", (Object)bizType);
        String entityId = this.getView().getEntityId();
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder") || StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_return")) {
            boolean isInitBill = CommonUtil.formatObjectToBoolean((Object)customParams.getOrDefault("isinitbill", Boolean.FALSE));
            if (!isInitBill) {
                String cacheKey = this.getView().getPageId() + "-" + "isinitbill";
                String isInit = this.getPageCache().get(cacheKey);
                isInitBill = StringUtils.equals((CharSequence)isInit, (CharSequence)"1");
                this.getPageCache().remove(cacheKey);
            }
            this.getModel().setValue("isinitbill", (Object)isInitBill);
        }
    }

    private long getDefBillTypeId(String formId, Map<String, Object> customParams) {
        long billTypeId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("basebilltype", 0L));
        if (billTypeId <= 0L) {
            billTypeId = PosOrderTypeEnum.getBillTypeIdByFormId((String)formId);
        }
        return billTypeId;
    }

    private long getDefReceivingTypeId(String formId, Map<String, Object> customParams) {
        long receivingTypeId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("receivingtype", 0L));
        if (receivingTypeId <= 0L) {
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"ocpos_saleorder_return")) {
                String cacheKey = this.getView().getPageId() + "-" + "receivingtype";
                receivingTypeId = CommonUtil.formatStringToLong((String)this.getPageCache().get(cacheKey));
                this.getPageCache().remove(cacheKey);
                if (receivingTypeId <= 0L) {
                    receivingTypeId = PosOrderTypeEnum.getReceivingTypeIdByFormId((String)formId);
                }
            } else {
                receivingTypeId = PosOrderTypeEnum.getReceivingTypeIdByFormId((String)formId);
            }
        }
        return receivingTypeId;
    }

    private String getDefBizType(String formId, Map<String, Object> customParams) {
        String bizType = String.valueOf(customParams.getOrDefault("biztype", ""));
        if (StringUtils.isBlank((CharSequence)bizType)) {
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"ocpos_saleorder_return")) {
                String cacheKey = this.getView().getPageId() + "-" + "biztype";
                bizType = this.getPageCache().get(cacheKey);
                this.getPageCache().remove(cacheKey);
                if (StringUtils.isBlank((CharSequence)bizType)) {
                    bizType = PosOrderTypeEnum.getBizTypeByFormId((String)formId);
                }
            } else {
                bizType = PosOrderTypeEnum.getBizTypeByFormId((String)formId);
            }
        }
        return bizType;
    }

    private void initializeGoodsEntry(DynamicObject branch) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryData)) {
            return;
        }
        long baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        DynamicObject saleMan = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"saler");
        for (DynamicObject entryItem : entryData) {
            entryItem.set("goodssaler", (Object)saleMan);
            entryItem.set("saledepartment", CommonUtils.getDeptObj((DynamicObject)saleMan));
            if (baseBillTypeId != BillTypeEnum.CREDIT.getId()) {
                String ownerType;
                String keepType = DynamicObjectUtil.getString((DynamicObject)entryItem, (String)"keepertype");
                DynamicObject invOrg = InventoryUtils.getInvOrg((DynamicObject)branch);
                if (StringUtils.equals((CharSequence)keepType, (CharSequence)"bos_org")) {
                    entryItem.set("keeperid", (Object)invOrg);
                }
                if (StringUtils.equals((CharSequence)(ownerType = DynamicObjectUtil.getString((DynamicObject)entryItem, (String)"ownertype")), (CharSequence)"bos_org")) {
                    long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)invOrg);
                    DynamicObject defOwner = InventoryUtils.getDefaultOwner((long)invOrgId);
                    entryItem.set("ownerid", (Object)defOwner);
                }
                if (baseBillTypeId == BillTypeEnum.RESERVE.getId()) {
                    entryItem.set("isbook", (Object)Boolean.TRUE);
                }
            }
            this.getView().updateView("goodsentryentity");
        }
    }

    private long initializeBranchId(long billTypeId) {
        long branchId = billTypeId == BillTypeEnum.STORE.getId() ? OwnerUtil.getDefaultOwnerIdToStore() : OwnerUtil.getDefaultOwnerId();
        return branchId;
    }

    private void initializeChannelUser(DynamicObject dataEntity, long billTypeId, long branchId, boolean isCopy) {
        QFilter qFilter = new QFilter("owner", "=", (Object)branchId);
        qFilter.and("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject channelUser = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"iscashier,id,issaler", (QFilter[])qFilter.toArray());
        long userId = DynamicObjectUtils.getPkValue((DynamicObject)channelUser);
        if (billTypeId == BillTypeEnum.STORE.getId()) {
            this.getModel().setValue("cashier", null);
        } else {
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"cashier", (Object)userId);
        }
        long salerId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"saler");
        if (isCopy && salerId > 0L) {
            return;
        }
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"saler", (Object)userId);
    }

    private void updateCurrency(DynamicObject branch, long orgId) {
        Map currencyMap = CurrencyHelper.initCurrency((DynamicObject)branch, (long)orgId);
        this.getModel().setItemValueByID("currencyid", currencyMap.get("currencyid"));
        this.getModel().setItemValueByID("locurrencyid", currencyMap.get("locurrencyid"));
        this.getModel().setItemValueByID("exratetable", currencyMap.get("exratetable"));
        this.getModel().setValue("financeexchangerate", currencyMap.get("financeexchangerate"));
    }

    private void setMustInput() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
        String source = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"ordersource");
        boolean isOnline = StringUtils.equals((CharSequence)source, (CharSequence)"D") || StringUtils.equals((CharSequence)source, (CharSequence)"E");
        boolean isMemberMustInput = SystemParamUtil.getIsMustInputMember((long)orgId, (long)branchId);
        FormViewUtil.setMustInput((IFormView)this.getView(), (boolean)isMemberMustInput, (String[])new String[]{"member"});
        boolean isSalerMustInput = SystemParamUtil.getIsSaleMustInput((long)orgId, (long)branchId);
        FormViewUtil.setMustInput((IFormView)this.getView(), (boolean)isSalerMustInput, (String[])new String[]{"saler"});
        if (billTypeId != BillTypeEnum.STORE.getId()) {
            FormViewUtil.setMustInput((!isOnline ? 1 : 0) != 0, (IFormView)this.getView(), (String[])new String[]{"cashier"});
        } else {
            FormViewUtil.setMustInput((boolean)false, (IFormView)this.getView(), (String[])new String[]{"cashier"});
        }
        String entityId = this.getView().getEntityId();
        if (!StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_final") && !isNotConfirm) {
            FormViewUtil.setMustInput((IFormView)this.getView(), (boolean)isSalerMustInput, (String[])new String[]{"goodssaler"});
        }
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            boolean isReturnReasonMustInput = SystemParamUtil.getIsReturnReasonMustInput((long)orgId, (long)branchId);
            FormViewUtil.setMustInput((boolean)isReturnReasonMustInput, (IFormView)this.getView(), (String[])new String[]{"returnreason"});
            String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
            if (!StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.CANCELORDER.getValue())) {
                FormViewUtil.setMustInput((boolean)true, (IFormView)this.getView(), (String[])new String[]{"delivergoodsid", "deliverbarcodeid", "deliversaleqty", "deliverunitid"});
            }
        }
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) {
            boolean isNotReserve = billTypeId != BillTypeEnum.RESERVE.getId();
            FormViewUtil.setMustInput((IFormView)this.getView(), (boolean)isNotReserve, (String[])new String[]{"inventoryorgid"});
        }
        if (isOnline) {
            DynamicObjectCollection deliveryEntity;
            DynamicObjectCollection goodsEntryEntity;
            boolean isEnable = false;
            String orderStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"orderstatus");
            if (StringUtils.equals((CharSequence)orderStatus, (CharSequence)"A") && !CollectionUtils.isEmpty((Collection)(goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity"))) && !CollectionUtils.isEmpty((Collection)(deliveryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)((DynamicObject)goodsEntryEntity.get(0)), (String)"salesorderdelivery")))) {
                isEnable = DynamicObjectUtils.getBoolean((DynamicObject)((DynamicObject)deliveryEntity.get(0)), (String)"isselfpickup");
            }
            if (!isEnable) {
                FormViewUtil.setUnEnable((IFormView)this.getView(), (String[])new String[]{"storepickup"});
            } else {
                FormViewUtil.setEnable((IFormView)this.getView(), (String[])new String[]{"storepickup"});
            }
        } else {
            FormViewUtil.setUnEnable((IFormView)this.getView(), (String[])new String[]{"storepickup"});
        }
    }

    private void beforeCopyOp(BeforeDoOperationEventArgs e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        long branchId = this.initializeBranchId(billTypeId);
        if (branchId == 0L) {
            if (billTypeId == BillTypeEnum.STORE.getId()) {
                e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u6536\u94f6\u5458\u6216\u9500\u552e\u5458\uff0c\u65e0\u6cd5\u6267\u884c\u95e8\u5e97\u5bfc\u8d2d\u4e1a\u52a1\u3002", (String)"SalesOrderBaseEdit_0", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            } else {
                e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u6536\u94f6\u5458\uff0c\u65e0\u6cd5\u6267\u884c\u5f00\u5355\u4e1a\u52a1\u3002", (String)"SalesOrderBaseEdit_1", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            e.setCancel(true);
        }
    }

    private boolean pushSaler() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        QFilter qFilter = new QFilter("owner", "=", (Object)branchId);
        qFilter.and("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject channelUser = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"iscashier,id,issaler", (QFilter[])qFilter.toArray());
        if (channelUser != null) {
            boolean isCashier = channelUser.getBoolean("iscashier");
            if (isCashier) {
                if (billTypeId == BillTypeEnum.STORE.getId()) {
                    this.getModel().setValue("cashier", null);
                } else {
                    this.getModel().setValue("cashier", channelUser.get("id"));
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private void checkPos(long branchId) {
        try {
            String ipAddress = PosUnit.getIpAddress();
            if (StringUtils.isBlank((CharSequence)ipAddress)) {
                return;
            }
            QFilter filter = F7Utils.getCommonStatusFilter();
            filter.and("macaddress", "=", (Object)ipAddress);
            filter.and("branch", "=", (Object)branchId);
            filter.and("registerstatus", "=", (Object)"1");
            filter.and("machinetype", "=", (Object)"A");
            DynamicObject pos = QueryServiceHelper.queryOne((String)"ocdbd_pos", (String)"id", (QFilter[])filter.toArray());
            long posId = DynamicObjectUtils.getPkValue((DynamicObject)pos);
            if (posId > 0L) {
                this.getModel().setItemValueByID("pos", (Object)posId);
            } else {
                HashMap<String, Object> customParams = new HashMap<String, Object>(2);
                customParams.put("branch", branchId);
                customParams.put("macaddress", ipAddress);
                FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_registerpos", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocpos_registerpos"));
                this.getView().showForm(parameter);
            }
        }
        catch (Exception ex) {
            NotificationUtil.showErrorNotification((String)String.format("\u83b7\u53d6MAC\u5730\u5740\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", ex.getMessage()), (IFormView)this.getView());
        }
    }
}

