/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.saleorder.SaleOrderItemF7Filter;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SalesOrderBeforeF7Edit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String[] F7FIELD_KEYS = new String[]{"salebranchid", "saler", "customerid", "goodsid", "barcode", "goodssaler", "saledepartment", "delivergoodsid", "deliverbarcodeid", "deliverstockid", "stockpositionid", "erpstockid", "erpstockpositionid", "deliverymode", "inventoryorgid"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List allFieldKeys = this.getModel().getDataEntityType().getAllFields().values().stream().map(IMetadata::getName).collect(Collectors.toList());
        for (String f7FieldKey : F7FIELD_KEYS) {
            BasedataEdit bEdit;
            if (!allFieldKeys.contains(f7FieldKey) || ObjectUtils.isEmpty((Object)(bEdit = (BasedataEdit)this.getView().getControl(f7FieldKey)))) continue;
            bEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int index = e.getRow();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (key) {
            case "salebranchid": {
                this.beforeBranchF7Select(e, dataEntity);
                break;
            }
            case "customerid": {
                this.beforeCustomerF7Select(e, dataEntity);
                break;
            }
            case "itemsale": {
                this.beforeSaleContentF7Select(e, dataEntity, index);
                break;
            }
            case "goodsid": 
            case "barcode": {
                this.beforeItemsInfoF7Select(e, dataEntity, key, index);
                break;
            }
            case "saler": 
            case "goodssaler": {
                this.beforeSalerF7Select(e, dataEntity);
                break;
            }
            case "deliverymode": {
                this.beforeDeliveryModeF7Select(e, index);
                break;
            }
            case "deliverstockid": 
            case "erpstockid": {
                this.beforeStockF7Select(e, key, index);
                break;
            }
            case "stockpositionid": {
                this.beforeStockPositionF7Select(e, key, "stockid", index);
                break;
            }
            case "erpstockpositionid": {
                this.beforeStockPositionF7Select(e, key, "erpstock", index);
                break;
            }
            case "inventoryorgid": {
                this.beforeInvOrgF7Select(e, dataEntity, index);
                break;
            }
            case "saledepartment": {
                this.beforeSaleDeptF7Select(e, index);
                break;
            }
            case "delivergoodsid": 
            case "deliverbarcodeid": {
                this.beforeDeliveryItemsInfoF7Select(e, key);
                break;
            }
        }
    }

    public void beforeItemsInfoF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity, String key, int index) {
        IFormView view = this.getView();
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        if (branchId == 0L || orgId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f00\u5355\u95e8\u5e97\u6216\u4e1a\u52a1\u7ec4\u7ec7\u5f02\u5e38\u3002", (IFormView)view);
            e.setCancel(true);
            return;
        }
        boolean memberIsBlank = this.checkMemberIsBlank(dataEntity);
        if (memberIsBlank) {
            e.setCancel(true);
            return;
        }
        boolean isEnableUserScopes = this.isEnableUserScopes(dataEntity);
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("goodsentryentity", index);
        long saleManId = 0L;
        long saleDeptId = 0L;
        if (isEnableUserScopes) {
            boolean saleManIsBlank = this.checkSaleManIsBlank(dataEntity);
            if (saleManIsBlank) {
                e.setCancel(true);
                return;
            }
            DynamicObject goodsSaleMan = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodssaler");
            saleManId = DynamicObjectUtils.getPkValue((DynamicObject)goodsSaleMan, (String)"sysuser");
            saleDeptId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"saledepartment");
            if (saleManId == 0L || saleDeptId == 0L) {
                NotificationUtil.showDefaultTipNotify((String)"\u8be5\u4e1a\u52a1\u7ec4\u7ec7\u542f\u7528\u4e86\u4eba\u5458\u53ef\u9500\u8303\u56f4\u63a7\u5236\uff0c \u8bf7\u5148\u5f55\u5165\u5546\u54c1\u9500\u552e\u5458\u548c\u9500\u552e\u90e8\u95e8\u4fe1\u606f\u3002", (IFormView)view);
                e.setCancel(true);
                return;
            }
        }
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsid");
        SaleOrderItemF7Filter.beforeItemF7Filter((BeforeF7SelectEvent)e, (IFormView)view, (long)orgId, (long)branchId, (long)currencyId, (String)key, (boolean)isEnableUserScopes, (long)saleDeptId, (long)saleManId, (long)goodsId);
    }

    public void beforeSaleContentF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity, int index) {
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        if (CommonUtils.checkBranchIsBlank((IFormView)this.getView(), (long)branchId) || this.checkMemberIsBlank(dataEntity)) {
            e.setCancel(true);
            return;
        }
        if (this.isEnableUserScopes(dataEntity)) {
            DynamicObject saleMan = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"saler");
            if (this.checkSaleManIsBlank(saleMan)) {
                e.setCancel(true);
                return;
            }
            DynamicObject entryEntity = this.getModel().getEntryRowEntity("goodsentryentity", index);
            DynamicObject goodsSaleMan = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodssaler");
            long saleManId = DynamicObjectUtils.getPkValue((DynamicObject)goodsSaleMan, (String)"sysuser");
            long saleDeptId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"saledepartment");
            if (saleManId == 0L || saleDeptId == 0L) {
                NotificationUtil.showDefaultTipNotify((String)"\u8be5\u4e1a\u52a1\u7ec4\u7ec7\u542f\u7528\u4e86\u4eba\u5458\u53ef\u9500\u8303\u56f4\u63a7\u5236\uff0c \u8bf7\u5148\u5f55\u5165\u5546\u54c1\u9500\u552e\u5458\u548c\u9500\u552e\u90e8\u95e8\u4fe1\u606f\u3002", (IFormView)this.getView());
                e.setCancel(true);
                return;
            }
        }
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        HashMap<String, Long> customParams = new HashMap<String, Long>(3);
        customParams.put("channelid", branchId);
        customParams.put("currencyid", currencyId);
        ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
        parameter.setBillFormId("ocpos_salecontent");
        parameter.setCustomParams(customParams);
        parameter.setCaption("\u5546\u54c1\u5217\u8868");
        parameter.setFormId("ocpos_goods_listf7");
        parameter.setLookUp(true);
        parameter.setMultiSelect(false);
        parameter.setShowApproved(false);
        parameter.setShowFilter(false);
        parameter.setShowQuickFilter(false);
        parameter.setShowTitle(true);
        QFilter filter = PosItemUtil.getSaleContentFilter((long)branchId, (long)currencyId, (String)"");
        ListFilterParameter filterParameter = new ListFilterParameter(Collections.singletonList(filter), null);
        parameter.setListFilterParameter(filterParameter);
    }

    public void beforeBranchF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        QFilter filter = billTypeId == BillTypeEnum.STORE.getId() ? F7Util.getBranchSalerFilterToStore() : F7Util.getBranchSalerFilter();
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    public void beforeCustomerF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        if (orgId <= 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u4e1a\u52a1\u7ec4\u7ec7\u5f02\u5e38\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and(BaseDataServiceHelper.getBaseDataProFilter((String)"bd_customer", (Long)orgId, (String)"id"));
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeSalerF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        if (CommonUtils.checkBranchIsBlank((IFormView)this.getView(), (long)branchId)) {
            e.setCancel(true);
            return;
        }
        QFilter filter = F7Util.getSalerFilter((long)branchId);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeDeliveryModeF7Select(BeforeF7SelectEvent e, int index) {
        DynamicObject goods = (DynamicObject)this.getModel().getValue("delivergoodsid", index);
        QFilter filter = F7Util.getDistributionModeFilter((DynamicObject)goods);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeStockF7Select(BeforeF7SelectEvent e, String key, int index) {
        QFilter filter = this.getStockFilter(key, index);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeStockPositionF7Select(BeforeF7SelectEvent e, String key, String stockKey, int index) {
        QFilter filter = this.getStockPositionIdFilter(key, stockKey, index);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeInvOrgF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity, int index) {
        QFilter filter;
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        if (orgId == 0L || branchId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u4e1a\u52a1\u7ec4\u7ec7\u6216\u5f00\u5355\u95e8\u5e97\u5f02\u5e38\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        String invQueryRange = SystemParamUtil.getInvQueryRange((long)orgId, (long)branchId);
        DynamicObject stock = (DynamicObject)this.getModel().getValue("erpstockid", index);
        if (stock == null) {
            filter = F7Util.getStockOrgFilter((long)orgId, (String)invQueryRange);
        } else {
            List invOrgIds = InventoryUtils.getInvOrgIds((long)orgId, (String)invQueryRange);
            long stockId = DynamicObjectUtils.getPkValue((DynamicObject)stock);
            List invOrgIdsByStock = InventoryUtils.getInvOrgIdsByStock((long)stockId);
            invOrgIds.retainAll(invOrgIdsByStock);
            filter = new QFilter("id", "in", (Object)invOrgIds);
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeSaleDeptF7Select(BeforeF7SelectEvent e, int index) {
        DynamicObject saler = (DynamicObject)this.getModel().getValue("goodssaler", index);
        if (saler == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u5458\u4fe1\u606f\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        QFilter filter = F7Util.getSaleDeptFilter((DynamicObject)saler);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeDeliveryItemsInfoF7Select(BeforeF7SelectEvent e, String key) {
        QFilter filter = this.getDeliveryGoodsFilter(key);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private QFilter getStockFilter(String key, int index) {
        QFilter filter;
        if (StringUtils.equals((CharSequence)key, (CharSequence)"deliverstockid")) {
            DynamicObject saleBranch = (DynamicObject)this.getModel().getValue("deliverdeliverybranchid", index);
            filter = F7Util.getStockIdFilter((DynamicObject)saleBranch);
        } else {
            DynamicObject inventoryOrg = (DynamicObject)this.getModel().getValue("inventoryorgid", index);
            long inventoryOrgId = DynamicObjectUtils.getPkValue((DynamicObject)inventoryOrg);
            List lstStockId = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IWareHouseService", (String)"getAllSetupWarehouseIDs", (Object[])new Object[]{Collections.singletonList(inventoryOrgId)});
            filter = new QFilter("Id", "in", (Object)lstStockId);
        }
        return filter;
    }

    private QFilter getStockPositionIdFilter(String key, String stockKey, int index) {
        DynamicObject stock = (DynamicObject)this.getModel().getValue(stockKey, index);
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)stock);
        if (StringUtils.equals((CharSequence)key, (CharSequence)"stockpositionid")) {
            return F7Util.getStockPositionidFilter((long)stockId);
        }
        return F7Util.getErpStockPositionidFilter((long)stockId);
    }

    private QFilter getDeliveryGoodsFilter(String key) {
        DynamicObjectCollection subEntry = this.getModel().getEntryEntity("salesorderdelivery");
        DynamicObject parent = (DynamicObject)subEntry.getParent();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"delivergoodsid")) {
            long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)parent, (String)"goodsid");
            return new QFilter("id", "=", (Object)goodsId);
        }
        long barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)parent, (String)"barcode");
        return new QFilter("id", "=", (Object)barCodeId);
    }

    private boolean checkMemberIsBlank(DynamicObject dataEntity) {
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        boolean isMemberMustInput = SystemParamUtil.getIsMustInputMember((long)saleOrgId, (long)branchId);
        DynamicObject member = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
        if (isMemberMustInput && ObjectUtils.isEmpty((Object)member)) {
            NotificationUtil.showDefaultTipNotify((String)"\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u542f\u7528\u4e86\u4f1a\u5458\u5fc5\u5f55\u53c2\u6570\uff0c\u8bf7\u5148\u5f55\u5165\u4f1a\u5458\u4fe1\u606f\u3002", (IFormView)this.getView());
            return true;
        }
        return false;
    }

    private boolean checkSaleManIsBlank(DynamicObject dataEntity) {
        long saleManId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"saler");
        if (saleManId <= 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u9500\u552e\u5458\u4fe1\u606f\u3002", (IFormView)this.getView());
            return true;
        }
        return false;
    }

    private boolean isEnableUserScopes(DynamicObject dataEntity) {
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        return SystemParamUtil.getIsEnableUserScopes((long)bizOrgId, (long)branchId);
    }
}

