/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.botp.ReleaseConvertDataMutexPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.botp.ConvertService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.promotion.BuildParamHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDrawHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderPushHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.JsonUtil;

public class SalesOrderDrawEdit
extends AbstractBillPlugIn {
    private static final Log LOG = LogFactory.getLog(SalesOrderDrawEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap4"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String entityId = this.getView().getEntityId();
        String formId = this.getView().getFormShowParameter().getFormId();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        block6 : switch (entityId) {
            case "ocpos_saleorder_final": {
                switch (formId) {
                    case "ocpos_saleorder_credit": {
                        this.showDrawForm("SXD", "\u9009\u62e9\u5e94\u6536\u660e\u7ec6", "adv_selectsxd");
                        break block6;
                    }
                    case "ocpos_saleorder_billfinal": 
                    case "ocpos_saleorder_bookfinal": {
                        String posSaleOrderType = "LSWKD";
                        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
                        if (billTypeId == BillTypeEnum.RESERVEFINAL.getId()) {
                            posSaleOrderType = "YDWKD";
                        }
                        this.showDrawForm(posSaleOrderType, "\u9009\u62e9\u5c3e\u6b3e\u660e\u7ec6", "adv_selectwkd");
                        break block6;
                    }
                }
                break;
            }
            case "ocpos_saleorder": {
                switch (formId) {
                    case "ocpos_saleorder_group": 
                    case "ocpos_saleorder_guide": {
                        this.showDrawForm("DGD", "\u9009\u62e9\u5bfc\u8d2d\u5355", "adv_selectdgd");
                        break block6;
                    }
                    case "ocpos_saleorder_cvtsale": {
                        this.showDrawForm("CVTSALE", "\u9009\u62e9\u9884\u8ba2\u6570\u636e", "adv_selectydd");
                        break block6;
                    }
                }
                break;
            }
            case "ocpos_saleorder_return": {
                String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
                if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) break;
                String posSaleOrderType = "RETURNSALE";
                String caption = "\u9009\u62e9\u9000\u8d27\u660e\u7ec6";
                if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.CANCELORDER.getValue())) {
                    posSaleOrderType = "CANCELORDER";
                    caption = "\u9009\u62e9\u9000\u8ba2\u660e\u7ec6";
                }
                this.showDrawForm(posSaleOrderType, caption, "adv_selectthd");
                break;
            }
            case "ocpos_salechange": {
                this.showDrawForm("CHANGE", "\u9009\u62e9\u6362\u8d27\u660e\u7ec6", "adv_selecthhd");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "adv_selectdgd": {
                this.showDrawForm("DGD", "\u9009\u62e9\u5bfc\u8d2d\u5355", key);
                break;
            }
            case "adv_selectsxd": {
                this.showDrawForm("SXD", "\u9009\u62e9\u5e94\u6536\u660e\u7ec6", key);
                break;
            }
            case "adv_selectwkd": {
                String posSaleOrderType = "LSWKD";
                DynamicObject billType = (DynamicObject)this.getModel().getValue("basebilltype");
                if (DynamicObjectUtils.getPkValue((DynamicObject)billType) == BillTypeEnum.RESERVEFINAL.getId()) {
                    posSaleOrderType = "YDWKD";
                }
                this.showDrawForm(posSaleOrderType, "\u9009\u62e9\u5c3e\u6b3e\u660e\u7ec6", key);
                break;
            }
            case "adv_selectydd": {
                this.showDrawForm("CVTSALE", "\u9009\u62e9\u9884\u8ba2\u6570\u636e", key);
                break;
            }
            case "adv_selectthd": {
                String posSaleOrderType = "RETURNSALE";
                String caption = "\u9009\u62e9\u9000\u8d27\u660e\u7ec6";
                String bizType = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("biztype"));
                if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.CANCELORDER.getValue())) {
                    posSaleOrderType = "CANCELORDER";
                    caption = "\u9009\u62e9\u9000\u8ba2\u660e\u7ec6";
                }
                this.showDrawForm(posSaleOrderType, caption, key);
                break;
            }
            case "adv_selecthhd": {
                this.showDrawForm("CHANGE", "\u9009\u62e9\u6362\u8d27\u660e\u7ec6", key);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        List lstReturnData = (List)returnData;
        if (ObjectUtils.isEmpty((Object)lstReturnData)) {
            return;
        }
        String srcEntityId = "ocpos_saleorder";
        String srcSubEntryKey = "salesorderdelivery";
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long targetBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        String targetBizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        String ruleId = this.getRuleId(targetBillTypeId);
        if (StringUtils.isEmpty((CharSequence)ruleId)) {
            throw new KDBizException("\u65e0\u5339\u914d\u7684\u5355\u636e\u8f6c\u6362\u89c4\u5219\u3002");
        }
        this.clearEntry(dataEntity);
        this.getModel().updateCache();
        String sourceEntryKey = this.getSourceEntryKey(targetBillTypeId);
        String targetEntityId = this.getView().getEntityId();
        this.drawUpdateUpData(lstReturnData, srcEntityId, targetEntityId, sourceEntryKey, srcSubEntryKey, ruleId);
        this.customProcess(lstReturnData, targetBillTypeId);
        this.getView().updateView();
        if (StringUtils.equals((CharSequence)targetBizType, (CharSequence)BizTypeEnum.GUIDEORDER.getValue()) || StringUtils.equals((CharSequence)targetBizType, (CharSequence)BizTypeEnum.GROUPORDER.getValue())) {
            DynamicObjectCollection goodsEntryList = this.getModel().getDataEntity(true).getDynamicObjectCollection("goodsentryentity");
            for (int index = 1; index < goodsEntryList.size() + 1; ++index) {
                BuildParamHelper.matchItemPromotion((IFormView)this.getView(), (DynamicObjectCollection)goodsEntryList, (int)index);
            }
        }
        this.getView().updateView();
    }

    private void clearEntry(DynamicObject dataEntity) {
        DynamicObjectCollection arEntryEntity;
        DynamicObjectCollection sendIntegralEntity;
        DynamicObjectCollection ticketSendEntity;
        DynamicObjectCollection goodSendEntity;
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            entryEntity.clear();
            this.getView().updateView("goodsentryentity");
        }
        if ((goodSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity")) != null && goodSendEntity.size() > 0) {
            goodSendEntity.clear();
            this.getView().updateView("goodsendentity");
        }
        if ((ticketSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity")) != null && ticketSendEntity.size() > 0) {
            ticketSendEntity.clear();
            this.getView().updateView("ticketsendentity");
        }
        if ((sendIntegralEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity")) != null && sendIntegralEntity.size() > 0) {
            sendIntegralEntity.clear();
            this.getView().updateView("sendintegralentity");
        }
        if ((arEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"arentryentity")) != null && arEntryEntity.size() > 0) {
            arEntryEntity.clear();
            this.getView().updateView("arentryentity");
        }
    }

    private void showDrawForm(String type, String caption, String actionId) {
        DynamicObject bill = this.getModel().getDataEntity(true);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"salebranchid");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"bizorgid");
        if (branchId == 0L || orgId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u7ef4\u62a4\u5f00\u5355\u95e8\u5e97\u548c\u4e1a\u52a1\u7ec4\u7ec7\u3002", (IFormView)this.getView());
            return;
        }
        HashMap<String, Object> customsParams = new HashMap<String, Object>(5);
        customsParams.put("branchid", branchId);
        customsParams.put("orgid", orgId);
        customsParams.put("type", type);
        customsParams.put("TargetBillPageId", this.getView().getPageId());
        String bizType = DynamicObjectUtils.getString((DynamicObject)bill, (String)"biztype");
        customsParams.put("isredrush", StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.REDRUSH.getValue()));
        if (type.equals("CHANGE")) {
            String changeItemType = bill.getString("changeitemtype");
            customsParams.put("changeitemtype", changeItemType);
            String makeUpBalanceMode = bill.getString("makeupbalancemode");
            customsParams.put("makeupbalancemode", makeUpBalanceMode);
        }
        FormShowParameter param = FormShowUtils.openNewForm((String)caption, (String)"ocpos_saleorder_draw", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customsParams);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(param);
    }

    private void drawUpdateUpData(List<Map<String, Object>> lstReturnData, String srcEntityId, String targetEntityId, String sourceEntryKey, String srcSubEntryKey, String ruleId) {
        Map<Long, List<Map>> mapList = lstReturnData.stream().collect(Collectors.groupingBy(m -> (Long)m.get("id")));
        boolean isStoreBill = false;
        for (Map.Entry<Long, List<Map>> entry : mapList.entrySet()) {
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)entry.getKey(), (String)srcEntityId);
            if (ObjectUtils.isEmpty((Object)dataEntity)) continue;
            List<Map<String, Object>> lstData = entry.getValue();
            long baseBillTypeId = CommonUtil.formatObejctToLong(lstData.get(0).get("basebilltypeid"));
            if (baseBillTypeId == BillTypeEnum.STORE.getId()) {
                isStoreBill = true;
                DynamicObjectCollection goodsEntryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
                if (CollectionUtils.isEmpty((Collection)goodsEntryEntity)) continue;
                this.doMergeDrawEachBill(dataEntity, lstData, srcEntityId, targetEntityId, sourceEntryKey, srcSubEntryKey, ruleId);
                continue;
            }
            this.doDrawEachBill(dataEntity, lstData, srcEntityId, targetEntityId, sourceEntryKey, srcSubEntryKey, ruleId);
        }
        if (isStoreBill) {
            DynamicObject drawBill = this.getView().getModel().getDataEntity(true);
            SaleOrderPushHelper.mergeSendTicketPointEntitys((DynamicObject)drawBill);
        }
    }

    private void doDrawEachBill(DynamicObject dataEntity, List<Map<String, Object>> lstData, String srcEntityId, String targetEntityId, String sourceEntryKey, String srcSubEntryKey, String ruleId) {
        JSONObject customParamJson = new JSONObject();
        String changeItemType = CommonUtil.formatStringToEmpty((Object)lstData.get(0).get("changeitemtype"));
        String makeUpBalanceMode = CommonUtil.formatStringToEmpty((Object)lstData.get(0).get("makeupbalancemode"));
        customParamJson.put("changeitemtype", (Object)changeItemType);
        customParamJson.put("makeupbalancemode", (Object)makeUpBalanceMode);
        boolean wholeBillPush = CommonUtil.formatObjectToBoolean((Object)lstData.get(0).get("wholebillpush"));
        String targetBillPageId = CommonUtil.formatStringToEmpty((Object)lstData.get(0).get("TargetBillPageId"));
        long baseBillTypeId = CommonUtil.formatObejctToLong((Object)lstData.get(0).get("basebilltypeid"));
        ListSelectedRowCollection selectedRows = SaleOrderDrawHelper.getAllListSelectedRow((DynamicObject)dataEntity, (boolean)wholeBillPush, lstData, (String)sourceEntryKey, (String)srcSubEntryKey);
        if (!ObjectUtils.isEmpty((Object)selectedRows)) {
            this.doDraw(selectedRows, customParamJson, srcEntityId, ruleId, targetEntityId, targetBillPageId);
            SaleOrderDrawHelper.setDrawQtyZero((DynamicObject)dataEntity);
        }
        if (StringUtils.equals((CharSequence)targetEntityId, (CharSequence)"ocpos_saleorder") && baseBillTypeId != BillTypeEnum.STORE.getId() || StringUtils.equals((CharSequence)targetEntityId, (CharSequence)"ocpos_saleorder_final")) {
            return;
        }
        Map otherBillListSelectedRowsMap = SaleOrderDrawHelper.getRelateSendEntitySelectedRow((DynamicObject)dataEntity, lstData, (String)sourceEntryKey, (String)srcSubEntryKey);
        if (otherBillListSelectedRowsMap.size() > 0) {
            for (Map.Entry entry : otherBillListSelectedRowsMap.entrySet()) {
                DynamicObject relateDataEntity = (DynamicObject)entry.getKey();
                ListSelectedRowCollection relateSelectedRows = (ListSelectedRowCollection)entry.getValue();
                this.doDraw(relateSelectedRows, customParamJson, srcEntityId, ruleId, targetEntityId, targetBillPageId);
                SaleOrderDrawHelper.setDrawQtyZero((DynamicObject)relateDataEntity);
            }
        }
    }

    private void doMergeDrawEachBill(DynamicObject dataEntity, List<Map<String, Object>> lstData, String srcEntityId, String targetEntityId, String sourceEntryKey, String srcSubEntryKey, String ruleId) {
        boolean wholeBillPush = true;
        String targetBillPageId = CommonUtil.formatStringToEmpty((Object)lstData.get(0).get("TargetBillPageId"));
        ListSelectedRowCollection selectedRows = SaleOrderDrawHelper.getAllListSelectedRow((DynamicObject)dataEntity, (boolean)wholeBillPush, lstData, (String)sourceEntryKey, (String)srcSubEntryKey);
        if (!ObjectUtils.isEmpty((Object)selectedRows)) {
            JSONObject customParamJson = new JSONObject();
            this.doDraw(selectedRows, customParamJson, srcEntityId, ruleId, targetEntityId, targetBillPageId);
            SaleOrderDrawHelper.setDrawQtyZero((DynamicObject)dataEntity);
        }
    }

    private ConvertOperationResult draw(DrawArgs args) {
        String argsJson = SerializationUtils.toJsonString((Object)args);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)args.getSourceEntityNumber());
        String resultStr = (String)DispatchServiceHelper.invokeBOSService((String)dt.getAppId(), (String)ConvertService.class.getSimpleName(), (String)"draw", (Object[])new Object[]{argsJson});
        return (ConvertOperationResult)SerializationUtils.fromJsonString((String)resultStr, ConvertOperationResult.class);
    }

    private void addReleaseSourceDataMutexPlugin(IFormView billView, ConvertOperationResult drawResult) {
        boolean exist = false;
        String plugInName = ReleaseConvertDataMutexPlugin.class.getName();
        for (Plugin plugin : billView.getFormShowParameter().getFormConfig().getPlugins()) {
            if (!StringUtils.equals((CharSequence)plugin.getClassName(), (CharSequence)plugInName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            billView.getFormShowParameter().addCustPlugin(plugInName);
            billView.cacheFormShowParameter();
        }
        ReleaseConvertDataMutexPlugin.addConvertDataMutex((IFormView)billView, (String)drawResult.getSourceEntityNumber(), (Collection)drawResult.getDataMutexSrcBillIds());
    }

    private void doDraw(ListSelectedRowCollection selectedRows, JSONObject customParamJson, String sourceEntityId, String ruleId, String targetEntityId, String targetBillPageId) {
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
        DrawArgs args = new DrawArgs();
        args.setSourceEntityNumber(sourceEntityId);
        args.setTargetEntityNumber(targetEntityId);
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.getSelectedRows().addAll(selectedRows);
        args.setTargetPageId(targetBillPageId);
        args.setRuleId(ruleId);
        args.setBuildConvReport(true);
        args.addCustomParam("customparam", customParamJson.toJSONString());
        ConvertOperationResult result = this.draw(args);
        if (!result.isSuccess() || result.getCachePageIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        } else {
            IBillView billView = (IBillView)this.getView();
            IRefrencedataProvider refProvider = BusinessDataReader::loadRefence;
            List dataEntities = result.loadTargetDataObjects(refProvider, billView.getModel().getDataEntityType());
            this.addReleaseSourceDataMutexPlugin((IFormView)billView, result);
            ((IBillModel)billView.getModel()).push(dataEntities.get(0));
            billView.updateView();
            this.getView().sendFormAction((IFormView)billView);
            result.release(refProvider, billView.getModel().getDataEntityType());
        }
    }

    private String getSourceEntryKey(long billTypeId) {
        if (billTypeId == BillTypeEnum.CREDIT.getId()) {
            return "finentity";
        }
        return "goodsentryentity";
    }

    private String getRuleId(long billTypeId) {
        String ruleId = "";
        BillTypeEnum billTypeEnum = BillTypeEnum.getTypeById((long)billTypeId);
        switch (billTypeEnum) {
            case CREDIT: {
                ruleId = "1041438978085186560";
                break;
            }
            case RESERVEFINAL: {
                ruleId = "1041439046024642560";
                break;
            }
            case FINAL: {
                ruleId = "1041439065595145216";
                break;
            }
            case CVTSALE: {
                ruleId = "1041425008972491776";
                break;
            }
            case GUIDE: 
            case GROUP: {
                ruleId = "1041424963749506048";
                break;
            }
            case RETURN: {
                ruleId = "1041435233737731072";
                break;
            }
            case CHANGE: {
                ruleId = "1072585245058205696";
                break;
            }
        }
        return ruleId;
    }

    private void customProcess(List<Map<String, Object>> lstReturnData, long billTypeId) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (billTypeId == BillTypeEnum.GROUP.getId()) {
            this.groupCustomProcess(dataEntity);
        } else if (billTypeId == BillTypeEnum.RETURN.getId()) {
            this.fillEntityFromDrawParam(dataEntity, lstReturnData);
            this.transferUnit(dataEntity);
            this.updateGiftDeliveryData(dataEntity, billTypeId);
            this.returnCustomProcess(dataEntity);
        } else if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            String changeItemType = (String)lstReturnData.get(0).get("changeitemtype");
            Object makeUpBalanceMode = lstReturnData.get(0).get("makeupbalancemode");
            JSONObject paramJson = new JSONObject();
            paramJson.put("changeitemtype", (Object)changeItemType);
            paramJson.put("makeupbalancemode", makeUpBalanceMode);
            SaleOrderPushHelper.pushChangeBillCreateNewGoodsEntity((DynamicObject)dataEntity, (JSONObject)paramJson);
            this.fillEntityFromDrawParam(dataEntity, lstReturnData);
            this.transferUnit(dataEntity);
            this.updateGiftDeliveryData(dataEntity, billTypeId);
        } else if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
            this.transferUnit(dataEntity);
        }
    }

    private void groupCustomProcess(DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        String date = CommonUtil.format((Date)TimeServiceHelper.now(), (String)TimeServiceHelper.getDateTimeFormatString());
        for (DynamicObject entryItem : entryEntity) {
            long stockTypeId;
            long unitId;
            long barCodeId;
            long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"goodsid");
            JSONObject result = CommonUtils.getPricePolicyData((long)goodsId, (long)(barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"barcode")), (long)channelId, (long)(unitId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"unit")), (long)(stockTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"channelstocktypeid")), (String)date);
            if (ObjectUtils.isEmpty((Object)result)) {
                entryItem.set("mingroupbuyingprice", (Object)BigDecimal.ZERO);
                continue;
            }
            JSONObject pricePolicyResult = result.getJSONObject("data");
            LOG.info("\u5f00\u5355\u53d6\u4ef7\u8fd4\u53c2\uff1a" + JsonUtil.toJson((Object)pricePolicyResult));
            if (ObjectUtils.isEmpty((Object)pricePolicyResult)) {
                entryItem.set("mingroupbuyingprice", (Object)BigDecimal.ZERO);
                continue;
            }
            BigDecimal lowestPrice = pricePolicyResult.getBigDecimal("lowestPrice");
            entryItem.set("mingroupbuyingprice", (Object)lowestPrice);
        }
        this.getView().updateView("goodsentryentity");
    }

    private void returnCustomProcess(DynamicObject dataEntity) {
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) {
            return;
        }
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        for (DynamicObject entryEntity : entryEntities) {
            int index = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq") - 1;
            if (index < 0) {
                index = 0;
            }
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
            this.getView().setEnable(Boolean.valueOf(!isPresent), index, new String[]{"saleqty"});
        }
    }

    private void fillEntityFromDrawParam(DynamicObject dataEntity, List<Map<String, Object>> lstReturnData) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        boolean wholeBillPush = (Boolean)lstReturnData.get(0).get("wholebillpush");
        HashMap<Long, Map<String, Object>> deliveryRuleMap = new HashMap<Long, Map<String, Object>>();
        this.assembleReturnRuleFromDraw(lstReturnData, deliveryRuleMap, wholeBillPush);
        for (DynamicObject entryItem : entryEntity) {
            String saleOption = DynamicObjectUtils.getString((DynamicObject)entryItem, (String)"saleoption");
            if (StringUtils.equalsIgnoreCase((CharSequence)saleOption, (CharSequence)"1")) continue;
            DynamicObjectCollection deliveryEntity = entryItem.getDynamicObjectCollection("salesorderdelivery");
            for (DynamicObject deliveryItem : deliveryEntity) {
                Object returnReason;
                Object returnType;
                Object returnWareHouse;
                Object returnOrg;
                Map deliveryMap = !wholeBillPush ? (Map)deliveryRuleMap.get(deliveryItem.getLong("srcdeliveryentryid")) : (Map)deliveryRuleMap.get(dataEntity.getLong("sourcebillid"));
                if (deliveryMap == null) continue;
                Object deliveryStockType = deliveryMap.get("deliverystocktype");
                if (deliveryStockType != null) {
                    deliveryItem.set("deliverystocktype", deliveryStockType);
                }
                if ((returnOrg = deliveryMap.get("returnorg")) != null) {
                    deliveryItem.set("inventoryorgid", returnOrg);
                    deliveryItem.set("deliverykeeper", returnOrg);
                    deliveryItem.set("deliveryowner", returnOrg);
                }
                if ((returnWareHouse = deliveryMap.get("returnwarehouse")) != null) {
                    deliveryItem.set("erpstockid", returnWareHouse);
                    deliveryItem.set("deliverstockid", null);
                }
                if (!ObjectUtils.isEmpty(returnType = deliveryMap.get("returntype"))) {
                    deliveryItem.set("returntype", returnType);
                }
                if ((returnReason = deliveryMap.get("returnreason")) == null) continue;
                deliveryItem.set("returnreason", returnReason);
            }
        }
    }

    private void assembleReturnRuleFromDraw(List<Map<String, Object>> lstReturnData, Map<Long, Map<String, Object>> deliveryRuleMap, boolean wholebillpush) {
        for (Map<String, Object> returnData : lstReturnData) {
            long sunEntryId = wholebillpush ? ((Long)returnData.get("id")).longValue() : ((Long)returnData.get("subentryid")).longValue();
            deliveryRuleMap.put(sunEntryId, returnData);
        }
    }

    private void transferUnit(DynamicObject dataEntity) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        for (DynamicObject entryEntity : entryEntities) {
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
            long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"materielid");
            long unitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"unit");
            long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"baseunit");
            if (materialId == 0L || unitId == 0L || baseUnitId == 0L) continue;
            BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)saleQty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
            entryEntity.set("baseunitqty", (Object)baseQty);
            long stockUnitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"stockunit");
            if (stockUnitId == 0L) continue;
            BigDecimal stockQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)stockUnitId);
            entryEntity.set("stockunitqty", (Object)stockQty);
        }
        this.getView().updateView("goodsentryentity");
    }

    private void updateGiftDeliveryData(DynamicObject dataEntity, long billTypeId) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        DynamicObjectCollection giftSendEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection promoteEntities;
            DynamicObjectCollection deliveryEntities;
            String saleOption;
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
            if (isPresent || billTypeId == BillTypeEnum.CHANGE.getId() && StringUtils.equals((CharSequence)(saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption")), (CharSequence)"1") || CollectionUtils.isEmpty((Collection)(deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery")))) continue;
            DynamicObject deliveryEntity = (DynamicObject)deliveryEntities.get(0);
            DynamicObject returnReason = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntity, (String)"returnreason");
            String returnType = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"returntype");
            if (returnReason == null || StringUtils.isBlank((CharSequence)returnType)) continue;
            String srcSeq = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"srcseq");
            if (!CollectionUtils.isEmpty((Collection)giftSendEntities)) {
                Set<Integer> manualGiftSeqSet = giftSendEntities.stream().filter(p -> Arrays.asList(DynamicObjectUtils.getString((DynamicObject)p, (String)"inisendgoodsseq").split(",")).contains(srcSeq)).map(q -> DynamicObjectUtils.getInt((DynamicObject)q, (String)"seq")).collect(Collectors.toSet());
                this.updateGiftDeliveryData(entryEntities, manualGiftSeqSet, returnReason, returnType, "promoteseq");
            }
            if (CollectionUtils.isEmpty((Collection)(promoteEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderpromote")))) continue;
            Set<Integer> promoteGiftSeqSet = promoteEntities.stream().filter(p -> DynamicObjectUtils.getPkValue((DynamicObject)p, (String)"promotegoodsid") > 0L).map(q -> DynamicObjectUtils.getInt((DynamicObject)q, (String)"promotegoodsseq")).collect(Collectors.toSet());
            this.updateGiftDeliveryData(entryEntities, promoteGiftSeqSet, returnReason, returnType, "seq");
        }
    }

    private void updateGiftDeliveryData(DynamicObjectCollection entryEntities, Set<Integer> giftSeqSet, DynamicObject reason, String type, String seqKey) {
        List giftEntities;
        if (!CollectionUtils.isEmpty(giftSeqSet) && !CollectionUtils.isEmpty(giftEntities = entryEntities.stream().filter(p -> DynamicObjectUtils.getBoolean((DynamicObject)p, (String)"ispresent") && giftSeqSet.contains(DynamicObjectUtils.getInt((DynamicObject)p, (String)seqKey))).collect(Collectors.toList()))) {
            for (DynamicObject giftEntity : giftEntities) {
                DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)giftEntity, (String)"salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
                deliveryEntities.forEach(x -> {
                    x.set("returnreason", (Object)reason);
                    x.set("returntype", (Object)type);
                });
            }
        }
    }
}

