/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocdbd.business.helper.UserServiceHelper;
import kd.occ.ocdbd.common.enums.UserStatusEnum;
import kd.occ.ocpos.business.promotion.BuildParamHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderInventoryHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderMemberHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;

public class SalesOrderMemberEdit
extends AbstractBillPlugIn
implements BeforeQuickAddNewListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit member = (BasedataEdit)this.getView().getControl("member");
        member.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        member.addBeforeF7SelectListener(event -> {
            DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorgid");
            long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)bizOrg);
            if (CommonUtils.checkBizOrg((IFormView)this.getView(), (long)bizOrgId)) {
                event.setCancel(true);
                return;
            }
            DynamicObject split = UserServiceHelper.getUserSplitByNumberOrOrgId(null, (Long)bizOrgId);
            if (split == null) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u914d\u7f6e\u4e1a\u52a1\u5355\u5143\u7ba1\u7406\u533a\u9694\u3002", (IFormView)this.getView());
                event.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.setFormId("ocpos_listf7_member");
            showParameter.setCustomParams(this.getCustomParamsAboutMember());
            showParameter.setBillFormId("ocpos_user_pos");
            showParameter.setCustomParam("splitid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)split));
            QFilter filter = new QFilter("splitid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)split));
            filter.and("userstatus", "=", (Object)UserStatusEnum.NORMAL.getValue());
            showParameter.getListFilterParameter().getQFilters().add(filter);
            showParameter.setShowTitle(true);
            OpenStyle openStyle = showParameter.getOpenStyle();
            StyleCss css = new StyleCss();
            css.setHeight("580");
            css.setWidth("960");
            openStyle.setInlineStyleCss(css);
            showParameter.setCustomParam("isFromPos", (Object)"1");
            showParameter.setShowQuickFilter(false);
            showParameter.setShowFilter(false);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "choose"));
            ArrayList<QFilter> customFilters = new ArrayList<QFilter>(0);
            customFilters.add(filter);
            event.setCustomQFilters(customFilters);
        });
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent e) {
        Control ctrl = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)ctrl.getKey(), (CharSequence)"member")) {
            e.setCancel(true);
            Map<String, Object> customParams = this.getCustomParamsAboutMember();
            FormShowParameter param = FormShowUtils.openNewForm((String)"", (String)"ocpos_registermember", (ShowType)ShowType.Modal, null, customParams);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "register"));
            this.getView().showForm(param);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"viewtickets")) {
            HashMap<String, Constable> customParams = new HashMap<String, Constable>(1);
            DynamicObject member = (DynamicObject)this.getModel().getValue("member");
            customParams.put("member", Long.valueOf(DynamicObjectUtils.getPkValue((DynamicObject)member)));
            customParams.put("isAllowSelect", Boolean.FALSE);
            customParams.put("salebranchid", Long.valueOf(0L));
            customParams.put("goodsid", null);
            FormShowParameter param = FormShowUtils.openNewForm((String)"", (String)"ocpos_ticketinfos", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"register")) {
            if (returnData instanceof Long) {
                Long memberId = Long.parseLong(returnData.toString());
                this.getModel().setValue("integralbalance", (Object)BigDecimal.ZERO);
                this.getModel().setValue("storevaluebalance", (Object)BigDecimal.ZERO);
                this.getModel().setItemValueByID("member", (Object)memberId);
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"choose")) {
            this.getModel().setValue("integralbalance", (Object)BigDecimal.ZERO);
            this.getModel().setValue("storevaluebalance", (Object)BigDecimal.ZERO);
            this.chooseMemberCallBack(returnData);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"member")) {
            DynamicObject member = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.initMemberView(member);
            this.reMatchPromotion();
        }
    }

    private Map<String, Object> getCustomParamsAboutMember() {
        HashMap<String, Object> customParams = new HashMap<String, Object>(3);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        customParams.put("bizorgid", bizOrgId);
        long saleBranchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        customParams.put("salebranchid", saleBranchId);
        long customerId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"customerid");
        customParams.put("customerid", customerId);
        return customParams;
    }

    private void chooseMemberCallBack(Object returnData) {
        BigDecimal integral = BigDecimal.ZERO;
        BigDecimal storedValue = BigDecimal.ZERO;
        long memberId = 0L;
        if (returnData instanceof ListSelectedRowCollection) {
            Object[] pkValues = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues();
            Map members = BusinessDataServiceHelper.loadFromCache((Object[])pkValues, (String)"ocdbd_user");
            DynamicObject member = members.values().stream().findFirst().orElse(null);
            memberId = DynamicObjectUtils.getPkValue((DynamicObject)member);
            integral = SaleOrderMemberHelper.getPointValue((long)memberId);
        } else if (returnData instanceof Map) {
            DynamicObject member = (DynamicObject)((Map)returnData).get("member");
            integral = (BigDecimal)((Map)returnData).get("pointvalue");
            storedValue = (BigDecimal)((Map)returnData).get("amountvalue");
            memberId = DynamicObjectUtils.getPkValue((DynamicObject)member);
        } else if (returnData instanceof Long) {
            memberId = CommonUtil.formatObejctToLong((Object)returnData);
        }
        this.getModel().setItemValueByID("member", (Object)memberId);
        this.getModel().setValue("integralbalance", (Object)integral);
        this.getModel().setValue("storevaluebalance", (Object)storedValue);
    }

    private void initMemberView(DynamicObject member) {
        List lstAddress;
        String memberPhone;
        String memberName;
        DynamicObjectCollection userAddress = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)member, (String)"ocdbd_user_addr_entry");
        if (CollectionUtils.isEmpty((Collection)userAddress)) {
            memberName = DynamicObjectUtils.getString((DynamicObject)member, (String)"name");
            memberPhone = DynamicObjectUtils.getString((DynamicObject)member, (String)"mobile");
        } else {
            DynamicObject defaultAddress = userAddress.stream().filter(a -> a.getBoolean("isdefault")).filter(s -> DynamicObjectUtils.getPkValue((DynamicObject)s, (String)"addresstypeid") == 749865059609482240L).findAny().orElse(null);
            if (null == defaultAddress) {
                DynamicObject deliveryAddress = userAddress.stream().filter(s -> DynamicObjectUtils.getPkValue((DynamicObject)s, (String)"addresstypeid") == 749865059609482240L).findAny().orElse(null);
                if (deliveryAddress != null) {
                    memberName = DynamicObjectUtils.getString((DynamicObject)deliveryAddress, (String)"contact");
                    memberPhone = DynamicObjectUtils.getString((DynamicObject)deliveryAddress, (String)"phone");
                } else {
                    memberName = DynamicObjectUtils.getString((DynamicObject)member, (String)"name");
                    memberPhone = DynamicObjectUtils.getString((DynamicObject)member, (String)"mobile");
                }
            } else {
                memberName = DynamicObjectUtils.getString((DynamicObject)defaultAddress, (String)"contact");
                memberPhone = DynamicObjectUtils.getString((DynamicObject)defaultAddress, (String)"phone");
            }
        }
        this.getModel().setValue("customername", (Object)memberName);
        this.getModel().setValue("customerphone", (Object)memberPhone);
        long vipTypeId = DynamicObjectUtils.getPkValue((DynamicObject)member, (String)"viptypeid");
        if (vipTypeId == 1069513413337666560L) {
            long customerId = DynamicObjectUtils.getPkValue((DynamicObject)member, (String)"customerid");
            this.getModel().setValue("customerid", (Object)customerId);
        }
        long memberId = DynamicObjectUtils.getPkValue((DynamicObject)member);
        BigDecimal integral = SaleOrderMemberHelper.getPointValue((long)memberId);
        this.getModel().setValue("integralbalance", (Object)integral);
        this.getModel().setValue("storevaluebalance", (Object)BigDecimal.ZERO);
        DynamicObjectCollection addressEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)member, (String)"ocdbd_user_addr_entry");
        String address = "";
        String districtId = "";
        if (!CollectionUtils.isEmpty((Collection)addressEntry) && !CollectionUtils.isEmpty(lstAddress = addressEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"addresstypeid") == 749865059609482240L).collect(Collectors.toList()))) {
            DynamicObject addressItem = lstAddress.stream().filter(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"isdefault")).findFirst().orElse(null);
            if (addressItem == null) {
                addressItem = (DynamicObject)lstAddress.get(0);
            }
            address = DynamicObjectUtils.getString((DynamicObject)addressItem, (String)"detailedaddress");
            districtId = DynamicObjectUtils.getString((DynamicObject)addressItem, (String)"districtid");
        }
        if (StringUtils.isEmpty((CharSequence)districtId) || StringUtils.equals((CharSequence)districtId, (CharSequence)"0")) {
            this.getModel().setValue("admindivisionid", null);
        } else {
            this.getModel().setValue("admindivisionid", (Object)districtId);
        }
        this.getModel().setValue("customeraddress", (Object)address);
        if (!ObjectUtils.isEmpty((Object)member)) {
            this.updateMemberDelivery(memberName, memberPhone, address);
        }
    }

    private void updateMemberDelivery(String memberName, String memberPhone, String address) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        if (StringUtils.equals((CharSequence)this.getView().getEntityId(), (CharSequence)BillTypeEnum.RESERVE.getNumber())) {
            return;
        }
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid");
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                deliveryEntity.set("consignee", (Object)memberName);
                if (memberPhone.contains("-")) {
                    memberPhone = memberPhone.substring(memberPhone.indexOf(45) + 1);
                }
                deliveryEntity.set("deliverphonenumber", (Object)memberPhone);
                SaleOrderInventoryHelper.upadateDeliveryAddress((DynamicObject)deliveryEntity, (String)adminDivisionId, (String)address);
            }
            this.getView().updateView("salesorderdelivery");
        }
    }

    private void reMatchPromotion() {
        String bizType = this.getView().getModel().getValue("biztype").toString();
        if (!StringUtils.equals((CharSequence)"ocpos_saleorder", (CharSequence)this.getView().getEntityId()) || StringUtils.equals((CharSequence)"C", (CharSequence)bizType)) {
            return;
        }
        DynamicObject currentBill = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection saleOrderGoodList = currentBill.getDynamicObjectCollection("goodsentryentity");
        DynamicObjectCollection saleOrderPromotionList = currentBill.getDynamicObjectCollection("promotionentity");
        saleOrderPromotionList.clear();
        for (int index = 0; index < saleOrderGoodList.size(); ++index) {
            if (((DynamicObject)saleOrderGoodList.get(index)).getDynamicObject("goodsid") == null) continue;
            BuildParamHelper.matchItemPromotion((IFormView)this.getView(), (DynamicObjectCollection)saleOrderGoodList, (int)index);
        }
    }
}

