/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.pay.payment.vo.PaymentRecord;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocdbd.business.helper.CreditMangageHelper;
import kd.occ.ocdbd.common.util.StringUtil;
import kd.occ.ocpos.business.commonhelper.CurrencyHelper;
import kd.occ.ocpos.business.push.AutoPushHelper;
import kd.occ.ocpos.business.saleorder.ReserveServiceHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderPushHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderReturnRuleHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.GiftTypeEnum;
import kd.occ.ocpos.common.enums.SaleStatusEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.PayUtil;
import kd.occ.ocpos.common.util.PermissionUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SalesOrderMenuActionEdit
extends AbstractBillPlugIn {
    private static final String PERM_SETTLEMENT = "18X97F3GNGE1";
    private static final String ACTION_SETTLE = "settleclose";
    private static final String ACTION_TICKETSENDCLOSE = "ticketsendclose";
    private static final String ACTION_NEWVIPADDRESSCLOSE = "newvipaddressclose";
    private static final String ACTION_UPDATEVIPADDRESSCLOSE = "updatevipaddressclose";
    private static final String ACTION_GOODSSENDCLOSE = "goodssendclose";
    private static final String ACTION_INTEGRALSENDCLOSE = "integralsendclose";
    private static final String ACTION_DISCOUNTWAYCLOSE = "discountwayclose";
    private static final String ACTION_CREDITPAYCLOSE = "creditpayclose";
    private static final String ACTION_DISTRIBUTIONCHANGECLOSE = "distributionchangeclose";
    private static final String ACTION_CREDITPAYCONFIRM = "creditpayconfirm";
    private static final Log log = LogFactory.getLog(SalesOrderMenuActionEdit.class);
    private static final String ACTION_USETICKETCLOSE = "useticketclose";
    private static final String KEY_CHECKPOLICY_CALLBACK_SAVE = "checkpolicy_callback_save";
    private static final String KEY_CHECKPOLICY_CALLBACK_SUBMIT = "checkpolicy_callback_submit";
    private static final String KEY_CHECKPOLICY_CALLBACK_SETTLE = "checkpolicy_callback_settle";
    private static final String ACTION_SETTLEAFTERAUDIT = "settleafteraudit";
    private static final String KEY_BTRECEIVABLES = "btreceivables";
    private static final String ACTION_DISCOUNTHANDLECLOSE = "discounthandleclose";
    private static final String ACTION_INVOICEINFOCLOSE = "invoiceinfoclose";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String opKey = op.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (opKey) {
            case "save": 
            case "submit": 
            case "settle": {
                OperationResult saveResult;
                String billStatus;
                String entityId = this.getView().getEntityId();
                if (StringUtils.equalsIgnoreCase((CharSequence)opKey, (CharSequence)"settle")) {
                    String saleStatus = dataEntity.getString("salestatus");
                    if (StringUtils.equalsIgnoreCase((CharSequence)saleStatus, (CharSequence)"S")) {
                        NotificationUtil.showDefaultTipNotify((String)"\u5355\u636e\u5df2\u7ed3\u7b97\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed3\u7b97\u3002", (IFormView)this.getView());
                        e.setCancel(true);
                        return;
                    }
                    this.setCashier(dataEntity);
                    if (!this.checkSettlePerm()) {
                        e.setCancel(true);
                        return;
                    }
                    if (!this.checkReturnRule(dataEntity, entityId)) {
                        e.setCancel(true);
                        return;
                    }
                }
                if (!this.checkCashierMustInput()) {
                    e.setCancel(true);
                    return;
                }
                List<OperateErrorInfo> errorList = this.checkDepositValidate(dataEntity);
                if (errorList.size() > 0) {
                    OperationResult errorResult = new OperationResult();
                    errorResult.setAllErrorInfo(errorList);
                    this.getView().showOperationResult(errorResult);
                    e.setCancel(true);
                    return;
                }
                if (!this.checkBookAndBalancePolicy(dataEntity, entityId, "checkpolicy_callback_" + opKey)) {
                    e.setCancel(true);
                    return;
                }
                this.removeBlankRow(dataEntity);
                if (!StringUtils.equals((CharSequence)opKey, (CharSequence)"submit") || !StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder") || !StringUtils.equals((CharSequence)(billStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus")), (CharSequence)StatusEnum.DRAFT.getValue()) || (saveResult = OperationServiceHelper.executeOperate((String)"save", (String)entityId, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create())) != null && saveResult.isSuccess()) break;
                this.getView().showOperationResult(saveResult);
                e.setCancel(true);
                break;
            }
            case "dodiscount": {
                String entityId;
                DynamicObjectCollection entryData = this.getModel().getEntryEntity("goodsentryentity");
                if (CollectionUtils.isEmpty((Collection)entryData)) {
                    this.getView().showErrorNotification("\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u3002");
                    e.setCancel(true);
                }
                if (!"ocpos_salechange".equals(entityId = this.getView().getEntityId())) break;
                this.saleChangeCheck(e);
                break;
            }
            case "newgoodsentry": {
                if (this.checkNewEntry()) break;
                e.setCancel(true);
                break;
            }
            case "creditpay": {
                this.beforeCreditPayOp(e);
                this.setCashier(dataEntity);
                break;
            }
            case "storepickup": {
                this.checkAndInputSerialNumber(e);
                break;
            }
            case "new": {
                CommonUtils.buildNewBillParams((AbstractBillPlugIn)this, (DynamicObject)dataEntity);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        String formId = this.getView().getFormShowParameter().getFormId();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (key) {
            case "submit": {
                if (result == null || !result.isSuccess()) break;
                this.afterSubmit(formId, dataEntity);
                break;
            }
            case "settle": {
                if (result == null || !result.isSuccess() || StringUtils.equals((CharSequence)formId, (CharSequence)"ocpos_saleorder_store")) break;
                this.doSettleOp(dataEntity);
                break;
            }
            case "manualcoupon": {
                this.showSendView(1);
                break;
            }
            case "manualsend": {
                this.showSendView(2);
                break;
            }
            case "sendintegral": {
                this.showSendView(3);
                break;
            }
            case "dodiscount": {
                this.showDiscountWay();
                break;
            }
            case "searchinventory": {
                this.showQueryInventory();
                break;
            }
            case "newvipaddress": {
                this.showVipAddressForm("ocpos_vipaddressnew", ACTION_NEWVIPADDRESSCLOSE);
                break;
            }
            case "updatevipaddress": {
                this.showVipAddressForm("ocpos_updatevipaddress", ACTION_UPDATEVIPADDRESSCLOSE);
                break;
            }
            case "dodistchange": {
                this.showDistributionChangeForm();
                break;
            }
            case "creditpay": {
                this.showCreditPayForm(dataEntity);
                break;
            }
            case "douseticket": {
                this.showSendView(4);
                break;
            }
            case "doinvoice": {
                this.showInvoiceInfoForm("ocpos_invoiceinfo", ACTION_INVOICEINFOCLOSE);
                break;
            }
            case "dovipconsumedetail": {
                this.showVipConsumeDetail(dataEntity);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            if (StringUtils.equals((CharSequence)actionId, (CharSequence)ACTION_SETTLE)) {
                this.getView().invokeOperation("refresh");
            }
            return;
        }
        switch (actionId) {
            case "ticketsendclose": {
                this.ticketSendClose(returnData);
                SaleOrderAmountHelper.recalculateShareAmount((DynamicObject)dataEntity);
                this.getView().updateView("goodsentryentity");
                break;
            }
            case "goodssendclose": {
                this.sendGoodsClose(returnData);
                break;
            }
            case "integralsendclose": {
                this.integralSendClose(returnData);
                SaleOrderAmountHelper.recalculateShareAmount((DynamicObject)dataEntity);
                this.getView().updateView("goodsentryentity");
                break;
            }
            case "discountwayclose": {
                this.discountWayClose(returnData);
                SaleOrderAmountHelper.recalculateShareAmount((DynamicObject)dataEntity);
                this.getView().updateView("goodsentryentity");
                break;
            }
            case "settleclose": {
                this.settleClose(returnData);
                break;
            }
            case "newvipaddressclose": 
            case "updatevipaddressclose": {
                this.vipAddressClose(returnData);
                break;
            }
            case "creditpayclose": {
                this.creditPayClose(returnData);
                break;
            }
            case "distributionchangeclose": {
                this.getView().updateView("salesorderdelivery");
                break;
            }
            case "useticketclose": {
                this.useTicketClose(returnData);
                SaleOrderAmountHelper.recalculateShareAmount((DynamicObject)dataEntity);
                this.getView().updateView("goodsentryentity");
                this.getView().updateView("useticketentity");
                break;
            }
            case "storepickup": {
                Object[] billIds;
                if (!(returnData instanceof Boolean) || !((Boolean)returnData).booleanValue()) break;
                NotificationUtil.showDefaultSuccessNotification((String)"\u5e8f\u5217\u53f7\u8865\u5f55\u5b8c\u6210\u3002", (IFormView)this.getView());
                DynamicObjectCollection goodsEntry = dataEntity.getDynamicObjectCollection("goodsentryentity");
                for (Object billId : billIds = goodsEntry.stream().filter(s -> s.getLong("lastbillid") != 0L).map(s -> s.getLong("lastbillid")).toArray()) {
                    AutoPushHelper.autoPushBill((Object)billId, (String)"ocococ_retailbill", (String)"ocococ_deliveryorder", (String)"audit");
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "discounthandleclose": {
                this.discountHandleClose(returnData);
                break;
            }
            case "invoiceinfoclose": {
                this.invoiceInfoClose(returnData);
                break;
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String actionId = e.getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (actionId) {
            case "settleafteraudit": {
                String billtype = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
                String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
                if (!StringUtils.equalsIgnoreCase((CharSequence)billtype, (CharSequence)"H")) {
                    log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u5e26\u91d1\u989d\u7ed3\u7b97\u8c03\u5ba1\u6838\u64cd\u4f5c", billNo));
                    this.settleAfterAudit(dataEntity);
                } else {
                    log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u5e26\u91d1\u989d\u7ed3\u7b97\u8c03\u6362\u8d27\u5355\u540c\u6b65\u66f4\u65b0\u4e0b\u6e38", billNo));
                    SaleOrderPushHelper.updateChangeBillTargartFinEntity((DynamicObject)dataEntity);
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BTRECEIVABLES});
                FormShowUtils.updateBillStatus((AbstractBillPlugIn)this);
                this.getView().invokeOperation("refresh");
                long orgId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
                long branchId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
                boolean isAutoPrint = SystemParamUtil.getIsAutoPrint((long)orgId, (long)branchId);
                if (!isAutoPrint) break;
                this.getView().invokeOperation("printpreview");
                break;
            }
            case "srcRelease": {
                Map releaseResult = ReserveServiceHelper.release((DynamicObject)dataEntity);
                if (CollectionUtils.isEmpty((Map)releaseResult)) {
                    return;
                }
                boolean isSuccess = CommonUtil.formatObjectToBoolean(releaseResult.get("releaseResult"));
                if (isSuccess) break;
                String errorMsg = CommonUtil.formatStringToEmpty(releaseResult.get("errorMsg"));
                this.getView().showErrorNotification(errorMsg);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key;
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        switch (key = e.getCallBackId()) {
            case "creditpayconfirm": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.showCreditPayForm(dataEntity);
                break;
            }
            case "checkpolicy_callback_save": {
                if (!e.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.getModel().setDataChanged(false);
                this.getView().invokeOperation("save");
                break;
            }
            case "checkpolicy_callback_submit": {
                if (!e.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.getModel().setDataChanged(false);
                this.getView().invokeOperation("submit");
                break;
            }
            case "checkpolicy_callback_settle": {
                if (!e.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.getModel().setDataChanged(false);
                this.getView().invokeOperation("settle");
                break;
            }
        }
    }

    private void setCashier(DynamicObject dataEntity) {
        long pkId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity);
        if (pkId == 0L) {
            return;
        }
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        QFilter qFilter = new QFilter("owner", "=", (Object)branchId);
        qFilter.and("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject channelUser = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"id", (QFilter[])qFilter.toArray());
        long userId = DynamicObjectUtils.getPkValue((DynamicObject)channelUser);
        if (userId > 0L) {
            DynamicObject cashier = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"ocdbd_channeluser");
            dataEntity.set("cashier", (Object)cashier);
            this.getView().getModel().setValue("cashier", (Object)cashier);
            SaveServiceHelper.update((DynamicObject)dataEntity);
        }
    }

    private boolean checkReturnRuleDiscount(DynamicObject dataEntity, String entityId) {
        if (!StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_salechange")) {
            return false;
        }
        Map mapResult = SaleOrderHelper.getReturnRuleDiscountAmount((DynamicObject)dataEntity, (boolean)true);
        if (mapResult == null) {
            return false;
        }
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        String retDiscountHandleWay = SystemParamUtil.getRetDiscountHandleWay((long)bizOrgId, (long)branchId).toString();
        BigDecimal giftDiscountAmount = CommonUtil.formatObjectToDecimal(mapResult.get("giftdiscountamount"));
        BigDecimal ticketDiscountAmt = CommonUtil.formatObjectToDecimal(mapResult.get("coupondiscount"));
        BigDecimal integralDiscountAmt = CommonUtil.formatObjectToDecimal(mapResult.get("integraldistamount"));
        BigDecimal receivableAmount = CommonUtil.formatObjectToDecimal(mapResult.get("receivableamount"));
        String pointReturnMode = mapResult.get("pointreturnmode").toString();
        String ticketReturnMode = mapResult.get("cashcouponreturnmode").toString();
        Map mapGiftValue = null;
        Object oGiftValue = mapResult.get("giftvalue");
        if (oGiftValue instanceof Map) {
            mapGiftValue = (Map)oGiftValue;
        }
        this.showDiscountHandle(giftDiscountAmount, ticketDiscountAmt, integralDiscountAmt, receivableAmount, pointReturnMode, ticketReturnMode, mapGiftValue, retDiscountHandleWay);
        NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u9000\u8d27\u5546\u54c1\u5b58\u5728\u8d60\u54c1\u3001\u8d60\u5238\u3001\u8d60\u79ef\u5206\uff0c\u8bf7\u9009\u62e9\u5904\u7406\u65b9\u5f0f", (IFormView)this.getView());
        return true;
    }

    private void showDiscountHandle(BigDecimal giftDiscountAmt, BigDecimal ticketDiscountAmt, BigDecimal integralDiscountAmt, BigDecimal receivableAmount, String pointReturnMode, String ticketReturnMode, Map<String, BigDecimal> mapGiftValue, String retDiscountHandleWay) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(0);
        customParams.put("giftdiscountamount", giftDiscountAmt);
        customParams.put("coupondiscount", ticketDiscountAmt);
        customParams.put("integraldistamount", integralDiscountAmt);
        customParams.put("srcamount", receivableAmount);
        customParams.put("pointreturnmode", pointReturnMode);
        customParams.put("cashcouponreturnmode", ticketReturnMode);
        customParams.put("retdiscounthandleway", retDiscountHandleWay);
        String giftValueData = JSONObject.toJSON(mapGiftValue).toString();
        customParams.put("giftvalue", giftValueData);
        FormShowParameter formShowParameter = FormShowUtils.openNewForm((String)"\u4f18\u60e0\u5904\u7406", (String)"ocpos_discounthandle", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_DISCOUNTHANDLECLOSE));
        this.getView().showForm(formShowParameter);
    }

    private void checkAndInputSerialNumber(BeforeDoOperationEventArgs e) {
        ArrayList data = new ArrayList(10);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities;
            DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"materialinv");
            boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
            if (!isEnableSerial || CollectionUtils.isEmpty((Collection)(deliveryEntities = entryEntity.getDynamicObjectCollection("salesorderdelivery")))) continue;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                int deliverSaleQty;
                String sn = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"deliveryserialnumber");
                if (!StringUtils.isBlank((CharSequence)sn) || (deliverSaleQty = DynamicObjectUtils.getInt((DynamicObject)deliveryEntity, (String)"deliversaleqty")) == 0) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("deliversaleqty", deliverSaleQty);
                map.put("delivergoodsid", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"delivergoodsid"));
                map.put("deliverymaterial", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymaterial"));
                map.put("inventoryorgid", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"inventoryorgid"));
                map.put("erpstockid", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"erpstockid"));
                map.put("PrimaryKeyValue", dataEntity.getPkValue());
                map.put("EntryPrimaryKeyValue", entryEntity.getPkValue());
                map.put("EntityId", "ocpos_saleorder");
                data.add(map);
            }
        }
        if (!data.isEmpty()) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ocpos_inputserialnumber");
            formShowParameter.setCustomParam("data", data);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "storepickup"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
            e.setCancel(true);
        }
    }

    private void saleChangeCheck(BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("goodsentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (IFormView)this.getView());
            e.setCancel(true);
        } else if (selectRows.length > 1) {
            boolean sale = Arrays.stream(selectRows).anyMatch(a -> "0".equals(this.getModel().getEntryRowEntity("goodsentryentity", a).getString("saleoption")));
            if (sale) {
                NotificationUtil.showDefaultTipNotify((String)"\u4ec5\u652f\u6301\u9500\u552e\u884c\u9009\u62e9\u6298\u6263\u5904\u7406\u3002", (IFormView)this.getView());
                e.setCancel(true);
            }
        } else {
            int index = this.getModel().getEntryCurrentRowIndex("goodsentryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("goodsentryentity", index);
            if ("0".equals(entryRowEntity.getString("saleoption"))) {
                NotificationUtil.showDefaultTipNotify((String)"\u4ec5\u652f\u6301\u9500\u552e\u884c\u9009\u62e9\u6298\u6263\u5904\u7406\u3002", (IFormView)this.getView());
                e.setCancel(true);
            }
        }
    }

    private void showDistributionChangeForm() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("salesorderdelivery");
        int[] rowIndexes = entryGrid.getSelectRows();
        if (rowIndexes == null || rowIndexes.length == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8c03\u6574\u7684\u914d\u9001\u660e\u7ec6\u4fe1\u606f\u3002", (IFormView)this.getView());
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
        for (int rowIndex : rowIndexes) {
            DynamicObject data = this.getView().getModel().getEntryRowEntity("salesorderdelivery", rowIndex);
            DynamicObject doParent = (DynamicObject)data.getParent();
            BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doParent, (String)"mustretqty");
            boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"deliverisdelivery");
            if (isDelivery && mustRetQty.abs().compareTo(BigDecimal.ZERO) != 0) continue;
            this.getView().showErrorNotification(String.format("\u8ba2\u5355\u53f7\uff1a%s\uff0c\u5f53\u524d\u9009\u62e9\u7684\u5546\u54c1\u5df2\u9000\u6216\u5df2\u8f6c\u9500\u5b8c\uff0c\u65e0\u9700\u8fdb\u884c\u914d\u9001\u8c03\u6574\u3002", billNo));
            return;
        }
        HashMap<String, String> customParams = new HashMap<String, String>(0);
        customParams.put("parentformtype", "0");
        customParams.put("EntityNumber", "ocpos_saleorder");
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_distributionchange", (ShowType)ShowType.Modal, null, customParams);
        parameter.setShowTitle(true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_DISTRIBUTIONCHANGECLOSE));
        this.getView().showForm(parameter);
    }

    private void showVipAddressForm(String fromId, String actionId) {
        HashMap<String, Long> customParams = new HashMap<String, Long>(4);
        DynamicObject member = (DynamicObject)this.getModel().getValue("member");
        if (ObjectUtils.isEmpty((Object)member)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u4f1a\u5458\u4fe1\u606f\u3002", (IFormView)this.getView());
            return;
        }
        customParams.put("member", DynamicObjectUtils.getPkValue((DynamicObject)member));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)fromId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    private void vipAddressClose(Object returnData) {
        if (returnData instanceof Map) {
            String address;
            String adminDivisionId;
            String customerPhone;
            Map mapData = (Map)returnData;
            String customerName = (String)mapData.get("customername");
            if (customerName != null) {
                this.getView().getModel().setValue("customername", (Object)customerName);
            }
            if ((customerPhone = (String)mapData.get("customerphone")) != null) {
                this.getView().getModel().setValue("customerphone", (Object)customerPhone);
            }
            if ((adminDivisionId = (String)mapData.get("admindivisionid")) != null) {
                this.getView().getModel().setValue("admindivisionid", (Object)adminDivisionId);
            }
            if ((address = (String)mapData.get("customeraddress")) != null) {
                this.getView().getModel().setValue("customeraddress", (Object)address);
            }
        }
    }

    private void showUseTicketView() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ocpos_useticketlist");
        DynamicObject saleOrder = this.getModel().getDataEntity(true);
        DynamicObjectCollection docUseTicketEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"useticketentity");
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("goodsentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        String goodsSeq = "";
        if (selectRows != null && selectRows.length > 0) {
            for (int rowIndex : selectRows) {
                DynamicObject goodsEntry = (DynamicObject)docGoodsEntry.get(rowIndex);
                boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)goodsEntry, (String)"ispresent");
                if (isPresent) continue;
                String seq = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"seq");
                goodsSeq = StringUtils.isEmpty((CharSequence)goodsSeq) ? seq : goodsSeq + "," + seq;
            }
        } else {
            Object[] seqs = docGoodsEntry.stream().filter(x -> !DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"ispresent")).map(x -> DynamicObjectUtils.getString((DynamicObject)x, (String)"seq")).toArray();
            goodsSeq = StringUtils.join((Object[])seqs, (String)",");
        }
        if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u975e\u8d60\u54c1\u884c\u5546\u54c1\u3002", (IFormView)this.getView());
            return;
        }
        String goodsData = DynamicObjectSerializeUtil.serialize((Object[])docGoodsEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") > 0L).toArray(), (DynamicObjectType)docGoodsEntry.getDynamicObjectType());
        String useTicketData = DynamicObjectSerializeUtil.serialize((Object[])docUseTicketEntry.toArray(), (DynamicObjectType)docUseTicketEntry.getDynamicObjectType());
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long memberId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"member");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"currencyid");
        parameter.setCustomParam("useticketentity", (Object)useTicketData);
        parameter.setCustomParam("goodsentryentity", (Object)goodsData);
        parameter.setCustomParam("bizorgid", (Object)bizOrgId);
        parameter.setCustomParam("salebranchid", (Object)branchId);
        parameter.setCustomParam("member", (Object)memberId);
        parameter.setCustomParam("currencyid", (Object)currencyId);
        parameter.setCustomParam("seq", (Object)goodsSeq);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_USETICKETCLOSE));
        this.getView().showForm(parameter);
    }

    private void showInvoiceInfoForm(String formId, String actionId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        Object salestatus = this.getModel().getValue("salestatus");
        if (ObjectUtils.isEmpty((Object)salestatus) || !StringUtils.equalsIgnoreCase((CharSequence)salestatus.toString(), (CharSequence)"S")) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u7ed3\u7b97\u5b8c\u6210\uff0c\u624d\u80fd\u5f00\u53d1\u7968\u3002", (IFormView)this.getView());
            return;
        }
        customParams.put("openquotype", this.getModel().getValue("openquotype"));
        customParams.put("name", this.getModel().getValue("name"));
        customParams.put("phonenumber", this.getModel().getValue("phonenumber"));
        customParams.put("invoicetype", this.getModel().getValue("invoicetype"));
        customParams.put("email", this.getModel().getValue("email"));
        customParams.put("enterprisename", this.getModel().getValue("enterprisename"));
        customParams.put("taxnumber", this.getModel().getValue("taxnumber"));
        customParams.put("enterpriseaddr", this.getModel().getValue("enterpriseaddr"));
        customParams.put("enterprisetel", this.getModel().getValue("enterprisetel"));
        customParams.put("bank", this.getModel().getValue("bank"));
        customParams.put("bankaccount", this.getModel().getValue("bankaccount"));
        customParams.put("enterprisephone", this.getModel().getValue("enterprisephone"));
        customParams.put("enterpriseemail", this.getModel().getValue("enterpriseemail"));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)formId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    private boolean checkBookAndBalancePolicy(DynamicObject dataEntity, String entityId, String opKey) {
        boolean isDataChange = this.getView().getModel().getDataChanged();
        if (isDataChange || !"ocpos_saleorder".equals(entityId)) {
            return true;
        }
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (isNotConfirm || billTypeId == BillTypeEnum.CREDIT.getId() || billTypeId == BillTypeEnum.RESERVEFINAL.getId()) {
            return true;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        boolean isEnableBookPolicy = CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getSystemParamValue((long)orgId, (long)branchId, (String)"isenablebookpolicy"));
        boolean isEnableBalancePolicy = CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getSystemParamValue((long)orgId, (long)branchId, (String)"isenablebalancepolicy"));
        if (!isEnableBookPolicy && !isEnableBalancePolicy) {
            return true;
        }
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            int seq = 0;
            for (DynamicObject entryRow : entryEntity) {
                String pageCacheValue;
                String tip;
                ++seq;
                boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryRow, (String)"isbook");
                BigDecimal depositscale = entryRow.getBigDecimal("depositscale");
                BigDecimal finalpaymentScale = entryRow.getBigDecimal("finalpaymentscale");
                if (isEnableBookPolicy && isBook) {
                    tip = SaleAmountHelper.depositScaleChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)entryRow, (String)opKey, (BigDecimal)depositscale);
                    if (!StringUtils.isBlank((CharSequence)tip)) {
                        this.getView().showErrorNotification(String.format("\u7b2c%d\u884c\u5546\u54c1\u660e\u7ec6\uff1a" + tip, seq));
                        return false;
                    }
                    pageCacheValue = this.getPageCache().get("PageCache_depositscale");
                    if (!StringUtils.isNotBlank((CharSequence)pageCacheValue)) continue;
                    return false;
                }
                if (billTypeId == BillTypeEnum.FINAL.getId() || !isEnableBalancePolicy || isBook) continue;
                tip = SaleAmountHelper.finalPaymentScaleChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)entryRow, (String)opKey, (BigDecimal)finalpaymentScale);
                if (!StringUtils.isBlank((CharSequence)tip)) {
                    this.getView().showErrorNotification(String.format("\u7b2c%d\u884c\u5546\u54c1\u660e\u7ec6\uff1a" + tip, seq));
                    return false;
                }
                pageCacheValue = this.getPageCache().get("PageCache_finalpaymentscale");
                if (!StringUtils.isNotBlank((CharSequence)pageCacheValue)) continue;
                return false;
            }
        }
        return true;
    }

    private void showQueryInventory() {
        DynamicObject currency;
        long currencyId;
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("ocpos_valiableinv_stand");
        DynamicObject branch = (DynamicObject)this.getModel().getValue("salebranchid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
        listShowParameter.setCustomParam("owner", (Object)branchId);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("goodsentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList stockOrgIds = new ArrayList();
        if (selectRows != null && selectRows.length > 0) {
            long stockOrgId;
            long saleOrgId;
            String invQueryRange;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("goodsentryentity");
            if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
                HashSet<Long> itemIds = new HashSet<Long>();
                for (int selectRow : selectRows) {
                    DynamicObject entryRow = (DynamicObject)entryEntity.get(selectRow);
                    long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryRow, (String)"goodsid");
                    if (goodsId > 0L) {
                        itemIds.add(goodsId);
                    }
                    DynamicObjectCollection deliveryEntity = entryRow.getDynamicObjectCollection("salesorderdelivery");
                    stockOrgIds.addAll(deliveryEntity.stream().filter(p -> DynamicObjectUtils.getPkValue((DynamicObject)p, (String)"inventoryorgid") > 0L).map(q -> DynamicObjectUtils.getPkValue((DynamicObject)q, (String)"inventoryorgid")).collect(Collectors.toList()));
                }
                listShowParameter.setCustomParam("itemIdSet", itemIds);
            }
            List<Object> invOrgIds = StringUtils.equals((CharSequence)(invQueryRange = SystemParamUtil.getInvQueryRange((long)(saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"saleorg")), (long)branchId)), (CharSequence)"0") ? (CollectionUtils.isEmpty(stockOrgIds) ? Collections.singletonList((stockOrgId = InventoryUtils.getDefaultInvOrgId((long)saleOrgId)) == 0L ? saleOrgId : stockOrgId) : stockOrgIds.stream().distinct().collect(Collectors.toList())) : (!CollectionUtils.isEmpty(stockOrgIds) ? stockOrgIds.stream().distinct().collect(Collectors.toList()) : new ArrayList());
            listShowParameter.setCustomParam("stockOrgId", invOrgIds);
        }
        if ((currencyId = DynamicObjectUtils.getPkValue((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currencyid")))) > 0L) {
            listShowParameter.setCustomParam("currency", (Object)currencyId);
        }
        listShowParameter.setCustomParam("extQTyShow", (Object)Boolean.TRUE);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showSendView(int type) {
        ArrayList<DynamicObject> goodsData;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("goodsentryentity");
        int[] selRow = entryGrid.getSelectRows();
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        DynamicObjectCollection goodsEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (selRow != null && selRow.length > 0) {
            int emptyGoodsCnt = 0;
            goodsData = new ArrayList(selRow.length);
            StringBuilder sbMsg = new StringBuilder();
            for (int row : selRow) {
                String saleOption;
                DynamicObject doGoodsItem = (DynamicObject)goodsEntities.get(row);
                DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)doGoodsItem, (String)"goodsid");
                boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)doGoodsItem, (String)"ispresent");
                if (isPresent) {
                    this.getView().showMessage("\u4e0d\u80fd\u52fe\u9009\u8d60\u54c1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
                    return;
                }
                if (billTypeId == BillTypeEnum.CHANGE.getId() && !StringUtils.equals((CharSequence)"1", (CharSequence)(saleOption = DynamicObjectUtils.getString((DynamicObject)doGoodsItem, (String)"saleoption")))) {
                    String seq = DynamicObjectUtils.getString((DynamicObject)doGoodsItem, (String)"seq");
                    sbMsg.append(String.format("\u6240\u9009\u5546\u54c1\u660e\u7ec6\u7b2c%s\u884c\u4e0d\u4e3a\u9500\u552e\u884c\u3002", seq));
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)goods)) {
                    goodsData.add(doGoodsItem);
                    continue;
                }
                ++emptyGoodsCnt;
            }
            if (sbMsg.length() > 0) {
                this.getView().showMessage(sbMsg.toString());
                return;
            }
            if (emptyGoodsCnt > 0) {
                this.getView().showMessage("\u8bf7\u5148\u5f55\u5165\u6240\u9009\u884c\u7684\u5546\u54c1\u4fe1\u606f\u3002");
                return;
            }
        } else {
            if (goodsEntities.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") > 0L)) {
                this.getView().showMessage("\u8bf7\u5148\u5f55\u5165\u5546\u54c1\u4fe1\u606f\u3002");
                return;
            }
            goodsData = new ArrayList<DynamicObject>(0);
        }
        DynamicObjectCollection docGoodsEntry = new DynamicObjectCollection(goodsEntities.getDynamicObjectType(), (Object)this);
        for (DynamicObject goodsEntry : goodsEntities) {
            long lGoodsId = DynamicObjectUtils.getPkValue((DynamicObject)goodsEntry, (String)"goodsid");
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)goodsEntry, (String)"ispresent");
            if (lGoodsId <= 0L || isPresent) continue;
            if (billTypeId == BillTypeEnum.CHANGE.getId()) {
                String saleOption = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"saleoption");
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)saleOption)) continue;
                docGoodsEntry.add((Object)goodsEntry);
                continue;
            }
            docGoodsEntry.add((Object)goodsEntry);
        }
        switch (type) {
            case 1: {
                this.showTicketSend(dataEntity, docGoodsEntry, goodsData);
                break;
            }
            case 2: {
                this.showManualSend(dataEntity, docGoodsEntry, goodsData);
                break;
            }
            case 3: {
                this.showIntegralSend(dataEntity, docGoodsEntry, goodsData);
                break;
            }
            case 4: {
                this.showUseTicketView();
                break;
            }
        }
    }

    private void showTicketSend(DynamicObject dataEntity, DynamicObjectCollection goodsEntities, List<DynamicObject> goodsData) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        DynamicObject member = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
        String goodsEntitiesData = DynamicObjectSerializeUtil.serialize((Object[])goodsEntities.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") > 0L).toArray(), (DynamicObjectType)goodsEntities.getDynamicObjectType());
        String goodsSelectData = DynamicObjectSerializeUtil.serialize((Object[])goodsData.toArray(), (DynamicObjectType)goodsEntities.getDynamicObjectType());
        customParams.put("member", member);
        customParams.put("goodsentryentity", goodsEntitiesData);
        customParams.put("goodsselectentity", goodsSelectData);
        customParams.put("biztype", dataEntity.getString("biztype"));
        DynamicObjectCollection docTicketSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity");
        String ticketSendData = DynamicObjectSerializeUtil.serialize((Object[])docTicketSendEntry.toArray(), (DynamicObjectType)docTicketSendEntry.getDynamicObjectType());
        customParams.put("ticketsendentity", ticketSendData);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_ticketsend", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_TICKETSENDCLOSE));
        this.getView().showForm(parameter);
    }

    private void showManualSend(DynamicObject dataEntity, DynamicObjectCollection goodsEntities, List<DynamicObject> goodsData) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        customParams.put("salebranchid", branchId);
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        customParams.put("bizorgid", bizOrgId);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        customParams.put("basebilltype", billTypeId);
        if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            String changeItemType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            customParams.put("changeitemtype", changeItemType);
        }
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        customParams.put("currencyid", currencyId);
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"bizdate");
        customParams.put("bizdate", bizDate);
        boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
        customParams.put("isinitbill", isInitBill);
        DynamicObjectType entryType = goodsEntities.getDynamicObjectType();
        String strEntry = DynamicObjectSerializeUtil.serialize((Object[])goodsEntities.toArray(), (DynamicObjectType)entryType);
        customParams.put("goodsentryentity", strEntry);
        String strRow = DynamicObjectSerializeUtil.serialize((Object[])goodsData.toArray(), (DynamicObjectType)entryType);
        customParams.put("goodsselectentity", strRow);
        DynamicObjectCollection docSendGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
        customParams.put("goodsendentity", docSendGoodsEntry);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_manualsend", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_GOODSSENDCLOSE));
        this.getView().showForm(parameter);
    }

    private void showIntegralSend(DynamicObject dataEntity, DynamicObjectCollection goodsEntities, List<DynamicObject> goodsData) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        DynamicObject member = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
        customParams.put("insmember", member);
        String goodsEntitiesData = DynamicObjectSerializeUtil.serialize((Object[])goodsEntities.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") > 0L).toArray(), (DynamicObjectType)goodsEntities.getDynamicObjectType());
        String goodsSelectData = DynamicObjectSerializeUtil.serialize((Object[])goodsData.toArray(), (DynamicObjectType)goodsEntities.getDynamicObjectType());
        customParams.put("goodsentryentity", goodsEntitiesData);
        customParams.put("goodsselectentity", goodsSelectData);
        customParams.put("biztype", dataEntity.getString("biztype"));
        DynamicObjectCollection docSendIntegralEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity");
        String sendIntegralEntryData = DynamicObjectSerializeUtil.serialize((Object[])docSendIntegralEntry.toArray(), (DynamicObjectType)docSendIntegralEntry.getDynamicObjectType());
        customParams.put("sendintegralentity", sendIntegralEntryData);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_sendintegral", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_INTEGRALSENDCLOSE));
        this.getView().showForm(parameter);
    }

    private void showDiscountWay() {
        HashMap<String, Long> customParams = new HashMap<String, Long>(1);
        long baseBillType = DynamicObjectUtils.getPkValue((DynamicObject)this.getModel().getDataEntity(true), (String)"basebilltype");
        customParams.put("basebilltype", baseBillType);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_discountway", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_DISCOUNTWAYCLOSE));
        this.getView().showForm(parameter);
    }

    private void showSaleOrderPay(boolean isNeedOpForm, Object discountData) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        String entityId = this.getView().getEntityId();
        customParams.put("entityid", entityId);
        long pkValue = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
        customParams.put("Id", pkValue);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        customParams.put("basebilltype", billTypeId);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        customParams.put("org", orgId);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        customParams.put("salebranchid", branchId);
        long memberId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"member");
        customParams.put("member", memberId);
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        customParams.put("currencyid", currencyId);
        DynamicObject cashier = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"cashier");
        long cashierRoleId = DynamicObjectUtils.getPkValue((DynamicObject)cashier, (String)"cashierid");
        customParams.put("cashierid", cashierRoleId);
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        customParams.put("biztype", bizType);
        long posId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"pos");
        customParams.put("pos", posId);
        BigDecimal creditAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"creditamount");
        if (creditAmount.compareTo(BigDecimal.ZERO) != 0) {
            customParams.put("creditamount", creditAmount);
            DynamicObject creditAccount = CreditMangageHelper.getCreditAccountInfo((long)branchId);
            customParams.put("creditaccountid", DynamicObjectUtils.getPkValue((DynamicObject)creditAccount));
        }
        String ticketDiscountType = "";
        String integralDiscountType = "";
        String giftDiscountType = "";
        String giftValueData = "";
        String gSendEntryData = "";
        BigDecimal discountValueDed = BigDecimal.ZERO;
        BigDecimal discountCustCpst = BigDecimal.ZERO;
        if (discountData instanceof HashMap) {
            Map mapDiscount = (Map)discountData;
            List lstDiscountData = (List)mapDiscount.get("data");
            giftValueData = mapDiscount.get("giftvalue").toString();
            for (DynamicObject doDiscountData : lstDiscountData) {
                String discountType = DynamicObjectUtils.getString((DynamicObject)doDiscountData, (String)"discounttype");
                String distSrcType = DynamicObjectUtils.getString((DynamicObject)doDiscountData, (String)"distsrctype");
                if ("1".equals(distSrcType)) {
                    ticketDiscountType = discountType;
                } else if ("2".equals(distSrcType)) {
                    integralDiscountType = discountType;
                } else {
                    giftDiscountType = discountType;
                }
                if ("1".equals(discountType)) {
                    discountValueDed = discountValueDed.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doDiscountData, (String)"afdiscountamount"));
                    continue;
                }
                discountCustCpst = discountCustCpst.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doDiscountData, (String)"afdiscountamount"));
            }
        }
        customParams.put("ticketdiscounttype", ticketDiscountType);
        customParams.put("integraldiscounttype", integralDiscountType);
        customParams.put("giftdiscounttype", giftDiscountType);
        customParams.put("discountvalueded", discountValueDed);
        customParams.put("discountcustcpst", discountCustCpst);
        customParams.put("giftvalue", giftValueData);
        customParams.put("goodsendentity", gSendEntryData);
        customParams.put("isneedopenform", isNeedOpForm);
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            String goodsData = DynamicObjectSerializeUtil.serialize((Object[])docGoodsEntry.toArray(), (DynamicObjectType)docGoodsEntry.getDynamicObjectType());
            customParams.put("goodsentryentity", goodsData);
        }
        String formId = this.getPayInfoFormId(dataEntity, discountValueDed);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"\u652f\u4ed8\u4fe1\u606f", (String)formId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_SETTLE));
        this.getView().showForm(parameter);
    }

    private String getPayInfoFormId(DynamicObject dataEntity, BigDecimal discountValueDed) {
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        BigDecimal receiveAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"receivableamount");
        if (discountValueDed.abs().compareTo(BigDecimal.ZERO) > 0) {
            receiveAmount = receiveAmount.subtract(discountValueDed);
        }
        if (BillTypeEnum.CHANGE.getId() == billTypeId && receiveAmount.compareTo(BigDecimal.ZERO) < 0) {
            return "ocpos_srcreturnpay";
        }
        return "ocpos_salepay";
    }

    private void ticketSendClose(Object returnData) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection docTicketSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity");
        if (docTicketSendEntry == null) {
            return;
        }
        String bizType = dataEntity.getString("biztype");
        boolean isChange = BizTypeEnum.CHANGE.getValue().equals(bizType);
        if (returnData instanceof DynamicObjectCollection) {
            DynamicObjectCollection docRetData = (DynamicObjectCollection)returnData;
            if (CollectionUtils.isEmpty((Collection)docRetData) && !isChange) {
                this.getModel().deleteEntryData("ticketsendentity");
            } else {
                long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
                if (!isChange) {
                    for (int i = docTicketSendEntry.getRowCount() - 1; i >= 0; --i) {
                        String seq = ((DynamicObject)docTicketSendEntry.get(i)).getString("seq");
                        if (!docRetData.stream().noneMatch(x -> StringUtils.equals((CharSequence)x.getString("seq"), (CharSequence)seq))) continue;
                        docTicketSendEntry.remove(i);
                    }
                }
                for (DynamicObject doData : docRetData) {
                    String seq = doData.getString("seq");
                    String goodsSeq = doData.getString("goodsseq");
                    String goodsName = DynamicObjectUtils.getString((DynamicObject)doData, (String)"goodsid");
                    BigDecimal ticketSendQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doData, (String)"qty");
                    DynamicObject doMember = DynamicObjectUtils.getDynamicObject((DynamicObject)doData, (String)"member");
                    DynamicObject doTicketType = DynamicObjectUtils.getDynamicObject((DynamicObject)doData, (String)"tickettype");
                    DynamicObject doTicketSendEntry = docTicketSendEntry.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("seq"), (CharSequence)seq)).findFirst().orElse(null);
                    if (ObjectUtils.isEmpty((Object)doTicketSendEntry) || isChange) {
                        doTicketSendEntry = docTicketSendEntry.addNew();
                    }
                    if (!ObjectUtils.isEmpty((Object)doMember)) {
                        doTicketSendEntry.set("emember", (Object)doMember);
                    }
                    if (!ObjectUtils.isEmpty((Object)doTicketType)) {
                        doTicketSendEntry.set("tickettype", (Object)doTicketType);
                        BigDecimal ticketValue = DynamicObjectUtils.getBigDecimal((DynamicObject)doTicketType, (String)"ticketvalue");
                        doTicketSendEntry.set("ticketvalue", (Object)ticketValue.multiply(ticketSendQty));
                    }
                    doTicketSendEntry.set("goodsseq", (Object)goodsSeq);
                    doTicketSendEntry.set("goodsname", (Object)goodsName);
                    doTicketSendEntry.set("qty", (Object)ticketSendQty);
                    if (billTypeId != BillTypeEnum.CHANGE.getId()) continue;
                    doTicketSendEntry.set("ticketsaleoption", (Object)"1");
                }
                this.getView().updateView("ticketsendentity");
            }
        }
    }

    private void integralSendClose(Object returnData) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection docSendIntegralEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity");
        if (docSendIntegralEntry == null) {
            return;
        }
        String bizType = dataEntity.getString("biztype");
        boolean isChange = BizTypeEnum.CHANGE.getValue().equals(bizType);
        if (returnData instanceof DynamicObjectCollection) {
            DynamicObjectCollection docRetData = (DynamicObjectCollection)returnData;
            if (CollectionUtils.isEmpty((Collection)docRetData) && !isChange) {
                this.getModel().deleteEntryData("ticketsendentity");
            } else {
                long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
                if (!isChange) {
                    for (int i = docSendIntegralEntry.getRowCount() - 1; i >= 0; --i) {
                        String seq = ((DynamicObject)docSendIntegralEntry.get(i)).getString("seq");
                        if (!docRetData.stream().noneMatch(x -> StringUtils.equals((CharSequence)x.getString("seq"), (CharSequence)seq))) continue;
                        docSendIntegralEntry.remove(i);
                    }
                }
                for (DynamicObject doData : docRetData) {
                    String seq = doData.getString("seq");
                    String goodsSeq = doData.getString("insgoodsseq");
                    DynamicObject doMember = DynamicObjectUtils.getDynamicObject((DynamicObject)doData, (String)"insmember");
                    DynamicObject doMemPointType = DynamicObjectUtils.getDynamicObject((DynamicObject)doData, (String)"insmempointtype");
                    BigDecimal integral = DynamicObjectUtils.getBigDecimal((DynamicObject)doData, (String)"insintegral");
                    BigDecimal price = DynamicObjectUtils.getBigDecimal((DynamicObject)doMemPointType, (String)"price");
                    DynamicObject doSendIntegralEntry = docSendIntegralEntry.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("seq"), (CharSequence)seq)).findFirst().orElse(null);
                    if (ObjectUtils.isEmpty((Object)doSendIntegralEntry) || isChange) {
                        doSendIntegralEntry = docSendIntegralEntry.addNew();
                    }
                    if (!ObjectUtils.isEmpty((Object)doMember)) {
                        doSendIntegralEntry.set("insmember", (Object)doMember);
                    }
                    if (!ObjectUtils.isEmpty((Object)doMemPointType)) {
                        doSendIntegralEntry.set("insmempointtype", (Object)doMemPointType);
                    }
                    doSendIntegralEntry.set("insgoodsseq", (Object)goodsSeq);
                    doSendIntegralEntry.set("insgoodsname", (Object)DynamicObjectUtils.getString((DynamicObject)doData, (String)"inssalegoods"));
                    doSendIntegralEntry.set("insintegral", (Object)integral);
                    doSendIntegralEntry.set("integralvalue", (Object)integral.multiply(price));
                    if (billTypeId != BillTypeEnum.CHANGE.getId()) continue;
                    doSendIntegralEntry.set("pointsaleoption", (Object)"1");
                }
                this.getView().updateView("sendintegralentity");
            }
        }
    }

    private void sendGoodsClose(Object returnData) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection docGoodsSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
        if (docGoodsSendEntry == null) {
            return;
        }
        if (returnData instanceof List) {
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            String changeItemType = DynamicObjectUtil.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
            List lstData = (List)returnData;
            for (Map returnMap : lstData) {
                String status = CommonUtil.formatStringToEmpty(returnMap.get("status"));
                if (!StringUtils.equals((CharSequence)status, (CharSequence)"SUCCESS")) continue;
                this.removeBlankRow(dataEntity);
                DynamicObject entryItem = entryEntity.addNew();
                int index = entryEntity.getRowCount() - 1;
                DynamicObject data = (DynamicObject)returnMap.get("data");
                DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
                for (IDataEntityProperty property : properties) {
                    String key = property.getName();
                    if (billTypeId == BillTypeEnum.CHANGE.getId() && StringUtils.equals((CharSequence)changeItemType, (CharSequence)"2")) {
                        entryItem.set("saleoption", (Object)"1");
                    }
                    if (StringUtils.equals((CharSequence)key, (CharSequence)"rowclosestatus")) {
                        entryItem.set("rowclosestatus", (Object)"A");
                    }
                    if (DynamicObjectUtils.contain((DynamicObject)data, (String)key)) {
                        entryItem.set(key, data.get(key));
                    }
                    if (StringUtils.equals((CharSequence)key, (CharSequence)"saleqty")) {
                        entryItem.set("mustretqty", data.get(key));
                    }
                    if (!StringUtils.equals((CharSequence)key, (CharSequence)"gifttype")) continue;
                    entryItem.set("gifttype", (Object)GiftTypeEnum.MANUALNEW.getValue());
                }
                this.getModel().beginInit();
                int rowIndex = this.getModel().createNewEntryRow("goodsendentity");
                DynamicObject doGoodsSendEntry = (DynamicObject)docGoodsSendEntry.get(rowIndex);
                BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"saleqty");
                BigDecimal giftPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"giftprice");
                entryItem.set("promoteseq", (Object)docGoodsSendEntry.getRowCount());
                doGoodsSendEntry.set("sendgoods", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"goodsid"));
                doGoodsSendEntry.set("sendbarcode", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"barcode"));
                doGoodsSendEntry.set("sendqty", (Object)qty);
                doGoodsSendEntry.set("giftunit", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"unit"));
                doGoodsSendEntry.set("sendgoodsseq", (Object)DynamicObjectUtils.getString((DynamicObject)data, (String)"sendgoodsseq"));
                doGoodsSendEntry.set("sendgoodsname", (Object)DynamicObjectUtils.getString((DynamicObject)data, (String)"salegoods"));
                doGoodsSendEntry.set("giftprice", (Object)giftPrice);
                doGoodsSendEntry.set("giftvalue", (Object)giftPrice.multiply(qty));
                this.getModel().endInit();
                SaleOrderDeliveryInfoHelper.updatePriceAndAmount((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)entryItem, (int)index);
                Object returnInfo = returnMap.get("salesorderdelivery");
                if (returnInfo instanceof JSONObject) {
                    SaleOrderDeliveryInfoHelper.fillDeliveryDataAllowOverSale((IFormView)this.getView(), (DynamicObject)data, (DynamicObject)entryItem, returnInfo);
                } else if (returnInfo instanceof List) {
                    SaleOrderDeliveryInfoHelper.fillDeliveryDataAboutStock((IFormView)this.getView(), (DynamicObject)data, (DynamicObject)entryItem, returnInfo);
                } else {
                    SaleOrderDeliveryInfoHelper.fillDeliveryData((IFormView)this.getView(), (DynamicObject)data, (DynamicObject)entryItem);
                }
                SaleOrderHelper.shareSendGoodsAmount((DynamicObjectCollection)entryEntity, (DynamicObject)doGoodsSendEntry);
            }
            this.getView().updateView("goodsendentity");
            this.getView().updateView("salesorderdelivery");
            this.getView().updateView("goodsentryentity");
        }
    }

    private void discountWayClose(Object returnData) {
        if (returnData instanceof Map) {
            JSONObject discountMap = JSONObject.parseObject((String)JSON.toJSONString((Object)returnData));
            if (CollectionUtils.isEmpty((Map)discountMap)) {
                return;
            }
            DynamicObjectCollection entryData = this.getModel().getDataEntity(true).getDynamicObjectCollection("goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)entryData)) {
                return;
            }
            String discountWay = CommonUtil.formatStringToEmpty(discountMap.get("discountWay"));
            BigDecimal discountValue = CommonUtil.formatObjectToDecimal(discountMap.get("discountValue"));
            switch (discountWay) {
                case "1": {
                    this.wholeDiscountHandle(entryData, discountValue);
                    break;
                }
                case "2": {
                    this.singlePricingHandle(entryData, discountValue);
                    break;
                }
                case "3": 
                case "4": {
                    this.singleDiscountAndPricingHandle(entryData, discountWay, discountValue);
                    break;
                }
            }
            CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
            this.getView().updateView("goodsentryentity");
        }
    }

    private void settleClose(Object returnData) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
        log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7ed3\u7b97\u56de\u8c03\u5904\u7406", billNo));
        if (returnData instanceof String) {
            String strReturnData = String.valueOf(returnData);
            if (StringUtils.equals((CharSequence)strReturnData, (CharSequence)"Success")) {
                NotificationUtil.showDefaultSuccessNotification((String)"\u7ed3\u7b97\u5b8c\u6210\u3002", (IFormView)this.getView());
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTRECEIVABLES});
                this.getView().addClientCallBack(ACTION_SETTLEAFTERAUDIT);
                log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7ed3\u7b97\u56de\u8c03\u5904\u74061", billNo));
                this.getView().addClientCallBack("srcRelease");
            } else {
                this.getView().showErrorNotification("\u7ed3\u7b97\u5931\u8d25\u3002");
                log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7ed3\u7b97\u56de\u8c03\u5904\u7406\u5931\u8d251", billNo));
            }
        } else if (returnData instanceof Map) {
            Map returnMap = (Map)returnData;
            String success = (String)returnMap.get("cashpay");
            if (StringUtils.equals((CharSequence)success, (CharSequence)"Success")) {
                BigDecimal returnCashAmount = (BigDecimal)returnMap.get("returncash");
                dataEntity.set("returncashamount", (Object)returnCashAmount);
                SaveServiceHelper.update((DynamicObject)dataEntity);
                NotificationUtil.showDefaultSuccessNotification((String)"\u7ed3\u7b97\u5b8c\u6210\u3002", (IFormView)this.getView());
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTRECEIVABLES});
                this.getView().addClientCallBack(ACTION_SETTLEAFTERAUDIT);
                log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7ed3\u7b97\u56de\u8c03\u5904\u74062", billNo));
                this.getView().addClientCallBack("srcRelease");
            } else {
                this.getView().showErrorNotification("\u7ed3\u7b97\u5931\u8d25\u3002");
                log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7ed3\u7b97\u56de\u8c03\u5904\u7406\u5931\u8d252", billNo));
            }
        }
        FormShowUtils.updateBillStatus((AbstractBillPlugIn)this);
        this.getView().invokeOperation("refresh");
    }

    private void settleAfterAudit(DynamicObject dataEntity) {
        String billtype = dataEntity.getString("biztype");
        if (!StringUtils.equalsIgnoreCase((CharSequence)billtype, (CharSequence)"H")) {
            String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
            try {
                log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u5ba1\u6838\u64cd\u4f5c1", billNo));
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"audit", (String)this.getView().getEntityId(), (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
                StringBuilder pushMsgBuilder = new StringBuilder();
                if (opResult == null) {
                    pushMsgBuilder.append(String.format("\u96f6\u552e\u5355\u53f7%s\u5f02\u6b65\u8c03\u5ba1\u6838\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8befnull", billNo));
                } else if (!opResult.isSuccess()) {
                    opResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getMessage()).append(','));
                }
                if (pushMsgBuilder.length() > 0) {
                    log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u5f02\u6b65\u8c03\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25:%s", billNo, pushMsgBuilder.toString()));
                    NotificationUtil.showTipNotification((String)pushMsgBuilder.toString(), (IFormView)this.getView(), (Integer)3000);
                }
                log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u5ba1\u6838\u64cd\u4f5c2", billNo));
            }
            catch (Exception ex) {
                log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u5f02\u6b65\u8c03\u5ba1\u6838\u64cd\u4f5c\u5f02\u5e38:%s", billNo, Arrays.toString(ex.getStackTrace())));
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    private void discountHandleClose(Object returnData) {
        if (returnData instanceof HashMap) {
            this.showSaleOrderPay(true, returnData);
            FormShowUtils.updateBillStatus((AbstractBillPlugIn)this);
            this.getView().invokeOperation("refresh");
        }
    }

    private void wholeDiscountHandle(DynamicObjectCollection entryData, BigDecimal discountRate) {
        for (DynamicObject entryItem : entryData) {
            DynamicObject goods;
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryItem, (String)"ispresent");
            if (isPresent || ObjectUtils.isEmpty((Object)(goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"goodsid")))) continue;
            entryItem.set("discountrate", (Object)discountRate);
            BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"retailprice");
            BigDecimal discountPrice = discountRate.divide(new BigDecimal(100), 4).multiply(retailPrice);
            entryItem.set("discountprice", (Object)discountPrice);
            BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"saleqty");
            BigDecimal balAmount = discountPrice.multiply(qty);
            entryItem.set("balamount", (Object)balAmount);
            CommonUtils.updateReceivableAmount((IDataModel)this.getModel(), (DynamicObject)entryItem);
            CommonUtils.updateExpectFinalAmount((DynamicObject)entryItem);
            CommonUtils.updateDepositscale((DynamicObject)entryItem);
        }
    }

    private void singlePricingHandle(DynamicObjectCollection entryData, BigDecimal discountAmount) {
        BigDecimal sumAmount = (BigDecimal)this.getView().getModel().getValue("sumamount");
        BigDecimal diffValue = sumAmount.subtract(discountAmount);
        BigDecimal sumDiffBalAmount = BigDecimal.ZERO;
        int size = entryData.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal diffBalAmount;
            DynamicObject goods;
            DynamicObject entryItem = (DynamicObject)entryData.get(i);
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryItem, (String)"ispresent");
            if (isPresent || ObjectUtils.isEmpty((Object)(goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"goodsid")))) continue;
            BigDecimal amount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"amount");
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"saleqty");
            BigDecimal discountPrice = BigDecimal.ZERO;
            if (i == size - 1) {
                diffBalAmount = amount.subtract(diffValue.subtract(sumDiffBalAmount));
                entryItem.set("balamount", (Object)diffBalAmount);
                if (saleQty.compareTo(BigDecimal.ZERO) != 0) {
                    discountPrice = diffBalAmount.divide(saleQty, 2, 4);
                }
            } else {
                BigDecimal shareDiffAmt = BigDecimal.ZERO;
                if (sumAmount.compareTo(BigDecimal.ZERO) != 0) {
                    shareDiffAmt = amount.divide(sumAmount, 2, 4).multiply(diffValue);
                }
                diffBalAmount = amount.subtract(shareDiffAmt);
                entryItem.set("balamount", (Object)diffBalAmount);
                if (saleQty.compareTo(BigDecimal.ZERO) != 0) {
                    discountPrice = diffBalAmount.divide(saleQty, 2, 4);
                }
                sumDiffBalAmount = sumDiffBalAmount.add(shareDiffAmt);
            }
            entryItem.set("discountprice", (Object)discountPrice);
            BigDecimal retailPrice = ((DynamicObject)entryData.get(i)).getBigDecimal("retailprice");
            if (retailPrice.compareTo(BigDecimal.ZERO) == 0) {
                entryItem.set("discountrate", (Object)BigDecimal.ZERO);
            } else {
                entryItem.set("discountrate", (Object)discountPrice.divide(retailPrice, 4, 4).multiply(new BigDecimal(100)));
            }
            CommonUtils.updateReceivableAmount((IDataModel)this.getModel(), (DynamicObject)entryItem);
            CommonUtils.updateExpectFinalAmount((DynamicObject)entryItem);
            CommonUtils.updateDepositscale((DynamicObject)entryItem);
        }
    }

    private void singleDiscountAndPricingHandle(DynamicObjectCollection entryData, String discountWay, BigDecimal discountValue) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("goodsentryentity");
        int[] selRow = entryGrid.getSelectRows();
        if (selRow == null || selRow.length == 0) {
            return;
        }
        for (int row : selRow) {
            BigDecimal retailPrice;
            DynamicObject entryItem = (DynamicObject)entryData.get(row);
            DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"goodsid");
            if (ObjectUtils.isEmpty((Object)goods)) continue;
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"saleqty");
            if (StringUtils.equals((CharSequence)"3", (CharSequence)discountWay)) {
                entryItem.set("discountprice", (Object)discountValue);
                retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"retailprice");
                if (retailPrice.compareTo(BigDecimal.ZERO) == 0) {
                    entryItem.set("discountrate", (Object)BigDecimal.ZERO);
                } else {
                    entryItem.set("discountrate", (Object)discountValue.divide(retailPrice, 4, 4).multiply(new BigDecimal(100)));
                }
                entryItem.set("balamount", (Object)discountValue.multiply(saleQty));
            } else if (StringUtils.equals((CharSequence)"4", (CharSequence)discountWay)) {
                entryItem.set("discountrate", (Object)discountValue);
                retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"retailprice");
                BigDecimal discountPrice = retailPrice.multiply(discountValue).divide(new BigDecimal(100));
                entryItem.set("discountprice", (Object)discountPrice);
                entryItem.set("balamount", (Object)discountPrice.multiply(saleQty));
            }
            CommonUtils.updateReceivableAmount((IDataModel)this.getModel(), (DynamicObject)entryItem);
            CommonUtils.updateExpectFinalAmount((DynamicObject)entryItem);
            CommonUtils.updateDepositscale((DynamicObject)entryItem);
        }
    }

    private boolean checkNewEntry() {
        DynamicObject doMember;
        DynamicObject doBillType = (DynamicObject)this.getModel().getValue("basebilltype");
        if (ObjectUtils.isEmpty((Object)doBillType)) {
            return false;
        }
        boolean bNotConfirm = CommonUtil.formatObjectToBoolean((Object)this.getModel().getValue("notconfirm"));
        if (DynamicObjectUtils.getPkValue((DynamicObject)doBillType) == BillTypeEnum.CVTSALE.getId() && bNotConfirm && ObjectUtils.isEmpty((Object)(doMember = (DynamicObject)this.getModel().getValue("member")))) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u4f1a\u5458\u4fe1\u606f\u3002", (IFormView)this.getView());
            return false;
        }
        return true;
    }

    private void beforeCreditPayOp(BeforeDoOperationEventArgs e) {
        boolean checkCreditRule;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject member = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
        if (ObjectUtils.isEmpty((Object)member)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5f55\u5165\u4f1a\u5458\u4fe1\u606f\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"salebranchid");
        if (ObjectUtils.isEmpty((Object)branch)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u95e8\u5e97\u4fe1\u606f\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        DynamicObject creditAccount = null;
        String branchName = DynamicObjectUtils.getString((DynamicObject)branch, (String)"name");
        boolean isEnableCredit = DynamicObjectUtils.getBoolean((DynamicObject)branch, (String)"isenablecredit");
        if (isEnableCredit && ObjectUtils.isEmpty((Object)(creditAccount = CreditMangageHelper.getCreditAccountInfo((long)DynamicObjectUtils.getPkValue((DynamicObject)branch))))) {
            NotificationUtil.showDefaultTipNotify((String)String.format("\u95e8\u5e97%s\u672a\u67e5\u5230\u5173\u8054\u7684\u4fe1\u7528\u8d26\u6237\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", branchName), (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        boolean isNotPresetBook = entryEntity.stream().anyMatch(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"isbook") && !DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"ispresent"));
        if (isNotPresetBook) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u9884\u8ba2\u5546\u54c1\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        boolean isFinal = entryEntity.stream().anyMatch(x -> DynamicObjectUtils.getBigDecimal((DynamicObject)x, (String)"finalpayment").compareTo(BigDecimal.ZERO) > 0);
        if (isFinal) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u5546\u54c1\u7ef4\u62a4\u4e86\u5c3e\u6b3e\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        Object pkValue = dataEntity.getPkValue();
        boolean isFromDatabase = dataEntity.getDataEntityState().getFromDatabase();
        if (ObjectUtils.isEmpty((Object)pkValue) || pkValue.equals(0L) || !isFromDatabase) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        String saleStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"salestatus");
        if (StringUtils.equals((CharSequence)saleStatus, (CharSequence)SaleStatusEnum.STATUS_S.getValue())) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5355\u636e\u5df2\u7ed3\u7b97\u5b8c\u6bd5\uff0c\u65e0\u9700\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        if (isEnableCredit && !(checkCreditRule = this.checkCreditRule(creditAccount, branchName))) {
            e.setCancel(true);
            return;
        }
        boolean hasPerm = this.checkSettlePerm();
        if (!hasPerm) {
            e.setCancel(true);
            return;
        }
        boolean hasAllowCreditPay = this.checkCashierRole(dataEntity);
        if (!hasAllowCreditPay) {
            e.setCancel(true);
        }
    }

    private boolean checkSettlePerm() {
        String entityId = this.getView().getEntityId();
        boolean hasPerm = PermissionUtil.checkPermission((String)"ocpos", (String)entityId, (String)PERM_SETTLEMENT);
        if (!hasPerm) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u8d26\u53f7\u65e0\u7ed3\u7b97\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (IFormView)this.getView());
        }
        return hasPerm;
    }

    private boolean checkReturnRule(DynamicObject dataEntity, String entityId) {
        if ("ocpos_salechange".equals(entityId)) {
            BigDecimal receivableamount = dataEntity.getBigDecimal("receivableamount");
            if (receivableamount.compareTo(BigDecimal.ZERO) >= 0) {
                return true;
            }
            boolean isAuthRetrun = CommonUtils.checkSaleRoleReturnAuth((DynamicObject)dataEntity);
            if (!isAuthRetrun) {
                NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u6536\u94f6\u5458\u5bf9\u5e94\u6536\u94f6\u89d2\u8272\u65e0\u9000\u6b3e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (IFormView)this.getView());
                return false;
            }
            Map rltMatchMap = SaleOrderReturnRuleHelper.matchRedRefundRuleBySaleOrder((DynamicObject)dataEntity);
            if (!CollectionUtils.isEmpty((Map)rltMatchMap) && !CommonUtil.formatObjectToBoolean(rltMatchMap.get("success"))) {
                this.getView().showErrorNotification(rltMatchMap.get("msg").toString());
                return false;
            }
        }
        return true;
    }

    private boolean checkCashierRole(DynamicObject dataEntity) {
        try {
            DynamicObject cashier = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"cashier");
            long cashierRoleId = DynamicObjectUtils.getPkValue((DynamicObject)cashier, (String)"cashierid");
            List payModeData = PayUtil.getDisplayPayModeData((long)cashierRoleId, (String)"", (String)"");
            boolean isMatch = payModeData.stream().anyMatch(x -> x.getLong("id") == 15L);
            if (!isMatch) {
                NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u6536\u94f6\u5458\u4e0d\u5177\u5907\u8d4a\u9500\u6536\u6b3e\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6240\u5c5e\u6536\u94f6\u89d2\u8272\u3002", (IFormView)this.getView());
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u6536\u94f6\u5458\u6536\u94f6\u89d2\u8272\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", (IFormView)this.getView());
            log.error("\u8d4a\u9500\u6536\u6b3e\uff1a" + StringUtil.getErrorMsg((Exception)ex));
            return false;
        }
    }

    private boolean checkCreditRule(DynamicObject creditAccount, String branchName) {
        boolean allOverDue;
        DynamicObject creditRule = DynamicObjectUtils.getDynamicObject((DynamicObject)creditAccount, (String)"creditruleid");
        String accountName = DynamicObjectUtils.getString((DynamicObject)creditAccount, (String)"name");
        DynamicObjectCollection ruleEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)creditRule, (String)"entity");
        if (CollectionUtils.isEmpty((Collection)ruleEntity)) {
            NotificationUtil.showDefaultTipNotify((String)String.format("\u5f53\u524d\u95e8\u5e97\u4fe1\u7528\u8d26\u6237%s\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u660e\u7ec6\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", accountName), (IFormView)this.getView());
            return false;
        }
        DynamicObject ruleEntityRow = ruleEntity.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getStrPkValue((DynamicObject)x, (String)"billid"), (CharSequence)"ocpos_saleorder")).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)ruleEntityRow)) {
            NotificationUtil.showDefaultTipNotify((String)String.format("\u5f53\u524d\u95e8\u5e97\u4fe1\u7528\u8d26\u6237%s\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", accountName), (IFormView)this.getView());
            return false;
        }
        BigDecimal overDueDays = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"overduedays");
        BigDecimal overDueAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"overdueamount");
        BigDecimal limitBalance = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"limitbalance");
        boolean isCheckOverDays = DynamicObjectUtils.getBoolean((DynamicObject)ruleEntityRow, (String)"isckoverdays");
        boolean isCheckOverLimit = DynamicObjectUtils.getBoolean((DynamicObject)ruleEntityRow, (String)"isckoverlimit");
        boolean daysIsOverDue = isCheckOverDays && overDueDays.compareTo(BigDecimal.ZERO) > 0;
        boolean limitIsOver = isCheckOverLimit && overDueAmount.compareTo(BigDecimal.ZERO) > 0;
        boolean balanceIsNull = limitBalance.compareTo(BigDecimal.ZERO) <= 0;
        boolean isOverDue = daysIsOverDue || limitIsOver || balanceIsNull;
        boolean isAllOverDue = daysIsOverDue && limitIsOver && balanceIsNull;
        String overProOfGist = DynamicObjectUtils.getString((DynamicObject)ruleEntityRow, (String)"overproofgist");
        boolean overDue = isOverDue && StringUtils.equals((CharSequence)"A", (CharSequence)overProOfGist);
        boolean bl = allOverDue = isAllOverDue && StringUtils.equals((CharSequence)"B", (CharSequence)overProOfGist);
        if (overDue || allOverDue) {
            String ctrlGrade = DynamicObjectUtils.getString((DynamicObject)ruleEntityRow, (String)"controlgrade");
            boolean result = true;
            switch (ctrlGrade) {
                case "A": {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ACTION_CREDITPAYCONFIRM, (IFormPlugin)this);
                    String tip = String.format("\u95e8\u5e97%s\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u6216\u5b58\u5728\u903e\u671f\u5e94\u6536\u8d26\u6b3e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u8d4a\u9500\u6536\u6b3e\uff1f\u70b9\u51fb\u662f\uff0c\u53ef\u7ee7\u7eed\u4ea4\u6613\u3002", branchName);
                    this.getView().showConfirm(tip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    result = false;
                    break;
                }
                case "B": {
                    String tip = String.format("\u95e8\u5e97%s\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u6216\u5b58\u5728\u903e\u671f\u5e94\u6536\u8d26\u6b3e\uff0c\u4e0d\u5141\u8bb8\u8d4a\u9500\u6536\u6b3e\u3002", branchName);
                    NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
                    result = false;
                    break;
                }
            }
            return result;
        }
        return true;
    }

    private void showCreditPayForm(DynamicObject dataEntity) {
        HashMap<String, Number> customParams = new HashMap<String, Number>(2);
        BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"receivableamount");
        customParams.put("receivableamount", receivableAmount);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        DynamicObject creditAccount = CreditMangageHelper.getCreditAccountInfo((long)branchId);
        customParams.put("creditaccountid", DynamicObjectUtils.getPkValue((DynamicObject)creditAccount));
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        customParams.put("settlecurrid", currencyId);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"\u8d4a\u9500\u6536\u6b3e", (String)"ocpos_creditpayment", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_CREDITPAYCLOSE));
        this.getView().showForm(parameter);
    }

    private void showVipConsumeDetail(DynamicObject dataEntity) {
        HashMap<String, Long> customParams = new HashMap<String, Long>(0);
        DynamicObject doMember = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
        if (doMember == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u4f1a\u5458\u4fe1\u606f.", (IFormView)this.getView());
            return;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long memberId = DynamicObjectUtils.getPkValue((DynamicObject)doMember);
        customParams.put("bizorgid", orgId);
        customParams.put("salebranchid", branchId);
        customParams.put("member", memberId);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_vipconsumedtl", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        this.getView().showForm(parameter);
    }

    private void creditPayClose(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            if (ObjectUtils.isEmpty((Object)data)) {
                return;
            }
            boolean result = this.doSettleOp(true);
            if (result) {
                long branchId;
                long orgId;
                boolean isAutoPrint;
                this.updateCreditPayRecord(data);
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                String saleStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"salestatus");
                if (StringUtils.equalsIgnoreCase((CharSequence)saleStatus, (CharSequence)"S") && (isAutoPrint = SystemParamUtil.getIsAutoPrint((long)(orgId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"bizorgid")), (long)(branchId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"salebranchid"))))) {
                    this.getView().invokeOperation("printpreview");
                }
            }
        }
    }

    private void useTicketClose(Object returnData) {
        if (returnData instanceof DynamicObjectCollection) {
            DynamicObjectCollection data = (DynamicObjectCollection)returnData;
            if (CollectionUtils.isEmpty((Collection)data)) {
                return;
            }
            DynamicObject saleOrder = this.getModel().getDataEntity(true);
            DynamicObjectCollection docUseTicketEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"useticketentity");
            DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
            if (docUseTicketEntry == null || CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
                return;
            }
            for (DynamicObject dataItem : data) {
                DynamicObject doUseTicketEntry = docUseTicketEntry.addNew();
                doUseTicketEntry.set("utticket", DynamicObjectUtils.get((DynamicObject)dataItem, (String)"utticket"));
                doUseTicketEntry.set("uttickettype", DynamicObjectUtils.get((DynamicObject)dataItem, (String)"uttickettype"));
                doUseTicketEntry.set("utgoodsseq", DynamicObjectUtils.get((DynamicObject)dataItem, (String)"utgoodsseq"));
            }
            SaleOrderAmountHelper.recalculateShareAmount((DynamicObject)saleOrder);
            this.getView().updateView("useticketentity");
            this.getView().updateView("goodsentryentity");
            CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
        }
    }

    private void invoiceInfoClose(Object returnData) {
        if (returnData instanceof DynamicObject) {
            DynamicObject invoiceInfo = (DynamicObject)returnData;
            if (ObjectUtils.isEmpty((Object)invoiceInfo)) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            dataEntity.set("openquotype", invoiceInfo.get("openquotype"));
            dataEntity.set("name", invoiceInfo.get("name"));
            dataEntity.set("phonenumber", invoiceInfo.get("phonenumber"));
            dataEntity.set("invoicetype", invoiceInfo.get("invoicetype"));
            dataEntity.set("email", invoiceInfo.get("email"));
            dataEntity.set("enterprisename", invoiceInfo.get("enterprisename"));
            dataEntity.set("taxnumber", invoiceInfo.get("taxnumber"));
            dataEntity.set("enterpriseaddr", invoiceInfo.get("enterpriseaddr"));
            dataEntity.set("enterprisetel", invoiceInfo.get("enterprisetel"));
            dataEntity.set("bank", invoiceInfo.get("bank"));
            dataEntity.set("bankaccount", invoiceInfo.get("bankaccount"));
            dataEntity.set("enterprisephone", invoiceInfo.get("enterprisephone"));
            dataEntity.set("enterpriseemail", invoiceInfo.get("enterpriseemail"));
            dataEntity.set("invoiceapplytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.update((DynamicObject)dataEntity);
            OperationResult operationResult = AutoPushHelper.autoPushBill((Object)DynamicObjectUtil.getPkValue((DynamicObject)dataEntity), (String)"ocpos_saleorder", (String)"sim_original_bill", (String)"audit");
            this.getView().showOperationResult(operationResult);
        }
    }

    private void updateCreditPayRecord(Map<String, Object> data) {
        BigDecimal receivableAmount;
        boolean isSubmitSuccess;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal creditAmount = CommonUtil.formatObjectToDecimal((Object)data.getOrDefault("settleamount", BigDecimal.ZERO));
        dataEntity.set("creditamount", (Object)creditAmount);
        dataEntity.set("salestatus", (Object)SaleStatusEnum.STATUS_B.getValue());
        this.updateBill(dataEntity);
        String entityId = this.getView().getEntityId();
        String status = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus");
        if (StringUtils.equals((CharSequence)status, (CharSequence)StatusEnum.DRAFT.getValue()) && !(isSubmitSuccess = this.submitBill(entityId, dataEntity))) {
            return;
        }
        OperationResult creditCheckResult = OperationServiceHelper.executeOperate((String)"creditcheck", (String)entityId, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        if (creditCheckResult != null && creditCheckResult.isSuccess() && creditAmount.compareTo(receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"receivableamount")) == 0) {
            SaleOrderHelper.doSendHandle((String)this.getView().getEntityId(), (DynamicObject)dataEntity);
            SaleOrderHelper.shareTicketSendAmount((DynamicObject)dataEntity);
            SaleOrderHelper.sharePointSendAmount((DynamicObject)dataEntity);
            this.savePayInfo(data, creditAmount);
            this.finishBill(dataEntity);
        }
        FormShowUtils.updateBillStatus((AbstractBillPlugIn)this);
        this.getView().invokeOperation("refresh");
    }

    private void savePayInfo(Map<String, Object> param, BigDecimal creditAmount) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        dataEntity.set("totalrealamount", (Object)BigDecimal.ZERO);
        dataEntity.set("salestatus", (Object)SaleStatusEnum.STATUS_S.getValue());
        this.saveCreditPayInfo(dataEntity, param, creditAmount);
        this.saveDisposePayInfo(dataEntity);
    }

    private void saveCreditPayInfo(DynamicObject dataEntity, Map<String, Object> param, BigDecimal creditAmount) {
        DynamicObject creditPayInfo = this.buildCreditPayInfo(param, creditAmount);
        PaymentRecord paymentRecord = new PaymentRecord();
        paymentRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)dataEntity).longValue());
        paymentRecord.setBillNo(dataEntity.getString("billno"));
        paymentRecord.setPayWay((DynamicObject)param.getOrDefault("setllementid", null));
        SaleOrderHelper.setEachPaymentRecord((DynamicObject)dataEntity, (PaymentRecord)paymentRecord, (DynamicObject)creditPayInfo);
        paymentRecord.setPayStatus("A");
        DynamicObjectCollection finEntryEntity = dataEntity.getDynamicObjectCollection("finentity");
        DynamicObject newFinEntity = finEntryEntity.addNew();
        SaleOrderHelper.updateSaleOrderAfterPayment((DynamicObject)dataEntity, (DynamicObject)newFinEntity, (PaymentRecord)paymentRecord, null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    private void saveDisposePayInfo(DynamicObject dataEntity) {
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        BigDecimal depositAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)dataEntity, (String)"depositamount");
        if (billTypeId != BillTypeEnum.CVTSALE.getId() || depositAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"deposit"), (String)"ocdbd_paymode");
        Date payTime = TimeServiceHelper.now();
        DynamicObject currency = DynamicObjectUtil.getDynamicObject((DynamicObject)dataEntity, (String)"currencyid");
        long locCurrencyId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"locurrencyid");
        long rateTableId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"exratetable");
        BigDecimal rate = CurrencyHelper.getExChangeRate((Long)DynamicObjectUtils.getPkValue((DynamicObject)currency), (Long)locCurrencyId, (Long)rateTableId, (Date)payTime);
        DynamicObject payInfo = this.buildPayInfo(payWay, payTime, depositAmount, currency, rate);
        PaymentRecord paymentRecord = new PaymentRecord();
        paymentRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)dataEntity).longValue());
        paymentRecord.setBillNo(dataEntity.getString("billno"));
        paymentRecord.setPayWay(payWay);
        SaleOrderHelper.setEachPaymentRecord((DynamicObject)dataEntity, (PaymentRecord)paymentRecord, (DynamicObject)payInfo);
        paymentRecord.setPayStatus("A");
        DynamicObjectCollection finEntryEntity = dataEntity.getDynamicObjectCollection("finentity");
        DynamicObject newFinEntity = finEntryEntity.addNew();
        SaleOrderHelper.updateSaleOrderAfterPayment((DynamicObject)dataEntity, (DynamicObject)newFinEntity, (PaymentRecord)paymentRecord, null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    private DynamicObject buildCreditPayInfo(Map<String, Object> data, Object creditAmount) {
        Object payWay = data.getOrDefault("setllementid", null);
        Object payTime = data.getOrDefault("paytime", null);
        Object currency = data.getOrDefault("settlecurrid", null);
        DynamicObject payInfo = this.buildPayInfo(payWay, payTime, creditAmount, currency, BigDecimal.ONE);
        DynamicObject account = data.getOrDefault("creditaccountid", null);
        payInfo.set("creditaccountid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)account));
        return payInfo;
    }

    private DynamicObject buildPayInfo(Object payWay, Object payTime, Object amount, Object currency, Object rate) {
        DynamicObjectType type = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_salepay.payrecords");
        DynamicObject payInfo = new DynamicObject(type);
        payInfo.set("payway", payWay);
        payInfo.set("paytime", payTime);
        payInfo.set("showamount", amount);
        payInfo.set("paycurrency", currency);
        return payInfo;
    }

    private void updateBill(DynamicObject dataEntity) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        this.getView().updateView();
    }

    private void finishBill(DynamicObject dataEntity) {
        String status = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus");
        if (StringUtils.equals((CharSequence)status, (CharSequence)StatusEnum.AUDIT.getValue())) {
            return;
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)this.getView().getEntityId(), (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            NotificationUtil.showDefaultSuccessNotification((String)"\u7ed3\u7b97\u5b8c\u6210\u3002", (IFormView)this.getView());
        } else {
            NotificationUtil.showDefaultSuccessNotification((String)("\u7ed3\u7b97\u5b8c\u6210\u3002\u5355\u636e\u5ba1\u6838\u5931\u8d25\uff1a" + result.getMessage()), (IFormView)this.getView());
            log.info("\u96f6\u552e\u5f00\u5355\u53f7\uff1a%s \u5ba1\u6838\u5931\u8d25\uff1a%s", (Object)dataEntity.getString("billno"), (Object)result.getMessage());
        }
    }

    private boolean doSettleOp(boolean isCreditPay) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        entryEntity.removeIf(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") == 0L);
        this.getView().updateView("goodsentryentity");
        String billStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus");
        String saleStatus = dataEntity.getString("salestatus");
        if (StringUtils.equalsIgnoreCase((CharSequence)saleStatus, (CharSequence)"S")) {
            NotificationUtil.showDefaultTipNotify((String)"\u5355\u636e\u5df2\u9000\u6b3e\uff0c\u4e0d\u80fd\u91cd\u590d\u9000\u6b3e\u3002", (IFormView)this.getView());
            return false;
        }
        String entityId = this.getView().getEntityId();
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.DRAFT.getValue())) {
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)entityId, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
            if (saveResult == null || !saveResult.isSuccess()) {
                if (saveResult == null) {
                    log.info("\u5355\u636e\u4fdd\u5b58\u5931\u8d25\uff1anull");
                } else {
                    List validateInfo = saveResult.getAllErrorOrValidateInfo();
                    log.info("\u5355\u636e\u4fdd\u5b58\u5931\u8d25:" + validateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.joining()));
                }
                this.getView().showOperationResult(saveResult);
                return false;
            }
            dataEntity.set("salestatus", (Object)"B");
            this.getView().updateView("salestatus");
            this.updateBill(dataEntity);
            if (!isCreditPay) {
                return this.submitBill(entityId, dataEntity);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSettleOp(DynamicObject dataEntity) {
        this.getView().showLoading(new LocaleString("\u7ed3\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u7b49..."));
        try {
            boolean isCvtSale;
            boolean opResult = this.doSettleOp(false);
            long baseBillType = DynamicObjectUtils.getPkValue((DynamicObject)this.getModel().getDataEntity(true).getDynamicObject("basebilltype"));
            boolean bl = isCvtSale = BillTypeEnum.CVTSALE.getId() == baseBillType;
            if (opResult) {
                String entityId = this.getView().getEntityId();
                String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
                log.info(String.format("\u96f6\u552e\u5f00\u5355\u7ed3\u7b97\u5f00\u59cb\uff0c%s \u5355\u636e\u7f16\u53f7:%s", entityId, billNo));
                boolean rlt = this.checkReturnRuleDiscount(dataEntity, entityId);
                if (!rlt) {
                    boolean isNeedOpPayForm;
                    BigDecimal receiveAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"receivableamount");
                    BigDecimal totalRealAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"totalrealamount");
                    BigDecimal creditAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"creditamount");
                    BigDecimal needPayAmt = receiveAmt.subtract(totalRealAmt).subtract(creditAmt);
                    boolean bl2 = isNeedOpPayForm = needPayAmt.compareTo(BigDecimal.ZERO) != 0 || isCvtSale;
                    if (needPayAmt.compareTo(BigDecimal.ZERO) != 0 || isCvtSale) {
                        log.info(String.format("\u96f6\u552e\u5f00\u5355\u5ba1\u6838\u96f6\u91d1\u989d\u7ed3\u7b97\uff0c%s \u5355\u636e\u7f16\u53f7:%s", entityId, billNo));
                        this.showSaleOrderPay(isNeedOpPayForm, null);
                    } else {
                        log.info(String.format("\u96f6\u552e\u5f00\u5355\u5e26\u91d1\u989d\u7ed3\u7b97\u4fdd\u5b58\u7ed3\u7b97\u8bb0\u5f55\uff0c%s \u5355\u636e\u7f16\u53f7:%s", entityId, billNo));
                        SaleOrderHelper.savePayRecordAfterSettleOp((DynamicObject)dataEntity, (DynamicObjectCollection)new DynamicObjectCollection(), new HashMap(0));
                        NotificationUtil.showDefaultSuccessNotification((String)"\u7ed3\u7b97\u5b8c\u6210\u3002", (IFormView)this.getView());
                        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTRECEIVABLES});
                        this.getView().addClientCallBack(ACTION_SETTLEAFTERAUDIT);
                        this.getView().addClientCallBack("srcRelease");
                    }
                    FormShowUtils.updateBillStatus((AbstractBillPlugIn)this);
                } else {
                    log.info(String.format("\u96f6\u552e\u5f00\u5355\u5ba1\u6838\u4f18\u60e0\u989d\u5904\u7406\u5931\u8d25\uff0c%s \u5355\u636e\u7f16\u53f7:%s", entityId, billNo));
                }
            }
        }
        finally {
            this.getView().hideLoading();
        }
    }

    public void afterSubmit(String formId, DynamicObject dataEntity) {
        if (StringUtils.equals((CharSequence)formId, (CharSequence)"ocpos_saleorder_store")) {
            dataEntity.set("billstatus", (Object)StatusEnum.AUDIT.getValue());
            SaveServiceHelper.update((DynamicObject)dataEntity);
            FormShowUtils.updateBillStatus((AbstractBillPlugIn)this);
            this.getView().invokeOperation("refresh");
        }
    }

    private void removeBlankRow(DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        entryEntity.removeIf(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") == 0L);
        this.getView().updateView("goodsentryentity");
    }

    private boolean submitBill(String entityId, DynamicObject dataEntity) {
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)entityId, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        if (submitResult == null || !submitResult.isSuccess()) {
            if (submitResult == null) {
                log.info("\u5355\u636e\u63d0\u4ea4\u5931\u8d25\uff1anull");
            } else {
                List validateInfo = submitResult.getAllErrorOrValidateInfo();
                log.info("\u5355\u636e\u63d0\u4ea4\u5931\u8d25:" + validateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.joining()));
            }
            this.getView().showOperationResult(submitResult);
            return false;
        }
        return true;
    }

    private boolean checkCashierMustInput() {
        DynamicObject cashier;
        boolean isStore;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        String orderSource = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"ordersource");
        boolean isOnline = StringUtils.equals((CharSequence)orderSource, (CharSequence)"D") || StringUtils.equals((CharSequence)orderSource, (CharSequence)"E");
        boolean bl = isStore = billTypeId == BillTypeEnum.STORE.getId();
        if (!isStore && !isOnline && (cashier = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"cashier")) == null) {
            this.getView().showErrorNotification("\u8bf7\u586b\u5199\u201c\u6536\u94f6\u5458\u201d\u3002");
            return false;
        }
        return true;
    }

    private List<OperateErrorInfo> checkDepositValidate(DynamicObject dataEntity) {
        DynamicObjectCollection goodsColl;
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        ArrayList<OperateErrorInfo> errorList = new ArrayList<OperateErrorInfo>(0);
        if ((BillTypeEnum.RETAIL.getId() == billTypeId || BillTypeEnum.RESERVE.getId() == billTypeId || BillTypeEnum.GUIDE.getId() == billTypeId || BillTypeEnum.GROUP.getId() == billTypeId) && (goodsColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity")) != null && goodsColl.size() > 0) {
            for (DynamicObject goodsEntry : goodsColl) {
                BigDecimal depositAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)goodsEntry, (String)"deposit");
                BigDecimal lineReceivableAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)goodsEntry, (String)"linereceivableamount");
                if (depositAmt.compareTo(BigDecimal.ZERO) == 0 || depositAmt.compareTo(lineReceivableAmt) <= 0) continue;
                OperateErrorInfo errorInfo = new OperateErrorInfo("ocpos_saleorder", ErrorLevel.Error, dataEntity.getPkValue());
                errorInfo.setMessage(String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%s\u884c,\u8ba2\u91d1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u884c\u5e94\u6536\u91d1\u989d", DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"seq")));
                errorList.add(errorInfo);
            }
        }
        return errorList;
    }
}

