/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.commonhelper.CurrencyHelper;
import kd.occ.ocpos.business.invoice.InvoiceHelper;
import kd.occ.ocpos.business.saleorder.ReserveServiceHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderReturnRuleHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.PermissionUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SalesOrderReturnMenuActionEdit
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(SalesOrderReturnMenuActionEdit.class);
    private static final String PERM_SETTLEMENT = "18X97F3GNGE1";
    private static final String PERM_CREATEINVOICE = "18X92ZU8TB4S";
    private static final String ACTION_SETTLE = "settleclose";
    private static final String ACTION_DISCOUNTHANDLECLOSE = "discounthandleclose";
    private static final String KEY_INVSTATUS = "bd_invstatus";
    private static final String ACTION_SETTLEAFTERAUDIT = "settleafteraudit";
    private static final String KEY_BTRECEIVABLES = "btreceivables";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        switch (key = op.getOperateKey()) {
            case "submit": {
                if (this.checkCashierMustInput()) break;
                e.setCancel(true);
                return;
            }
            case "settle": {
                if (this.checkCurrency() && this.checkSettle() && this.checkCashierMustInput()) break;
                e.setCancel(true);
                return;
            }
            case "save": {
                if (this.checkCurrency()) break;
                e.setCancel(true);
                break;
            }
            case "dodiscount": {
                DynamicObjectCollection entryData = this.getModel().getEntryEntity("goodsentryentity");
                if (!CollectionUtils.isEmpty((Collection)entryData)) break;
                this.getView().showErrorNotification("\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u3002");
                e.setCancel(true);
                break;
            }
            case "doinvoice": {
                if (this.checkInvoice()) break;
                e.setCancel(true);
                break;
            }
            case "new": {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                CommonUtils.buildNewBillParams((AbstractBillPlugIn)this, (DynamicObject)dataEntity);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (key) {
            case "save": {
                this.setOther(dataEntity);
                break;
            }
            case "settle": {
                if (result == null || !result.isSuccess()) break;
                this.doSettleOp(dataEntity);
                break;
            }
            case "searchinventory": {
                this.showQueryInventory();
                break;
            }
            case "dovipconsumedetail": {
                this.showVipConsumeDetail(dataEntity);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "settleclose": {
                this.settleClose(returnData);
                break;
            }
            case "discounthandleclose": {
                this.discountHandleClose(returnData);
                break;
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String actionId = e.getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (actionId) {
            case "settleafteraudit": {
                SaleOrderWriteBackHelper.addOrderBillFinEntry((DynamicObject)dataEntity);
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BTRECEIVABLES});
                FormShowUtils.updateBillStatus((AbstractBillPlugIn)this);
                this.getView().invokeOperation("refresh");
                long orgId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
                long branchId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
                boolean isAutoPrint = SystemParamUtil.getIsAutoPrint((long)orgId, (long)branchId);
                if (!isAutoPrint) break;
                this.getView().invokeOperation("printpreview");
                break;
            }
            case "srcRelease": {
                Map releaseResult = ReserveServiceHelper.release((DynamicObject)dataEntity);
                if (CollectionUtils.isEmpty((Map)releaseResult)) {
                    return;
                }
                boolean isSuccess = CommonUtil.formatObjectToBoolean(releaseResult.get("releaseResult"));
                if (isSuccess) break;
                String errorMsg = CommonUtil.formatStringToEmpty(releaseResult.get("errorMsg"));
                this.getView().showErrorNotification(errorMsg);
                break;
            }
        }
    }

    private void doSettle(DynamicObject dataEntity, Object discountData) {
        String saleStatus = dataEntity.getString("salestatus");
        if (StringUtils.equalsIgnoreCase((CharSequence)saleStatus, (CharSequence)"S")) {
            NotificationUtil.showDefaultTipNotify((String)"\u5355\u636e\u5df2\u9000\u6b3e\uff0c\u4e0d\u80fd\u91cd\u590d\u9000\u6b3e\u3002", (IFormView)this.getView());
            return;
        }
        dataEntity.set("salestatus", (Object)"B");
        this.setOther(dataEntity);
        this.showSaleOrderPay(discountData);
    }

    private void doSettleOp(DynamicObject dataEntity) {
        this.getView().showLoading(new LocaleString("\u9000\u6b3e\u4e2d\uff0c\u8bf7\u7a0d\u7b49..."));
        boolean rlt = this.checkFixedRuleDiscount();
        if (!rlt) {
            BigDecimal receiveAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"receivableamount").abs();
            BigDecimal totalRealAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"totalrealamount").abs();
            BigDecimal creditAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"creditamount").abs();
            BigDecimal needPayAmt = receiveAmt.subtract(totalRealAmt).subtract(creditAmt);
            if (needPayAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.doSettle(dataEntity, null);
            } else {
                SaleOrderHelper.saveRefundRecordAfterSettleOp((DynamicObject)dataEntity, new ArrayList(0), new HashMap(0));
                NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u5b8c\u6210\u3002", (IFormView)this.getView());
                this.getView().addClientCallBack(ACTION_SETTLEAFTERAUDIT);
                this.getView().addClientCallBack("srcRelease");
            }
            FormShowUtils.updateBillStatus((AbstractBillPlugIn)this);
            this.getView().invokeOperation("refresh");
        }
        this.getView().hideLoading();
    }

    private boolean checkCurrency() {
        boolean result = true;
        DynamicObject exRateTable = (DynamicObject)this.getModel().getValue("exratetable");
        BigDecimal financeExchangeRate = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("financeexchangerate"));
        if (ObjectUtils.isEmpty((Object)exRateTable) || financeExchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("bizorgid");
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)org);
            Map currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
            if (!CollectionUtils.isEmpty((Map)currencyAndExRateMap)) {
                long baseCurrencyId = (Long)currencyAndExRateMap.get("baseCurrencyID");
                long exchangeRateTableId = (Long)currencyAndExRateMap.get("exchangeRateTableID");
                this.getModel().setItemValueByID("locurrencyid", (Object)baseCurrencyId);
                this.getModel().setItemValueByID("exratetable", (Object)exchangeRateTableId);
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currencyid");
                BigDecimal rate = CurrencyHelper.getExChangeRate((Long)Long.parseLong(currency.getPkValue().toString()), (Long)baseCurrencyId, (Long)exchangeRateTableId, (Date)new Date());
                this.getModel().setValue("financeexchangerate", (Object)rate);
            } else {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u68c0\u67e5\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u5bf9\u5e94\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\u8bbe\u7f6e\u3002", (IFormView)this.getView());
                result = false;
            }
        }
        return result;
    }

    private boolean checkFixedRuleDiscount() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        if (!StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue()) && !StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.CANCELORDER.getValue())) {
            return false;
        }
        Map mapResult = SaleOrderHelper.getReturnRuleDiscountAmount((DynamicObject)dataEntity, (boolean)false);
        if (mapResult == null) {
            return false;
        }
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        String retDiscountHandleWay = SystemParamUtil.getRetDiscountHandleWay((long)bizOrgId, (long)branchId).toString();
        BigDecimal giftDiscountAmount = CommonUtil.formatObjectToDecimal(mapResult.get("giftdiscountamount"));
        BigDecimal ticketDiscountAmt = CommonUtil.formatObjectToDecimal(mapResult.get("coupondiscount"));
        BigDecimal integralDiscountAmt = CommonUtil.formatObjectToDecimal(mapResult.get("integraldistamount"));
        BigDecimal receivableAmount = CommonUtil.formatObjectToDecimal(mapResult.get("receivableamount"));
        String pointReturnMode = mapResult.get("pointreturnmode").toString();
        String ticketReturnMode = mapResult.get("cashcouponreturnmode").toString();
        Map mapGiftValue = null;
        Object oGiftValue = mapResult.get("giftvalue");
        if (oGiftValue instanceof Map) {
            mapGiftValue = (Map)oGiftValue;
        }
        this.showDiscountHandle(giftDiscountAmount, ticketDiscountAmt, integralDiscountAmt, receivableAmount, pointReturnMode, ticketReturnMode, mapGiftValue, retDiscountHandleWay);
        NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u9000\u8d27\u5546\u54c1\u5b58\u5728\u8d60\u54c1\u3001\u8d60\u5238\u3001\u8d60\u79ef\u5206\uff0c\u8bf7\u9009\u62e9\u5904\u7406\u65b9\u5f0f", (IFormView)this.getView());
        return true;
    }

    private boolean checkSettle() {
        Map rltMatchMap;
        long branchId;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String saleStatus = dataEntity.getString("salestatus");
        if (StringUtils.equalsIgnoreCase((CharSequence)saleStatus, (CharSequence)"S")) {
            NotificationUtil.showDefaultTipNotify((String)"\u5355\u636e\u5df2\u7ed3\u7b97\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed3\u7b97\u3002", (IFormView)this.getView());
            return false;
        }
        this.setCashier(dataEntity);
        String entityId = this.getView().getEntityId();
        boolean hasPerm = PermissionUtil.checkPermission((String)"ocpos", (String)entityId, (String)PERM_SETTLEMENT);
        if (!hasPerm) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u8d26\u53f7\u65e0\u7ed3\u7b97\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (IFormView)this.getView());
            return false;
        }
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        boolean isAllowZeroSaleNoGift = this.checkIsAllowZeroSaleNoGift(bizOrgId, branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid"));
        if (!isAllowZeroSaleNoGift) {
            return false;
        }
        boolean isAuthRetrun = CommonUtils.checkSaleRoleReturnAuth((DynamicObject)dataEntity);
        if (!isAuthRetrun) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u6536\u94f6\u5458\u5bf9\u5e94\u6536\u94f6\u89d2\u8272\u65e0\u9000\u6b3e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (IFormView)this.getView());
            return false;
        }
        DynamicObject billData = this.getModel().getDataEntity();
        String biztype = billData.getString("biztype");
        if (!(StringUtils.equalsIgnoreCase((CharSequence)biztype, (CharSequence)BizTypeEnum.CANCELORDER.getValue()) || CollectionUtils.isEmpty((Map)(rltMatchMap = SaleOrderReturnRuleHelper.matchRedRefundRuleBySaleOrder((DynamicObject)billData))) || CommonUtil.formatObjectToBoolean(rltMatchMap.get("success")))) {
            this.getView().showErrorNotification(rltMatchMap.get("msg").toString());
            return false;
        }
        return this.checkIsAllowZeroSettleOrder(bizOrgId, branchId);
    }

    private void setCashier(DynamicObject dataEntity) {
        long pkId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity);
        if (pkId == 0L) {
            return;
        }
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        QFilter qFilter = new QFilter("owner", "=", (Object)branchId);
        qFilter.and("sysuser", "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject channelUser = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"id", (QFilter[])qFilter.toArray());
        long userId = DynamicObjectUtils.getPkValue((DynamicObject)channelUser);
        if (userId > 0L) {
            DynamicObject cashier = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"ocdbd_channeluser");
            dataEntity.set("cashier", (Object)cashier);
            this.getView().getModel().setValue("cashier", (Object)cashier);
            SaveServiceHelper.update((DynamicObject)dataEntity);
        }
    }

    private boolean checkInvoice() {
        String entityId = this.getView().getEntityId();
        boolean hasPerm = PermissionUtil.checkPermission((String)"ocpos", (String)entityId, (String)PERM_CREATEINVOICE);
        if (!hasPerm) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u8d26\u53f7\u65e0\u5f00\u53d1\u7968\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (IFormView)this.getView());
            return false;
        }
        DynamicObject billData = this.getModel().getDataEntity();
        long pkId = DynamicObjectUtils.getPkValue((DynamicObject)billData);
        if (pkId == 0L) {
            this.getView().showErrorNotification("\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002");
            return false;
        }
        String result = InvoiceHelper.reCreateInvoice((Object)this.getModel().getValue("Id"));
        if (StringUtil.isNotEmpty((CharSequence)result)) {
            this.getView().showErrorNotification(result);
            return false;
        }
        return true;
    }

    private boolean checkIsAllowZeroSaleNoGift(long bizOrgId, long branchId) {
        DynamicObjectCollection docGoodsEntry;
        boolean result = true;
        boolean isAllowZeroSaleNoGift = SystemParamUtil.getIsAllowZeroSaleNotGift((long)bizOrgId, (long)branchId);
        if (!isAllowZeroSaleNoGift && !CollectionUtils.isEmpty((Collection)(docGoodsEntry = this.getModel().getEntryEntity("goodsentryentity")))) {
            for (DynamicObject doGoodsEntry : docGoodsEntry) {
                DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)doGoodsEntry, (String)"goodsid");
                if (ObjectUtils.isEmpty((Object)goods)) continue;
                boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)doGoodsEntry, (String)"ispresent");
                BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
                if (isPresent || balAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                NotificationUtil.showDefaultTipNotify((String)"\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u672a\u542f\u7528\u975e\u8d60\u54c1\u5141\u8bb8\u96f6\u5355\u4ef7\u9500\u552e\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97\u3002", (IFormView)this.getView());
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean checkIsAllowZeroSettleOrder(long bizOrgId, long branchId) {
        BigDecimal receivableAmount;
        boolean result = true;
        boolean isAllowZeroSettleOrder = SystemParamUtil.getIsAllowZeroSettleOrder((long)bizOrgId, (long)branchId);
        if (!isAllowZeroSettleOrder && (receivableAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("receivableamount"))).compareTo(BigDecimal.ZERO) == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u672a\u542f\u7528\u5141\u8bb8\u6574\u5355\u96f6\u91d1\u989d\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97\u3002", (IFormView)this.getView());
            result = false;
        }
        return result;
    }

    private void showQueryInventory() {
        DynamicObject currency;
        long currencyId;
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("ocpos_valiableinv_stand");
        DynamicObject owner = (DynamicObject)this.getModel().getValue("salebranchid");
        long ownerId = DynamicObjectUtils.getPkValue((DynamicObject)owner);
        listShowParameter.setCustomParam("owner", (Object)ownerId);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("goodsentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            DynamicObject currentItem;
            long stockOrgId;
            DynamicObjectCollection itemList = this.getModel().getEntryEntity("goodsentryentity");
            if (!CollectionUtils.isEmpty((Collection)itemList)) {
                HashSet<Long> itemIds = new HashSet<Long>();
                for (DynamicObject item : itemList) {
                    long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"goodsid");
                    if (goodsId <= 0L) continue;
                    itemIds.add(goodsId);
                }
                listShowParameter.setCustomParam("itemIdSet", itemIds);
            }
            if ((stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)(currentItem = (DynamicObject)itemList.get(selectRows[0])), (String)"inventoryorg")) > 0L) {
                listShowParameter.setCustomParam("stockOrgId", (Object)stockOrgId);
            } else if (ownerId > 0L) {
                listShowParameter.setCustomParam("stockOrgId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)owner, (String)"saleorg"));
            }
            long stockId = DynamicObjectUtils.getPkValue((DynamicObject)currentItem, (String)"stockid");
            if (stockId > 0L) {
                listShowParameter.setCustomParam("warehouseId", (Object)stockId);
            }
        }
        if ((currencyId = DynamicObjectUtils.getPkValue((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currencyid")))) > 0L) {
            listShowParameter.setCustomParam("currency", (Object)currencyId);
        }
        listShowParameter.setCustomParam("extQTyShow", (Object)Boolean.TRUE);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showSaleOrderPay(Object discountData) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        HashMap<String, Object> customParams = new HashMap<String, Object>(15);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long cashierRoleId = 0L;
        DynamicObject cashier = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"cashier");
        if (cashier != null) {
            DynamicObject cashierRole = DynamicObjectUtils.getDynamicObject((DynamicObject)cashier, (String)"cashierid");
            cashierRoleId = DynamicObjectUtils.getPkValue((DynamicObject)cashierRole);
        }
        long posId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"pos");
        customParams.put("pos", posId);
        customParams.put("org", orgId);
        customParams.put("cashierid", cashierRoleId);
        customParams.put("Id", DynamicObjectUtils.getPkValue((DynamicObject)dataEntity));
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        customParams.put("salebranchid", branchId);
        String ticketDiscountType = "";
        String integralDiscountType = "";
        String giftDiscountType = "";
        String giftValueData = "";
        BigDecimal discountValueDed = BigDecimal.ZERO;
        BigDecimal discountCustCpst = BigDecimal.ZERO;
        if (discountData instanceof HashMap) {
            Map mapDiscount = (Map)discountData;
            List lstDiscountData = (List)mapDiscount.get("data");
            giftValueData = mapDiscount.get("giftvalue").toString();
            for (DynamicObject doDiscountData : lstDiscountData) {
                String discountType = DynamicObjectUtils.getString((DynamicObject)doDiscountData, (String)"discounttype");
                String distSrcType = DynamicObjectUtils.getString((DynamicObject)doDiscountData, (String)"distsrctype");
                if ("1".equals(distSrcType)) {
                    ticketDiscountType = discountType;
                } else if ("2".equals(distSrcType)) {
                    integralDiscountType = discountType;
                } else {
                    giftDiscountType = discountType;
                }
                if ("1".equals(discountType)) {
                    discountValueDed = discountValueDed.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doDiscountData, (String)"afdiscountamount"));
                    continue;
                }
                discountCustCpst = discountCustCpst.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doDiscountData, (String)"afdiscountamount"));
            }
        }
        customParams.put("ticketdiscounttype", ticketDiscountType);
        customParams.put("integraldiscounttype", integralDiscountType);
        customParams.put("giftdiscounttype", giftDiscountType);
        customParams.put("discountvalueded", discountValueDed);
        customParams.put("discountcustcpst", discountCustCpst);
        customParams.put("giftvalue", giftValueData);
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        customParams.put("biztype", bizType);
        String formId = this.getPayInfoFormId(dataEntity, discountValueDed);
        FormShowParameter formShowParameter = FormShowUtils.openNewForm((String)"\u9000\u6b3e", (String)formId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_SETTLE));
        this.getView().showForm(formShowParameter);
    }

    private void showVipConsumeDetail(DynamicObject dataEntity) {
        HashMap<String, Long> customParams = new HashMap<String, Long>(0);
        DynamicObject doMember = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
        if (doMember == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u4f1a\u5458\u4fe1\u606f.", (IFormView)this.getView());
            return;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long memberId = DynamicObjectUtils.getPkValue((DynamicObject)doMember);
        customParams.put("bizorgid", orgId);
        customParams.put("salebranchid", branchId);
        customParams.put("member", memberId);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_vipconsumedtl", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        this.getView().showForm(parameter);
    }

    private void showDiscountHandle(BigDecimal giftDiscountAmt, BigDecimal ticketDiscountAmt, BigDecimal integralDiscountAmt, BigDecimal receivableAmount, String pointReturnMode, String ticketReturnMode, Map<String, BigDecimal> mapGiftValue, String retDiscountHandleWay) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(0);
        customParams.put("giftdiscountamount", giftDiscountAmt);
        customParams.put("coupondiscount", ticketDiscountAmt);
        customParams.put("integraldistamount", integralDiscountAmt);
        customParams.put("srcamount", receivableAmount);
        customParams.put("pointreturnmode", pointReturnMode);
        customParams.put("cashcouponreturnmode", ticketReturnMode);
        customParams.put("retdiscounthandleway", retDiscountHandleWay);
        String giftValueData = JSONObject.toJSON(mapGiftValue).toString();
        customParams.put("giftvalue", giftValueData);
        FormShowParameter formShowParameter = FormShowUtils.openNewForm((String)"\u4f18\u60e0\u5904\u7406", (String)"ocpos_discounthandle", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_DISCOUNTHANDLECLOSE));
        this.getView().showForm(formShowParameter);
    }

    private String getPayInfoFormId(DynamicObject billData, BigDecimal discountValueDed) {
        String bizType = DynamicObjectUtils.getString((DynamicObject)billData, (String)"biztype");
        BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)billData, (String)"receivableamount");
        if (receivableAmount.compareTo(discountValueDed) > 0) {
            return "ocpos_salepay";
        }
        if (!StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) {
            return "ocpos_srcreturnpay";
        }
        return "ocpos_nosrcreturnpay";
    }

    private void settleClose(Object returnData) {
        this.getView().invokeOperation("refresh");
        DynamicObject saleReturn = this.getModel().getDataEntity(true);
        if (returnData instanceof String) {
            String strReturnData = String.valueOf(returnData);
            if (StringUtils.equals((CharSequence)strReturnData, (CharSequence)"Success")) {
                NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u5b8c\u6210\u3002", (IFormView)this.getView());
                this.getView().addClientCallBack(ACTION_SETTLEAFTERAUDIT);
                this.getView().addClientCallBack("srcRelease");
            } else {
                NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u5931\u8d25\u3002", (IFormView)this.getView());
                SaveServiceHelper.update((DynamicObject)saleReturn);
            }
        } else if (returnData instanceof Map) {
            Map returnmap = (Map)returnData;
            String success = (String)returnmap.get("success");
            if (StringUtils.equals((CharSequence)success, (CharSequence)"Success")) {
                NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u5b8c\u6210\u3002", (IFormView)this.getView());
                BigDecimal returncashamount = (BigDecimal)returnmap.get("returncashamount");
                saleReturn.set("returncashamount", (Object)returncashamount);
                SaveServiceHelper.update((DynamicObject)saleReturn);
                this.getView().addClientCallBack(ACTION_SETTLEAFTERAUDIT);
            } else {
                NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u5931\u8d25\u3002", (IFormView)this.getView());
                SaveServiceHelper.update((DynamicObject)saleReturn);
            }
        }
        this.getView().invokeOperation("refresh");
    }

    private void discountHandleClose(Object returnData) {
        if (returnData instanceof HashMap) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            this.doSettle(dataEntity, returnData);
            FormShowUtils.updateBillStatus((AbstractBillPlugIn)this);
            this.getView().invokeOperation("refresh");
        }
    }

    private void setOther(DynamicObject dataEntity) {
        int isBookCount = 0;
        int noBookCount = 0;
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        DynamicObject stockStatus = null;
        if (orgId > 0L) {
            stockStatus = BusinessDataServiceHelper.loadSingle((Object)SystemParamUtil.getInvStatus((long)orgId, (long)branchId), (String)KEY_INVSTATUS);
        }
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        DynamicObjectCollection entryData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        for (DynamicObject item : entryData) {
            if (DynamicObjectUtil.getBoolean((DynamicObject)item, (String)"isbook")) {
                ++isBookCount;
            } else {
                noBookCount = StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.ORDERCONVERTSALE.getValue()) ? ++noBookCount : ++noBookCount;
            }
            if (!StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue())) continue;
            item.set("channelstockstatusid", (Object)stockStatus);
        }
        if (isBookCount > 0 && noBookCount > 0) {
            dataEntity.set("ismergebill", (Object)"2");
        } else if (isBookCount > 0 && noBookCount == 0) {
            dataEntity.set("ismergebill", (Object)"0");
        } else if (isBookCount == 0 && noBookCount > 0) {
            dataEntity.set("ismergebill", (Object)"1");
        }
    }

    private boolean checkCashierMustInput() {
        DynamicObject cashier;
        boolean isOnline;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String orderSource = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"ordersource");
        boolean bl = isOnline = StringUtils.equals((CharSequence)orderSource, (CharSequence)"D") || StringUtils.equals((CharSequence)orderSource, (CharSequence)"E");
        if (!isOnline && (cashier = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"cashier")) == null) {
            this.getView().showErrorNotification("\u8bf7\u586b\u5199\u201c\u6536\u94f6\u5458\u201d\u3002");
            return false;
        }
        return true;
    }
}

