/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit.creditadjust;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.OwnerUtil;
import org.apache.commons.lang.StringUtils;

public class CustomerCreditAdjustEdit
extends AbstractBillPlugIn {
    private static final String ACTION_SALEORDER_ADJUST = "ocpos_saleorder_adjust";
    public static final String BOS_LIST = "bos_listf7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit control = (BasedataEdit)this.getView().getControl("adjustbranch");
        control.addBeforeF7SelectListener(a -> {
            ListShowParameter formShowParameter = (ListShowParameter)a.getFormShowParameter();
            List branchIdList = OwnerUtil.getOwnerIds((String[])new String[0]);
            formShowParameter.setFormId(BOS_LIST);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("Id", "in", (Object)branchIdList));
        });
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long branchId = this.initializeBranchId();
        this.getModel().setItemValueByID("adjustbranch", (Object)branchId);
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"adjustbranch");
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)branch, (String)"saleorg");
        this.getModel().setItemValueByID("org", (Object)orgId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        if (result == null) {
            return;
        }
        if (!result.isSuccess()) {
            return;
        }
        if (StringUtils.equals((String)key, (String)"choosesrcbill")) {
            this.showForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((String)actionId, (String)ACTION_SALEORDER_ADJUST) && returnData instanceof DynamicObjectCollection) {
            DynamicObjectCollection data = (DynamicObjectCollection)returnData;
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)data) && entrys != null) {
                entrys.clear();
                this.setEntryValue(data, entrys);
                this.getView().updateView("entryentity");
            }
        }
    }

    private void setEntryValue(DynamicObjectCollection data, DynamicObjectCollection entrys) {
        IDataEntityType dataEntityType;
        DynamicObject doBranch = (DynamicObject)this.getModel().getValue("adjustbranch");
        DynamicObject doSettlement = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.creditpay.getKey(), (String)"ocdbd_paymode");
        List oCustomerIds = data.stream().map(x -> x.get("customerid")).collect(Collectors.toList());
        List oMemberIds = data.stream().map(x -> x.get("memberid")).collect(Collectors.toList());
        List oCashierIds = data.stream().map(x -> x.get("cashierid")).collect(Collectors.toList());
        DynamicObject[] customers = null;
        DynamicObject[] members = null;
        DynamicObject[] cashiers = null;
        if (oCustomerIds.size() > 0) {
            dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)"bd_customer").getDataEntityType();
            customers = (DynamicObject[])BusinessDataServiceHelper.load((Object[])oCustomerIds.toArray(), (IDataEntityType)dataEntityType);
        }
        if (oMemberIds.size() > 0) {
            dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_user").getDataEntityType();
            members = (DynamicObject[])BusinessDataServiceHelper.load((Object[])oMemberIds.toArray(), (IDataEntityType)dataEntityType);
        }
        if (oCashierIds.size() > 0) {
            dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_channeluser").getDataEntityType();
            cashiers = (DynamicObject[])BusinessDataServiceHelper.load((Object[])oCashierIds.toArray(), (IDataEntityType)dataEntityType);
        }
        for (DynamicObject item : data) {
            long cashierId;
            DynamicObject entry = entrys.addNew();
            long billId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"id");
            long entryId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"entryid");
            long creditAccountId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"creditaccountid");
            entry.set("billid", (Object)billId);
            entry.set("finentryid", (Object)entryId);
            entry.set("creditaccountid", (Object)creditAccountId);
            entry.set("srcbillno", (Object)DynamicObjectUtils.getString((DynamicObject)item, (String)"billno"));
            long customerId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"customerid");
            if (customerId > 0L && customers != null && customers.length > 0) {
                DynamicObject doCustomer = Arrays.stream(customers).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == customerId).findFirst().orElse(null);
                entry.set("customer", (Object)doCustomer);
            }
            entry.set("customerphone", (Object)DynamicObjectUtils.getString((DynamicObject)item, (String)"customerphone"));
            long memberId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"memberid");
            if (memberId > 0L && members != null && members.length > 0) {
                DynamicObject doMember = Arrays.stream(members).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == memberId).findFirst().orElse(null);
                entry.set("member", (Object)doMember);
            }
            if ((cashierId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"cashierid")) > 0L && cashiers != null && cashiers.length > 0) {
                DynamicObject doCashier = Arrays.stream(cashiers).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == cashierId).findFirst().orElse(null);
                entry.set("cashier", (Object)doCashier);
            }
            entry.set("billdate", (Object)DynamicObjectUtils.getDate((DynamicObject)item, (String)"bizdate"));
            entry.set("settlement", (Object)doSettlement);
            entry.set("creditamount", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"creditamount"));
            entry.set("alrsettleamount", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"alrsettleamount"));
            entry.set("amount", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"amount"));
            entry.set("receivabledate", (Object)DynamicObjectUtils.getDate((DynamicObject)item, (String)"receivabledate"));
            entry.set("salebranch", (Object)doBranch);
        }
    }

    private long initializeBranchId() {
        return OwnerUtil.getDefaultOwnerId();
    }

    private void showForm() {
        DynamicObject bill = this.getModel().getDataEntity(true);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"adjustbranch");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"org");
        if (branchId == 0L || orgId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u7ef4\u62a4\u8c03\u6574\u95e8\u5e97\u548c\u4e1a\u52a1\u7ec4\u7ec7\u3002", (IFormView)this.getView());
            return;
        }
        HashMap<String, Long> customsParams = new HashMap<String, Long>(0);
        customsParams.put("branchid", branchId);
        customsParams.put("orgid", orgId);
        FormShowParameter param = FormShowUtils.openNewForm((String)"\u8d4a\u9500\u8c03\u6574\u5355\u9009\u5355", (String)ACTION_SALEORDER_ADJUST, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customsParams);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_SALEORDER_ADJUST));
        this.getView().showForm(param);
    }
}

