/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit.creditadjust;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.SaleStatusEnum;

public class SaleOrderAdjustChooseFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_query", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        Long branchId = customParams.getOrDefault("branchid", 0L);
        this.getModel().setValue("branchid", (Object)branchId);
        Long orgId = customParams.getOrDefault("orgid", 0L);
        this.getModel().setValue("orgid", (Object)orgId);
        this.initBillType();
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (ctrl.getKey()) {
            case "btnok": {
                this.returnDataToParent();
                break;
            }
            case "btn_query": {
                this.query();
                break;
            }
        }
    }

    private void initBillType() {
        this.getModel().setValue("billtype", (Object)BillTypeEnum.RETAIL.getId());
    }

    private void query() {
        QFilter filter = this.getFilter();
        DynamicObjectCollection data = this.getBillData(filter);
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (entryEntity == null) {
            return;
        }
        entryEntity.clear();
        this.fillData(data, entryEntity);
        this.getView().updateView("entryentity");
    }

    private void returnDataToParent() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            DynamicObjectCollection selectedEntryEntity = new DynamicObjectCollection();
            for (int selectRow : selectRows) {
                selectedEntryEntity.add(entryEntity.get(selectRow));
            }
            if (CollectionUtils.isEmpty((Collection)selectedEntryEntity)) {
                return;
            }
            if (!CollectionUtils.isEmpty((Collection)selectedEntryEntity)) {
                this.getView().returnDataToParent((Object)selectedEntryEntity);
                this.getView().close();
            }
        } else {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u8c03\u6574\u7684\u6570\u636e\u3002", (IFormView)this.getView());
        }
    }

    private void fillData(DynamicObjectCollection data, DynamicObjectCollection entryEntity) {
        for (DynamicObject item : data) {
            DynamicObject entryItem = entryEntity.addNew();
            this.fillDataItem(item, entryItem);
        }
    }

    private void fillDataItem(DynamicObject item, DynamicObject entryItem) {
        long billId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"id");
        entryItem.set("id", (Object)billId);
        long entryId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"finentity.id");
        entryItem.set("entryid", (Object)entryId);
        String billNo = DynamicObjectUtils.getString((DynamicObject)item, (String)"billno");
        entryItem.set("billno", (Object)billNo);
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"basebilltype.id");
        entryItem.set("billtypeid", (Object)billTypeId);
        String billType = DynamicObjectUtils.getString((DynamicObject)item, (String)"basebilltype.name");
        entryItem.set("billtypename", (Object)billType);
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)item, (String)"bizdate");
        entryItem.set("bizdate", (Object)bizDate);
        long memberId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"member.id");
        entryItem.set("memberid", (Object)memberId);
        String memberName = DynamicObjectUtils.getString((DynamicObject)item, (String)"member.name");
        entryItem.set("vipname", (Object)memberName);
        String mobile = DynamicObjectUtils.getString((DynamicObject)item, (String)"customerphone");
        entryItem.set("customerphone", (Object)mobile);
        long customerId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"customerid.id");
        entryItem.set("customerid", (Object)customerId);
        String customerName = DynamicObjectUtils.getString((DynamicObject)item, (String)"customerid.name");
        entryItem.set("customername", (Object)customerName);
        long saleBranchId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"salebranchid.id");
        entryItem.set("salebranchid", (Object)saleBranchId);
        String saleBranch = DynamicObjectUtils.getString((DynamicObject)item, (String)"salebranchid.name");
        entryItem.set("salebranch", (Object)saleBranch);
        long cashierId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"cashier.id");
        entryItem.set("cashierid", (Object)cashierId);
        String cashier = DynamicObjectUtils.getString((DynamicObject)item, (String)"cashier.username");
        entryItem.set("cashier", (Object)cashier);
        long settlementId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"finentity.setllementid.id");
        entryItem.set("settlementid", (Object)settlementId);
        String settlementName = DynamicObjectUtils.getString((DynamicObject)item, (String)"finentity.setllementid.name");
        entryItem.set("settlement", (Object)settlementName);
        BigDecimal creditAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"finentity.notsettleamount");
        entryItem.set("creditamount", (Object)creditAmount);
        BigDecimal alrSettleAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"finentity.alrsettleamount");
        entryItem.set("alrsettleamount", (Object)alrSettleAmount);
        BigDecimal amount = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"finentity.settleamount");
        entryItem.set("amount", (Object)amount);
        Date receivableDate = DynamicObjectUtils.getDate((DynamicObject)item, (String)"finentity.receivabledate");
        entryItem.set("receivabledate", (Object)receivableDate);
        long creditAccountId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"finentity.creditaccountid");
        entryItem.set("creditaccountid", (Object)creditAccountId);
    }

    private QFilter getFilter() {
        String billNo;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long branchId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"branchid");
        QFilter filter = new QFilter("salebranchid.id", "=", (Object)branchId);
        DynamicObject billType = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"billtype");
        if (!ObjectUtils.isEmpty((Object)billType)) {
            String billTypeNumber = DynamicObjectUtils.getString((DynamicObject)billType, (String)"number");
            filter.and("basebilltype.id", "=", (Object)BillTypeEnum.getIdByNumber((String)billTypeNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)(billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"tarbillno")))) {
            filter.and("billno", "=", (Object)billNo.trim());
        }
        filter.and("billstatus", "=", (Object)BillStatus.C.name());
        filter.and("salestatus", "=", (Object)SaleStatusEnum.STATUS_S.getValue());
        filter.and("finentity.setllementid.id", "=", (Object)PaymentModeEnum.creditpay.getKey());
        filter.and("finentity.notsettleamount", ">", (Object)BigDecimal.ZERO);
        return filter;
    }

    private DynamicObjectCollection getBillData(QFilter filter) {
        String selectFields = this.getHeadSelectFields() + "," + this.getEntrySelectFields();
        return this.getData(selectFields, filter.toArray());
    }

    private String getHeadSelectFields() {
        return "id,billno,basebilltype.id,basebilltype.name,bizdate,member.id,member.name,customerphone,customerid.id,customerid.name,salebranchid.id,salebranchid.name,cashier.id,cashier.username";
    }

    private String getEntrySelectFields() {
        return "finentity.id,finentity.setllementid.id,finentity.setllementid.name,finentity.settleamount,finentity.notsettleamount,finentity.alrsettleamount,finentity.receivabledate,finentity.creditaccountid";
    }

    private DynamicObjectCollection getData(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.query((String)"ocpos_saleorder", (String)selectFields, (QFilter[])filters, (String)this.getOrderByFields());
    }

    private String getOrderByFields() {
        return "bizdate, billno";
    }
}

