/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit.entity;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.inventory.LogisticsInfoHelper;
import kd.occ.ocpos.business.inventory.VisualiZationHelper;
import kd.occ.ocpos.business.push.AutoPushHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderInventoryHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.saleorder.UnitTransferUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.FormViewUtil;
import kd.occ.ocpos.common.util.PermissionUtil;

public class SalesOrderDeliveryEntryEdit
extends AbstractBillPlugIn {
    private static final String[] Logistics_Ops = new String[]{"getlogisticsinfo", "delivery", "receive"};

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entityName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"salesorderdelivery")) {
            RowDataEntity[] rowEntities = e.getRowDataEntities();
            if (rowEntities == null || rowEntities.length <= 0) {
                return;
            }
            for (RowDataEntity rowEntity : rowEntities) {
                int index = rowEntity.getRowIndex();
                DynamicObject row = rowEntity.getDataEntity();
                DynamicObject dataEntity = this.getModel().getDataEntity();
                int pIndex = rowEntity.getParentRowIndex();
                DynamicObjectCollection goodsEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
                if (CollectionUtils.isEmpty((Collection)goodsEntities) || pIndex < 0) continue;
                DynamicObject goodsEntity = (DynamicObject)goodsEntities.get(pIndex);
                this.initDefaultItems(row, goodsEntity, index);
                this.initDefaultUnit(row, goodsEntity, index);
                this.initDefaultReceiving(row, dataEntity, index);
                this.initDefaultInventory(row, goodsEntity, index);
            }
        }
        FormViewUtil.setFocus((IFormView)this.getView(), (String)"deliversaleqty");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String opKey = op.getOperateKey();
        if (Arrays.asList(Logistics_Ops).contains(opKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String billStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billstatus");
            if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.AUDIT.getValue())) {
                NotificationUtil.showDefaultTipNotify((String)String.format("\u5355\u636e\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u8fdb\u884c%s\u64cd\u4f5c\u3002", op.getOperateName()), (IFormView)this.getView());
                return;
            }
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            String changeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            if (billTypeId == BillTypeEnum.CHANGE.getId() && StringUtils.equals((CharSequence)changeType, (CharSequence)"3")) {
                NotificationUtil.showDefaultTipNotify((String)String.format("\u5f53\u524d\u5355\u636e\u4e3a\u6362\u8d27\u8865\u5dee\uff0c\u4e0d\u652f\u6301%s\u64cd\u4f5c\u3002", op.getOperateName()), (IFormView)this.getView());
                return;
            }
            int index = this.getModel().getEntryCurrentRowIndex("salesorderdelivery");
            DynamicObject deliveryEntity = this.getModel().getEntryRowEntity("salesorderdelivery", index);
            if (deliveryEntity == null) {
                NotificationUtil.showDefaultTipNotify((String)String.format("\u914d\u9001\u4fe1\u606f\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c%s\u64cd\u4f5c\u3002", op.getOperateName()), (IFormView)this.getView());
                return;
            }
            DynamicObject entryEntity = (DynamicObject)deliveryEntity.getParent();
            boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
            if (isBook) {
                NotificationUtil.showDefaultTipNotify((String)String.format("\u5f53\u524d\u5546\u54c1\u4e3a\u9884\u8ba2\u5546\u54c1\uff0c\u4e0d\u652f\u6301%s\u64cd\u4f5c\u3002", op.getOperateName()), (IFormView)this.getView());
                return;
            }
            long shippingStatusId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverystatus");
            long detailId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity);
            if (StringUtils.equals((CharSequence)opKey, (CharSequence)"delivery") || StringUtils.equals((CharSequence)opKey, (CharSequence)"receive")) {
                boolean isRight;
                String entityId;
                switch (entityId = this.getView().getEntityId()) {
                    case "ocpos_saleorder": {
                        isRight = this.checkDeliveryStatus(shippingStatusId, true);
                        break;
                    }
                    case "ocpos_saleorder_return": {
                        isRight = this.checkDeliveryStatus(shippingStatusId, false);
                        break;
                    }
                    case "ocpos_salechange": {
                        String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
                        if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"1")) {
                            isRight = this.checkDeliveryStatus(shippingStatusId, true);
                            break;
                        }
                        isRight = this.checkDeliveryStatus(shippingStatusId, false);
                        break;
                    }
                    default: {
                        isRight = true;
                    }
                }
                if (!isRight) {
                    return;
                }
                if (!this.checkAndInputSerialNumber(dataEntity.getPkValue())) {
                    return;
                }
                this.showLogisticsInfoForm(entryEntity, detailId);
            } else {
                DynamicObjectCollection logisticsData = LogisticsInfoHelper.getLogisticsData((long)detailId);
                if (!CollectionUtils.isEmpty((Collection)logisticsData)) {
                    this.showLogisticsInfoQueryForm(entryEntity, logisticsData, detailId);
                } else {
                    NotificationUtil.showDefaultTipNotify((String)"\u672a\u67e5\u5230\u5f53\u524d\u914d\u9001\u884c\u5bf9\u5e94\u7269\u6d41\u4fe1\u606f\u3002", (IFormView)this.getView());
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String parentKey = e.getProperty().getParent().getName();
        if (StringUtils.equals((CharSequence)parentKey, (CharSequence)"salesorderdelivery")) {
            String key;
            ChangeData[] changeData = e.getChangeSet();
            if (changeData == null || changeData.length <= 0) {
                return;
            }
            switch (key = e.getProperty().getName()) {
                case "deliversaleqty": {
                    this.deliverySaleQty(changeData[0]);
                    break;
                }
                case "districtid": {
                    this.districtChanged(changeData[0]);
                    break;
                }
                case "address": {
                    this.deliveryAreaChange(changeData[0]);
                    break;
                }
                case "deliverymode": {
                    this.deliveryModeChange(changeData[0]);
                    break;
                }
                case "returntype": {
                    this.returnTypeChange(changeData[0]);
                    break;
                }
            }
        }
    }

    private void returnTypeChange(ChangeData changeData) {
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String bizType = dataEntity.getString("biztype");
        int deliveryCurrentRowIndex = this.getView().getModel().getEntryCurrentRowIndex("salesorderdelivery");
        int entryCurrentRowIndex = this.getView().getModel().getEntryCurrentRowIndex("goodsentryentity");
        DynamicObject goodEntryEntity = (DynamicObject)dataEntity.getDynamicObjectCollection("goodsentryentity").get(entryCurrentRowIndex);
        DynamicObject delivery = (DynamicObject)goodEntryEntity.getDynamicObjectCollection("salesorderdelivery").get(deliveryCurrentRowIndex);
        if (BizTypeEnum.NOSRCRETURN.getValue().equals(bizType)) {
            String returnType = (String)changeData.getNewValue();
            DynamicObject deliverStatus = "A".equals(returnType) || "B".equals(returnType) ? BusinessDataServiceHelper.loadSingle((Object)1026080127278495744L, (String)"ococic_deliverstatus") : BusinessDataServiceHelper.loadSingle((Object)1026080809389766656L, (String)"ococic_deliverstatus");
            delivery.set("deliverystatus", (Object)deliverStatus);
            this.getView().updateView("deliverystatus", deliveryCurrentRowIndex, entryCurrentRowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"ocpos_logisticsinfo")) {
            JSONObject result;
            Boolean isSuccess;
            if (returnData instanceof JSONObject && (isSuccess = (result = (JSONObject)returnData).getBoolean("isSuccess")) != null) {
                if (isSuccess.booleanValue()) {
                    NotificationUtil.showDefaultSuccessNotification((String)"\u5f53\u524d\u914d\u9001\u660e\u7ec6\u884c\u7269\u6d41\u4fe1\u606f\u66f4\u65b0\u6210\u529f\u3002", (IFormView)this.getView());
                    this.updateOrderStatus(e);
                    this.getView().invokeOperation("refresh");
                } else {
                    String errorMsg = result.getString("errorMsg");
                    this.getView().showErrMessage(errorMsg, "\u7269\u6d41\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
                }
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"returnpickup") && returnData instanceof DynamicObject) {
            DynamicObject ret = (DynamicObject)returnData;
            int index = this.getModel().getEntryCurrentRowIndex("salesorderdelivery");
            DynamicObject deliveryEntity = this.getModel().getEntryRowEntity("salesorderdelivery", index);
            List saleOrderSubEntryIds = Collections.singletonList(DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity));
            saleOrderSubEntryIds = VisualiZationHelper.getAllSubEntryIdFormSingle((String)"ocpos_saleorder_return", saleOrderSubEntryIds);
            DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)DeliveryStatus.RETURN_HAVE_PICK, (String)"ococic_deliverstatus");
            VisualiZationHelper.updataSaleOrderValue((String)"ocpos_saleorder_return", (List)saleOrderSubEntryIds, (String)"deliverystatus", (Object)deliveryStatus);
            VisualiZationHelper.updataDeliveryOrderStatus((List)saleOrderSubEntryIds, (DynamicObject)deliveryStatus);
            VisualiZationHelper.updataReturnDataToDeliveryOrder((List)saleOrderSubEntryIds, (DynamicObject)ret);
            VisualiZationHelper.updataRetailOrderStatus((List)saleOrderSubEntryIds, (String)"deliverystatus", (Object)deliveryStatus);
            VisualiZationHelper.updataSignStatus((List)saleOrderSubEntryIds, (String)"B");
            VisualiZationHelper.updataRetailOrderStatus((List)saleOrderSubEntryIds, (String)"signstatus", (Object)"B");
            VisualiZationHelper.updateSaleOrderStatusAndChange((DynamicObject)deliveryStatus, (List)saleOrderSubEntryIds, (String)"ocpos_saleorder_return");
        }
    }

    private void initDefaultItems(DynamicObject row, DynamicObject goodsEntity, int index) {
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)goodsEntity, (String)"goodsid");
        row.set("delivergoodsid", (Object)goods);
        this.getView().updateView("delivergoodsid", index);
        this.getView().updateView("delivergoodname", index);
        DynamicObject barCode = DynamicObjectUtils.getDynamicObject((DynamicObject)goodsEntity, (String)"barcode");
        row.set("deliverbarcodeid", (Object)barCode);
        this.getView().updateView("deliverbarcodeid", index);
        DynamicObject brand = DynamicObjectUtils.getDynamicObject((DynamicObject)goodsEntity, (String)"brand");
        row.set("brandid", (Object)brand);
        this.getView().updateView("brandid", index);
        DynamicObject goodsClass = DynamicObjectUtils.getDynamicObject((DynamicObject)goodsEntity, (String)"goodsclass");
        row.set("delivergoodsclass", (Object)goodsClass);
        this.getView().updateView("delivergoodsclass", index);
    }

    private void initDefaultUnit(DynamicObject row, DynamicObject goodsEntity, int index) {
        DynamicObject unit = DynamicObjectUtils.getDynamicObject((DynamicObject)goodsEntity, (String)"unit");
        row.set("deliverunitid", (Object)unit);
        this.getView().updateView("deliverunitid", index);
        DynamicObject baseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)goodsEntity, (String)"baseunit");
        row.set("deliverybaseunit", (Object)baseUnit);
        this.getView().updateView("deliverybaseunit", index);
        DynamicObject stockUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)goodsEntity, (String)"stockunit");
        row.set("deliverystockunit", (Object)stockUnit);
        this.getView().updateView("deliverystockunit", index);
        DynamicObject auxUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)goodsEntity, (String)"auxunit");
        row.set("deliveryauxunit", (Object)auxUnit);
        this.getView().updateView("deliveryauxunit", index);
    }

    private void initDefaultReceiving(DynamicObject row, DynamicObject dataEntity, int index) {
        DynamicObject member = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
        String memberName = DynamicObjectUtils.getString((DynamicObject)member, (String)"name");
        row.set("consignee", (Object)memberName);
        this.getView().updateView("consignee", index);
        String memberPhone = DynamicObjectUtils.getString((DynamicObject)member, (String)"telephone");
        if (memberPhone.contains("-")) {
            memberPhone = memberPhone.substring(memberPhone.indexOf(45) + 1);
        }
        row.set("deliverphonenumber", (Object)memberPhone);
        this.getView().updateView("deliverphonenumber", index);
        String address = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"customeraddress");
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid");
        if (StringUtils.isNotBlank((CharSequence)adminDivisionId) && !StringUtils.equals((CharSequence)adminDivisionId, (CharSequence)"0")) {
            SaleOrderInventoryHelper.upadateDeliveryAddress((DynamicObject)row, (String)adminDivisionId, (String)address);
            this.getView().updateView("districtid", index);
            this.getView().updateView("address", index);
            this.getView().updateView("fulladdress", index);
        }
    }

    private void initDefaultInventory(DynamicObject row, DynamicObject goodsEntity, int index) {
        String ownerType;
        DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)DeliveryStatus.SALE_OUTBOUND, (String)"ococic_deliverstatus");
        row.set("deliverystatus", (Object)deliveryStatus);
        this.getView().updateView("deliverystatus", index);
        String operationMode = DynamicObjectUtils.getString((DynamicObject)goodsEntity, (String)"operationmodel");
        long distributionModeId = StringUtils.equals((CharSequence)operationMode, (CharSequence)"0") ? 926601157210585088L : 926601071999218688L;
        DynamicObject deliveryMode = BusinessDataServiceHelper.loadSingle((Object)distributionModeId, (String)"ocdbd_distributionmode");
        row.set("deliverymode", (Object)deliveryMode);
        this.getView().updateView("deliverymode", index);
        String keeperType = DynamicObjectUtils.getString((DynamicObject)row, (String)"deliverykeepertype");
        DynamicObject branch = (DynamicObject)this.getModel().getValue("salebranchid");
        DynamicObject invOrg = InventoryUtils.getInvOrg((DynamicObject)branch);
        if (StringUtils.equals((CharSequence)keeperType, (CharSequence)"bos_org")) {
            row.set("deliverykeeper", (Object)invOrg);
            this.getView().updateView("deliverykeeper", index);
        }
        if (StringUtils.equals((CharSequence)(ownerType = DynamicObjectUtils.getString((DynamicObject)row, (String)"deliveryownertype")), (CharSequence)"bos_org")) {
            long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)invOrg);
            DynamicObject owner = InventoryUtils.getDefaultOwner((long)invOrgId);
            row.set("deliveryowner", (Object)owner);
            this.getView().updateView("deliveryowner", index);
        }
    }

    private void deliverySaleQty(ChangeData changeData) {
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        int parentRowIndex = changeData.getParentRowIndex();
        SaleOrderInventoryHelper.deliveryInventory((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex);
        DynamicObject delivery = changeData.getDataEntity();
        BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)delivery, (String)"deliversaleqty");
        UnitTransferUtils.updateDeliveryMultiQuantities((IFormView)this.getView(), (DynamicObject)delivery, (BigDecimal)qty);
        this.getView().updateView("salesorderdelivery", rowIndex);
    }

    private void deliveryModeChange(ChangeData changeData) {
        long modeId;
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String bizType = dataEntity.getString("biztype");
        DynamicObject deliveryMode = (DynamicObject)changeData.getNewValue();
        DynamicObject delivery = changeData.getDataEntity();
        if (!BizTypeEnum.NOSRCRETURN.getValue().equals(bizType)) {
            DynamicObject deliveryStatus = this.getDeliverySentStatus(deliveryMode);
            delivery.set("deliverystatus", (Object)deliveryStatus);
        }
        if ((modeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryMode)) == 926601071999218688L) {
            DynamicObject branch = (DynamicObject)this.getModel().getValue("salebranchid");
            delivery.set("deliverdeliverybranchid", (Object)branch);
            DynamicObject stock = InventoryUtils.getDefaultChannelStock((DynamicObject)branch);
            delivery.set("deliverstockid", (Object)stock);
            DynamicObject stockOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)stock, (String)"erpstockorgid");
            delivery.set("inventoryorgid", (Object)stockOrg);
            DynamicObject erpStock = DynamicObjectUtils.getDynamicObject((DynamicObject)stock, (String)"erpwarehouseid");
            delivery.set("erpstockid", (Object)erpStock);
        } else {
            delivery.set("deliverdeliverybranchid", null);
            delivery.set("deliverstockid", null);
            delivery.set("inventoryorgid", null);
            delivery.set("erpstockid", null);
        }
        delivery.set("stockpositionid", null);
        delivery.set("erpstockpositionid", null);
        this.getView().updateView("salesorderdelivery", changeData.getRowIndex());
    }

    private void districtChanged(ChangeData changeData) {
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        DynamicObject delivery = changeData.getDataEntity();
        delivery.set("address", (Object)"");
        delivery.set("fulladdress", (Object)"");
        this.getView().updateView("salesorderdelivery", changeData.getRowIndex());
    }

    private void deliveryAreaChange(ChangeData changeData) {
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        DynamicObject delivery = changeData.getDataEntity();
        int rowIndex = changeData.getRowIndex();
        int parentRowIndex = changeData.getParentRowIndex();
        delivery.set("fulladdress", null);
        SaleOrderInventoryHelper.deliveryInventory((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex);
    }

    private void showLogisticsInfoForm(DynamicObject entryEntity, long detailId) {
        String caption = "\u7269\u6d41\u4fe1\u606f";
        String entityId = this.getView().getEntityId();
        String type = "0";
        switch (entityId) {
            case "ocpos_saleorder": {
                caption = "\u53d1\u8d27\u5904\u7406";
                break;
            }
            case "ocpos_saleorder_return": {
                type = "1";
                caption = "\u53d6\u4ef6\u5904\u7406";
                break;
            }
            case "ocpos_salechange": {
                String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
                if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                    type = "1";
                    caption = "\u53d6\u4ef6\u5904\u7406";
                    break;
                }
                caption = "\u53d1\u8d27\u5904\u7406";
                break;
            }
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"1")) {
            if (this.checkPerm()) {
                return;
            }
            int index = this.getModel().getEntryCurrentRowIndex("salesorderdelivery");
            DynamicObject deliveryEntity = this.getModel().getEntryRowEntity("salesorderdelivery", index);
            List<Object> lstSubEntryIds = Collections.singletonList(DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity));
            List saleOrderSubEntryIds = VisualiZationHelper.getAllSubEntryIdFormSingle((String)"ocpos_saleorder_return", lstSubEntryIds);
            if (CollectionUtils.isEmpty((Collection)saleOrderSubEntryIds)) {
                NotificationUtil.showDefaultTipNotify((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u4e0b\u6e38\u53d1\u8d27\u5355,\u8bf7\u624b\u5de5\u4e0b\u63a8\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (IFormView)this.getView());
                return;
            }
            if (DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverystatus") == DeliveryStatus.RETURN_WAIT_PICK) {
                this.showDeliveryForm(lstSubEntryIds);
            } else {
                NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5546\u54c1\u4e0d\u662f\u5f85\u53d6\u8d27\u72b6\u6001\uff0c\u65e0\u9700\u8fdb\u884c\u9000\u8d27\u53d6\u4ef6\u3002", (IFormView)this.getView());
            }
        } else {
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            customParams.put("subentryid", detailId);
            customParams.put("type", type);
            FormShowParameter parameter = FormShowUtils.openNewForm((String)caption, (String)"ocpos_logisticsinfo", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocpos_logisticsinfo"));
            this.getView().showForm(parameter);
        }
    }

    private void showDeliveryForm(List<Object> saleOrderSubEntryIds) {
        FormShowParameter param = new FormShowParameter();
        param.setCustomParam("id", saleOrderSubEntryIds);
        param.setCustomParam("name", (Object)"ocpos_saleorder_return");
        param.setFormId("ocpos_fillpickupinfo");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "returnpickup"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private void showLogisticsInfoQueryForm(DynamicObject entryEntity, DynamicObjectCollection logisticData, long detailId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("deliveryData", logisticData);
        customParams.put("subentryid", detailId);
        String entityId = this.getView().getEntityId();
        String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
        String type = "0";
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_return") || StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_salechange") && StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
            type = "1";
        }
        customParams.put("type", type);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_querylogisticsinfo", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        this.getView().showForm(parameter);
    }

    private DynamicObject getDeliverySentStatus(DynamicObject deliveryMode) {
        if (ObjectUtils.isEmpty((Object)deliveryMode)) {
            return null;
        }
        long deliveryModeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryMode);
        String filterNumber = deliveryModeId == 926601071999218688L || deliveryModeId == 926601157210585088L ? "F003" : "F001";
        QFilter numberFilter = new QFilter("number", "=", (Object)filterNumber);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"ococic_deliverstatus", (String)"id", (QFilter[])numberFilter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return dynamicObjects[0];
        }
        return null;
    }

    private void updateOrderStatus(ClosedCallBackEvent closedCallBackEvent) {
        int index = this.getModel().getEntryCurrentRowIndex("salesorderdelivery");
        DynamicObject deliveryEntity = this.getModel().getEntryRowEntity("salesorderdelivery", index);
        String entityId = this.getView().getEntityId();
        List saleOrderSubEntryIds = Collections.singletonList(DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity));
        JSONObject returnData = (JSONObject)closedCallBackEvent.getReturnData();
        if (!returnData.getBoolean("isSuccess").booleanValue()) {
            NotificationUtil.showDefaultTipNotify((String)("\u53d1\u8d27\u5931\u8d25\uff0c" + returnData.getString("errorMsg")), (IFormView)this.getView());
            return;
        }
        DynamicObject billType = (DynamicObject)this.getModel().getValue("basebilltype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        long deliveryStatusId = billTypeId == BillTypeEnum.RETURN.getId() ? DeliveryStatus.RETURN_HAVE_PICK : DeliveryStatus.SALE_OUTBOUND;
        DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)deliveryStatusId, (String)"ococic_deliverstatus");
        saleOrderSubEntryIds = VisualiZationHelper.getAllSubEntryIdFormSingle((String)entityId, saleOrderSubEntryIds);
        VisualiZationHelper.updataSaleOrderValue((String)entityId, (List)saleOrderSubEntryIds, (String)"deliverystatus", (Object)deliveryStatus);
        VisualiZationHelper.updataDeliveryOrderStatus((List)saleOrderSubEntryIds, (DynamicObject)deliveryStatus);
        VisualiZationHelper.updataRetailOrderStatus((List)saleOrderSubEntryIds, (String)"deliverystatus", (Object)deliveryStatus);
        if (ObjectUtils.nullSafeEquals((Object)entityId, (Object)"ocpos_saleorder")) {
            VisualiZationHelper.updataSaleOrderValue((String)entityId, (List)saleOrderSubEntryIds, (String)"signstatus", (Object)"B");
        }
        VisualiZationHelper.updataSignStatus((List)saleOrderSubEntryIds, (String)"B");
        VisualiZationHelper.updataRetailOrderStatus((List)saleOrderSubEntryIds, (String)"signstatus", (Object)"B");
        VisualiZationHelper.updateSaleOrderStatusAndChange((DynamicObject)deliveryStatus, (List)saleOrderSubEntryIds, (String)entityId);
        QFilter qFilter = new QFilter("entryentity.corebillentryid", "in", (Object)saleOrderSubEntryIds);
        Object[] deliveryOrders = BusinessDataServiceHelper.load((String)"ocococ_deliveryorder", (String)"id", (QFilter[])qFilter.toArray());
        if (!ArrayUtils.isEmpty((Object[])deliveryOrders)) {
            for (Object deliveryOrder : deliveryOrders) {
                boolean flag = BFTrackerServiceHelper.isPush((String)"ocococ_deliveryorder", (Long)deliveryOrder.getLong("id"));
                if (flag) continue;
                AutoPushHelper.autoPushBill((Object)deliveryOrder.getLong("id"), (String)"ocococ_deliveryorder", (String)"im_saloutbill", (String)"audit");
            }
        }
    }

    private boolean checkPerm() {
        boolean hasPerm = PermissionUtil.checkPermission((String)"ocpos", (String)"ocpos_saleorder_return", (String)"1Q4=9KRO17MN");
        if (!hasPerm) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u8d26\u53f7\u65e0\u9000\u8d27\u53d6\u4ef6\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (IFormView)this.getView());
        }
        return !hasPerm;
    }

    private boolean checkDeliveryStatus(long shippingStatusId, boolean isSale) {
        if (isSale) {
            if (shippingStatusId != DeliveryStatus.SALE_WAIT_DELIVERY) {
                NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5546\u54c1\u53d1\u8d27\u72b6\u6001\u4e0d\u662f\u5f85\u53d1\u8d27\uff0c\u65e0\u9700\u586b\u5199\u7269\u6d41\u4fe1\u606f\u3002", (IFormView)this.getView());
                return false;
            }
        } else if (shippingStatusId != DeliveryStatus.RETURN_WAIT_PICK) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5546\u54c1\u53d1\u8d27\u72b6\u6001\u4e0d\u662f\u5f85\u53d6\u8d27\uff0c\u65e0\u9700\u586b\u5199\u7269\u6d41\u4fe1\u606f\u3002", (IFormView)this.getView());
            return false;
        }
        return true;
    }

    private boolean checkAndInputSerialNumber(Object pkValue) {
        ArrayList data = new ArrayList(10);
        String entityId = this.getView().getEntityId();
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)entityId);
        DynamicObjectCollection entryEntities = saleOrder.getDynamicObjectCollection("goodsentryentity");
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities;
            DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"materialinv");
            boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
            if (!isEnableSerial || CollectionUtils.isEmpty((Collection)(deliveryEntities = entryEntity.getDynamicObjectCollection("salesorderdelivery")))) continue;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                int deliverSaleQty;
                String sn = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"deliveryserialnumber");
                if (!StringUtils.isBlank((CharSequence)sn) || (deliverSaleQty = DynamicObjectUtils.getInt((DynamicObject)deliveryEntity, (String)"deliversaleqty")) == 0) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("deliversaleqty", deliverSaleQty);
                map.put("delivergoodsid", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"delivergoodsid"));
                map.put("deliverymaterial", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymaterial"));
                map.put("inventoryorgid", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"inventoryorgid"));
                map.put("erpstockid", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"erpstockid"));
                map.put("PrimaryKeyValue", saleOrder.getPkValue());
                map.put("EntryPrimaryKeyValue", entryEntity.getPkValue());
                map.put("EntityId", entityId);
                data.add(map);
            }
        }
        if (!data.isEmpty()) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ocpos_inputserialnumber");
            formShowParameter.setCustomParam("data", data);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "EntityId"));
            this.getView().showForm(formShowParameter);
            return false;
        }
        return true;
    }
}

