/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DecimalEdit;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.promotion.SaleorderPromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderInventoryHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.saleorder.UnitTransferUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.FormViewUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SalesOrderGoodsEntryEdit
extends AbstractBillPlugIn {
    private static final String KEY_DEPOSIT_TIP_CALLBACK = "depositChange";
    private static final String KEY_DEPOSITSCALE_TIP_CALLBACK = "depositScaleChange";
    private static final String KEY_FINALPAYMENT_TIP_CALLBACK = "finalPaymentChange";
    private static final String KEY_FINALPAYMENTSCALE_TIP_CALLBACK = "finalPaymentScaleChange";

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Object source = e.getSource();
        if (source instanceof DecimalEdit) {
            String fieldKey;
            DecimalEdit decimalEdit = (DecimalEdit)source;
            switch (fieldKey = decimalEdit.getKey()) {
                case "deposit": {
                    this.getPageCache().remove("PageCache_" + fieldKey);
                    this.beforeDepositFieldPostBack(e, fieldKey);
                    break;
                }
                case "depositscale": {
                    this.getPageCache().remove("PageCache_" + fieldKey);
                    this.beforeDepositScaleFieldPostBack(e, fieldKey);
                    break;
                }
                case "notincomedisamount": 
                case "stddiscountamount": 
                case "ticketshareamount": {
                    this.beforeAboutBalAmountFieldPostBack(e, fieldKey);
                    break;
                }
                case "manualdiscount": {
                    this.beforeManualDiscountFieldPostBack(e, fieldKey);
                    break;
                }
                case "finalpayment": {
                    this.getPageCache().remove("PageCache_" + fieldKey);
                    this.beforeFinalPaymentFieldPostBack(e, fieldKey);
                    break;
                }
                case "finalpaymentscale": 
                case "balamount": {
                    this.getPageCache().remove("PageCache_" + fieldKey);
                    this.beforeFinalPaymentScaleFieldPostBack(e, fieldKey);
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String parentKey = e.getProperty().getParent().getName();
        if (StringUtils.equals((CharSequence)parentKey, (CharSequence)"goodsentryentity")) {
            ChangeData[] changeSet = e.getChangeSet();
            if (changeSet == null || changeSet.length <= 0) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                return;
            }
            String key = e.getProperty().getName();
            this.propertyChanged(changeSet, key, dataEntity, entryEntities);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"goodsentryentity")) {
            RowDataEntity[] rowEntities = e.getRowDataEntities();
            if (rowEntities == null || rowEntities.length <= 0) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"salebranchid");
            DynamicObject saler = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"saler");
            Object dpt = CommonUtils.getDeptObj((DynamicObject)saler);
            long baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            for (RowDataEntity rowEntity : rowEntities) {
                int index = rowEntity.getRowIndex();
                DynamicObject row = rowEntity.getDataEntity();
                if (baseBillTypeId == BillTypeEnum.RESERVE.getId()) {
                    row.set("isbook", (Object)Boolean.TRUE);
                    this.getView().updateView("isbook", index);
                }
                row.set("goodssaler", (Object)saler);
                this.getView().updateView("goodssaler", index);
                row.set("saledepartment", dpt);
                this.getView().updateView("saledepartment", index);
                String inventoryUpdate = DynamicObjectUtils.getString((DynamicObject)row, (String)"inventoryupdate");
                if (StringUtils.equals((CharSequence)inventoryUpdate, (CharSequence)"B")) {
                    DynamicObject invOrg = InventoryUtils.getInvOrg((DynamicObject)branch);
                    row.set("keeperid", (Object)invOrg);
                    this.getView().updateView("keeperid", index);
                    long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)invOrg);
                    DynamicObject defOwner = InventoryUtils.getDefaultOwner((long)invOrgId);
                    row.set("ownerid", (Object)defOwner);
                    this.getView().updateView("ownerid", index);
                }
                if (baseBillTypeId == BillTypeEnum.RETURN.getId()) {
                    long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
                    long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
                    long stockStatusId = SystemParamUtil.getInvStatus((long)orgId, (long)branchId);
                    DynamicObject stockStatus = BusinessDataServiceHelper.loadSingle((Object)stockStatusId, (String)"bd_invstatus");
                    row.set("channelstockstatusid", (Object)stockStatus);
                    this.getView().updateView("channelstockstatusid", index);
                }
                row.set("inventoryorg", null);
                this.getView().updateView("inventoryorg", index);
            }
            CommonUtils.setSaleQtyEnable((IFormView)this.getView());
            FormViewUtil.setFocus((IFormView)this.getView(), (String)"goodsid");
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName;
        super.beforeDeleteRow(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.FINAL.getId() || billTypeId == BillTypeEnum.RESERVEFINAL.getId() || billTypeId == BillTypeEnum.CREDIT.getId()) {
            return;
        }
        String bizTypeId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        if (StringUtils.equals((CharSequence)bizTypeId, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) {
            return;
        }
        switch (entryName = e.getEntryProp().getName()) {
            case "goodsentryentity": {
                this.checkBeforeDelete(e, dataEntity, billTypeId);
                break;
            }
            case "ticketsendentity": {
                DynamicObjectCollection ticketSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity");
                boolean anyTicketMatchReturn = Arrays.stream(e.getRowIndexs()).anyMatch(x -> "0".equals(DynamicObjectUtils.getString((DynamicObject)((DynamicObject)ticketSendEntity.get(x)), (String)"ticketsaleoption")));
                if (!anyTicketMatchReturn) break;
                NotificationUtil.showDefaultTipNotify((String)"\u53ea\u80fd\u5220\u9664\u9500\u552e\u884c\u8d60\u5238\u660e\u7ec6", (IFormView)this.getView());
                e.setCancel(true);
                break;
            }
            case "sendintegralentity": {
                DynamicObjectCollection pointSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity");
                boolean anyPointMatchReturn = Arrays.stream(e.getRowIndexs()).anyMatch(x -> "0".equals(DynamicObjectUtils.getString((DynamicObject)((DynamicObject)pointSendEntity.get(x)), (String)"pointsaleoption")));
                if (!anyPointMatchReturn) break;
                NotificationUtil.showDefaultTipNotify((String)"\u53ea\u80fd\u5220\u9664\u9500\u552e\u884c\u8d60\u79ef\u5206\u660e\u7ec6", (IFormView)this.getView());
                e.setCancel(true);
                break;
            }
        }
    }

    private void checkBeforeDelete(BeforeDeleteRowEventArgs e, DynamicObject dataEntity, long billTypeId) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        long baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("basebilltype"));
        String bizType = dataEntity.getString("biztype");
        String billEntityId = dataEntity.getDataEntityType().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)billEntityId, (CharSequence)"ocpos_saleorder") || StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"N")) {
            return;
        }
        int[] selectRowIndexs = e.getRowIndexs();
        if (entryEntities.size() == selectRowIndexs.length) {
            return;
        }
        StringBuilder messages = new StringBuilder();
        for (int rowIndex : selectRowIndexs) {
            DynamicObject entryEntry = (DynamicObject)entryEntities.get(rowIndex);
            int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntry, (String)"seq");
            boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntry, (String)"isbook");
            if (!isBook) continue;
            String saleOption = DynamicObjectUtil.getString((DynamicObject)entryEntry, (String)"saleoption");
            if (baseBillTypeId != BillTypeEnum.RETURN.getId() && !StringUtils.equalsIgnoreCase((CharSequence)saleOption, (CharSequence)"0")) continue;
            messages.append(String.format("\u7b2c%d\u884c\u9000\u8d27\u7684\u662f\u9884\u8ba2\u5546\u54c1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", seq));
        }
        if (messages.length() > 0) {
            e.setCancel(true);
            NotificationUtil.showDefaultTipNotify((String)messages.toString(), (IFormView)this.getView());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        int[] deleteRowIndexs = e.getRowIndexs();
        if (deleteRowIndexs == null || deleteRowIndexs.length == 0) {
            return;
        }
        List deleteRowIndexLst = CollectionUtils.arrayToList((Object)deleteRowIndexs);
        Collections.sort(deleteRowIndexLst);
        String entityId = this.getView().getEntityId();
        switch (entryName = e.getEntryProp().getName()) {
            case "goodsentryentity": {
                String changeItemType;
                HashMap<Integer, DynamicObject> manualPromSeqGoodsEntryMap = new HashMap<Integer, DynamicObject>(0);
                HashMap<Integer, DynamicObject> promPromSeqGoodsEntryMap = new HashMap<Integer, DynamicObject>(0);
                HashMap<Integer, Integer> beforeAfterGoodsSeqMap = new HashMap<Integer, Integer>(0);
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
                if (billTypeId == BillTypeEnum.CHANGE.getId() && (StringUtils.equalsIgnoreCase((CharSequence)(changeItemType = DynamicObjectUtil.getString((DynamicObject)dataEntity, (String)"changeitemtype")), (CharSequence)"1") || StringUtils.equalsIgnoreCase((CharSequence)changeItemType, (CharSequence)"3"))) {
                    this.clearAllEntity(dataEntity);
                    return;
                }
                boolean notConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
                if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder") && billTypeId != BillTypeEnum.CVTSALE.getId() || notConfirm && billTypeId == BillTypeEnum.CVTSALE.getId()) {
                    this.unExecutePromote(dataEntity);
                    SaleorderPromotionHelper.afterDeleteRowReMatchPromoteRule((IFormView)this.getView(), (int[])e.getRowIndexs());
                }
                DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
                this.getBeforeDeleteRowSeqMap(goodsEntryEntity, deleteRowIndexLst, beforeAfterGoodsSeqMap, manualPromSeqGoodsEntryMap, promPromSeqGoodsEntryMap);
                this.deleteGoodsSeqRelateSendGoodsEntity(dataEntity, goodsEntryEntity, deleteRowIndexLst, beforeAfterGoodsSeqMap, manualPromSeqGoodsEntryMap, promPromSeqGoodsEntryMap, billTypeId, notConfirm);
                this.updateEntityGoodsSeq(dataEntity, goodsEntryEntity, beforeAfterGoodsSeqMap, manualPromSeqGoodsEntryMap, promPromSeqGoodsEntryMap, billTypeId, notConfirm);
                if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) {
                    SaleOrderAmountHelper.recalculateShareAmount((DynamicObject)dataEntity);
                }
                CommonUtils.setSaleQtyEnable((IFormView)this.getView());
                CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
                this.getView().updateView("salesorderpromote");
                this.getView().updateView("goodsentryentity");
                break;
            }
            case "useticketentity": {
                if (!StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) break;
                DynamicObject saleOrder = this.getModel().getDataEntity(true);
                SaleOrderAmountHelper.recalculateShareAmount((DynamicObject)saleOrder);
                this.getView().updateView("useticketentity");
                this.getView().updateView("goodsentryentity");
                CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
                break;
            }
        }
    }

    private void clearAllEntity(DynamicObject dataEntity) {
        DynamicObjectCollection useTicketEntity;
        DynamicObjectCollection sendIntegralEntity;
        DynamicObjectCollection ticketSendEntity;
        DynamicObjectCollection goodSendEntity;
        DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)goodsEntryEntity)) {
            goodsEntryEntity.clear();
            this.getView().updateView("goodsentryentity");
            this.getView().updateView("salesorderdelivery");
            this.getView().updateView("salesorderpromote");
        }
        if (!CollectionUtils.isEmpty((Collection)(goodSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity")))) {
            goodSendEntity.clear();
            this.getView().updateView("goodsendentity");
        }
        if (!CollectionUtils.isEmpty((Collection)(ticketSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity")))) {
            ticketSendEntity.clear();
            this.getView().updateView("ticketsendentity");
        }
        if (!CollectionUtils.isEmpty((Collection)(sendIntegralEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity")))) {
            sendIntegralEntity.clear();
            this.getView().updateView("sendintegralentity");
        }
        if (!CollectionUtils.isEmpty((Collection)(useTicketEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"useticketentity")))) {
            useTicketEntity.clear();
            this.getView().updateView("useticketentity");
        }
    }

    public void getManualPromSeqGoodsEntryMap(DynamicObjectCollection goodsEntryEntity, List<Integer> deleteRowIndexLst, Map<Integer, DynamicObject> manualPromSeqGoodsEntryMap) {
        for (DynamicObject goodsEntry : goodsEntryEntity) {
            boolean isPresent = DynamicObjectUtil.getBoolean((DynamicObject)goodsEntry, (String)"ispresent");
            String giftType = DynamicObjectUtil.getString((DynamicObject)goodsEntry, (String)"gifttype");
            if (!isPresent || !StringUtils.equals((CharSequence)giftType, (CharSequence)"2")) continue;
            int promoteSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"promoteseq");
            manualPromSeqGoodsEntryMap.put(promoteSeq, goodsEntry);
        }
    }

    public void getBeforeDeleteRowSeqMap(DynamicObjectCollection goodsEntryEntity, List<Integer> deleteRowIndexLst, Map<Integer, Integer> beforeAfterGoodsSeqMap, Map<Integer, DynamicObject> manualPromSeqGoodsEntryMap, Map<Integer, DynamicObject> promPromSeqGoodsEntryMap) {
        for (DynamicObject goodsEntry : goodsEntryEntity) {
            int seq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"seq");
            int beforeRowIndex = this.getEntityBeforeDeleteIndex(deleteRowIndexLst, seq - 1);
            int beforeGoodsSeq = beforeRowIndex + 1;
            beforeAfterGoodsSeqMap.put(beforeGoodsSeq, seq);
            boolean isPresent = DynamicObjectUtil.getBoolean((DynamicObject)goodsEntry, (String)"ispresent");
            if (!isPresent) continue;
            String giftType = DynamicObjectUtil.getString((DynamicObject)goodsEntry, (String)"gifttype");
            int promoteSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"promoteseq");
            if (StringUtils.equals((CharSequence)giftType, (CharSequence)"2")) {
                manualPromSeqGoodsEntryMap.put(promoteSeq, goodsEntry);
                continue;
            }
            if (!StringUtils.equals((CharSequence)giftType, (CharSequence)"3")) continue;
            promPromSeqGoodsEntryMap.put(beforeGoodsSeq, goodsEntry);
        }
    }

    public void deleteGoodsSeqRelateSendGoodsEntity(DynamicObject dataEntity, DynamicObjectCollection goodsEntryEntity, List<Integer> deleteRowIndexLst, Map<Integer, Integer> beforeAfterGoodsSeqMap, Map<Integer, DynamicObject> manualPromSeqGoodsEntryMap, Map<Integer, DynamicObject> promPromSeqGoodsEntryMap, long billTypeId, boolean notConfirm) {
        if (manualPromSeqGoodsEntryMap != null && manualPromSeqGoodsEntryMap.size() > 0) {
            DynamicObjectCollection goodSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
            for (DynamicObject sendEntry : goodSendEntity) {
                String[] lstSendGoodsSeq;
                int sendSeq;
                DynamicObject goodsEntry;
                String sendGoodsSeq = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"sendgoodsseq");
                if (StringUtils.isEmpty((CharSequence)sendGoodsSeq) || (goodsEntry = manualPromSeqGoodsEntryMap.get(sendSeq = DynamicObjectUtil.getInt((DynamicObject)sendEntry, (String)"seq"))) == null) continue;
                boolean isDeleteAll = true;
                boolean isDeleteGoodsEntry = false;
                for (String goodsSeq : lstSendGoodsSeq = sendGoodsSeq.split(",")) {
                    int goodsSeqIndex = CommonUtil.formatStringToInt((String)goodsSeq) - 1;
                    if (deleteRowIndexLst.contains(goodsSeqIndex)) {
                        String saleOption = DynamicObjectUtil.getString((DynamicObject)goodsEntry, (String)"saleoption");
                        if (!notConfirm && billTypeId == BillTypeEnum.CVTSALE.getId() || billTypeId == BillTypeEnum.RETURN.getId() || StringUtils.equalsIgnoreCase((CharSequence)saleOption, (CharSequence)"0")) continue;
                        isDeleteGoodsEntry = true;
                        continue;
                    }
                    isDeleteAll = false;
                }
                if (!isDeleteAll && !isDeleteGoodsEntry) continue;
                int afterSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"seq");
                this.deleteSendGoodsSeqUpdateMap(beforeAfterGoodsSeqMap, afterSeq);
                manualPromSeqGoodsEntryMap.remove(sendSeq);
                goodsEntryEntity.remove((Object)goodsEntry);
            }
        }
        if (promPromSeqGoodsEntryMap != null && promPromSeqGoodsEntryMap.size() > 0 && (!notConfirm && billTypeId == BillTypeEnum.CVTSALE.getId() || billTypeId == BillTypeEnum.RETURN.getId() || billTypeId == BillTypeEnum.CHANGE.getId())) {
            ArrayList<DynamicObject> deletePromGoodsEntrys = new ArrayList<DynamicObject>();
            for (DynamicObject promGoodsEntry : promPromSeqGoodsEntryMap.values()) {
                String saleOption = DynamicObjectUtil.getString((DynamicObject)promGoodsEntry, (String)"saleoption");
                if (StringUtils.equalsIgnoreCase((CharSequence)saleOption, (CharSequence)"1")) continue;
                deletePromGoodsEntrys.add(promGoodsEntry);
            }
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderPromote;
                boolean isPresent = goodsEntry.getBoolean("ispresent");
                if (isPresent || CollectionUtils.isEmpty((Collection)(salesOrderPromote = goodsEntry.getDynamicObjectCollection("salesorderpromote")))) continue;
                for (DynamicObject promoteEntry : salesOrderPromote) {
                    boolean isDeleteAll = true;
                    int promoteGoodsSeq = DynamicObjectUtils.getInt((DynamicObject)promoteEntry, (String)"promotegoodsseq");
                    DynamicObject promGoodsEntry = promPromSeqGoodsEntryMap.get(promoteGoodsSeq);
                    if (promGoodsEntry != null) {
                        String[] lstExeGoodsSeq;
                        String exeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)promoteEntry, (String)"exegoodsseq");
                        for (String goodsSeq : lstExeGoodsSeq = exeGoodsSeq.split(",")) {
                            int goodsSeqIndex = CommonUtil.formatStringToInt((String)goodsSeq) - 1;
                            if (deleteRowIndexLst.contains(goodsSeqIndex)) continue;
                            isDeleteAll = false;
                            break;
                        }
                        if (!isDeleteAll) {
                            deletePromGoodsEntrys.remove(promGoodsEntry);
                        }
                    }
                    if (!isDeleteAll || promoteGoodsSeq <= 0) continue;
                    promPromSeqGoodsEntryMap.remove(promoteGoodsSeq);
                }
            }
            if (!CollectionUtils.isEmpty(deletePromGoodsEntrys)) {
                goodsEntryEntity.removeAll(deletePromGoodsEntrys);
                for (DynamicObject deletePromGoodsEntry : deletePromGoodsEntrys) {
                    int afterSeq = DynamicObjectUtil.getInt((DynamicObject)deletePromGoodsEntry, (String)"seq");
                    this.deleteSendGoodsSeqUpdateMap(beforeAfterGoodsSeqMap, afterSeq);
                }
            }
        }
    }

    public void deleteSendGoodsSeqUpdateMap(Map<Integer, Integer> beforeAfterGoodsSeqMap, int deleteAfterSeq) {
        ArrayList<Integer> deleteKeys = new ArrayList<Integer>();
        for (Map.Entry<Integer, Integer> entry : beforeAfterGoodsSeqMap.entrySet()) {
            int beforeSeq = entry.getKey();
            int afterSeq = entry.getValue();
            if (afterSeq == deleteAfterSeq) {
                deleteKeys.add(beforeSeq);
                continue;
            }
            if (afterSeq <= deleteAfterSeq) continue;
            beforeAfterGoodsSeqMap.put(beforeSeq, afterSeq - 1);
        }
        if (deleteKeys.size() > 0) {
            for (Integer deleteKey : deleteKeys) {
                beforeAfterGoodsSeqMap.remove(deleteKey);
            }
        }
    }

    public void updateEntityGoodsSeq(DynamicObject dataEntity, DynamicObjectCollection goodsEntryEntity, Map<Integer, Integer> beforeAfterGoodsSeqMap, Map<Integer, DynamicObject> manualPromSeqGoodsEntryMap, Map<Integer, DynamicObject> promPromSeqGoodsEntryMap, long billTypeId, boolean notConfirm) {
        DynamicObjectCollection sendintegralentity;
        Integer newSeq;
        DynamicObjectCollection ticketsendentity;
        Integer newSeq2;
        if (!notConfirm && billTypeId == BillTypeEnum.CVTSALE.getId() || billTypeId == BillTypeEnum.RETURN.getId() || billTypeId == BillTypeEnum.CHANGE.getId()) {
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                Iterator salesOrderPromote;
                boolean isPresent = goodsEntry.getBoolean("ispresent");
                String saleOption = DynamicObjectUtil.getString((DynamicObject)goodsEntry, (String)"saleoption");
                if (isPresent || billTypeId == BillTypeEnum.CHANGE.getId() && StringUtils.equalsIgnoreCase((CharSequence)saleOption, (CharSequence)"1") || CollectionUtils.isEmpty((Collection)((Object)(salesOrderPromote = goodsEntry.getDynamicObjectCollection("salesorderpromote"))))) continue;
                Iterator iterator = salesOrderPromote.iterator();
                while (iterator.hasNext()) {
                    String[] lstExeGoodsSeq;
                    DynamicObject promoteEntry = (DynamicObject)iterator.next();
                    StringBuilder seqSb = new StringBuilder();
                    int promoteGoodsSeq = DynamicObjectUtils.getInt((DynamicObject)promoteEntry, (String)"promotegoodsseq");
                    String exeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)promoteEntry, (String)"exegoodsseq");
                    for (String goodsSeq : lstExeGoodsSeq = exeGoodsSeq.split(",")) {
                        Integer newSeq3 = beforeAfterGoodsSeqMap.get(CommonUtil.formatStringToInt((String)goodsSeq));
                        if (newSeq3 == null) continue;
                        seqSb.append(newSeq3).append(',');
                    }
                    if (seqSb.length() > 0) {
                        promoteEntry.set("exegoodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
                        promoteEntry.set("promotegoodsseq", (Object)beforeAfterGoodsSeqMap.getOrDefault(promoteGoodsSeq, 0));
                        continue;
                    }
                    promoteEntry.set("exegoodsseq", (Object)"");
                    promoteEntry.set("promotegoodsseq", (Object)0);
                }
            }
        }
        int promoteSeq = 1;
        boolean isDeleteSendEntry = true;
        DynamicObjectCollection goodSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
        if (!CollectionUtils.isEmpty((Collection)goodSendEntity)) {
            ArrayList<Object> deleteSendEntity = new ArrayList<Object>();
            for (Object sendEntry : goodSendEntity) {
                isDeleteSendEntry = true;
                int seq = DynamicObjectUtil.getInt((DynamicObject)sendEntry, (String)"seq");
                String giftSaleOption = DynamicObjectUtil.getString((DynamicObject)sendEntry, (String)"giftsaleoption");
                if (!notConfirm && billTypeId == BillTypeEnum.CVTSALE.getId() || billTypeId == BillTypeEnum.RETURN.getId() || StringUtils.equalsIgnoreCase((CharSequence)giftSaleOption, (CharSequence)"0")) {
                    isDeleteSendEntry = false;
                }
                DynamicObject goodsEntry = manualPromSeqGoodsEntryMap.get(seq);
                if (isDeleteSendEntry && goodsEntry == null) {
                    deleteSendEntity.add(sendEntry);
                    continue;
                }
                boolean isDeleteChangeSeq = false;
                StringBuilder seqSb = new StringBuilder();
                String sendGoodsSeq = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"sendgoodsseq");
                if (StringUtils.isNotEmpty((CharSequence)sendGoodsSeq)) {
                    String[] lstSendGoodsSeq;
                    for (String goodsSeq : lstSendGoodsSeq = sendGoodsSeq.split(",")) {
                        newSeq2 = beforeAfterGoodsSeqMap.get(CommonUtil.formatStringToInt((String)goodsSeq));
                        if (newSeq2 != null) {
                            seqSb.append(newSeq2).append(',');
                            continue;
                        }
                        if (!isDeleteSendEntry) continue;
                        isDeleteChangeSeq = true;
                    }
                    if (seqSb.length() > 0) {
                        sendEntry.set("sendgoodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
                    } else {
                        sendEntry.set("sendgoodsseq", (Object)"");
                    }
                }
                if (isDeleteChangeSeq) {
                    deleteSendEntity.add(sendEntry);
                    continue;
                }
                if (goodsEntry != null) {
                    goodsEntry.set("promoteseq", (Object)promoteSeq);
                }
                ++promoteSeq;
            }
            if (!CollectionUtils.isEmpty(deleteSendEntity)) {
                goodSendEntity.removeAll(deleteSendEntity);
            }
            this.getView().updateView("goodsendentity");
        }
        if (!CollectionUtils.isEmpty((Collection)(ticketsendentity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity")))) {
            isDeleteSendEntry = true;
            ArrayList<DynamicObject> deleteTicketSendEntity = new ArrayList<DynamicObject>();
            for (DynamicObject sendEntry : ticketsendentity) {
                String[] lstSendGoodsSeq;
                isDeleteSendEntry = true;
                String ticketSaleOption = DynamicObjectUtil.getString((DynamicObject)sendEntry, (String)"ticketsaleoption");
                if (!notConfirm && billTypeId == BillTypeEnum.CVTSALE.getId() || billTypeId == BillTypeEnum.RETURN.getId() || StringUtils.equalsIgnoreCase((CharSequence)ticketSaleOption, (CharSequence)"0")) {
                    isDeleteSendEntry = false;
                }
                StringBuilder seqSb = new StringBuilder();
                String sendGoodsSeq = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"goodsseq");
                if (!StringUtils.isNotEmpty((CharSequence)sendGoodsSeq)) continue;
                boolean isDeleteChangeSeq = false;
                for (String goodsSeq : lstSendGoodsSeq = sendGoodsSeq.split(",")) {
                    newSeq = beforeAfterGoodsSeqMap.get(CommonUtil.formatStringToInt((String)goodsSeq));
                    if (newSeq != null) {
                        seqSb.append(newSeq).append(',');
                        continue;
                    }
                    if (!isDeleteSendEntry) continue;
                    isDeleteChangeSeq = true;
                }
                if (seqSb.length() > 0) {
                    sendEntry.set("goodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
                } else {
                    sendEntry.set("goodsseq", (Object)"");
                }
                if (!isDeleteChangeSeq) continue;
                deleteTicketSendEntity.add(sendEntry);
            }
            if (!CollectionUtils.isEmpty(deleteTicketSendEntity)) {
                ticketsendentity.removeAll(deleteTicketSendEntity);
            }
            this.getView().updateView("ticketsendentity");
        }
        if (!CollectionUtils.isEmpty((Collection)(sendintegralentity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity")))) {
            isDeleteSendEntry = true;
            ArrayList<DynamicObject> deleteIntegralSendEntity = new ArrayList<DynamicObject>();
            for (DynamicObject sendEntry : sendintegralentity) {
                String[] lstSendGoodsSeq;
                isDeleteSendEntry = true;
                String pointSaleOption = DynamicObjectUtil.getString((DynamicObject)sendEntry, (String)"pointsaleoption");
                if (!notConfirm && billTypeId == BillTypeEnum.CVTSALE.getId() || billTypeId == BillTypeEnum.RETURN.getId() || StringUtils.equalsIgnoreCase((CharSequence)pointSaleOption, (CharSequence)"0")) {
                    isDeleteSendEntry = false;
                }
                StringBuilder seqSb = new StringBuilder();
                String sendGoodsSeq = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"insgoodsseq");
                if (!StringUtils.isNotEmpty((CharSequence)sendGoodsSeq)) continue;
                boolean isDeleteChangeSeq = false;
                for (String goodsSeq : lstSendGoodsSeq = sendGoodsSeq.split(",")) {
                    newSeq2 = beforeAfterGoodsSeqMap.get(CommonUtil.formatStringToInt((String)goodsSeq));
                    if (newSeq2 != null) {
                        seqSb.append(newSeq2).append(',');
                        continue;
                    }
                    if (!isDeleteSendEntry) continue;
                    isDeleteChangeSeq = true;
                }
                if (seqSb.length() > 0) {
                    sendEntry.set("insgoodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
                } else {
                    sendEntry.set("insgoodsseq", (Object)"");
                }
                if (!isDeleteChangeSeq) continue;
                deleteIntegralSendEntity.add(sendEntry);
            }
            if (!CollectionUtils.isEmpty(deleteIntegralSendEntity)) {
                sendintegralentity.removeAll(deleteIntegralSendEntity);
            }
            this.getView().updateView("sendintegralentity");
        }
        ArrayList<DynamicObject> deleteUseTicketEntity = new ArrayList<DynamicObject>();
        DynamicObjectCollection useTicketEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"useticketentity");
        if (!CollectionUtils.isEmpty((Collection)useTicketEntity)) {
            for (DynamicObject sendEntry : useTicketEntity) {
                StringBuilder seqSb = new StringBuilder();
                String sendGoodsSeq = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"utgoodsseq");
                if (StringUtils.isNotEmpty((CharSequence)sendGoodsSeq)) {
                    String[] lstSendGoodsSeq;
                    for (String goodsSeq : lstSendGoodsSeq = sendGoodsSeq.split(",")) {
                        newSeq = beforeAfterGoodsSeqMap.get(CommonUtil.formatStringToInt((String)goodsSeq));
                        if (newSeq == null) {
                            seqSb.setLength(0);
                            break;
                        }
                        seqSb.append(newSeq).append(',');
                    }
                }
                if (seqSb.length() > 0) {
                    sendEntry.set("utgoodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
                    continue;
                }
                deleteUseTicketEntity.add(sendEntry);
            }
            if (!CollectionUtils.isEmpty(deleteUseTicketEntity)) {
                useTicketEntity.removeAll(deleteUseTicketEntity);
            }
            this.getView().updateView("useticketentity");
        }
    }

    private int getEntityBeforeDeleteIndex(List<Integer> deleteBeforeRowIndexLst, int currentIndex) {
        int beforeRowIndex = -1;
        int loopRowIndex = -1;
        do {
            if (deleteBeforeRowIndexLst.contains(++beforeRowIndex)) continue;
            ++loopRowIndex;
        } while (currentIndex > loopRowIndex);
        return beforeRowIndex;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key = messageBoxClosedEvent.getCallBackId();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection goodsList = dataEntity.getDynamicObjectCollection("goodsentryentity");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("goodsentryentity");
        if ((long)entryCurrentRowIndex < 0L) {
            return;
        }
        DynamicObject entryItem = (DynamicObject)goodsList.get(entryCurrentRowIndex);
        switch (key) {
            case "finalPaymentChange": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.updateAmt(dataEntity, entryItem, "finalpayment", entryItem.getBigDecimal("finalpayment"));
                    this.getView().updateView("goodsentryentity");
                    CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
                } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                    String oldChangeValue = this.getPageCache().get("PageCache_finalpayment");
                    entryItem.set("finalpayment", (Object)CommonUtil.formatObjectToDecimal((Object)oldChangeValue));
                    this.getView().updateView("goodsentryentity");
                }
                this.getPageCache().remove("PageCache_finalpayment");
                break;
            }
            case "finalPaymentScaleChange": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.updateAmt(dataEntity, entryItem, "finalpaymentscale", entryItem.getBigDecimal("finalpaymentscale"));
                    this.getView().updateView("goodsentryentity");
                    CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
                } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                    String oldChangeValue = this.getPageCache().get("PageCache_finalpaymentscale");
                    entryItem.set("finalpaymentscale", (Object)CommonUtil.formatObjectToDecimal((Object)oldChangeValue));
                    this.getView().updateView("goodsentryentity");
                }
                this.getPageCache().remove("PageCache_finalpaymentscale");
                break;
            }
            case "depositChange": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.updateAmt(dataEntity, entryItem, "deposit", entryItem.getBigDecimal("deposit"));
                    this.getView().updateView("goodsentryentity");
                    CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
                } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                    String oldChangeValue = this.getPageCache().get("PageCache_deposit");
                    entryItem.set("deposit", (Object)CommonUtil.formatObjectToDecimal((Object)oldChangeValue));
                    this.getView().updateView("goodsentryentity");
                }
                this.getPageCache().remove("PageCache_deposit");
                break;
            }
            case "depositScaleChange": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.updateAmt(dataEntity, entryItem, "depositscale", entryItem.getBigDecimal("depositscale"));
                    this.getView().updateView("goodsentryentity");
                    CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
                } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                    String oldChangeValue = this.getPageCache().get("PageCache_depositscale");
                    entryItem.set("depositscale", (Object)CommonUtil.formatObjectToDecimal((Object)oldChangeValue));
                    this.getView().updateView("goodsentryentity");
                }
                this.getPageCache().remove("PageCache_depositscale");
                break;
            }
        }
    }

    private void beforeDepositFieldPostBack(BeforeFieldPostBackEvent e, String fieldKey) {
        int index = e.getRowIndex();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("goodsentryentity", index);
        BigDecimal fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue());
        String tip = SaleAmountHelper.depositChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)entryEntity, (String)fieldKey, (BigDecimal)fieldValue);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView(fieldKey, index);
            e.setCancel(true);
        }
    }

    private void beforeDepositScaleFieldPostBack(BeforeFieldPostBackEvent e, String fieldKey) {
        int index = e.getRowIndex();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("goodsentryentity", index);
        BigDecimal fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue());
        String tip = SaleAmountHelper.depositScaleChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)entryEntity, (String)fieldKey, (BigDecimal)fieldValue);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView(fieldKey, index);
            e.setCancel(true);
        }
    }

    private void beforeManualDiscountFieldPostBack(BeforeFieldPostBackEvent e, String fieldKey) {
        BigDecimal fieldValue;
        DynamicObject entryEntity;
        int index = e.getRowIndex();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String tip = SaleAmountHelper.manualDiscountChanged((DynamicObject)dataEntity, (DynamicObject)(entryEntity = this.getModel().getEntryRowEntity("goodsentryentity", index)), (String)fieldKey, (BigDecimal)(fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue())));
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView(fieldKey, index);
            e.setCancel(true);
        }
        if (!StringUtils.isBlank((CharSequence)(tip = SaleAmountHelper.depositChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)entryEntity, (String)fieldKey, (BigDecimal)fieldValue)))) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView(fieldKey, index);
            e.setCancel(true);
        }
    }

    private void beforeFinalPaymentScaleFieldPostBack(BeforeFieldPostBackEvent e, String fieldKey) {
        int index = e.getRowIndex();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("goodsentryentity", index);
        BigDecimal fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue());
        String tip = SaleAmountHelper.finalPaymentScaleChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)entryEntity, (String)fieldKey, (BigDecimal)fieldValue);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView(fieldKey, index);
            e.setCancel(true);
        }
    }

    private void beforeFinalPaymentFieldPostBack(BeforeFieldPostBackEvent e, String fieldKey) {
        int index = e.getRowIndex();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("goodsentryentity", index);
        BigDecimal fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue());
        String tip = SaleAmountHelper.finalPaymentChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)entryEntity, (String)fieldKey, (BigDecimal)fieldValue);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView(fieldKey, index);
            e.setCancel(true);
        }
    }

    private void beforeAboutBalAmountFieldPostBack(BeforeFieldPostBackEvent e, String fieldKey) {
        BigDecimal fieldValue;
        int index = e.getRowIndex();
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("goodsentryentity", index);
        String tip = SaleAmountHelper.checkBalAmount((DynamicObject)entryEntity, (String)fieldKey, (BigDecimal)(fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue())));
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView(fieldKey, index);
            e.setCancel(true);
        }
    }

    private void unExecutePromote(DynamicObject dataEntity) {
        DynamicObjectCollection docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"promotionentity");
        if (CollectionUtils.isEmpty((Collection)docPromoteEntry)) {
            return;
        }
        for (int i = 0; i < docPromoteEntry.getRowCount(); ++i) {
            boolean isExecute = DynamicObjectUtils.getBoolean((DynamicObject)((DynamicObject)docPromoteEntry.get(i)), (String)"execute");
            if (!isExecute) continue;
            this.getView().getModel().setValue("execute", (Object)Boolean.FALSE, i);
        }
    }

    private void propertyChanged(ChangeData[] changeSet, String key, DynamicObject dataEntity, DynamicObjectCollection entryEntities) {
        boolean isCalculateAmt = false;
        for (ChangeData changeData : changeSet) {
            if (CommonUtil.checkChanged((ChangeData)changeData)) continue;
            String oldValue = "";
            int rowIndex = changeData.getRowIndex();
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(rowIndex);
            switch (key) {
                case "channelstocktypeid": {
                    this.stockTypeChanged(entryEntity, rowIndex);
                    break;
                }
                case "distributionmode": {
                    this.distributionModeChanged(changeData, rowIndex);
                    break;
                }
                case "goodssaler": {
                    this.goodsSalerChanged(changeData, entryEntity);
                    break;
                }
                case "deliverytime": {
                    this.deliveryTimeChanged(changeSet);
                    break;
                }
                case "unit": {
                    this.unitChanged(changeData, entryEntity);
                    break;
                }
                case "deposit": 
                case "depositscale": 
                case "balamount": 
                case "finalpayment": 
                case "finalpaymentscale": {
                    oldValue = this.getPageCache().get("PageCache_" + key);
                    isCalculateAmt = true;
                    break;
                }
                case "manualdiscount": 
                case "discountrate": 
                case "discountprice": 
                case "retailprice": 
                case "isbook": 
                case "promotiondiscount": 
                case "notincomedisamount": 
                case "stddiscountamount": 
                case "giftdiscountamount": 
                case "ticketshareamount": {
                    isCalculateAmt = true;
                    break;
                }
            }
            if (isCalculateAmt && StringUtils.isBlank((CharSequence)oldValue)) {
                BigDecimal newValue = CommonUtil.formatObjectToDecimal((Object)changeData.getNewValue());
                this.updateAmt(dataEntity, entryEntity, key, newValue);
                continue;
            }
            isCalculateAmt = false;
        }
        this.getView().updateView("goodsentryentity");
        if (isCalculateAmt) {
            SaleOrderAmountHelper.recalculateShareAmount((DynamicObject)dataEntity);
            CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
        }
    }

    private void stockTypeChanged(DynamicObject entryItem, int rowIndex) {
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"goodsid");
        long barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem, (String)"barcode");
        boolean isEnablePricePolicy = this.checkIsEnablePricePolicy();
        CommonUtils.setRetailPrice((IFormView)this.getView(), (DynamicObject)entryItem, (long)goodsId, (long)barCodeId, (int)rowIndex, (boolean)isEnablePricePolicy);
    }

    private void distributionModeChanged(ChangeData changeData, int rowIndex) {
        DynamicObject distributionMode = (DynamicObject)changeData.getNewValue();
        if (distributionMode != null) {
            long oldModeId;
            DynamicObject goods = (DynamicObject)this.getModel().getValue("goodsid", rowIndex);
            DynamicObject oldMode = (DynamicObject)changeData.getOldValue();
            long newModeId = DynamicObjectUtils.getPkValue((DynamicObject)distributionMode);
            if (newModeId != (oldModeId = DynamicObjectUtils.getPkValue((DynamicObject)oldMode))) {
                this.getModel().setValue("erpstockposition", null, rowIndex);
                this.getModel().setValue("stockid", null, rowIndex);
                this.getModel().setValue("stockposition", null, rowIndex);
                this.getModel().setValue("inventoryorg", null, rowIndex);
                this.getModel().setValue("erpstock", null, rowIndex);
            }
            if (newModeId == 926596489101228032L || newModeId == 926601071999218688L) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"stockid"});
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"stockid"});
            }
            if (newModeId == 926601071999218688L || newModeId == 926601157210585088L) {
                this.getModel().setValue("isdelivery", (Object)Boolean.FALSE, rowIndex);
            } else {
                this.getModel().setValue("isdelivery", (Object)Boolean.TRUE, rowIndex);
            }
            this.inventoryMatch(goods, rowIndex);
        }
    }

    private void goodsSalerChanged(ChangeData changeData, DynamicObject entryItem) {
        DynamicObject saler = (DynamicObject)changeData.getNewValue();
        if (saler != null) {
            Object dpt = CommonUtils.getDeptObj((DynamicObject)saler);
            entryItem.set("saledepartment", dpt);
        }
    }

    private void deliveryTimeChanged(ChangeData[] changeSet) {
        DynamicObjectCollection entryData = this.getModel().getDataEntity(true).getDynamicObjectCollection("goodsentryentity");
        for (ChangeData changeData : changeSet) {
            int rowIndex;
            DynamicObject entryItem;
            DynamicObjectCollection deliveryEntityList;
            if (CommonUtil.checkChanged((ChangeData)changeData) || ObjectUtils.isEmpty((Object)(deliveryEntityList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)(entryItem = (DynamicObject)entryData.get(rowIndex = changeData.getRowIndex())), (String)"salesorderdelivery")))) continue;
            for (DynamicObject delivery : deliveryEntityList) {
                delivery.set("deliverdeliverytime", changeData.getNewValue());
            }
            this.getView().updateView("salesorderdelivery");
        }
    }

    private void unitChanged(ChangeData changeData, DynamicObject entryItem) {
        DynamicObject unit = (DynamicObject)changeData.getNewValue();
        if (unit != null) {
            BigDecimal baseUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"baseunitqty");
            if (baseUnitQty.compareTo(BigDecimal.ZERO) != 0) {
                UnitTransferUtils.updateMultiQuantities((IFormView)this.getView(), (DynamicObject)entryItem, (DynamicObject)unit);
            } else {
                BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"saleqty");
                if (saleQty.compareTo(BigDecimal.ZERO) != 0) {
                    UnitTransferUtils.updateMultiQuantities((IFormView)this.getView(), (DynamicObject)entryItem, (BigDecimal)saleQty);
                }
            }
        }
    }

    private void inventoryMatch(DynamicObject goods, int rowIndex) {
        boolean checkSuccess = this.inventoryCheck(rowIndex);
        if (checkSuccess) {
            return;
        }
        SaleOrderInventoryHelper.saleOrderInventoryAvaiable((IFormView)this.getView(), (DynamicObject)goods, (int)rowIndex);
    }

    private void updateAmt(DynamicObject dataEntity, DynamicObject entryEntity, String key, BigDecimal value) {
        boolean isChangeReturnOrReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)entryEntity);
        if (isChangeReturnOrReturn) {
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            SaleAmountHelper.updateReturnAmountFields((DynamicObject)dataEntity, (DynamicObject)entryEntity, (long)billTypeId, (String)key, (BigDecimal)value);
        } else {
            SaleAmountHelper.updateSaleAmountFields((DynamicObject)dataEntity, (DynamicObject)entryEntity, (String)key, (BigDecimal)value);
        }
    }

    private boolean inventoryCheck(int index) {
        DynamicObject branch = (DynamicObject)this.getModel().getValue("salebranchid");
        boolean isBook = (Boolean)this.getModel().getValue("isbook", index);
        if (branch == null || isBook) {
            return false;
        }
        return CommonUtils.checkOrderType((IDataModel)this.getModel());
    }

    private boolean checkIsEnablePricePolicy() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        return CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getSystemParamValue((long)bizOrgId, (long)branchId, (String)"isenblepricepolicy"));
    }
}

