/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit.items;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.promotion.SaleorderPromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.business.saleorder.SnServiceHelper;
import kd.occ.ocpos.common.entity.request.CxRequestEntity;
import kd.occ.ocpos.common.entity.request.CxResultEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.saleorder.UnitTransferUtils;
import kd.occ.ocpos.common.util.CommonUtil;

public class SalesOrderItemsEdit
extends AbstractBillPlugIn {
    private static final String KEY_ACTION_ID = "itemsInfoEdit";
    private static final String KEY_FORM_ID = "ocpos_itemsinfoedit";
    private static final String ADV_MAIN = "advcontoolbarap";
    protected static final String ADV_MODIFY = "adv_modify";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{ADV_MAIN});
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        DecimalEdit decimalEdit;
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (source instanceof DecimalEdit && StringUtils.equals((CharSequence)(decimalEdit = (DecimalEdit)source).getKey(), (CharSequence)"saleqty")) {
            int index = e.getRowIndex();
            Object value = e.getValue();
            if (value == null) {
                NotificationUtil.showDefaultTipNotify((String)"\u9500\u552e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (IFormView)this.getView());
                this.getView().updateView("saleqty", index);
                e.setCancel(true);
                return;
            }
            BigDecimal saleQty = CommonUtil.formatObjectToDecimal((Object)e.getValue());
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
            if (!CollectionUtils.isEmpty((Collection)entryEntities)) {
                DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
                String tip = this.checkSaleQty(entryEntity, dataEntity, saleQty);
                if (!StringUtils.isBlank((CharSequence)tip)) {
                    NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
                    this.getView().updateView("saleqty", index);
                    e.setCancel(true);
                }
                this.updateInventoryData(e, dataEntity, entryEntity, saleQty, index);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int index = changeData.getRowIndex();
        DynamicObject entryEntity = changeData.getDataEntity();
        DynamicObject dataEntity = (DynamicObject)entryEntity.getParent();
        switch (key = e.getProperty().getName()) {
            case "itemsale": {
                DynamicObject saleContent;
                DynamicObject goods;
                this.clearEntryValue(index);
                DynamicObject oldGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodsid");
                if (oldGoods != null) {
                    this.getView().getPageCache().put("goodsid" + this.getView().getPageId(), DynamicObjectUtils.getString((DynamicObject)oldGoods, (String)"id"));
                }
                if ((goods = DynamicObjectUtils.getDynamicObject((DynamicObject)(saleContent = (DynamicObject)newValue), (String)"itemid")) == null) {
                    if (StringUtils.equals((CharSequence)this.getView().getEntityId(), (CharSequence)"ocpos_saleorder")) {
                        String seq = Integer.toString(index + 1);
                        this.deleteGoodsUnionSendEntry(dataEntity, entryEntity, seq);
                    }
                    return;
                }
                entryEntity.set("goodsid", (Object)goods);
                DynamicObject barCode = DynamicObjectUtils.getDynamicObject((DynamicObject)saleContent, (String)"barcodeid");
                entryEntity.set("barcode", (Object)barCode);
                entryEntity.set("saleqty", (Object)BigDecimal.ONE);
                entryEntity.set("retailprice", (Object)BigDecimal.ZERO);
                entryEntity.set("discountprice", (Object)BigDecimal.ZERO);
                this.showItemsInfoInput(this.buildCustomParamsAboutOther(entryEntity, dataEntity, index));
                entryEntity.set("goodsid", null);
                entryEntity.set("barcode", null);
                break;
            }
            case "goodsid": {
                this.goodsIdChanged(dataEntity, entryEntity, oldValue, newValue, index);
                break;
            }
            case "barcode": {
                this.barCodeChanged(dataEntity, entryEntity, newValue, index);
                break;
            }
            case "saleqty": {
                BigDecimal saleQty = CommonUtil.formatObjectToDecimal((Object)newValue);
                this.updateAmt(dataEntity, entryEntity, saleQty, index);
                DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodsid");
                DynamicObject barCode = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"barcode");
                if (ObjectUtils.isEmpty((Object)goods) || ObjectUtils.isEmpty((Object)barCode)) break;
                this.showItemsInfoInput(this.buildCustomParamsAboutOther(entryEntity, dataEntity, index));
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        if (StringUtils.equals((CharSequence)e.getItemKey(), (CharSequence)ADV_MODIFY)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u5546\u54c1\u660e\u7ec6\u3002", (IFormView)this.getView());
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("goodsentryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (IFormView)this.getView());
                return;
            }
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(selectRows[0]);
            DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodsid");
            if (goods == null) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u5546\u54c1\u3002", (IFormView)this.getView());
                return;
            }
            this.getView().getPageCache().put("goodsid" + this.getView().getPageId(), DynamicObjectUtils.getString((DynamicObject)goods, (String)"id"));
            String giftType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"gifttype");
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
            if (isPresent) {
                boolean isChangeNewGift;
                if (!StringUtils.equals((CharSequence)giftType, (CharSequence)"2") && !StringUtils.equals((CharSequence)giftType, (CharSequence)"3")) {
                    NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5546\u54c1\u4e3a\u8d60\u54c1\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (IFormView)this.getView());
                    return;
                }
                long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
                if (billTypeId == BillTypeEnum.CHANGE.getId() && (isChangeNewGift = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ischangenewgift"))) {
                    NotificationUtil.showDefaultTipNotify((String)"\u540c\u578b\u53f7\u6362\u8d27\u53ca\u8865\u5dee\u6362\u8d27\u8d60\u54c1\u9500\u552e\u884c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (IFormView)this.getView());
                    return;
                }
            }
            this.showItemsInfoInput(this.buildCustomParamsAboutOther(entryEntity, dataEntity, selectRows[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)KEY_ACTION_ID)) {
            Object returnData = e.getReturnData();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
            if (ObjectUtils.isEmpty((Object)returnData)) {
                this.getView().updateView("goodsentryentity");
                return;
            }
            if (returnData instanceof Map) {
                boolean isNotConfirm = false;
                if (StringUtils.equals((CharSequence)"ocpos_saleorder", (CharSequence)dataEntity.getDataEntityType().getName())) {
                    isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
                }
                long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
                Map returnMap = (Map)returnData;
                String status = CommonUtil.formatStringToEmpty(returnMap.get("status"));
                int index = CommonUtil.formatObjectToInt(returnMap.get("index"));
                if (StringUtils.equals((CharSequence)status, (CharSequence)"SUCCESS")) {
                    DynamicObject currentGood = (DynamicObject)entryEntities.get(index);
                    this.addNewEntryRow(entryEntities, index, returnMap);
                    boolean isCheckMatchPromotion = this.checkBillTypeMatchPromotion(returnMap, billTypeId, isNotConfirm);
                    if (isCheckMatchPromotion) {
                        if (currentGood != null && !currentGood.getBoolean("ispresent")) {
                            this.checkExecutePlan(dataEntity);
                            this.matchItemPromotion(this.getView(), entryEntities, index, isNotConfirm);
                        }
                        if (billTypeId == BillTypeEnum.RETAIL.getId() || billTypeId == BillTypeEnum.STORE.getId() || billTypeId == BillTypeEnum.RESERVE.getId()) {
                            this.addBlankRow(dataEntity, entryEntities, returnMap);
                        }
                        CommonUtils.setSaleQtyEnable((IFormView)this.getView(), (DynamicObjectCollection)entryEntities);
                    }
                    if (StringUtils.equals((CharSequence)this.getView().getEntityId(), (CharSequence)"ocpos_saleorder")) {
                        String seq = Integer.toString(index + 1);
                        this.deleteGoodsUnionSendEntry(dataEntity, currentGood, seq);
                    }
                    this.recalculateSumDiscountAmount(currentGood);
                } else if (billTypeId == BillTypeEnum.RETAIL.getId() || billTypeId == BillTypeEnum.STORE.getId() || billTypeId == BillTypeEnum.RESERVE.getId()) {
                    this.getModel().insertEntryRow("goodsentryentity", index);
                    this.getModel().deleteEntryRow("goodsentryentity", index + 1);
                } else {
                    this.getModel().deleteEntryRow("goodsentryentity", index);
                }
                if (billTypeId != BillTypeEnum.RETURN.getId()) {
                    SaleOrderAmountHelper.recalculateShareAmount((DynamicObject)dataEntity);
                }
                this.getView().updateView("goodsentryentity");
                CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
            }
            this.getView().getPageCache().remove("goodsid" + this.getView().getPageId());
        }
    }

    private void showItemsInfoInput(Map<String, Object> customParams) {
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)KEY_FORM_ID, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        List<Long> lockSnMainFileIds = this.getLockSnMainFileIds();
        if (!CollectionUtils.isEmpty(lockSnMainFileIds)) {
            parameter.setCustomParam("locksnmainfiles", lockSnMainFileIds);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ACTION_ID));
        this.getView().showForm(parameter);
    }

    private void recalculateSumDiscountAmount(DynamicObject currentGood) {
        if (currentGood == null) {
            return;
        }
        BigDecimal manualdiscount = currentGood.getBigDecimal("manualdiscount");
        BigDecimal promotiondiscount = currentGood.getBigDecimal("promotiondiscount");
        BigDecimal coupondiscount = currentGood.getBigDecimal("coupondiscount");
        BigDecimal integraldistamount = currentGood.getBigDecimal("integraldistamount");
        BigDecimal giftdiscountamount = currentGood.getBigDecimal("giftdiscountamount");
        BigDecimal stddiscountamount = currentGood.getBigDecimal("stddiscountamount");
        BigDecimal notincomedisamount = currentGood.getBigDecimal("notincomedisamount");
        BigDecimal sumsharediscount = manualdiscount.add(promotiondiscount).add(coupondiscount).add(integraldistamount).add(giftdiscountamount);
        BigDecimal sumdiscountamount = stddiscountamount.add(notincomedisamount).add(promotiondiscount);
        currentGood.set("sumsharediscount", (Object)sumsharediscount);
        currentGood.set("sumdiscountamount", (Object)sumdiscountamount);
    }

    private void deleteGoodsUnionSendEntry(DynamicObject dataEntity, DynamicObject doGoodsEntry, String seq) {
        DynamicObjectCollection docIntegralSendEntry;
        long oldGoodsId;
        long newGoodsId = DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsid");
        if (newGoodsId == (oldGoodsId = CommonUtil.formatObejctToLong((Object)this.getView().getPageCache().get("goodsid" + this.getView().getPageId()))) || oldGoodsId == 0L) {
            return;
        }
        DynamicObjectCollection docTicketSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity");
        if (!CollectionUtils.isEmpty((Collection)docTicketSendEntry)) {
            docTicketSendEntry.removeIf(x -> Arrays.asList(DynamicObjectUtils.getString((DynamicObject)x, (String)"goodsseq").split(",")).contains(seq));
            this.getView().updateView("ticketsendentity");
        }
        if (!CollectionUtils.isEmpty((Collection)(docIntegralSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity")))) {
            docIntegralSendEntry.removeIf(x -> Arrays.asList(DynamicObjectUtils.getString((DynamicObject)x, (String)"insgoodsseq").split(",")).contains(seq));
            this.getView().updateView("sendintegralentity");
        }
    }

    private void matchItemPromotion(IFormView view, DynamicObjectCollection entry, int index, Boolean isNotConfirm) {
        String bizType = view.getModel().getValue("biztype").toString();
        if (!StringUtils.equals((CharSequence)"ocpos_saleorder", (CharSequence)view.getEntityId()) || StringUtils.equals((CharSequence)"C", (CharSequence)bizType) && !isNotConfirm.booleanValue()) {
            return;
        }
        try {
            ArrayList memberLabelIdList = new ArrayList();
            String memberlevelid = null;
            DynamicObject bizOrg = (DynamicObject)view.getModel().getValue("bizorgid");
            String bizOrgId = DynamicObjectUtils.getString((DynamicObject)bizOrg, (String)"id");
            DynamicObject branch = (DynamicObject)view.getModel().getValue("salebranchid");
            String branchId = DynamicObjectUtils.getString((DynamicObject)branch, (String)"id");
            DynamicObject member = (DynamicObject)view.getModel().getValue("member");
            String memberId = DynamicObjectUtils.getString((DynamicObject)member, (String)"id");
            if (member != null && member.getDynamicObject("viplevelid") != null) {
                memberlevelid = member.getDynamicObject("viplevelid").getString("id");
            }
            String billDate = CommonUtil.format((Date)TimeServiceHelper.now(), (String)TimeServiceHelper.getDateTimeFormatString());
            CxRequestEntity req = new CxRequestEntity(bizOrgId, branchId, memberId, memberLabelIdList, memberlevelid, billDate, null, null);
            this.buildMaterialEntry(view.getModel(), entry, req, index);
            if (req.getMaterialEntries() == null) {
                return;
            }
            CxResultEntity result = SaleorderPromotionHelper.matchPromotion((CxRequestEntity)req);
            if (result.getResMultiPromotion().size() > 0) {
                SaleorderPromotionHelper.setPromotionInfo((IFormView)view, (List)result.getResMultiPromotion());
            }
            if (result.getUnMatchPlan().size() > 0) {
                SaleorderPromotionHelper.clearUnMatchPromotion((IFormView)view, (List)result.getUnMatchPlan());
            }
        }
        catch (KDBizException e) {
            e.printStackTrace();
        }
    }

    private void buildMaterialEntry(IDataModel model, DynamicObjectCollection entry, CxRequestEntity req, int rowIndex) {
        ArrayList<MaterialEntryEntity> materialEntryEntityList = new ArrayList<MaterialEntryEntity>();
        for (int index = 0; index < entry.size(); ++index) {
            DynamicObject goods;
            DynamicObject entryItem = (DynamicObject)entry.get(index);
            boolean isPresent = entryItem.getBoolean("ispresent");
            if (isPresent || (goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"goodsid")) == null) continue;
            DynamicObject unit = (DynamicObject)model.getValue("unit", index);
            String unitId = DynamicObjectUtils.getString((DynamicObject)unit, (String)"id");
            DynamicObject auxattr = (DynamicObject)model.getValue("auxattrid", index);
            String auxattrid = DynamicObjectUtils.getString((DynamicObject)auxattr, (String)"id");
            BigDecimal retailPrice = entryItem.getBigDecimal("discountprice");
            BigDecimal saleQty = entryItem.getBigDecimal("saleqty");
            List classIds = ItemClassUtil.queryClassList((Object)goods.getPkValue());
            DynamicObject goodsBrand = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"brand");
            String brand = goodsBrand != null ? goodsBrand.getString("id") : "";
            DynamicObject goodSaleAttr = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"saleattr");
            long saleAttr = goodSaleAttr != null ? goodSaleAttr.getLong("id") : 0L;
            BigDecimal stdDiscountAmount = entryItem.getBigDecimal("stddiscountamount");
            BigDecimal notinComeDisAmount = entryItem.getBigDecimal("notincomedisamount");
            boolean isChangePrice = stdDiscountAmount.compareTo(BigDecimal.ZERO) != 0 || notinComeDisAmount.compareTo(BigDecimal.ZERO) != 0;
            long inventoryType = 0L;
            if (DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryItem, (String)"salesorderdelivery").size() > 0) {
                DynamicObject deliveryEntry = (DynamicObject)DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryItem, (String)"salesorderdelivery").get(0);
                DynamicObject goodInventoryType = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntry, (String)"deliverystocktype");
                inventoryType = goodInventoryType != null ? goodInventoryType.getLong("id") : 0L;
            }
            MaterialEntryEntity entryEntity = new MaterialEntryEntity(index, goods.getString("id"), goods.getString("name"), unitId, auxattrid, retailPrice, saleQty, brand, classIds.stream().map(CommonUtil::formatStringToEmpty).collect(Collectors.toList()), Long.valueOf(saleAttr), Long.valueOf(inventoryType), isChangePrice);
            materialEntryEntityList.add(entryEntity);
            if (index != rowIndex) continue;
            req.setMatchMaterial(entryEntity);
        }
        req.setMaterialEntries(materialEntryEntityList);
    }

    private void addNewEntryRow(DynamicObjectCollection entryEntity, int index, Map<String, Object> returnMap) {
        DynamicObject entryRow = CollectionUtils.isEmpty((Collection)entryEntity) ? entryEntity.addNew() : (DynamicObject)entryEntity.get(index);
        DynamicObject data = (DynamicObject)returnMap.get("data");
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String key = property.getName();
            if (!DynamicObjectUtils.contain((DynamicObject)data, (String)key)) continue;
            entryRow.set(key, data.get(key));
            if (StringUtils.equals((CharSequence)key, (CharSequence)"saleqty")) {
                entryRow.set("mustretqty", data.get(key));
            }
            if (!StringUtils.equals((CharSequence)key, (CharSequence)"finalpayment")) continue;
            entryRow.set("norecefinalamount", data.get(key));
        }
        Object returnInfo = returnMap.get("deliveryData");
        if (returnInfo instanceof JSONObject) {
            SaleOrderDeliveryInfoHelper.fillDeliveryDataAllowOverSale((IFormView)this.getView(), (DynamicObject)data, (DynamicObject)entryRow, (Object)returnInfo);
        } else if (returnInfo instanceof List) {
            SaleOrderDeliveryInfoHelper.fillDeliveryDataAboutStock((IFormView)this.getView(), (DynamicObject)data, (DynamicObject)entryRow, (Object)returnInfo);
        } else {
            SaleOrderDeliveryInfoHelper.fillDeliveryData((IFormView)this.getView(), (DynamicObject)data, (DynamicObject)entryRow);
        }
        this.getView().updateView("salesorderdelivery");
        this.getView().updateView("goodsentryentity", index);
    }

    private void checkExecutePlan(DynamicObject dataEntity) {
        DynamicObjectCollection docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"promotionentity");
        if (CollectionUtils.isEmpty((Collection)docPromoteEntry)) {
            return;
        }
        for (int i = 0; i < docPromoteEntry.size(); ++i) {
            boolean isExecute = DynamicObjectUtils.getBoolean((DynamicObject)((DynamicObject)docPromoteEntry.get(i)), (String)"execute");
            if (!isExecute) continue;
            this.getView().getModel().setValue("execute", (Object)Boolean.FALSE, i);
        }
    }

    private void addBlankRow(DynamicObject dataEntity, DynamicObjectCollection entryEntity, Map<String, Object> returnMap) {
        int newIndex;
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        int size = entryEntity.size();
        int lastIndex = size > 0 ? size - 1 : 0;
        DynamicObject lastEntryRow = (DynamicObject)entryEntity.get(lastIndex);
        if (DynamicObjectUtils.getPkValue((DynamicObject)lastEntryRow, (String)"goodsid") != 0L) {
            newIndex = this.getModel().createNewEntryRow("goodsentryentity");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("goodsentryentity");
            entryGrid.getEntryState().setFocusRow(newIndex);
        } else {
            newIndex = lastIndex;
        }
        String opSource = CommonUtil.formatStringToEmpty((Object)returnMap.get("operation"));
        if (StringUtils.equals((CharSequence)opSource, (CharSequence)"saveandnew")) {
            DynamicObject newEntryRow = (DynamicObject)entryEntity.get(newIndex);
            Map<String, Object> customParams = this.buildCustomParamsAboutOther(newEntryRow, dataEntity, newIndex);
            this.showItemsInfoInput(customParams);
        }
    }

    private String checkSaleQty(DynamicObject entryEntity, DynamicObject dataEntity, BigDecimal newValue) {
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        BigDecimal srcMustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"srcmustretqty");
        boolean notConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
        String tip = null;
        if (newValue.compareTo(BigDecimal.ZERO) <= 0) {
            tip = "\u9500\u552e\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002";
        } else if (billTypeId == BillTypeEnum.CVTSALE.getId() && !notConfirm && srcMustRetQty.compareTo(BigDecimal.ZERO) > 0 && newValue.abs().compareTo(srcMustRetQty) > 0) {
            String strMustQty = srcMustRetQty.stripTrailingZeros().toPlainString();
            tip = String.format("\u8f6c\u9500\u6570\u91cf\u5e94\u4e3a\u6b63\u6570, \u4e14\u6700\u591a\u53ef\u8f6c\u9500%s\u3002", strMustQty);
        }
        return tip;
    }

    protected void clearEntryValue(int index) {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("basebilltype");
        boolean isReserve = DynamicObjectUtils.getPkValue((DynamicObject)billType) == BillTypeEnum.RESERVE.getId();
        CommonUtils.clearEntryValue((IFormView)this.getView(), (int)index, (boolean)isReserve, (boolean)false);
    }

    private void updateAmt(DynamicObject dataEntity, DynamicObject entryEntity, BigDecimal saleQty, int index) {
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
            SaleAmountHelper.updateCvtAmountFieldsByQty((DynamicObject)dataEntity, (long)billTypeId, (DynamicObject)entryEntity);
        } else {
            boolean isChangeReturnOrReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)entryEntity);
            if (isChangeReturnOrReturn) {
                SaleAmountHelper.updateReturnAmountFields((DynamicObject)dataEntity, (DynamicObject)dataEntity, (long)billTypeId, (String)"saleqty", (BigDecimal)saleQty);
            } else {
                SaleAmountHelper.updateSaleAmountFields((DynamicObject)dataEntity, (DynamicObject)entryEntity, (String)"saleqty", (BigDecimal)saleQty);
            }
        }
        this.getView().updateView("goodsentryentity", index);
    }

    private Map<String, Object> buildCustomParams(DynamicObject entryEntity, DynamicObject dataEntity, int index) {
        Map customParams = SaleOrderDeliveryInfoHelper.buildCustomParams((DynamicObject)dataEntity, (int)index);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
        if (BillTypeEnum.CHANGE.getId() == billTypeId && StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
            customParams.put("amount", entryEntity.get("amount"));
        }
        customParams.put("id", entryEntity.getLong("id"));
        this.buildCustomParamsAboutContact(entryEntity, dataEntity, customParams);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutSale((DynamicObject)entryEntity, (Map)customParams);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutAmt((DynamicObject)entryEntity, (Map)customParams);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutBook((DynamicObject)entryEntity, (Map)customParams);
        this.buildCustomParamsAboutInv(entryEntity, customParams);
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
        long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"sourcebillid");
        if (isNotConfirm && sourceBillId > 0L) {
            DynamicObject saleBranch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"salebranchid");
            long saleBranchId = DynamicObjectUtils.getPkValue((DynamicObject)saleBranch);
            DynamicObject member = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
            long memberId = DynamicObjectUtils.getPkValue((DynamicObject)member);
            BigDecimal prePayAmount = SaleAmountHelper.getBookPreStoreAmount((long)saleBranchId, (long)memberId, (long)sourceBillId);
            BigDecimal depositAmount = dataEntity.getBigDecimal("depositamount");
            BigDecimal deposit = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"deposit");
            BigDecimal surplusPrePayAmount = prePayAmount.subtract(depositAmount).add(deposit);
            customParams.put("surpluspreamount", surplusPrePayAmount);
        }
        customParams.put("notconfirm", isNotConfirm);
        boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
        customParams.put("isinitbill", isInitBill);
        return customParams;
    }

    private Map<String, Object> buildCustomParamsAboutGoods(DynamicObject entryEntity, DynamicObject dataEntity, DynamicObject goods, int index) {
        Map<String, Object> customParams = this.buildCustomParams(entryEntity, dataEntity, index);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutGoods(customParams, (DynamicObject)goods);
        long baseBillType = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (baseBillType == BillTypeEnum.CHANGE.getId()) {
            customParams.put("saleoption", entryEntity.get("saleoption"));
            customParams.put("changeitemtype", dataEntity.get("changeitemtype"));
        }
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        long barCodeId = SaleOrderDeliveryInfoHelper.getBarCodeIdByGoods((long)branchId, (long)currencyId, (long)goodsId);
        customParams.put("barcode", barCodeId);
        this.buildCustomParamsAboutItems(customParams, goods);
        return customParams;
    }

    private Map<String, Object> buildCustomParamsAboutBarCode(DynamicObject entryEntity, DynamicObject dataEntity, DynamicObject barCode, int index) {
        Map<String, Object> customParams = this.buildCustomParams(entryEntity, dataEntity, index);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutBarCode(customParams, (DynamicObject)barCode);
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)barCode, (String)"item");
        this.buildCustomParamsAboutItems(customParams, goods);
        return customParams;
    }

    private Map<String, Object> buildCustomParamsAboutOther(DynamicObject entryEntity, DynamicObject dataEntity, int index) {
        Map<String, Object> customParams = this.buildCustomParams(entryEntity, dataEntity, index);
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
        customParams.put("notconfirm", isNotConfirm);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
            customParams.put("saleoption", saleOption);
            Object changeType = DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"changeitemtype");
            customParams.put("changeitemtype", changeType);
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"mustretqty");
                customParams.put("mustretqty", mustRetQty);
                this.setNegativeQtyParams(entryEntity, customParams);
            }
        } else if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
            BigDecimal srcMustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"srcmustretqty");
            customParams.put("srcmustretqty", srcMustRetQty);
        } else if (billTypeId == BillTypeEnum.RETURN.getId()) {
            BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"mustretqty");
            customParams.put("mustretqty", mustRetQty);
            this.setNegativeQtyParams(entryEntity, customParams);
        } else if (billTypeId == BillTypeEnum.RETAIL.getId()) {
            this.setGoodsTotalValue(dataEntity, customParams);
        }
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutOther((DynamicObject)entryEntity, customParams);
        this.buildCustomParamsAbountOtherDelivery(entryEntity, customParams);
        boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
        if (isPresent) {
            customParams.put("ispresent", Boolean.TRUE);
            customParams.put("isgiftmodify", Boolean.TRUE);
        }
        customParams.put("type", false);
        BigDecimal realPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"realprice");
        customParams.put("realprice", realPrice);
        return customParams;
    }

    public void buildCustomParamsAboutItems(Map<String, Object> customParams, DynamicObject goods) {
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)goods, (String)"isdelivery");
        customParams.put("isdelivery", isDelivery);
        customParams.put("deliverytime", null);
        boolean isInstall = DynamicObjectUtils.getBoolean((DynamicObject)goods, (String)"isinstall");
        customParams.put("isinstall", isInstall);
        customParams.put("installtime", null);
        customParams.put("type", true);
    }

    public void buildCustomParamsAbountOtherDelivery(DynamicObject entryEntity, Map<String, Object> customParams) {
        boolean isDelivery = false;
        boolean isInstall = false;
        boolean isSelfPickup = false;
        Date deliveryTime = null;
        Date installTime = null;
        Date selfPickupTime = null;
        long deliveryModeId = 0L;
        long snMainFileId = 0L;
        long returnReasonId = 0L;
        long deliveryStatusId = 0L;
        long wbSrcDeliverStatusId = 0L;
        long srcDeliverStatusId = 0L;
        String serialNum = "";
        String lotNum = "";
        String returnType = "";
        DynamicObjectCollection subEntryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
        if (!CollectionUtils.isEmpty((Collection)subEntryEntities)) {
            DynamicObject subEntryEntity = (DynamicObject)subEntryEntities.get(0);
            isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)subEntryEntity, (String)"deliverisdelivery");
            deliveryTime = DynamicObjectUtils.getDate((DynamicObject)subEntryEntity, (String)"deliverdeliverytime");
            deliveryModeId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryEntity, (String)"deliverymode");
            isInstall = DynamicObjectUtils.getBoolean((DynamicObject)subEntryEntity, (String)"deliverisinstall");
            installTime = DynamicObjectUtils.getDate((DynamicObject)subEntryEntity, (String)"deliverinstalltime");
            isSelfPickup = DynamicObjectUtils.getBoolean((DynamicObject)subEntryEntity, (String)"isselfpickup");
            selfPickupTime = DynamicObjectUtils.getDate((DynamicObject)subEntryEntity, (String)"selfpickuptime");
            snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryEntity, (String)"snmainfile");
            serialNum = DynamicObjectUtils.getString((DynamicObject)subEntryEntity, (String)"deliveryserialnumber");
            lotNum = DynamicObjectUtils.getString((DynamicObject)subEntryEntity, (String)"deliverylotnum");
            returnType = DynamicObjectUtils.getString((DynamicObject)subEntryEntity, (String)"returntype");
            returnReasonId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryEntity, (String)"returnreason");
            deliveryStatusId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryEntity, (String)"deliverystatus");
            wbSrcDeliverStatusId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryEntity, (String)"wbsrcdeliverstatus");
            srcDeliverStatusId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryEntity, (String)"srcdeliverystatus");
        }
        customParams.put("isdelivery", isDelivery);
        customParams.put("deliverytime", deliveryTime);
        customParams.put("deliverymode", deliveryModeId);
        customParams.put("isinstall", isInstall);
        customParams.put("installtime", installTime);
        customParams.put("isselfpickup", isSelfPickup);
        customParams.put("selfpickuptime", selfPickupTime);
        customParams.put("snmainfile", snMainFileId);
        customParams.put("deliveryserialnumber", serialNum);
        customParams.put("deliverylotnum", lotNum);
        customParams.put("returntype", returnType);
        customParams.put("returnreason", returnReasonId);
        customParams.put("deliverystatus", deliveryStatusId);
        customParams.put("wbsrcdeliverstatus", wbSrcDeliverStatusId);
        customParams.put("srcdeliverystatus", srcDeliverStatusId);
    }

    private void buildCustomParamsAboutContact(DynamicObject entryEntity, DynamicObject dataEntity, Map<String, Object> customParams) {
        String customerName = "";
        String customerPhone = "";
        String adminDivisionId = "";
        String address = "";
        DynamicObjectCollection subEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
        if (!CollectionUtils.isEmpty((Collection)subEntryEntity)) {
            DynamicObject subEntryItem = (DynamicObject)subEntryEntity.get(0);
            customerName = DynamicObjectUtils.getString((DynamicObject)subEntryItem, (String)"consignee");
            customerPhone = DynamicObjectUtils.getString((DynamicObject)subEntryItem, (String)"deliverphonenumber");
            adminDivisionId = DynamicObjectUtils.getString((DynamicObject)subEntryItem, (String)"districtid");
            address = DynamicObjectUtils.getString((DynamicObject)subEntryItem, (String)"address");
        }
        customerName = StringUtils.isEmpty((CharSequence)customerName) ? DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"customername") : customerName;
        customerPhone = StringUtils.isEmpty((CharSequence)customerPhone) ? DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"customerphone") : customerPhone;
        adminDivisionId = StringUtils.isEmpty((CharSequence)adminDivisionId) || StringUtils.equals((CharSequence)adminDivisionId, (CharSequence)"0") ? DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid") : adminDivisionId;
        address = StringUtils.isEmpty((CharSequence)address) ? DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"customeraddress") : address;
        customParams.put("customername", customerName);
        customParams.put("customerphone", customerPhone);
        customParams.put("admindivisionid", adminDivisionId);
        customParams.put("customeraddress", address);
    }

    private void buildCustomParamsAboutInv(DynamicObject entryEntity, Map<String, Object> customParams) {
        long srcDeliveryId;
        long stockTypeId;
        long erpStockId;
        long inventoryOrgId;
        long ownerId;
        String ownerType;
        long keeperId;
        String keeperType;
        DynamicObjectCollection subEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
        if (!CollectionUtils.isEmpty((Collection)subEntryEntity)) {
            DynamicObject subEntryItem = (DynamicObject)subEntryEntity.get(0);
            keeperType = DynamicObjectUtils.getString((DynamicObject)subEntryItem, (String)"deliverykeepertype");
            keeperId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryItem, (String)"deliverykeeper");
            ownerType = DynamicObjectUtils.getString((DynamicObject)subEntryItem, (String)"deliveryownertype");
            ownerId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryItem, (String)"deliveryowner");
            inventoryOrgId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryItem, (String)"inventoryorgid");
            erpStockId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryItem, (String)"erpstockid");
            stockTypeId = DynamicObjectUtils.getPkValue((DynamicObject)subEntryItem, (String)"deliverystocktype");
            srcDeliveryId = DynamicObjectUtils.getLong((DynamicObject)subEntryItem, (String)"srcdeliveryentryid");
        } else {
            keeperType = "bos_org";
            keeperId = 0L;
            ownerType = "bos_org";
            ownerId = 0L;
            inventoryOrgId = 0L;
            erpStockId = 0L;
            stockTypeId = 0L;
            srcDeliveryId = 0L;
        }
        customParams.put("keepertype", keeperType);
        customParams.put("keeperid", keeperId);
        customParams.put("ownertype", ownerType);
        customParams.put("ownerid", ownerId);
        customParams.put("inventoryorgid", inventoryOrgId);
        customParams.put("erpstockid", erpStockId);
        customParams.put("channelstocktypeid", stockTypeId);
        customParams.put("srcdeliveryentryid", srcDeliveryId);
    }

    private List<Long> getLockSnMainFileIds() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        return SnServiceHelper.getLockSnMainFileIdsFromDr((DynamicObject)dataEntity);
    }

    private void updateInventoryData(BeforeFieldPostBackEvent e, DynamicObject dataEntity, DynamicObject entryEntity, BigDecimal saleQty, int index) {
        DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
        if (CollectionUtils.isEmpty((Collection)deliveryEntities)) {
            return;
        }
        DynamicObject deliveryEntity = (DynamicObject)deliveryEntities.get(0);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
        if (BillTypeEnum.CHANGE.getId() == billTypeId && StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
            return;
        }
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodsid");
        String operationMode = DynamicObjectUtils.getString((DynamicObject)goods, (String)"operationmodel");
        boolean isJoint = StringUtils.equals((CharSequence)operationMode, (CharSequence)"0");
        long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymode");
        boolean isVenderSell = distributionModeId == 1098521642067513344L;
        long itemsTypeId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"itemtypeid");
        boolean isService = itemsTypeId == 870946434386494464L;
        boolean isAmt = itemsTypeId == 870946349007286272L;
        boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
        if (isInitBill || isService || isAmt || isVenderSell || isBook || isJoint) {
            return;
        }
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)deliveryEntity, (String)"deliverisdelivery");
        boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
        BigDecimal baseUnitQty = UnitTransferUtils.updateMultiQuantities((DynamicObject)entryEntity, (BigDecimal)saleQty);
        Date deliveryTime = DynamicObjectUtils.getDate((DynamicObject)deliveryEntity, (String)"deliverdeliverytime");
        long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"inventoryorgid");
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"erpstockid");
        long invTypeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverystocktype");
        boolean isAllowChange = isPresent || !isDelivery ? this.updateInventoryDataWithoutOverSale(dataEntity, entryEntity, saleQty, baseUnitQty, invOrgId, stockId, invTypeId, index) : this.updateInventoryDataWithOverSale(dataEntity, entryEntity, deliveryEntity, saleQty, baseUnitQty, deliveryTime, invOrgId, stockId, invTypeId, index);
        if (!isAllowChange) {
            this.getView().updateView("saleqty", index);
            e.setCancel(true);
        }
    }

    private boolean updateInventoryDataWithOverSale(DynamicObject dataEntity, DynamicObject entryEntity, DynamicObject deliveryEntity, BigDecimal saleQty, BigDecimal baseUnitQty, Date deliveryTime, long invOrgId, long stockId, long invTypeId, int index) {
        HashMap result;
        HashMap deliveryInfo;
        boolean isOverSale;
        List<JSONObject> overSaleParams;
        List overSaleData;
        if (invOrgId <= 0L || stockId <= 0L) {
            return true;
        }
        if (deliveryTime != null && !CollectionUtils.isEmpty((Collection)(overSaleData = SaleOrderDeliveryInfoHelper.getOverSaleData(overSaleParams = this.getOverSaleParams(dataEntity, entryEntity, deliveryEntity, saleQty, baseUnitQty, deliveryTime, invOrgId, stockId, invTypeId, index)))) && (isOverSale = SaleOrderDeliveryInfoHelper.matchingOverSalePolicy((List)overSaleData, deliveryInfo = new HashMap(2), (BigDecimal)saleQty, (Date)deliveryTime, (String)"1", result = new HashMap(3)))) {
            return true;
        }
        return this.updateInventoryDataWithoutOverSale(dataEntity, entryEntity, saleQty, baseUnitQty, invOrgId, stockId, invTypeId, index);
    }

    private boolean updateInventoryDataWithoutOverSale(DynamicObject dataEntity, DynamicObject entryEntity, BigDecimal saleQty, BigDecimal baseUnitQty, long invOrgId, long stockId, long invTypeId, int index) {
        if (invOrgId <= 0L || stockId <= 0L || invTypeId <= 0L) {
            return true;
        }
        List<JSONObject> inventoryParams = this.getInventoryParams(dataEntity, entryEntity, saleQty, baseUnitQty, invOrgId, stockId, invTypeId, index);
        List inventoryInfo = SaleOrderDeliveryInfoHelper.getInventoryInfo(inventoryParams);
        if (CollectionUtils.isEmpty((Collection)inventoryInfo)) {
            NotificationUtil.showDefaultTipNotify((String)"\u5e93\u5b58\u4e0d\u8db3\u3002", (IFormView)this.getView());
            return false;
        }
        JSONObject inventoryItem = (JSONObject)inventoryInfo.get(0);
        String invStatus = inventoryItem.getString("invstatus");
        if (!StringUtils.equals((CharSequence)invStatus, (CharSequence)"1")) {
            NotificationUtil.showDefaultTipNotify((String)"\u5e93\u5b58\u4e0d\u8db3\u3002", (IFormView)this.getView());
            return false;
        }
        return true;
    }

    private List<JSONObject> getOverSaleParams(DynamicObject dataEntity, DynamicObject entryEntity, DynamicObject deliveryEntity, BigDecimal saleQty, BigDecimal baseUnitQty, Date deliveryTime, long invOrgId, long stockId, long invTypeId, int index) {
        ArrayList<JSONObject> overSaleParams = new ArrayList<JSONObject>(0);
        JSONObject overSaleParam = new JSONObject();
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        overSaleParam.put("saleOrgId", (Object)orgId);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        overSaleParam.put("saleChannelID", (Object)branchId);
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsid");
        overSaleParam.put("itemId", (Object)goodsId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"materielid");
        overSaleParam.put("materialId", (Object)materialId);
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"baseunit");
        overSaleParam.put("baseUnitID", (Object)baseUnitId);
        overSaleParam.put("baseUnitQty", (Object)baseUnitQty);
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"unit");
        overSaleParam.put("unitId", (Object)unitId);
        overSaleParam.put("unitQty", (Object)saleQty);
        long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymode");
        overSaleParam.put("distributionModeId", (Object)distributionModeId);
        overSaleParam.put("deliveryDate", (Object)deliveryTime);
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"bizdate");
        overSaleParam.put("bizdate", (Object)bizDate);
        overSaleParam.put("stockOrgId", (Object)invOrgId);
        overSaleParam.put("stockId", (Object)stockId);
        overSaleParam.put("invtypeid", (Object)invTypeId);
        overSaleParam.put("customerKey", (Object)index);
        overSaleParams.add(overSaleParam);
        return overSaleParams;
    }

    private List<JSONObject> getInventoryParams(DynamicObject dataEntity, DynamicObject entryEntity, BigDecimal saleQty, BigDecimal baseUnitQty, long invOrgId, long stockId, long invTypeId, int index) {
        JSONObject inventoryParam = new JSONObject();
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        inventoryParam.put("saleOrgId", (Object)bizOrgId);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        inventoryParam.put("saleChannelID", (Object)branchId);
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodsid");
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        inventoryParam.put("itemId", (Object)goodsId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"materielid");
        inventoryParam.put("materialId", (Object)materialId);
        long auxAttrId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"auxattrid");
        inventoryParam.put("auxPtyID", (Object)auxAttrId);
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"unit");
        inventoryParam.put("unitId", (Object)unitId);
        inventoryParam.put("unitQty", (Object)saleQty);
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"baseunit");
        inventoryParam.put("baseUnitID", (Object)baseUnitId);
        inventoryParam.put("baseUnitQty", (Object)baseUnitQty);
        inventoryParam.put("invtypeid", (Object)invTypeId);
        inventoryParam.put("stockOrgId", (Object)invOrgId);
        inventoryParam.put("warehouseId", (Object)stockId);
        String operationMode = DynamicObjectUtils.getString((DynamicObject)goods, (String)"operationmodel");
        long distributionModeId = StringUtils.equals((CharSequence)operationMode, (CharSequence)"0") ? 926601157210585088L : 926601071999218688L;
        inventoryParam.put("distributionModeId", (Object)distributionModeId);
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid");
        inventoryParam.put("adminDivisionId", (Object)adminDivisionId);
        inventoryParam.put("customerKey", (Object)index);
        return Collections.singletonList(inventoryParam);
    }

    private void setNegativeQtyParams(DynamicObject entryEntity, Map<String, Object> customParams) {
        BigDecimal baseQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"baseunitqty");
        customParams.put("baseunitqty", baseQty);
        BigDecimal stockQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"stockunitqty");
        customParams.put("stockunitqty", stockQty);
    }

    private boolean checkBillTypeMatchPromotion(Map<String, Object> returnMap, long billTypeId, Boolean isNotConfirm) {
        if (billTypeId == BillTypeEnum.RETURN.getId() || billTypeId == BillTypeEnum.CVTSALE.getId() && !isNotConfirm.booleanValue()) {
            return false;
        }
        if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            DynamicObject data = (DynamicObject)returnMap.get("data");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)CommonUtil.formatStringToEmpty((String)data.getString("changeitemtype"))) || StringUtils.equals((CharSequence)"3", (CharSequence)CommonUtil.formatStringToEmpty((String)data.getString("changeitemtype")))) {
                return false;
            }
            return !StringUtils.equals((CharSequence)"2", (CharSequence)CommonUtil.formatStringToEmpty((String)data.getString("changeitemtype"))) || !StringUtils.equals((CharSequence)"0", (CharSequence)CommonUtil.formatStringToEmpty((String)data.getString("saleoption")));
        }
        return true;
    }

    private void goodsIdChanged(DynamicObject dataEntity, DynamicObject entryEntity, Object oldValue, Object newValue, int index) {
        this.clearEntryValue(index);
        if (oldValue != null) {
            DynamicObject oldGoods = (DynamicObject)oldValue;
            this.getView().getPageCache().put("goodsid" + this.getView().getPageId(), DynamicObjectUtils.getString((DynamicObject)oldGoods, (String)"id"));
        }
        if (newValue == null) {
            if (StringUtils.equals((CharSequence)this.getView().getEntityId(), (CharSequence)"ocpos_saleorder")) {
                String seq = Integer.toString(index + 1);
                this.deleteGoodsUnionSendEntry(dataEntity, entryEntity, seq);
            }
            return;
        }
        DynamicObject goods = (DynamicObject)newValue;
        boolean isItemsRight = CommonUtils.checkItemsInfo((AbstractFormPlugin)this, (DynamicObject)dataEntity, (DynamicObject)entryEntity, (DynamicObject)goods);
        if (!isItemsRight) {
            entryEntity.set("goodsid", null);
            return;
        }
        entryEntity.set("saleqty", (Object)BigDecimal.ONE);
        entryEntity.set("retailprice", (Object)BigDecimal.ZERO);
        entryEntity.set("discountprice", (Object)BigDecimal.ZERO);
        this.showItemsInfoInput(this.buildCustomParamsAboutGoods(entryEntity, dataEntity, goods, index));
    }

    private void barCodeChanged(DynamicObject dataEntity, DynamicObject entryEntity, Object newValue, int index) {
        this.clearEntryValue(index);
        if (newValue == null) {
            return;
        }
        DynamicObject barCode = (DynamicObject)newValue;
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)barCode, (String)"item");
        boolean isItemsRight = CommonUtils.checkItemsInfo((AbstractFormPlugin)this, (DynamicObject)dataEntity, (DynamicObject)entryEntity, (DynamicObject)goods);
        if (!isItemsRight) {
            entryEntity.set("barcode", null);
            return;
        }
        entryEntity.set("saleqty", (Object)BigDecimal.ONE);
        entryEntity.set("retailprice", (Object)BigDecimal.ZERO);
        entryEntity.set("discountprice", (Object)BigDecimal.ZERO);
        this.showItemsInfoInput(this.buildCustomParamsAboutBarCode(entryEntity, dataEntity, barCode, index));
    }

    private void setGoodsTotalValue(DynamicObject dataEntity, Map<String, Object> customParams) {
        boolean isCheckPresent = false;
        BigDecimal totalValue = BigDecimal.ZERO;
        BigDecimal totalGiftAmount = BigDecimal.ZERO;
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        boolean isReserve = entryEntities.stream().anyMatch(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"isbook") && !DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"ispresent"));
        if (isReserve) {
            isCheckPresent = true;
            for (DynamicObject entryEntity : entryEntities) {
                boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
                if (isPresent) continue;
                boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
                if (isBook) {
                    BigDecimal deposit = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"deposit");
                    totalValue = totalValue.add(deposit);
                    continue;
                }
                BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"balamount");
                totalValue = totalValue.add(balAmount);
            }
            DynamicObjectCollection docSendGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
            for (DynamicObject sendGoodsEntry : docSendGoodsEntry) {
                totalGiftAmount = totalGiftAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)sendGoodsEntry, (String)"giftvalue"));
            }
        }
        customParams.put("giftvalue", totalGiftAmount);
        customParams.put("sumamount", totalValue);
        customParams.put("ischeckpresent", isCheckPresent);
    }
}

