/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit.items;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormRuleUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.saleorder.UnitTransferUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.SystemParamUtil;
import kd.occ.ocpos.formplugin.saleorder.edit.items.SalesOrderItemsEdit;

public class SalesOrderReturnItemsEdit
extends SalesOrderItemsEdit {
    private boolean isFromBarCode = false;
    private List<RowDataEntity> dataEntities;

    @Override
    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        DecimalEdit decimalEdit;
        Object source = e.getSource();
        if (source instanceof DecimalEdit && StringUtils.equals((CharSequence)(decimalEdit = (DecimalEdit)source).getKey(), (CharSequence)"saleqty")) {
            int index = e.getRowIndex();
            DynamicObject entryEntity = this.getModel().getEntryRowEntity("goodsentryentity", index);
            Object value = e.getValue();
            if (value == null) {
                NotificationUtil.showDefaultTipNotify((String)"\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (IFormView)this.getView());
                this.getView().updateView("saleqty", index);
                e.setCancel(true);
                return;
            }
            BigDecimal saleQty = CommonUtil.formatObjectToDecimal((Object)e.getValue());
            String tip = this.checkSaleQty(entryEntity, saleQty);
            if (!StringUtils.isBlank((CharSequence)tip)) {
                NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
                this.getView().updateView("saleqty", index);
                e.setCancel(true);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length <= 0) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "goodsid": {
                this.goodsChanged(changeData);
                break;
            }
            case "barcode": {
                this.barCodeChanged(changeData);
                break;
            }
            case "saleqty": {
                this.saleQtyChanged(changeData);
                break;
            }
            case "ispresent": {
                this.isPresentChanged(changeData);
                break;
            }
        }
    }

    public void goodsChanged(ChangeData[] changeSet) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
        DataSetBuilder goodsDataBuilder = this.getGoodsDataBuilder();
        HashSet<Long> materialIds = new HashSet<Long>(changeSet.length);
        HashSet<Integer> rowIndexes = new HashSet<Integer>(changeSet.length);
        for (ChangeData changeData : changeSet) {
            DynamicObject goods;
            if (CommonUtil.checkChanged((ChangeData)changeData)) continue;
            int rowIndex = changeData.getRowIndex();
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(rowIndex);
            boolean isItemsRight = CommonUtils.checkItemsInfo((AbstractFormPlugin)this, (DynamicObject)dataEntity, (DynamicObject)entryEntity, (DynamicObject)(goods = (DynamicObject)changeData.getNewValue()));
            if (!isItemsRight) {
                entryEntity.set("goodsid", null);
                continue;
            }
            this.setGoodsClass(entryEntity, goods);
            this.setBrand(entryEntity, goods);
            this.setBarcodeByGoodsId(entryEntity, goods, rowIndex);
            this.setSerialQty(entryEntity, rowIndex);
            long materialId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"material");
            materialIds.add(materialId);
            goodsDataBuilder.append(new Object[]{rowIndex, materialId});
            rowIndexes.add(rowIndex);
        }
        if (!CollectionUtils.isEmpty(materialIds)) {
            DataSet goodsData = goodsDataBuilder.build();
            this.dataEntities = new ArrayList<RowDataEntity>();
            this.initMaterial(entryEntities, goodsData, materialIds);
            if (!CollectionUtils.isEmpty(this.dataEntities)) {
                DynamicProperty property = entryEntities.getDynamicObjectType().getProperty("materialinv");
                FormRuleUtils.raiseFormRules((IFormView)this.getView(), this.dataEntities, (IDataEntityProperty)property);
            }
        }
        if (!CollectionUtils.isEmpty(rowIndexes)) {
            Iterator iterator = rowIndexes.iterator();
            while (iterator.hasNext()) {
                int rowIndex = (Integer)iterator.next();
                DynamicObject entryEntity = (DynamicObject)entryEntities.get(rowIndex);
                this.initSaleQty(entryEntity);
                SaleOrderDeliveryInfoHelper.fillDeliveryData((IFormView)this.getView(), (DynamicObject)entryEntity, (DynamicObject)entryEntity);
                this.getView().updateView("salesorderdelivery");
            }
        }
        this.getView().updateView("goodsentryentity");
        CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
    }

    public void barCodeChanged(ChangeData[] changeSet) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
        for (ChangeData changeData : changeSet) {
            DynamicObject barCode;
            DynamicObject goods;
            if (CommonUtil.checkChanged((ChangeData)changeData)) continue;
            int rowIndex = changeData.getRowIndex();
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(rowIndex);
            boolean isItemsRight = CommonUtils.checkItemsInfo((AbstractFormPlugin)this, (DynamicObject)dataEntity, (DynamicObject)entryEntity, (DynamicObject)(goods = DynamicObjectUtils.getDynamicObject((DynamicObject)(barCode = (DynamicObject)changeData.getNewValue()), (String)"item")));
            if (!isItemsRight) {
                entryEntity.set("barcode", null);
                continue;
            }
            this.setGoodsIdByBarCode(entryEntity, barCode, rowIndex);
        }
        this.getView().updateView("goodsentryentity");
        CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
    }

    public void saleQtyChanged(ChangeData[] changeSet) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        for (ChangeData changeData : changeSet) {
            if (CommonUtil.checkChanged((ChangeData)changeData)) continue;
            int rowIndex = changeData.getRowIndex();
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(rowIndex);
            BigDecimal saleQty = CommonUtil.formatObjectToDecimal((Object)changeData.getNewValue());
            this.updateSaleQty(entryEntity, saleQty);
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            SaleAmountHelper.updateReturnAmountFieldsByQty((DynamicObject)dataEntity, (long)billTypeId, (DynamicObject)entryEntity);
        }
        this.getView().updateView("goodsentryentity");
        CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
    }

    public void isPresentChanged(ChangeData[] changeSet) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        for (ChangeData changeData : changeSet) {
            if (CommonUtil.checkChanged((ChangeData)changeData)) continue;
            int rowIndex = changeData.getRowIndex();
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(rowIndex);
            boolean isPresent = CommonUtil.formatObjectToBoolean((Object)changeData.getNewValue());
            if (isPresent) {
                entryEntity.set("discountprice", (Object)BigDecimal.ZERO);
                entryEntity.set("discountrate", (Object)BigDecimal.ZERO);
                entryEntity.set("balamount", (Object)BigDecimal.ZERO);
                entryEntity.set("linereceivableamount", (Object)BigDecimal.ZERO);
                continue;
            }
            long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsid");
            long barcodeId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"barcode");
            this.setDiscountPrice(entryEntity, goodsId, barcodeId, rowIndex);
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
            SaleAmountHelper.updateReturnAmountFieldsByQty((DynamicObject)dataEntity, (long)billTypeId, (DynamicObject)entryEntity);
        }
        this.getView().updateView("goodsentryentity");
        CommonUtils.updateBaseInfoAmount((IFormView)this.getView());
    }

    public void setBarcodeByGoodsId(DynamicObject entryEntity, DynamicObject goods, int index) {
        if (goods == null) {
            super.clearEntryValue(index);
            return;
        }
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        if (!this.isFromBarCode) {
            List<DynamicObject> lstBarCode = this.getBarCodeByGoodsId(goodsId, index);
            if (!CollectionUtils.isEmpty(lstBarCode)) {
                DynamicObject barCode = lstBarCode.get(0);
                entryEntity.set("barcode", (Object)barCode);
            }
            this.isFromBarCode = false;
        }
        long barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"barcode");
        if (goodsId > 0L && barCodeId > 0L) {
            this.setDiscountPrice(entryEntity, goodsId, barCodeId, index);
            CommonUtils.setAuxAttrIdByBarCode((DynamicObject)entryEntity, (long)barCodeId);
        }
    }

    private void setDiscountPrice(DynamicObject entryEntity, long goodsId, long barCodeId, int index) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        boolean isEnablePricePolicy = CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getSystemParamValue((long)bizOrgId, (long)branchId, (String)"isenblepricepolicy"));
        CommonUtils.setRetailPrice((IFormView)this.getView(), (DynamicObject)entryEntity, (long)goodsId, (long)barCodeId, (int)index, (boolean)isEnablePricePolicy);
        BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"retailprice");
        entryEntity.set("discountprice", (Object)retailPrice);
        entryEntity.set("discountrate", (Object)new BigDecimal(100));
    }

    public void setGoodsIdByBarCode(DynamicObject entryEntity, DynamicObject barCode, int index) {
        if (barCode != null) {
            DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)barCode, (String)"item");
            long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
            this.isFromBarCode = true;
            if (goodsId != 0L) {
                this.getModel().setValue("goodsid", (Object)goodsId, index);
            } else {
                this.getModel().setValue("goodsid", null, index);
            }
        } else {
            this.getModel().setValue("goodsid", null, index);
        }
    }

    public void initSaleQty(DynamicObject entryItem) {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("basebilltype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        BigDecimal qty = BigDecimal.ONE;
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            qty = BigDecimal.ONE.negate();
        }
        entryItem.set("discountrate", (Object)new BigDecimal(100));
        entryItem.set("saleqty", (Object)qty);
        UnitTransferUtils.updateMultiQuantities((IFormView)this.getView(), (DynamicObject)entryItem, (BigDecimal)qty);
    }

    private void initMaterial(DynamicObjectCollection entryEntities, DataSet goodsData, Set<Long> materialIds) {
        QFilter filter = F7Util.getMaterialInvFilter();
        filter.and("masterid.id", "in", materialIds);
        DataSet materialInvData = QueryServiceHelper.queryDataSet((String)"materialmasterid", (String)"bd_materialinventoryinfo", (String)"id, masterid.id as masterid", (QFilter[])filter.toArray(), null);
        DataSet data = goodsData.fullJoin(materialInvData).on("materielid", "masterid").select(new String[]{"index", "id"}).finish();
        if (data != null) {
            DataSet dataSet = data.select(this.getGoodsMaterialInvInfoFields());
            this.getModel().beginInit();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long materialInvId = row.getLong("id");
                if (materialInvId == 0L) continue;
                int index = row.getInteger("index");
                this.getModel().setItemValueByID("materialinv", (Object)materialInvId, index);
                this.dataEntities.add((RowDataEntity)new ChangeData(index, (DynamicObject)entryEntities.get(index), (Object)0L, (Object)materialInvId));
            }
            this.getModel().endInit();
        }
    }

    public List<DynamicObject> getBarCodeByGoodsId(long goodsId, int index) {
        if (goodsId == 0L) {
            return new ArrayList<DynamicObject>();
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        QFilter filter = F7Util.getBarCodeByGoodsIdFilter((long)branchId, (long)currencyId, (long)goodsId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"ocdbd_item_barcode", (QFilter[])filter.toArray());
        return new ArrayList<DynamicObject>(map.values());
    }

    public void updateDiscountAmount(DynamicObject entryItem) {
        BigDecimal discountAmount;
        BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"retailprice");
        if (retailPrice.compareTo(discountAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"discountprice")) == 0) {
            return;
        }
        BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"saleqty");
        BigDecimal balAmount = retailPrice.multiply(qty);
        entryItem.set("balamount", (Object)balAmount);
        entryItem.set("discountprice", (Object)retailPrice);
    }

    public void setBrand(DynamicObject entryItem, DynamicObject goods) {
        DynamicObject brand = DynamicObjectUtils.getDynamicObject((DynamicObject)goods, (String)"itembrands");
        entryItem.set("brand", (Object)brand);
    }

    public void setGoodsClass(DynamicObject entryItem, DynamicObject goods) {
        DynamicObjectCollection docItemClassEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goods, (String)"itemclassentity");
        if (CollectionUtils.isEmpty((Collection)docItemClassEntry)) {
            return;
        }
        DynamicObject doClass = CommonUtils.getClassstdApply((String)"1");
        if (ObjectUtils.isEmpty((Object)doClass)) {
            return;
        }
        long classstandardId = DynamicObjectUtils.getLong((DynamicObject)doClass, (String)"classstandardid");
        DynamicObject doItemClassEntry = docItemClassEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"classstandardid") == classstandardId).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)doItemClassEntry)) {
            return;
        }
        DynamicObject doGoodsClass = DynamicObjectUtils.getDynamicObject((DynamicObject)doItemClassEntry, (String)"goodsclasssid");
        if (!ObjectUtils.isEmpty((Object)doGoodsClass)) {
            entryItem.set("goodsclass", (Object)doGoodsClass);
        }
    }

    public void setSerialQty(DynamicObject entryItem, int index) {
        DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"materialinv");
        boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
        this.getView().setEnable(Boolean.valueOf(!isEnableSerial), index, new String[]{"saleqty"});
        entryItem.set("saleqty", (Object)BigDecimal.ONE.negate());
        ChangeData changeData = new ChangeData(index, entryItem, (Object)BigDecimal.ZERO, (Object)BigDecimal.ONE.negate());
        this.saleQtyChanged(new ChangeData[]{changeData});
    }

    public void updateSaleQty(DynamicObject entryEntity, BigDecimal saleQty) {
        UnitTransferUtils.updateMultiQuantities((IFormView)this.getView(), (DynamicObject)entryEntity, (BigDecimal)saleQty);
        DynamicObjectCollection deliveryEntityList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
        if (!ObjectUtils.isEmpty((Object)deliveryEntityList)) {
            DynamicObject delivery = (DynamicObject)deliveryEntityList.get(0);
            delivery.set("deliversaleqty", (Object)saleQty);
            delivery.set("deliveryavareturnqty", (Object)saleQty);
            UnitTransferUtils.updateDeliveryMultiQuantities((IFormView)this.getView(), (DynamicObject)delivery, (BigDecimal)saleQty);
            DynamicObject baseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)delivery, (String)"deliverybaseunit");
            BigDecimal baseUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)delivery, (String)"deliverybaseunitqty");
            UnitTransferUtils.updateDeliveryOtherQuantities((IFormView)this.getView(), (DynamicObject)delivery, (BigDecimal)baseUnitQty, (long)DynamicObjectUtils.getPkValue((DynamicObject)delivery, (String)"deliverymaterial"), (long)DynamicObjectUtils.getPkValue((DynamicObject)baseUnit), (String)DynamicObjectUtils.getString((DynamicObject)baseUnit, (String)"name"));
            this.getView().updateView("salesorderdelivery");
        }
    }

    public String checkSaleQty(DynamicObject entryItem, BigDecimal newValue) {
        BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"mustretqty");
        String tip = "";
        if (newValue.compareTo(BigDecimal.ZERO) >= 0) {
            tip = "\u9000\u8d27\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e0\u3002";
        } else {
            boolean isNegative;
            boolean isPositive = mustRetQty.compareTo(BigDecimal.ZERO) > 0 && newValue.abs().compareTo(mustRetQty) > 0;
            boolean bl = isNegative = mustRetQty.compareTo(BigDecimal.ZERO) < 0 && newValue.compareTo(mustRetQty) < 0;
            if (isPositive || isNegative) {
                String strMustQty = mustRetQty.abs().stripTrailingZeros().toPlainString();
                tip = String.format("\u9000\u8d27\u6570\u91cf\u5e94\u4e3a\u8d1f\u6570, \u4e14\u6700\u591a\u53ef\u9000%s\u3002", strMustQty);
            }
        }
        return tip;
    }

    private DataSetBuilder getGoodsDataBuilder() {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        fields.add(new Field("index", (DataType)DataType.IntegerType));
        fields.add(new Field("materielid", (DataType)DataType.LongType));
        RowMeta meta = new RowMeta(fields.toArray(new Field[0]));
        return Algo.create((String)"goodsid").createDataSetBuilder(meta);
    }

    private String getGoodsMaterialInvInfoFields() {
        Object[] fields = new String[]{"index", "case when id is null then 0 else id end as id"};
        return StringUtils.join((Object[])fields, (char)',');
    }
}

