/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.edit.items;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocpos.business.saleorder.SnServiceHelper;
import kd.occ.ocpos.common.util.CommonUtil;

public class SalesOrderSerialEdit
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        List data = (List)this.getView().getFormShowParameter().getCustomParam("data");
        if (!CollectionUtils.isEmpty((Collection)data)) {
            this.getModel().deleteEntryData("itementry");
            this.getModel().batchCreateNewEntryRow("itementry", data.size());
            int index = 0;
            for (Map datum : data) {
                Object goodsId = datum.get("delivergoodsid");
                this.getModel().setItemValueByID("itemid", goodsId, index);
                Object materialId = datum.get("deliverymaterial");
                this.getModel().setItemValueByID("materialid", materialId, index);
                Object stockOrgId = datum.get("inventoryorgid");
                this.getModel().setItemValueByID("inventoryorgid", stockOrgId, index);
                Object stockId = datum.get("erpstockid");
                this.getModel().setItemValueByID("erpstockid", stockId, index);
                Object qty = datum.get("deliversaleqty");
                this.getModel().setValue("selectnumber", qty, index);
                Object parentId = datum.get("EntryPrimaryKeyValue");
                this.getModel().setValue("parentid", parentId, index);
                ++index;
            }
            this.getView().updateView("itementry");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        TextEdit serialNumberEdit = (TextEdit)this.getView().getControl("deliveryserialnumber");
        serialNumberEdit.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (key = ctrl.getKey()) {
            case "btnok": {
                this.confirm();
                break;
            }
            case "deliveryserialnumber": {
                int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getPageCache().put("index_" + this.getView().getPageId(), String.valueOf(currIndex));
                this.querySerialNumber(currIndex);
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryKey = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryKey, (CharSequence)"entryentity")) {
            this.updateSerialNumber();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        List data;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"ocpos_snmainfile_query") && returnData instanceof List && !CollectionUtils.isEmpty((Collection)(data = (List)returnData))) {
            int currIndex = CommonUtil.formatStringToInt((String)this.getPageCache().get("index_" + this.getView().getPageId()));
            this.getModel().beginInit();
            int size = data.size();
            for (int i = 0; i < size; ++i) {
                JSONObject datum = (JSONObject)data.get(i);
                long snMainFileId = datum.getLongValue("snmainfile");
                this.getModel().setItemValueByID("supplyserialid", (Object)snMainFileId, currIndex);
                String sn = datum.getString("deliveryserialnumber");
                this.getModel().setValue("deliveryserialnumber", (Object)sn, currIndex);
                if (i >= size - 1) continue;
                currIndex = this.getModel().insertEntryRow("entryentity", currIndex + 1);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
            this.getPageCache().remove("index_" + this.getView().getPageId());
            this.updateSerialNumber();
        }
    }

    private void confirm() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"itementry");
        int index = 1;
        for (DynamicObject entryEntity : entryEntities) {
            int serialNumber;
            int selectNumber = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"selectnumber");
            if (selectNumber != (serialNumber = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"serialnumber"))) {
                this.getView().showMessage(String.format("\u7b2c%d\u884c,\u5546\u54c1\u6570\u91cf\u4e0e\u5df2\u9009\u62e9\u5e8f\u5217\u53f7\u6570\u91cf\u4e0d\u540c\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", index));
                continue;
            }
            this.updateParentView();
            this.getView().returnDataToParent((Object)Boolean.TRUE);
            this.getView().close();
        }
    }

    private void querySerialNumber(int currIndex) {
        DynamicObject subEntryEntity = this.getModel().getEntryRowEntity("entryentity", currIndex);
        DynamicObject entryEntity = (DynamicObject)subEntryEntity.getParent();
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"materialid");
        long auxPtyId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"auxattrid");
        long stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"inventoryorgid");
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"erpstockid");
        HashMap<String, Object> customParams = new HashMap<String, Object>(0);
        customParams.put("material", materialId);
        customParams.put("auxpty", auxPtyId);
        customParams.put("stockorg", stockOrgId);
        customParams.put("stock", stockId);
        customParams.put("ismul", Boolean.TRUE);
        customParams.put("locksnmainfiles", this.getExistId());
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_snmainfile_query", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocpos_snmainfile_query"));
        this.getView().showForm(parameter);
    }

    public void updateParentView() {
        List customParams = (List)this.getView().getFormShowParameter().getCustomParam("data");
        if (customParams == null) {
            return;
        }
        for (Map customParam : customParams) {
            Object pkValue = customParam.get("PrimaryKeyValue");
            Object entityName = customParam.get("EntityId");
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle(pkValue, (String)entityName.toString());
            DynamicObjectCollection thisItemEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("itementry");
            for (DynamicObject thisItemEntity : thisItemEntry) {
                DynamicObjectCollection parentItemEntry = saleOrder.getDynamicObjectCollection("goodsentryentity");
                for (DynamicObject parentItemEntryRow : parentItemEntry) {
                    DynamicObjectCollection salesOrderDelivery;
                    if (!parentItemEntryRow.getPkValue().equals(thisItemEntity.getLong("parentid")) || CollectionUtils.isEmpty((Collection)(salesOrderDelivery = parentItemEntryRow.getDynamicObjectCollection("salesorderdelivery")))) continue;
                    DynamicObjectCollection entryEntity = thisItemEntity.getDynamicObjectCollection("entryentity");
                    DynamicObject supplySerial = ((DynamicObject)entryEntity.get(0)).getDynamicObject("supplyserialid");
                    ((DynamicObject)salesOrderDelivery.get(0)).set("snmainfile", (Object)supplySerial);
                    ((DynamicObject)salesOrderDelivery.get(0)).set("deliveryserialnumber", (Object)supplySerial.getString("number"));
                    SnServiceHelper.updateDeliveryOrder((Object)((DynamicObject)salesOrderDelivery.get(0)).getPkValue(), (DynamicObject)supplySerial);
                }
            }
            SaveServiceHelper.update((DynamicObject)saleOrder);
            this.updateSnMainFiles(saleOrder);
        }
    }

    private void updateSnMainFiles(DynamicObject saleOrder) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        ArrayList<JSONObject> params = new ArrayList<JSONObject>();
        ArrayList<Long> snMainFileIds = new ArrayList<Long>();
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities = entryEntity.getDynamicObjectCollection("salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
            long supplierId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"supplier");
            for (DynamicObject deliveryEntity : deliveryEntities) {
                long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"snmainfile");
                if (snMainFileId <= 0L) continue;
                snMainFileIds.add(snMainFileId);
                JSONObject param = SnServiceHelper.buildParam((DynamicObject)saleOrder, (long)supplierId, (DynamicObject)deliveryEntity);
                params.add(param);
            }
        }
        if (!CollectionUtils.isEmpty(snMainFileIds)) {
            this.updateSnState(snMainFileIds, params);
        }
    }

    private void updateSnState(List<Long> snMainFileIds, List<JSONObject> params) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                SnServiceHelper.updateSnStatus(snMainFileIds, (String)"C");
                SnServiceHelper.updateSnMoveTrack(params);
            }
            catch (Exception ex) {
                handle.markRollback();
                throw ex;
            }
        }
    }

    private void updateSerialNumber() {
        DynamicObjectCollection itemEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("itementry");
        for (DynamicObject itemEntity : itemEntry) {
            DynamicObjectCollection subEntry = itemEntity.getDynamicObjectCollection("entryentity");
            int index = Math.toIntExact(subEntry.stream().filter(s -> s.get("supplyserialid") != null).count());
            itemEntity.set("serialnumber", (Object)index);
        }
        this.getView().updateView("itementry");
    }

    public String getExistId() {
        DynamicObjectCollection entryEntities = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("itementry");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return "";
        }
        HashSet result = new HashSet(entryEntities.size());
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection subEntryEntities = entryEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)subEntryEntities)) continue;
            Set subResult = subEntryEntities.stream().filter(p -> p.get("supplyserialid") != null).map(q -> DynamicObjectUtils.getPkValue((DynamicObject)q, (String)"supplyserialid")).collect(Collectors.toSet());
            result.addAll(subResult);
        }
        if (CollectionUtils.isEmpty(result)) {
            return "";
        }
        return StringUtils.join((Object[])result.toArray(), (String)",");
    }
}

