/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.inventory.VisualiZationHelper;
import kd.occ.ocpos.business.push.AutoPushHelper;
import kd.occ.ocpos.formplugin.base.OcposListPlugin;

public class SaleShippingList
extends OcposListPlugin {
    @Override
    protected String[] listBranchCols() {
        return new String[0];
    }

    @Override
    protected String branchKey() {
        return "salebranchid";
    }

    @Override
    protected String[] listChannelUserCols() {
        return new String[0];
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String entityId = this.getView().getEntityId();
        String statusFilter = "";
        switch (entityId) {
            case "ocpos_saleorder": {
                statusFilter = " tod.fdeliverystatusid = 1026065142993238016";
                break;
            }
            case "ocpos_saleorder_return": {
                statusFilter = " tod.fdeliverystatusid = 1026080127278495744";
                break;
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        sql.append(" select toddx.fcorebillentryid from t_ocococ_deliveryorder tod ");
        sql.append(" inner join t_ocococ_delorder_det_x toddx on toddx.fid = tod.fid and tod.fbillstatus = 'C' ");
        if (StringUtils.isNotBlank((CharSequence)statusFilter)) {
            sql.append(" and ").append(statusFilter);
        }
        sql.append(" )");
        QFilter filter = QFilter.sqlExpress((String)"goodsentryentity.salesorderdelivery.id", (String)"in", (String)sql.toString());
        e.getQFilters().add(filter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"delivery") || StringUtils.equals((CharSequence)opKey, (CharSequence)"receive")) {
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (IFormView)this.getView());
                return;
            }
            if (selectedRows.size() > 1) {
                NotificationUtil.showDefaultTipNotify((String)"\u53ea\u5141\u8bb8\u5904\u7406\u5355\u884c\u6570\u636e\u3002", (IFormView)this.getView());
                return;
            }
            List saleOrderSubEntryIds = selectedRows.stream().map(ListSelectedRow::getSubEntryPrimaryKeyValue).distinct().collect(Collectors.toList());
            String entityId = ((IListView)this.getView()).getListModel().getEntityId();
            String formId = "";
            if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) {
                formId = "ocpos_fillindelivery";
            } else if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_return")) {
                formId = "ocpos_fillpickupinfo";
            }
            if (StringUtils.isNotBlank((CharSequence)formId)) {
                if (!this.checkAndInputSerialNumber(selectedRows)) {
                    return;
                }
                HashMap<String, Object> customParams = new HashMap<String, Object>(2);
                customParams.put("id", saleOrderSubEntryIds);
                customParams.put("name", entityId);
                FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)formId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, opKey));
                this.getView().showForm(parameter);
            }
        }
    }

    private boolean checkAndInputSerialNumber(ListSelectedRowCollection selectedRows) {
        ArrayList data = new ArrayList(10);
        BillList billList = (BillList)this.getControl("billlistap");
        String entityId = billList.getEntityId();
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)entityId);
        DynamicObjectCollection entryEntities = saleOrder.getDynamicObjectCollection("goodsentryentity");
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities;
            DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"materialinv");
            boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
            if (!isEnableSerial || CollectionUtils.isEmpty((Collection)(deliveryEntities = entryEntity.getDynamicObjectCollection("salesorderdelivery")))) continue;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                int deliverSaleQty;
                String sn = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"deliveryserialnumber");
                if (!StringUtils.isBlank((CharSequence)sn) || (deliverSaleQty = DynamicObjectUtils.getInt((DynamicObject)deliveryEntity, (String)"deliversaleqty")) == 0) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("deliversaleqty", deliverSaleQty);
                map.put("delivergoodsid", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"delivergoodsid"));
                map.put("deliverymaterial", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymaterial"));
                map.put("inventoryorgid", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"inventoryorgid"));
                map.put("erpstockid", DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"erpstockid"));
                map.put("PrimaryKeyValue", saleOrder.getPkValue());
                map.put("EntryPrimaryKeyValue", entryEntity.getPkValue());
                map.put("EntityId", entityId);
                data.add(map);
            }
        }
        if (!data.isEmpty()) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ocpos_inputserialnumber");
            formShowParameter.setCustomParam("data", data);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "EntityId"));
            this.getView().showForm(formShowParameter);
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"delivery") || StringUtils.equals((CharSequence)actionId, (CharSequence)"receive")) {
            String entityId = ((IListView)this.getView()).getListModel().getEntityId();
            DynamicObject deliveryStatus = null;
            String orderStatus = "";
            if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) {
                deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)DeliveryStatus.SALE_OUTBOUND, (String)"ococic_deliverstatus");
                orderStatus = "D";
            } else if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_return")) {
                deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)DeliveryStatus.RETURN_HAVE_PICK, (String)"ococic_deliverstatus");
                orderStatus = "G";
            }
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            List saleOrderSubEntryIds = selectedRows.stream().map(ListSelectedRow::getSubEntryPrimaryKeyValue).distinct().collect(Collectors.toList());
            VisualiZationHelper.updataReturnDataToDeliveryOrder(saleOrderSubEntryIds, (DynamicObject)((DynamicObject)returnData));
            VisualiZationHelper.updataDeliveryOrderStatus(saleOrderSubEntryIds, (DynamicObject)deliveryStatus);
            VisualiZationHelper.updataSaleOrderValue((String)entityId, saleOrderSubEntryIds, (String)"deliverystatus", (Object)deliveryStatus);
            VisualiZationHelper.updataRetailOrderStatus(saleOrderSubEntryIds, (String)"deliverystatus", (Object)deliveryStatus);
            VisualiZationHelper.updataSaleOrderValue((String)entityId, saleOrderSubEntryIds, (String)"signstatus", (Object)"B");
            VisualiZationHelper.updataSignStatus(saleOrderSubEntryIds, (String)"B");
            VisualiZationHelper.updataRetailOrderStatus(saleOrderSubEntryIds, (String)"signstatus", (Object)"B");
            VisualiZationHelper.updateSaleOrderStatusAndChange((DynamicObject)deliveryStatus, saleOrderSubEntryIds, (String)entityId);
            QFilter qFilter = new QFilter("entryentity.corebillentryid", "in", saleOrderSubEntryIds);
            qFilter.and("entryentity.deliveryserialnumber", "!=", (Object)" ");
            DynamicObjectCollection deliveryOrders = QueryServiceHelper.query((String)"ocococ_deliveryorder", (String)"id", (QFilter[])qFilter.toArray());
            if (!CollectionUtils.isEmpty((Collection)deliveryOrders)) {
                for (DynamicObject deliveryOrder : deliveryOrders) {
                    boolean flag = BFTrackerServiceHelper.isPush((String)"ocococ_deliveryorder", (Long)deliveryOrder.getLong("id"));
                    if (flag) continue;
                    AutoPushHelper.autoPushBill((Object)deliveryOrder.getLong("id"), (String)"ocococ_deliveryorder", (String)"im_saloutbill", (String)"audit");
                }
            }
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"EntityId") && returnData instanceof Boolean && ((Boolean)returnData).booleanValue()) {
            NotificationUtil.showDefaultSuccessNotification((String)"\u5e8f\u5217\u53f7\u8865\u5f55\u5b8c\u6210\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d27\u3002", (IFormView)this.getView());
        }
    }
}

