/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.saleorder.ElectWarrantyHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.ReceiveTypeEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.formplugin.base.OcposListPlugin;

public class SalesOrderList
extends OcposListPlugin {
    private static final String ACTION_DISTRIBUTIONCHANGECLOSE = "distributionchangeclose";

    @Override
    protected String[] listBranchCols() {
        return new String[]{"salebranchid.name", "salebranchid.number", "saler.owner.number"};
    }

    @Override
    protected String branchKey() {
        return "salebranchid";
    }

    @Override
    protected String[] listChannelUserCols() {
        return new String[]{"saler.sysuser.name", "cashier.sysuser.name", "cashier.sysuser.number"};
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String entityId = ((IListView)this.getView()).getBillFormId();
        List filters = e.getQFilters();
        if (filters != null) {
            if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) {
                filters.add(new QFilter("isinitbill", "=", (Object)Boolean.FALSE));
            } else if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_init")) {
                QFilter filter = new QFilter("isinitbill", "=", (Object)Boolean.TRUE);
                long billTypeId = this.getBillTypeParameter();
                filter.and("basebilltype", "=", (Object)billTypeId);
                filters.add(filter);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        OperationStatus status = e.getParameter().getStatus();
        if (status.equals((Object)OperationStatus.EDIT) || status.equals((Object)OperationStatus.VIEW)) {
            ListSelectedRow row = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (ObjectUtils.isEmpty((Object)row)) {
                e.setCancel(true);
                return;
            }
            String entityId = ((IListView)this.getView()).getBillFormId();
            long billTypeId = row.getBillTypeID();
            if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_init")) {
                if (billTypeId == BillTypeEnum.RETAIL.getId()) {
                    e.getParameter().setCaption("\u521d\u59cb\u5316\u96f6\u552e\u5f00\u5355");
                } else if (billTypeId == BillTypeEnum.RESERVE.getId()) {
                    e.getParameter().setCaption("\u521d\u59cb\u5316\u9884\u8ba2\u5f00\u5355");
                }
            } else {
                String caption = BillTypeEnum.getNameById((long)billTypeId);
                e.getParameter().setCaption(caption);
            }
        } else if (status.equals((Object)OperationStatus.ADDNEW)) {
            String entityId = ((IListView)this.getView()).getBillFormId();
            String caption = "";
            if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) {
                caption = BillTypeEnum.RETAIL.getName();
            } else if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_final")) {
                caption = BillTypeEnum.FINAL.getName();
            } else if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_init")) {
                long billTypeId = this.getBillTypeParameter();
                if (billTypeId == BillTypeEnum.RETAIL.getId()) {
                    caption = "\u521d\u59cb\u5316\u96f6\u552e\u5f00\u5355";
                    e.getParameter().setCustomParam("biztype", (Object)BizTypeEnum.SALEBILL.getValue());
                } else if (billTypeId == BillTypeEnum.RESERVE.getId()) {
                    caption = "\u521d\u59cb\u5316\u9884\u8ba2\u5f00\u5355";
                    e.getParameter().setCustomParam("biztype", (Object)BizTypeEnum.SALEORDER.getValue());
                }
                e.getParameter().setCustomParam("isinitbill", (Object)Boolean.TRUE);
                e.getParameter().setCustomParam("basebilltype", (Object)billTypeId);
                e.getParameter().setCustomParam("receivingtype", (Object)ReceiveTypeEnum.GENERALCOLLECTION.getValue());
            }
            e.getParameter().setCaption(caption);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)op.getOperateKey(), (CharSequence)"importdata")) {
            IAppCache cache = AppCache.get((String)"ocpos");
            String entityId = ((IListView)this.getView()).getBillFormId();
            cache.put("type", (Object)entityId);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long billTypeId = customParams.getOrDefault("basebilltype", 0L);
            cache.put("billtype", (Object)billTypeId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult opResult = e.getOperationResult();
        if (ObjectUtils.isEmpty((Object)opResult) || !opResult.isSuccess()) {
            return;
        }
        ListSelectedRowCollection listSelectedRow = ((IListView)this.getView()).getSelectedRows();
        switch (e.getOperateKey()) {
            case "dodistchange": {
                this.showDeliveryChangeForm(listSelectedRow);
                break;
            }
            case "electwarranty": {
                this.electWarranty(listSelectedRow);
                break;
            }
            case "import": {
                this.showImportForm();
                break;
            }
        }
    }

    private void electWarranty(ListSelectedRowCollection listSelectedRow) {
        if (listSelectedRow.getPrimaryKeyValues().length > 1) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u4ec5\u9009\u62e9\u4e00\u6761\u5355\u636e\u751f\u6210\u3002", (IFormView)this.getView());
            return;
        }
        Object primaryKeyValue = listSelectedRow.get(0).getPrimaryKeyValue();
        DynamicObject selectEntry = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"ocpos_saleorder");
        if (!"S".equals(selectEntry.getString("salestatus"))) {
            NotificationUtil.showDefaultTipNotify((String)"\u5355\u636e\u672a\u7ed3\u7b97\uff0c\u65e0\u6cd5\u751f\u6210\u7535\u5b50\u4fdd\u4fee\u5355\u3002", (IFormView)this.getView());
            return;
        }
        DynamicObjectCollection goods = selectEntry.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)goods)) {
            NotificationUtil.showDefaultTipNotify((String)"\u4e0d\u786e\u8ba4\u5546\u54c1\uff0c\u6682\u4e0d\u652f\u6301\u751f\u6210\u7535\u5b50\u4fdd\u4fee\u5355\u3002", (IFormView)this.getView());
            return;
        }
        Long branchid = DynamicObjectUtils.getPkValue((DynamicObject)selectEntry.getDynamicObject("salebranchid"));
        String showMsg = this.getShowMsg(selectEntry, goods, branchid);
        if (StringUtils.isEmpty((CharSequence)showMsg)) {
            NotificationUtil.showDefaultTipNotify((String)"\u9884\u8ba2\u5546\u54c1\uff0c\u6682\u4e0d\u652f\u6301\u751f\u6210\u7535\u5b50\u4fdd\u4fee\u5355\u3002", (IFormView)this.getView());
            return;
        }
        this.getView().showMessage(showMsg);
    }

    private void showImportForm() {
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("basebilltype", this.getBillTypeParameter());
        customParams.put("BillFormId", "ocpos_saleorder");
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_importdata", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        this.getView().showForm(parameter);
    }

    private void showDeliveryChangeForm(ListSelectedRowCollection listSelectedRow) {
        ArrayList<Object> lstDetailId = new ArrayList<Object>(0);
        for (Object selectedRow : listSelectedRow) {
            Object subEntryPrimaryKeyValue = selectedRow.getSubEntryPrimaryKeyValue();
            if (ObjectUtils.isEmpty((Object)subEntryPrimaryKeyValue)) {
                NotificationUtil.showDefaultTipNotify((String)String.format("\u8ba2\u5355\u53f7\uff1a\u3010%s\u3011,\u672a\u83b7\u53d6\u5230\u914d\u9001\u660e\u7ec6\u4fe1\u606f\u3002", selectedRow.getBillNo()), (IFormView)this.getView());
                return;
            }
            if (lstDetailId.contains(subEntryPrimaryKeyValue)) continue;
            lstDetailId.add(subEntryPrimaryKeyValue);
        }
        DynamicObjectCollection queryDelivery = SaleOrderHelper.queryDelivery(lstDetailId);
        if (lstDetailId.isEmpty() || CollectionUtils.isEmpty((Collection)queryDelivery)) {
            NotificationUtil.showDefaultTipNotify((String)"\u672a\u83b7\u53d6\u5230\u914d\u9001\u660e\u7ec6\u4fe1\u606f\u3002", (IFormView)this.getView());
            return;
        }
        for (DynamicObject delivery : queryDelivery) {
            String billNo = DynamicObjectUtils.getString((DynamicObject)delivery, (String)"billno");
            BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)delivery, (String)"goodsentryentity.mustretqty");
            boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)delivery, (String)"goodsentryentity.salesorderdelivery.deliverisdelivery");
            if (isDelivery && mustRetQty.abs().compareTo(BigDecimal.ZERO) != 0) continue;
            this.getView().showErrorNotification(String.format("\u8ba2\u5355\u53f7\uff1a%s\uff0c\u5f53\u524d\u9009\u62e9\u7684\u5546\u54c1\u5df2\u9000\u6216\u5df2\u8f6c\u9500\u5b8c\uff0c\u65e0\u9700\u8fdb\u884c\u914d\u9001\u8c03\u6574\u3002", billNo));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(0);
        customParams.put("subEntryPrimaryKeyValue", lstDetailId);
        customParams.put("parentformtype", "1");
        customParams.put("EntityNumber", "ocpos_saleorder");
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_distributionchange", (ShowType)ShowType.Modal, null, customParams);
        parameter.setShowTitle(true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_DISTRIBUTIONCHANGECLOSE));
        this.getView().showForm(parameter);
    }

    private String getShowMsg(DynamicObject selectEntry, DynamicObjectCollection goods, Long branchId) {
        StringBuilder stringBuilder = new StringBuilder();
        List entryId = goods.stream().filter(s -> !s.getBoolean("isbook")).map(DynamicObjectUtils::getPkValue).collect(Collectors.toList());
        QFilter filter1 = new QFilter("billentryid", "in", entryId);
        DynamicObject[] electWarranty = BusinessDataServiceHelper.load((String)"ocpos_electwarranty", (String)String.join((CharSequence)",", "billentryid", "goodsid"), (QFilter[])filter1.toArray());
        ArrayList<Long> electId = new ArrayList<Long>();
        if (electWarranty != null && electWarranty.length > 0) {
            for (DynamicObject dynamicObject : electWarranty) {
                electId.add(dynamicObject.getLong("billentryid"));
                stringBuilder.append(dynamicObject.getDynamicObject("goodsid").getString("number")).append(": \u5546\u54c1\u5df2\u751f\u6210\u7535\u5b50\u4fdd\u4fee\u5355\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
                stringBuilder.append("\r\n");
            }
        }
        entryId.removeAll(electId);
        List unElects = goods.stream().filter(s -> entryId.contains(DynamicObjectUtils.getPkValue((DynamicObject)s))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(unElects)) {
            return stringBuilder.toString();
        }
        DynamicObject[] electWarrantyModes = ElectWarrantyHelper.getElectWarrantyModes((long)branchId, unElects);
        for (DynamicObject elect : unElects) {
            DynamicObject warranty = ElectWarrantyHelper.buildElectWarranty((DynamicObject)selectEntry, (long)branchId, (DynamicObject)elect, (DynamicObject[])electWarrantyModes);
            if (warranty != null) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{warranty});
                stringBuilder.append(elect.getDynamicObject("goodsid").getString("number")).append(": \u5546\u54c1\u6210\u529f\u751f\u6210\u7535\u5b50\u4fdd\u4fee\u5355");
            } else {
                stringBuilder.append(elect.getDynamicObject("goodsid").getString("number")).append(": \u5546\u54c1\u672a\u9884\u7f6e\u7535\u5b50\u4fdd\u4fee\u7684\u6a21\u677f\uff0c\u65e0\u6cd5\u751f\u6210\u7535\u5b50\u4fdd\u4fee\u5355");
            }
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    private long getBillTypeParameter() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        return CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("basebilltype", BillTypeEnum.RETAIL.getId()));
    }
}

