/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.ReceiveTypeEnum;
import kd.occ.ocpos.formplugin.base.OcposListPlugin;

public class SalesReturnOrderList
extends OcposListPlugin {
    private static final String ACTION_DISTRIBUTIONCHANGECLOSE = "distributionchangeclose";

    @Override
    protected String[] listBranchCols() {
        return new String[]{"salebranchid.number", "salebranchid.name"};
    }

    @Override
    protected String branchKey() {
        return "salebranchid";
    }

    @Override
    protected String[] listChannelUserCols() {
        return new String[]{"saler.sysuser.name", "cashier.sysuser.number", "cashier.sysuser.name"};
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String entityId = ((IListView)this.getView()).getBillFormId();
        List filters = e.getQFilters();
        if (filters != null) {
            if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_re_init")) {
                QFilter filter = new QFilter("isinitbill", "=", (Object)Boolean.TRUE);
                String bizType = BizTypeEnum.SALERETURN.getValue();
                filter.and("biztype", "=", (Object)bizType);
                filters.add(filter);
            } else {
                filters.add(new QFilter("isinitbill", "=", (Object)Boolean.FALSE));
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        OperationStatus status = e.getParameter().getStatus();
        if (status.equals((Object)OperationStatus.EDIT) || status.equals((Object)OperationStatus.VIEW)) {
            String caption;
            ListSelectedRow row = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (ObjectUtils.isEmpty((Object)row)) {
                e.setCancel(true);
                return;
            }
            String entityId = ((IListView)this.getView()).getBillFormId();
            if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_re_init")) {
                caption = "\u521d\u59cb\u5316\u96f6\u552e\u9000\u8d27";
            } else {
                Object billId = row.getPrimaryKeyValue();
                DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"ocpos_saleorder_return");
                String bizType = DynamicObjectUtils.getString((DynamicObject)bill, (String)"biztype");
                caption = BizTypeEnum.getName((String)bizType);
            }
            e.getParameter().setCaption(caption);
        } else if (status.equals((Object)OperationStatus.ADDNEW)) {
            String entityId = ((IListView)this.getView()).getBillFormId();
            String caption = "";
            if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_re_init")) {
                caption = "\u521d\u59cb\u5316\u96f6\u552e\u9000\u8d27";
                e.getParameter().setCustomParam("isinitbill", (Object)Boolean.TRUE);
            } else {
                caption = BizTypeEnum.SALERETURN.getName();
            }
            e.getParameter().setCustomParam("basebilltype", (Object)BillTypeEnum.RETURN.getId());
            e.getParameter().setCustomParam("receivingtype", (Object)ReceiveTypeEnum.SALECOLLECTION.getValue());
            e.getParameter().setCustomParam("biztype", (Object)BizTypeEnum.SALERETURN.getValue());
            e.getParameter().setCaption(caption);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)op.getOperateKey(), (CharSequence)"importdata")) {
            IAppCache cache = AppCache.get((String)"ocpos");
            String entityId = ((IListView)this.getView()).getBillFormId();
            cache.put("type", (Object)entityId);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long billTypeId = customParams.getOrDefault("basebilltype", 0L);
            cache.put("billtype", (Object)billTypeId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult opResult = e.getOperationResult();
        if (ObjectUtils.isEmpty((Object)opResult) || !opResult.isSuccess()) {
            return;
        }
        if (StringUtils.equals((CharSequence)e.getOperateKey(), (CharSequence)"import")) {
            this.showImportForm();
        }
        if (StringUtils.equals((CharSequence)e.getOperateKey(), (CharSequence)"dodistchange")) {
            ListSelectedRowCollection listSelectedRow = ((IListView)this.getView()).getSelectedRows();
            this.showDeliveryChangeForm(listSelectedRow);
        }
    }

    private void showImportForm() {
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("basebilltype", BillTypeEnum.RETURN.getId());
        customParams.put("BillFormId", "ocpos_saleorder_return");
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_importdata", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        this.getView().showForm(parameter);
    }

    private void showDeliveryChangeForm(ListSelectedRowCollection listSelectedRow) {
        ArrayList<Object> lstDetailId = new ArrayList<Object>(0);
        for (ListSelectedRow selectedRow : listSelectedRow) {
            Object subEntryPrimaryKeyValue = selectedRow.getSubEntryPrimaryKeyValue();
            if (ObjectUtils.isEmpty((Object)subEntryPrimaryKeyValue)) {
                NotificationUtil.showDefaultTipNotify((String)String.format("\u8ba2\u5355\u53f7\uff1a\u3010%s\u3011,\u672a\u83b7\u53d6\u5230\u914d\u9001\u660e\u7ec6\u4fe1\u606f\u3002", selectedRow.getBillNo()), (IFormView)this.getView());
                return;
            }
            if (lstDetailId.contains(subEntryPrimaryKeyValue)) continue;
            lstDetailId.add(subEntryPrimaryKeyValue);
        }
        DynamicObjectCollection queryDelivery = SaleOrderHelper.queryReturnDelivery(lstDetailId);
        if (lstDetailId.isEmpty() || CollectionUtils.isEmpty((Collection)queryDelivery)) {
            NotificationUtil.showDefaultTipNotify((String)"\u672a\u83b7\u53d6\u5230\u914d\u9001\u660e\u7ec6\u4fe1\u606f\u3002", (IFormView)this.getView());
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(0);
        customParams.put("subEntryPrimaryKeyValue", lstDetailId);
        customParams.put("parentformtype", "1");
        customParams.put("EntityNumber", "ocpos_saleorder_return");
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_distributionchange", (ShowType)ShowType.Modal, null, customParams);
        parameter.setShowTitle(true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_DISTRIBUTIONCHANGECLOSE));
        this.getView().showForm(parameter);
    }
}

