/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.msg.AbstractMessageServiceHandler;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.SMSServiceHandler;
import kd.bos.workflow.engine.msg.handler.WeixinqyServiceHandler;
import kd.bos.workflow.engine.msg.handler.YunzhijiaServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;

public class CreditAuthCodeEditPlugin
extends AbstractFormPlugin {
    private static final String AUTH_CODE = "authcode";
    private static final String P_MSG_TEMPLATE = "msg_template";
    private static final String ACTION_CREDIT_AUTH_USER_CLOSE = "creditauthuserlistclose";
    private static final Log log = LogFactory.getLog(CreditAuthCodeEditPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showCreditAuthUserList();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm"});
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            this.getView().close();
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)ACTION_CREDIT_AUTH_USER_CLOSE) && returnData instanceof DynamicObject) {
            DynamicObject doUser = (DynamicObject)returnData;
            long userId = DynamicObjectUtils.getPkValue((DynamicObject)doUser, (String)"sysuser");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            long billId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("Id", 0L));
            BigDecimal creditAmount = CommonUtil.formatObjectToDecimal((Object)customParams.getOrDefault("settleamount", BigDecimal.ZERO));
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdbd_posauthorizerule");
            Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
            DynamicObject posAuthRule = QueryServiceHelper.queryOne((String)"ocdbd_posauthorizerule", (String)StringUtils.join((Object[])fieldKeys, (char)','), null);
            if (ObjectUtils.isEmpty((Object)posAuthRule)) {
                return;
            }
            String ruleType = DynamicObjectUtils.getString((DynamicObject)posAuthRule, (String)"ruletype");
            long msgTemplateId = DynamicObjectUtils.getLong((DynamicObject)posAuthRule, (String)"msgtemplate");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)ruleType)) {
                String msgCheckAccess = DynamicObjectUtils.getString((DynamicObject)posAuthRule, (String)"msgcheckaccess");
                String verificationCodeNum = DynamicObjectUtils.getString((DynamicObject)posAuthRule, (String)"verificationcodenum");
                String authCode = this.getAuthCode(verificationCodeNum);
                MessageInfo message = this.getMessageInfo(userId, billId, msgTemplateId, authCode, creditAmount);
                MessageContext messageContext = new MessageContext();
                if (StringUtils.equals((CharSequence)"1", (CharSequence)msgCheckAccess)) {
                    message.setNotifyType(MessageChannels.SMS.getNumber());
                    this.sendAuthCode(authCode, message, messageContext, (AbstractMessageServiceHandler)new SMSServiceHandler());
                } else if (StringUtils.equals((CharSequence)"2", (CharSequence)msgCheckAccess)) {
                    message.setNotifyType(MessageChannels.YUNZHIJIA.getNumber());
                    this.sendAuthCode(authCode, message, messageContext, (AbstractMessageServiceHandler)new YunzhijiaServiceHandler());
                } else if (StringUtils.equals((CharSequence)"3", (CharSequence)msgCheckAccess)) {
                    message.setNotifyType(MessageChannels.WEIXINQY.getNumber());
                    this.sendAuthCode(authCode, message, messageContext, (AbstractMessageServiceHandler)new WeixinqyServiceHandler());
                }
            } else {
                String sMsgCheckAccess = DynamicObjectUtils.getString((DynamicObject)posAuthRule, (String)"smsgcheckaccess");
                String sVerificationCodeNum = DynamicObjectUtils.getString((DynamicObject)posAuthRule, (String)"sverificationcodenum");
                String authCode = this.getAuthCode(sVerificationCodeNum);
                MessageInfo message = this.getMessageInfo(userId, billId, msgTemplateId, authCode, creditAmount);
                MessageContext messageContext = new MessageContext();
                if (StringUtils.equals((CharSequence)"1", (CharSequence)sMsgCheckAccess)) {
                    message.setNotifyType(MessageChannels.SMS.getNumber());
                    this.sendAuthCode(authCode, message, messageContext, (AbstractMessageServiceHandler)new SMSServiceHandler());
                } else if (StringUtils.equals((CharSequence)"2", (CharSequence)sMsgCheckAccess)) {
                    message.setNotifyType(MessageChannels.YUNZHIJIA.getNumber());
                    this.sendAuthCode(authCode, message, messageContext, (AbstractMessageServiceHandler)new YunzhijiaServiceHandler());
                } else if (StringUtils.equals((CharSequence)"3", (CharSequence)sMsgCheckAccess)) {
                    message.setNotifyType(MessageChannels.WEIXINQY.getNumber());
                    this.sendAuthCode(authCode, message, messageContext, (AbstractMessageServiceHandler)new WeixinqyServiceHandler());
                }
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)ctrl.getKey(), (CharSequence)"btn_confirm")) {
            String authCode = this.getModel().getValue(AUTH_CODE).toString();
            if (StringUtils.isEmpty((CharSequence)authCode)) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\u3002", (IFormView)this.getView());
                return;
            }
            String confirmAuthCode = this.getView().getPageCache().get(AUTH_CODE + this.getView().getPageId());
            if (!StringUtils.equals((CharSequence)confirmAuthCode, (CharSequence)authCode)) {
                NotificationUtil.showDefaultTipNotify((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u3002", (IFormView)this.getView());
                return;
            }
            this.getView().returnDataToParent((Object)"OK");
            this.getView().close();
        }
    }

    private String getAuthCode(String verificationCodeNum) {
        String authCode;
        switch (verificationCodeNum) {
            case "2": {
                authCode = this.getRandom(5);
                break;
            }
            case "3": {
                authCode = this.getRandom(6);
                break;
            }
            default: {
                authCode = this.getRandom(4);
            }
        }
        return authCode;
    }

    public String getRandom(int len) {
        String source = "0123456789";
        StringBuilder sb = new StringBuilder();
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < len; ++i) {
            sb.append(source.charAt(random.nextInt(10)));
        }
        return sb.toString();
    }

    private void showCreditAuthUserList() {
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_creditauthuserlist", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, (Map)this.getView().getFormShowParameter().getCustomParams());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_CREDIT_AUTH_USER_CLOSE));
        parameter.setShowTitle(false);
        this.getView().showForm(parameter);
    }

    private void sendAuthCode(String authCode, MessageInfo message, MessageContext messageContext, AbstractMessageServiceHandler serviceHandler) {
        try {
            serviceHandler.sendMessage(messageContext, message);
            NotificationUtil.showDefaultTipNotify((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\u3002", (IFormView)this.getView());
            this.getView().getPageCache().put(AUTH_CODE + this.getPageCache().getPageId(), authCode);
        }
        catch (Exception e) {
            NotificationUtil.showDefaultTipNotify((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6d88\u606f\u65e5\u5fd7\u3002", (IFormView)this.getView());
            log.error("\u96f6\u552e\u8d4a\u9500\u6536\u6b3e\u8d4a\u9500\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25" + e.getMessage());
        }
    }

    private MessageInfo getMessageInfo(long userId, long billId, long msgTemplateId, String authCode, BigDecimal creditAmount) {
        String msgContent;
        MessageInfo message = new MessageInfo();
        LocaleString title = new LocaleString();
        title.setLocaleValue_en("Auth code");
        title.setLocaleValue_zh_CN("\u6388\u6743\u9a8c\u8bc1\u7801");
        title.setLocaleValue_zh_TW("");
        if (msgTemplateId > 0L && billId > 0L) {
            DynamicObjectType saleOrderDt;
            DynamicObject doMsgTemplate = BusinessDataServiceHelper.loadSingle((Object)msgTemplateId, (String)P_MSG_TEMPLATE);
            DynamicObject doSaleOrder = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_saleorder");
            String svMsgTemplate = DynamicObjectUtils.getString((DynamicObject)doMsgTemplate, (String)"msgtemplate");
            JSONObject jsonTemplate = JSONObject.parseObject((String)svMsgTemplate);
            String mContent = jsonTemplate.getString("content");
            if (!StringUtils.isEmpty((CharSequence)mContent) && (saleOrderDt = doSaleOrder.getDynamicObjectType()) != null) {
                DataEntityPropertyCollection properties = saleOrderDt.getProperties();
                for (IDataEntityProperty property : properties) {
                    Date date;
                    String key = property.getName();
                    String oldChar = String.format("{%s}", key);
                    if (!mContent.contains(oldChar)) continue;
                    String newValue = DynamicObjectUtils.getString((DynamicObject)doSaleOrder, (String)property.getName());
                    if (StringUtils.equals((CharSequence)key, (CharSequence)"creditamount")) {
                        DecimalFormat df = new DecimalFormat("0.00");
                        newValue = df.format(creditAmount);
                    }
                    if (key.contains("date") && (date = DynamicObjectUtils.getDate((DynamicObject)doSaleOrder, (String)key)) != null) {
                        newValue = DateUtil.getDateFormat((Date)date, (String)"yyyy-MM-dd");
                    }
                    mContent = mContent.replace(oldChar, newValue);
                }
            }
            msgContent = mContent + authCode;
        } else {
            msgContent = authCode;
        }
        LocaleString content = new LocaleString();
        content.setLocaleValue_en("");
        content.setLocaleValue_zh_CN(msgContent);
        content.setLocaleValue_zh_TW("");
        ArrayList<Long> receivers = new ArrayList<Long>(0);
        receivers.add(userId);
        LocaleString tag = new LocaleString();
        tag.setLocaleValue("\u91cd\u8981");
        message.setMessageTitle((ILocaleString)title);
        message.setMessageContent((ILocaleString)content);
        message.setUserIds(receivers);
        message.setType("message");
        message.setEntityNumber("ocpos_saleorder");
        message.setSenderId(Long.valueOf(UserServiceHelper.getCurrentUserId()));
        message.setBizDataId(Long.valueOf(billId));
        message.setMessageTag((ILocaleString)tag);
        message.setTplScene("success");
        return message;
    }
}

