/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.PayUtil;

public class CreditPayFormPlugin
extends AbstractFormPlugin {
    private static final String ACTION_CREDITPAYCONFIRM = "creditpayconfirm";
    private static final String ACTION_CREDITAUTHCDOECLOSE = "creditauthcodeclose";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm", "btn_apply"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        BigDecimal receivableAmount = CommonUtil.formatObjectToDecimal((Object)customParams.getOrDefault("receivableamount", BigDecimal.ONE));
        this.getModel().setValue("receivableamount", (Object)receivableAmount);
        this.getModel().setValue("settleamount", (Object)receivableAmount);
        long currencyId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("settlecurrid", 0L));
        this.getModel().setItemValueByID("settlecurrid", (Object)currencyId);
        long creditAccountId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("creditaccountid", 0L));
        if (creditAccountId > 0L) {
            this.getModel().setItemValueByID("creditaccountid", (Object)creditAccountId);
            DynamicObject creditAccount = (DynamicObject)this.getModel().getValue("creditaccountid");
            BigDecimal limitBalance = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"limitbalance");
            this.getModel().setValue("limitbalance", (Object)limitBalance);
            long creditRuleId = DynamicObjectUtils.getPkValue((DynamicObject)creditAccount, (String)"creditruleid");
            this.getModel().setItemValueByID("creditruleid", (Object)creditRuleId);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (ctrl.getKey()) {
            case "btn_confirm": {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObject parentDataEntity = this.getView().getParentView().getModel().getDataEntity(true);
                if (StringUtils.equals((CharSequence)parentDataEntity.getDataEntityType().getName(), (CharSequence)"ocpos_salepay")) {
                    parentDataEntity = this.getView().getParentView().getParentView().getModel().getDataEntity(true);
                }
                DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)parentDataEntity, (String)"salebranchid");
                boolean hasCreditAuthItem = this.checkCashierAuthItem(parentDataEntity, 1135417618501760000L);
                if (!hasCreditAuthItem) {
                    long pkValue = DynamicObjectUtils.getPkValue((DynamicObject)parentDataEntity);
                    long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
                    DynamicObject data = QueryServiceHelper.queryOne((String)"ocdbd_posauthorizerule", (String)"id", null);
                    if (ObjectUtils.isEmpty((Object)data)) {
                        NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u6536\u94f6\u5458\u6ca1\u6709\u8d4a\u9500\u786e\u8ba4\u6743\u9650\u3002", (IFormView)this.getView());
                        return;
                    }
                    this.showAuthCodeForm(pkValue, branchId);
                    return;
                }
                this.confirmCreditPay(dataEntity, branch);
                break;
            }
            case "btn_apply": {
                this.showCreditTmpApplyForm();
                this.getView().close();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)ACTION_CREDITPAYCONFIRM) && e.getResult() == MessageBoxResult.Yes) {
            this.returnDataToParent();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String result;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)ACTION_CREDITAUTHCDOECLOSE) && returnData instanceof String && StringUtils.equals((CharSequence)(result = returnData.toString()), (CharSequence)"OK")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject parentDataEntity = this.getView().getParentView().getModel().getDataEntity(true);
            DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)parentDataEntity, (String)"salebranchid");
            this.confirmCreditPay(dataEntity, branch);
        }
    }

    private void confirmCreditPay(DynamicObject dataEntity, DynamicObject branch) {
        boolean isRight;
        String branchName = DynamicObjectUtils.getString((DynamicObject)branch, (String)"name");
        boolean isEnableCredit = DynamicObjectUtils.getBoolean((DynamicObject)branch, (String)"isenablecredit");
        DynamicObject creditAccount = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"creditaccountid");
        boolean bl = isRight = this.checkCreditAccount(creditAccount, isEnableCredit, branchName) && this.checkAmount(dataEntity, creditAccount, isEnableCredit);
        if (isRight) {
            this.returnDataToParent();
        }
    }

    private void showCreditTmpApplyForm() {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("isFromPos", Boolean.TRUE);
        DynamicObject creditAccount = (DynamicObject)this.getModel().getValue("creditaccountid");
        customParams.put("creditaccountid", DynamicObjectUtils.getPkValue((DynamicObject)creditAccount));
        IFormView parentView = this.getView().getParentView();
        String billNo = CommonUtil.formatStringToEmpty((Object)parentView.getModel().getValue("billno"));
        customParams.put("bizbillno", billNo);
        BaseShowParameter parameter = FormShowUtils.openNewBaseData((String)"", (String)"ocdbd_credittmpapply", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.getOpenStyle().setTargetKey("tab_add_apply");
        parentView.showForm((FormShowParameter)parameter);
    }

    private void showAuthCodeForm(long pkValue, long branchId) {
        HashMap<String, Number> customParams = new HashMap<String, Number>(2);
        customParams.put("Id", pkValue);
        customParams.put("salebranchid", branchId);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal creditAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"settleamount");
        customParams.put("settleamount", creditAmount);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_creditauthcode", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_CREDITAUTHCDOECLOSE));
        parameter.setShowTitle(false);
        this.getView().showForm(parameter);
    }

    private boolean checkCashierAuthItem(DynamicObject dataEntity, long authItemId) {
        try {
            DynamicObject cashier = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"cashier");
            long cashierRoleId = DynamicObjectUtils.getPkValue((DynamicObject)cashier, (String)"cashierid");
            DynamicObjectCollection authItemData = PayUtil.getAuthItemData((long)cashierRoleId);
            if (CollectionUtils.isEmpty((Collection)authItemData)) {
                return false;
            }
            return authItemData.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"authority") == authItemId && DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"isoperate"));
        }
        catch (Exception ex) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u6536\u94f6\u5458\u6536\u94f6\u89d2\u8272\u6743\u9650\u63a7\u5236\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", (IFormView)this.getView());
            return false;
        }
    }

    private void returnDataToParent() {
        HashMap<String, Comparable<BigDecimal>> params = new HashMap<String, Comparable<BigDecimal>>(8);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal amount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"settleamount");
        params.put("settleamount", amount);
        DynamicObject currency = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"settlecurrid");
        params.put("settlecurrid", (Comparable<BigDecimal>)currency);
        DynamicObject payWay = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"setllementid");
        params.put("setllementid", (Comparable<BigDecimal>)payWay);
        DynamicObject payWayType = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"paywaytypeid");
        params.put("paywaytypeid", (Comparable<BigDecimal>)payWayType);
        params.put("paytime", TimeServiceHelper.now());
        DynamicObject account = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"creditaccountid");
        params.put("creditaccountid", (Comparable<BigDecimal>)account);
        this.getView().returnDataToParent(params);
        this.getView().close();
    }

    private boolean checkCreditAccount(DynamicObject creditAccount, boolean isEnableCredit, String branchName) {
        if (!isEnableCredit) {
            return true;
        }
        DynamicObject creditRule = (DynamicObject)this.getModel().getValue("creditruleid");
        return this.checkCreditRule(creditAccount, creditRule, branchName);
    }

    private boolean checkAmount(DynamicObject dataEntity, DynamicObject creditAccount, boolean isEnableCredit) {
        BigDecimal minSettleAmount;
        BigDecimal settleAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"settleamount");
        if (settleAmount.compareTo(minSettleAmount = this.getMinAmount(dataEntity, creditAccount, isEnableCredit)) > 0) {
            DynamicObject currency = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"settlecurrid");
            String sign = DynamicObjectUtils.getString((DynamicObject)currency, (String)"sign");
            String tip = String.format("\u5f53\u524d\u5355\u636e\u5141\u8bb8\u6700\u5927\u8d4a\u9500\u91d1\u989d\u4e3a\uff1a%s%s", sign, minSettleAmount.stripTrailingZeros().toPlainString());
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            return false;
        }
        return true;
    }

    private boolean checkCreditRule(DynamicObject creditAccount, DynamicObject creditRule, String branchName) {
        boolean allOverDue;
        String accountName = DynamicObjectUtils.getString((DynamicObject)creditAccount, (String)"name");
        DynamicObjectCollection ruleEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)creditRule, (String)"entity");
        if (CollectionUtils.isEmpty((Collection)ruleEntity)) {
            NotificationUtil.showDefaultTipNotify((String)String.format("\u5f53\u524d\u95e8\u5e97\u4fe1\u7528\u8d26\u6237%s\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", accountName), (IFormView)this.getView());
            return false;
        }
        DynamicObject ruleEntityRow = ruleEntity.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getStrPkValue((DynamicObject)x, (String)"billid"), (CharSequence)"ocpos_saleorder")).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)ruleEntityRow)) {
            NotificationUtil.showDefaultTipNotify((String)String.format("\u5f53\u524d\u95e8\u5e97\u4fe1\u7528\u8d26\u6237%s\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", accountName), (IFormView)this.getView());
            return false;
        }
        BigDecimal overDueDays = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"overduedays");
        BigDecimal overDueAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"overdueamount");
        BigDecimal limitBalance = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"limitbalance");
        boolean isCheckOverDays = DynamicObjectUtils.getBoolean((DynamicObject)ruleEntityRow, (String)"isckoverdays");
        boolean isCheckOverLimit = DynamicObjectUtils.getBoolean((DynamicObject)ruleEntityRow, (String)"isckoverlimit");
        boolean daysIsOverDue = isCheckOverDays && overDueDays.compareTo(BigDecimal.ZERO) > 0;
        boolean limitIsOver = isCheckOverLimit && overDueAmount.compareTo(BigDecimal.ZERO) > 0;
        boolean balanceIsNull = limitBalance.compareTo(BigDecimal.ZERO) <= 0;
        boolean isOverDue = false;
        if (daysIsOverDue || limitIsOver || balanceIsNull) {
            isOverDue = true;
        }
        boolean isAllOverDue = false;
        if (daysIsOverDue && limitIsOver && balanceIsNull) {
            isAllOverDue = true;
        }
        String overProOfGist = DynamicObjectUtils.getString((DynamicObject)ruleEntityRow, (String)"overproofgist");
        boolean overDue = isOverDue && StringUtils.equals((CharSequence)"A", (CharSequence)overProOfGist);
        boolean bl = allOverDue = isAllOverDue && StringUtils.equals((CharSequence)"B", (CharSequence)overProOfGist);
        if (overDue || allOverDue) {
            String ctrlGrade = DynamicObjectUtils.getString((DynamicObject)ruleEntityRow, (String)"controlgrade");
            boolean result = true;
            switch (ctrlGrade) {
                case "A": {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ACTION_CREDITPAYCONFIRM, (IFormPlugin)this);
                    String tip = String.format("\u95e8\u5e97%s\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u6216\u5b58\u5728\u903e\u671f\u5e94\u6536\u8d26\u6b3e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u8d4a\u9500\u6536\u6b3e\uff1f\u70b9\u51fb\u662f\uff0c\u53ef\u7ee7\u7eed\u4ea4\u6613\u3002", branchName);
                    this.getView().showConfirm(tip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    result = false;
                    break;
                }
                case "B": {
                    String tip = String.format("\u95e8\u5e97%s\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u6216\u5b58\u5728\u903e\u671f\u5e94\u6536\u8d26\u6b3e\uff0c\u4e0d\u5141\u8bb8\u8d4a\u9500\u6536\u6b3e\u3002", branchName);
                    NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
                    result = false;
                    break;
                }
            }
            return result;
        }
        return true;
    }

    private BigDecimal getMinAmount(DynamicObject dataEntity, DynamicObject creditAccount, boolean isEnableCredit) {
        BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"receivableamount");
        if (isEnableCredit) {
            ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
            list.add(receivableAmount);
            BigDecimal limitBalance = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"limitbalance");
            list.add(limitBalance);
            BigDecimal singleLimitAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"singlelimitamount");
            list.add(singleLimitAmount);
            return list.stream().min(Comparator.naturalOrder()).orElse(BigDecimal.ONE);
        }
        return receivableAmount;
    }
}

