/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class CustCompensationPayPlugin
extends OcbaseFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityId = (String)formShowParameter.getCustomParam("entityid");
        this.getModel().setValue("payseq", formShowParameter.getCustomParam("payseq"));
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)entityId);
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"currencyid");
        this.getModel().setValue("currency", (Object)currencyId);
        this.getModel().setValue("paycurrency", (Object)currencyId);
        BigDecimal needPayAmount = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("needpayamount"));
        BigDecimal payBackAmount = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("paybackamount"));
        this.getModel().setValue("amount", (Object)payBackAmount);
        this.getModel().setValue("needpayamount", (Object)needPayAmount);
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return;
        }
        BigDecimal sumIntegratedAmount = BigDecimal.ZERO;
        BigDecimal sumCouponDiscount = BigDecimal.ZERO;
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            sumIntegratedAmount = sumIntegratedAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"integraldistamount"));
            sumCouponDiscount = sumCouponDiscount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"coupondiscount"));
        }
        BigDecimal sumDiscount = sumIntegratedAmount.add(sumCouponDiscount);
        if (needPayAmount.abs().compareTo(sumDiscount.abs()) < 0) {
            sumDiscount = needPayAmount;
        }
        this.getModel().setValue("recoverableamount", (Object)sumDiscount);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            BigDecimal payAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("amount"));
            if (payAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showErrorNotification("\u9000\u6b3e\u91d1\u989d\u5e94\u5c0f\u4e8e0\u3002");
                return;
            }
            FormShowParameter parameter = this.getView().getFormShowParameter();
            BigDecimal needPayAmount = CommonUtil.formatObjectToDecimal((Object)parameter.getCustomParam("needpayamount"));
            if (needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showErrorNotification("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u53d1\u8d77\u652f\u4ed8\u3002");
                return;
            }
            BigDecimal recoverableAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("recoverableamount"));
            if (payAmount.abs().compareTo(needPayAmount.abs()) > 0) {
                this.getView().showErrorNotification("\u8f93\u5165\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u3002");
                return;
            }
            Object payWay = parameter.getCustomParam("payway");
            DynamicObject payCurrency = (DynamicObject)this.getModel().getValue("paycurrency");
            HashMap<String, Object> map = new HashMap<String, Object>(0);
            map.put("showamount", payAmount);
            map.put("paybackamount", BigDecimal.ZERO);
            map.put("paycurrency", payCurrency.getPkValue());
            map.put("payway", payWay);
            map.put("srcreplacepaywayid", CommonUtil.formatObejctToLong((Object)parameter.getCustomParam("srcreplacepaywayid")));
            map.put("paytime", TimeServiceHelper.now());
            map.put("payseq", this.getModel().getValue("payseq"));
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }
}

