/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocpos.business.pay.PosPayLogHelper;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.formplugin.saleorder.pay.SaleOrderPosPlugin;

public class SaleOrderBocScanPlugin
extends SaleOrderPosPlugin {
    private static final String QRCODE = "qrcode";

    @Override
    public void afterCreateNewData(EventObject e) {
        String saleOption;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String string = saleOption = formShowParameter.getCustomParam("saleoption") == null ? "1" : (String)formShowParameter.getCustomParam("saleoption");
        if (StringUtils.equals((CharSequence)"0", (CharSequence)saleOption)) {
            this.getModel().setValue(QRCODE, formShowParameter.getCustomParam("orderno"));
        }
    }

    public void afterBindData(EventObject e) {
        String saleOption;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String string = saleOption = formShowParameter.getCustomParam("saleoption") == null ? "1" : (String)formShowParameter.getCustomParam("saleoption");
        if (StringUtils.equals((CharSequence)"0", (CharSequence)saleOption)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{QRCODE});
        } else {
            TextEdit qrCode = (TextEdit)this.getView().getControl(QRCODE);
            qrCode.setFocus(true);
            qrCode.setFireFocus(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String saleOption = formShowParameter.getCustomParam("saleoption") == null ? "1" : (String)formShowParameter.getCustomParam("saleoption");
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)QRCODE) && StringUtils.equals((CharSequence)"1", (CharSequence)saleOption)) {
            Button button = (Button)this.getView().getControl("btnok");
            button.addClickListener((ClickListener)this);
            button.click();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String outPutData = e.getEventArgs();
        String eventName = e.getEventName();
        if (StringUtils.equals((CharSequence)eventName, (CharSequence)"getRequestDataByBOC")) {
            this.getView().setReturnData((Object)outPutData);
            this.getView().returnDataToParent((Object)outPutData);
            this.closePosForm(this.getView(), 33);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            this.getView().showLoading(new LocaleString("\u652f\u4ed8\u4e2d"));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String saleOption = this.getModel().getValue("saleoption").toString();
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"1") && this.getModel().getValue(QRCODE).toString() == "") {
                this.getView().showTipNotification("\u8bf7\u626b\u63cf\u624b\u673a\u6761\u7801");
                this.getView().hideLoading();
                return;
            }
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
            String qrCode = "";
            if (this.getModel().getValue(QRCODE) != "") {
                qrCode = this.getModel().getValue(QRCODE).toString();
            }
            String tranType = "00";
            String ogOrderNo = "";
            BigDecimal payAmt = new BigDecimal(this.getModel().getValue("payamount").toString());
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                boolean isSecondDay = DateUtil.comparePayDate((String)((String)formShowParameter.getCustomParam("paytime")));
                boolean isEqualPayAmount = CommonUtils.checkReturnEqualPayAmount((BigDecimal)payAmt, (String)formShowParameter.getCustomParam("payflowid").toString());
                tranType = !isSecondDay && isEqualPayAmount ? "01" : "05";
                ogOrderNo = this.getModel().getValue(QRCODE).toString();
            } else if (payAmt.compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showErrorNotification("\u652f\u4ed8\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
                this.getView().hideLoading();
                return;
            }
            String entityId = (String)formShowParameter.getCustomParam("entityid");
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)entityId);
            String billNo = DynamicObjectUtil.getString((DynamicObject)saleOrder, (String)"billno");
            BigDecimal hasPayAmount = (BigDecimal)formShowParameter.getCustomParam("haspayamount");
            boolean isCheckSuccess = SaleOrderPosPlugin.checkPayAmount(this.getView(), payAmt, hasPayAmount, saleOption);
            if (!isCheckSuccess) {
                return;
            }
            JSONObject data = new JSONObject();
            data.put("tranType", (Object)tranType);
            data.put("payAmt", (Object)payAmt.abs().toString());
            data.put("qrCode", (Object)qrCode);
            data.put("ogOrderNo", (Object)ogOrderNo);
            data.put("methodname", (Object)"HTTPBOCInterFace");
            PosPayLogHelper.savePayLog((String)billNo, (String)JSON.toJSONString((Object)data), (int)1);
            customcontrol.setData((Object)JSON.toJSONString((Object)data));
        }
    }
}

