/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.ocpos.business.commonhelper.AmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleOrderCashPayPlugin
extends OcbaseFormPlugin {
    private static final String AMOUNT = "amount";
    private static final String PAYCURRENCY = "paycurrency";
    private static final String NEEDPAYAMOUNT = "needpayamount";
    private static final String SALEOPTION = "saleoption";
    private static final String ORG = "org";

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        long bizOrgId = CommonUtil.formatObejctToLong((Object)parameter.getCustomParam("bizorgid"));
        String saleOption = (String)parameter.getCustomParam(SALEOPTION);
        BigDecimal needPayAmount = CommonUtil.formatObjectToDecimal((Object)parameter.getCustomParam(NEEDPAYAMOUNT));
        this.getModel().setValue(SALEOPTION, (Object)saleOption);
        this.getModel().setValue("bizorgid", (Object)bizOrgId);
        this.getModel().setValue("payway", parameter.getCustomParam("paywayid"));
        this.getModel().setValue("currency", parameter.getCustomParam("paycurrencyid"));
        this.getModel().setValue(PAYCURRENCY, parameter.getCustomParam("paycurrencyid"));
        this.getModel().setValue("biztype", parameter.getCustomParam("biztype"));
        this.getModel().setValue(NEEDPAYAMOUNT, parameter.getCustomParam(NEEDPAYAMOUNT));
        this.getModel().setValue("payflowid", parameter.getCustomParam("payflowid"));
        this.getModel().setValue("refundmap", parameter.getCustomParam("refundmap"));
        if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"1")) {
            long branchId = CommonUtil.formatObejctToLong((Object)parameter.getCustomParam("salebranchid"));
            this.getModel().setValue(AMOUNT, (Object)AmountHelper.getAmountAfterWipeZeroMode((long)bizOrgId, (long)branchId, (BigDecimal)needPayAmount));
        } else if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{AMOUNT});
            this.getModel().setValue(AMOUNT, (Object)needPayAmount);
        } else {
            this.getView().showErrorNotification("\u9500\u552e\u65b9\u5411\u4e3a\u7a7a\u3002");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        DynamicObject payWay = (DynamicObject)this.getModel().getValue("payway");
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            BigDecimal inputAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue(AMOUNT));
            String saleOption = this.getModel().getValue(SALEOPTION).toString();
            BigDecimal showAmount = inputAmount;
            BigDecimal returnCashAmount = BigDecimal.ZERO;
            BigDecimal maxReturnCash = this.getMaxReturnCash();
            BigDecimal needpayamount = this.getModel().getDataEntity().getBigDecimal(NEEDPAYAMOUNT);
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"1")) {
                if (inputAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showErrorNotification("\u652f\u4ed8\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
                    return;
                }
                if (payWay.getLong("id") == 3L) {
                    returnCashAmount = inputAmount.subtract(needpayamount);
                } else {
                    if (needpayamount.compareTo(BigDecimal.ZERO) == 0) {
                        this.getView().showErrorNotification("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u53d1\u8d77\u652f\u4ed8\u3002");
                        return;
                    }
                    if (inputAmount.compareTo(needpayamount) > 0) {
                        this.getModel().setValue(AMOUNT, (Object)needpayamount);
                        this.getView().showErrorNotification("\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8fd8\u9700\u652f\u4ed8\u91d1\u989d");
                        return;
                    }
                }
            } else if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                if (inputAmount.compareTo(BigDecimal.ZERO) >= 0) {
                    this.getView().showErrorNotification("\u9000\u6b3e\u91d1\u989d\u5e94\u5c0f\u4e8e0\u3002");
                    return;
                }
                returnCashAmount = needpayamount.subtract(inputAmount);
            } else {
                this.getView().showErrorNotification("\u652f\u4ed8\u65b9\u5411\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return;
            }
            if (returnCashAmount.compareTo(maxReturnCash) > 0) {
                this.getModel().setValue(AMOUNT, (Object)needpayamount);
                this.getView().showErrorNotification("\u8d85\u8fc7\u6700\u5927\u627e\u96f6\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                return;
            }
            if (returnCashAmount.compareTo(BigDecimal.ZERO) < 0) {
                returnCashAmount = BigDecimal.ZERO;
            }
            showAmount = StringUtils.equals((CharSequence)saleOption, (CharSequence)"1") ? inputAmount.subtract(returnCashAmount) : inputAmount.add(returnCashAmount);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            HashMap<String, Object> map = new HashMap<String, Object>(0);
            map.put("showamount", showAmount);
            map.put(PAYCURRENCY, this.getModel().getValue(PAYCURRENCY));
            map.put("returncashamount", returnCashAmount);
            map.put("payflowid", this.getModel().getValue("payflowid"));
            map.put("refundmap", this.getModel().getValue("refundmap"));
            map.put("payway", payWay);
            map.put("srcpaywaytype", SaleOrderHelper.getPayWayType((DynamicObject)payWay));
            map.put("srcreplacepaywayid", CommonUtil.formatObejctToLong((Object)parameter.getCustomParam("srcreplacepaywayid")));
            map.put("paytime", TimeServiceHelper.now());
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private BigDecimal getMaxReturnCash() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)ORG);
        if (orgId == 0L) {
            return BigDecimal.ZERO;
        }
        long branchId = (Long)this.getView().getFormShowParameter().getCustomParam("salebranchid");
        boolean controlCashReturn = SystemParamUtil.isControlCashReturn((long)orgId, (long)branchId);
        if (controlCashReturn) {
            Object maxCashReturn = SystemParamUtil.getMaxCashReturn((long)orgId, (long)branchId);
            if (!ObjectUtils.isEmpty((Object)maxCashReturn)) {
                return (BigDecimal)maxCashReturn;
            }
            return BigDecimal.ZERO;
        }
        return BigDecimal.ZERO;
    }
}

