/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.ocpos.business.commonhelper.AmountHelper;
import kd.occ.ocpos.common.util.CommonUtil;

public class SaleOrderCreditPayPlugin
extends OcbaseFormPlugin {
    private static final String AMOUNT = "creditamount";
    private static final String CURRENCY = "currency";
    private static final String BUTTON_OK = "btnok";
    private static final String SALEOPTION = "saleoption";
    private static final String VAL_A = "A";
    private static final String VAL_B = "B";
    private static final String VAL_0 = "0";

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String saleOption = formShowParameter.getCustomParam(SALEOPTION) == null ? "1" : (String)formShowParameter.getCustomParam(SALEOPTION);
        this.getModel().setValue(SALEOPTION, (Object)saleOption);
        DynamicObject saleOrder = this.getSaleOrder(formShowParameter);
        if (saleOrder == null) {
            return;
        }
        DynamicObject currency = saleOrder.getDynamicObject("currencyid");
        this.getModel().setValue(CURRENCY, (Object)currency.getLong("Id"));
        BigDecimal needPayAmount = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("needpayamount"));
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        this.getModel().setValue("org", (Object)orgId);
        this.getModel().setValue("needpayamount", (Object)needPayAmount);
        this.getModel().setValue("payflowid", formShowParameter.getCustomParam("payflowid"));
        this.getModel().setValue(AMOUNT, (Object)needPayAmount);
        if (VAL_0.equalsIgnoreCase(saleOption)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{AMOUNT});
            this.getModel().setValue(AMOUNT, (Object)needPayAmount);
        } else {
            this.getModel().setValue(AMOUNT, (Object)AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (long)branchId, (BigDecimal)needPayAmount));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_OK});
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if (BUTTON_OK.equals(source.getKey())) {
            BigDecimal needPayAmount = new BigDecimal(this.getModel().getValue("needpayamount").toString());
            if (needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showErrorNotification("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u5df2\u4e3a0\uff0c\u65e0\u9700\u8d4a\u8d26\u3002");
                return;
            }
            BigDecimal creditAmount = new BigDecimal(this.getModel().getValue(AMOUNT).toString());
            String saleOption = this.getModel().getValue(SALEOPTION).toString();
            if (VAL_0.equalsIgnoreCase(saleOption)) {
                if (creditAmount.compareTo(BigDecimal.ZERO) > 0) {
                    this.getView().showErrorNotification("\u9500\u552e\u9000\u8d27\u8d4a\u8d26\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e0\u3002");
                    return;
                }
            } else {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                DynamicObject saleOrder = this.getSaleOrder(formShowParameter);
                if (saleOrder == null) {
                    return;
                }
                DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"salebranchid");
                if (branch == null) {
                    return;
                }
                boolean isEnableCredit = DynamicObjectUtils.getBoolean((DynamicObject)branch, (String)"isenablecredit");
                if (isEnableCredit && !this.checkCreditAmount()) {
                    return;
                }
            }
            if (creditAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showErrorNotification("\u8bf7\u8f93\u5165\u8d4a\u8d26\u91d1\u989d\u3002");
                return;
            }
            this.returnData();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"tosettleaccounts", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.returnData();
        }
    }

    private DynamicObject getSaleOrder(FormShowParameter formShowParameter) {
        String entityId = (String)formShowParameter.getCustomParam("entityid");
        return BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)entityId);
    }

    private void returnData() {
        BigDecimal creditAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue(AMOUNT));
        BigDecimal needPayAmount = new BigDecimal(this.getModel().getValue("needpayamount").toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = CommonUtil.formatObejctToLong((Object)org.getPkValue());
        long branchId = (Long)this.getView().getFormShowParameter().getCustomParam("salebranchid");
        BigDecimal wipeAmount = AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (long)branchId, (BigDecimal)needPayAmount);
        if (creditAmount.abs().compareTo(wipeAmount.abs()) > 0) {
            this.getView().showErrorNotification("\u8d4a\u8d26\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u3002");
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BigDecimal lastAmount = needPayAmount.subtract(creditAmount);
        if (creditAmount.compareTo(wipeAmount) == 0 && lastAmount.compareTo(BigDecimal.ZERO) != 0) {
            map.put("wipeamount", lastAmount);
        }
        map.put("showamount", this.getModel().getValue(AMOUNT));
        DynamicObject paycurrency = (DynamicObject)this.getModel().getValue(CURRENCY);
        map.put("paycurrency", paycurrency.getPkValue());
        map.put("payway", this.getModel().getValue("payway"));
        map.put("srcreplacepaywayid", CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("srcreplacepaywayid")));
        map.put("payflowid", this.getModel().getValue("payflowid"));
        map.put("paybillid", CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("paybillid")));
        map.put("refundmap", this.getModel().getValue("refundmap"));
        map.put("paytime", TimeServiceHelper.now());
        map.put("creditaccountid", formShowParameter.getCustomParam("creditaccountid"));
        map.put("payseq", formShowParameter.getCustomParam("payseq"));
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private boolean checkCreditAmount() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String creditAccountId = (String)formShowParameter.getCustomParam("creditaccountid");
        DynamicObject doCreditAccount = BusinessDataServiceHelper.loadSingle((Object)creditAccountId, (String)"ocdbd_credit_accountinfo");
        if (ObjectUtils.isEmpty((Object)doCreditAccount)) {
            this.getView().showMessage("\u4fe1\u7528\u8d26\u6237\u4e3a\u7a7a\u3002");
            return false;
        }
        BigDecimal limitBalance = DynamicObjectUtils.getBigDecimal((DynamicObject)doCreditAccount, (String)"limitbalance");
        BigDecimal singleLimitAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doCreditAccount, (String)"singlelimitamount");
        BigDecimal overdueAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doCreditAccount, (String)"overdueamount");
        long creditRuleId = DynamicObjectUtils.getPkValue((DynamicObject)doCreditAccount, (String)"creditruleid");
        if (creditRuleId <= 0L) {
            this.getView().showMessage("\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u4e3a\u7a7a\u3002");
            return false;
        }
        DynamicObject doCreditRule = BusinessDataServiceHelper.loadSingle((Object)creditRuleId, (String)"ocdbd_credit_rule");
        DynamicObjectCollection docCreditRuleEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doCreditRule, (String)"entity");
        if (ObjectUtils.isEmpty((Object)docCreditRuleEntry)) {
            this.getView().showMessage("\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u660e\u7ec6\u4e3a\u7a7a\u3002");
            return false;
        }
        DynamicObject doCreditRuleEntry = docCreditRuleEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getPkId((DynamicObject)x, (String)"billid").toString(), (CharSequence)"ocpos_saleorder")).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)doCreditRuleEntry)) {
            this.getView().showMessage("\u96f6\u552e\u5f00\u5355\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u660e\u7ec6\u4e3a\u7a7a\u3002");
            return false;
        }
        boolean isDue = false;
        boolean isAllDue = false;
        StringBuilder sbTips = new StringBuilder();
        BigDecimal creditAmount = CommonUtil.formatObjectToDecimal((Object)this.getView().getModel().getValue(AMOUNT));
        String overProOfGist = DynamicObjectUtils.getString((DynamicObject)doCreditRuleEntry, (String)"overproofgist");
        String controlGrade = DynamicObjectUtils.getString((DynamicObject)doCreditRuleEntry, (String)"controlgrade");
        if (creditAmount.compareTo(limitBalance) > 0 || creditAmount.compareTo(singleLimitAmount) > 0 || overdueAmount.compareTo(BigDecimal.ZERO) > 0) {
            isDue = true;
        }
        if (creditAmount.compareTo(limitBalance) > 0 && creditAmount.compareTo(singleLimitAmount) > 0 && overdueAmount.compareTo(BigDecimal.ZERO) > 0) {
            isAllDue = true;
        }
        switch (controlGrade) {
            case "A": {
                if (this.isOverProOfGist(isDue, isAllDue, overProOfGist)) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("tosettleaccounts", (IFormPlugin)this);
                sbTips.append(String.format("\u8d4a\u9500\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u6216\u5b58\u5728\u903e\u671f\u5e94\u6536\u8d26\u6b3e\u3001\u6216\u8d85\u8fc7\u5355\u7b14\u9650\u989d\u3001\u76ee\u524d\u4fe1\u7528\u4f59\u989d%.2f\uff0c\u672c\u6b21\u7ed3\u7b97\u91d1\u989d%.2f\uff0c\u65e0\u6cd5\u6ee1\u8db3\u652f\u4ed8\u9700\u6c42\uff0c\u8bf7\u4fee\u6539\u91d1\u989d\uff0c\u6216\u8005\u8c03\u6574\u4e34\u65f6\u8d4a\u9500\u4fe1\u7528\u989d\u5ea6\u3002", limitBalance, creditAmount));
                this.getView().showConfirm(sbTips.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return false;
            }
            case "B": {
                if (this.isOverProOfGist(isDue, isAllDue, overProOfGist)) break;
                sbTips.append(String.format("\u8d4a\u9500\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u6216\u5b58\u5728\u903e\u671f\u5e94\u6536\u8d26\u6b3e\u3001\u6216\u8d85\u8fc7\u5355\u7b14\u9650\u989d\u3001\u76ee\u524d\u4fe1\u7528\u4f59\u989d%.2f\uff0c\u672c\u6b21\u7ed3\u7b97\u91d1\u989d%.2f\uff0c\u65e0\u6cd5\u6ee1\u8db3\u652f\u4ed8\u9700\u6c42\uff0c\u8bf7\u4fee\u6539\u91d1\u989d\uff0c\u6216\u8005\u8c03\u6574\u4e34\u65f6\u8d4a\u9500\u4fe1\u7528\u989d\u5ea6\u3002", limitBalance, creditAmount));
                this.getView().showMessage(sbTips.toString());
                return false;
            }
        }
        if (limitBalance.compareTo(creditAmount) < 0) {
            this.getView().showErrorNotification(String.format("\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u76ee\u524d\u4fe1\u7528\u4f59\u989d%.2f\uff0c\u672c\u6b21\u7ed3\u7b97\u91d1\u989d%.2f", limitBalance, creditAmount));
            return false;
        }
        return true;
    }

    private boolean isOverProOfGist(boolean isDue, boolean isAllDue, String overProOfGist) {
        if (isDue && StringUtils.equals((CharSequence)VAL_A, (CharSequence)overProOfGist)) {
            return false;
        }
        return !isAllDue || !StringUtils.equals((CharSequence)VAL_B, (CharSequence)overProOfGist);
    }
}

