/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.pay.config.PayResult;
import kd.occ.ocbase.common.pay.config.RefundResult;
import kd.occ.ocbase.common.pay.payment.vo.PaymentRecord;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.ocpos.business.commonhelper.AmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class SaleOrderElectronicPayPlugin
extends OcbaseFormPlugin {
    private static final String AMOUNT = "amount";
    private static final String PAYABLEAMOUNT = "payableamount";
    private static final String AUTHCODE = "authcode";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String saleOption = formShowParameter.getCustomParam("saleoption") == null ? "1" : (String)formShowParameter.getCustomParam("saleoption");
        this.getModel().setValue("saleoption", (Object)saleOption);
        Object payAmount = formShowParameter.getCustomParam("haspayamount");
        this.getModel().setValue("payflowid", formShowParameter.getCustomParam("payflowid"));
        if (StringUtils.equals((CharSequence)"1", (CharSequence)saleOption)) {
            this.getModel().setValue(AMOUNT, payAmount);
            this.getModel().setValue(PAYABLEAMOUNT, payAmount);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{AMOUNT});
            String authCode = CommonUtil.formatStringToEmpty((String)((String)formShowParameter.getCustomParam("orderno")));
            this.getModel().setValue(AUTHCODE, (Object)authCode);
            this.getModel().setValue(AMOUNT, payAmount);
            this.getModel().setValue(PAYABLEAMOUNT, payAmount);
            if (StringUtils.isNotEmpty((CharSequence)authCode)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{AUTHCODE});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changeName = e.getProperty().getName();
        if (e.getChangeSet().length == 0) {
            return;
        }
        if (CommonUtil.checkChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        if (AUTHCODE.equals(changeName)) {
            this.saveElecPayRecordAfterOperate();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject e) {
        String saleOption;
        super.click(e);
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)source.getKey()) && StringUtils.equals((CharSequence)"0", (CharSequence)(saleOption = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("saleoption"))))) {
            this.saveElecPayRecordAfterOperate();
        }
    }

    protected void saveElecPayRecordAfterOperate() {
        long payWayTypeId;
        LocaleString paramLocaleString;
        BigDecimal totalAmount = BigDecimalUtil.toBigDecimal((Object)this.getModel().getValue(AMOUNT));
        String authCode = (String)this.getModel().getDataEntity(true).get(AUTHCODE);
        if (StringUtils.isEmpty((CharSequence)authCode)) {
            return;
        }
        String isFail = this.getPageCache().get("isfail");
        if (StringUtils.equals((CharSequence)isFail, (CharSequence)"1")) {
            this.getPageCache().put("isfail", "0");
            this.getModel().setValue(AUTHCODE, null);
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        String entityId = (String)formShowParameter.getCustomParam("entityid");
        long payWayId = CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("paywayid"));
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)entityId);
        String hasPayAmountStr = formShowParameter.getCustomParam("haspayamount").toString();
        BigDecimal needPayAmount = new BigDecimal(hasPayAmountStr);
        String saleOption = formShowParameter.getCustomParam("saleoption") == null ? "1" : (String)formShowParameter.getCustomParam("saleoption");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        BigDecimal finalWipeAmount = BigDecimal.ZERO;
        if (needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showErrorNotification("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u53d1\u8d77\u652f\u4ed8\u3002");
            return;
        }
        if (totalAmount.abs().compareTo(needPayAmount.abs()) > 0) {
            this.getView().showErrorNotification("\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u3002");
            return;
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)saleOption)) {
            needPayAmount = AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (long)branchId, (BigDecimal)needPayAmount);
            if (totalAmount.compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showErrorNotification("\u652f\u4ed8\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
                return;
            }
            paramLocaleString = new LocaleString("\u652f\u4ed8\u4e2d...");
        } else {
            if (totalAmount.compareTo(BigDecimal.ZERO) >= 0) {
                this.getView().showErrorNotification("\u9000\u6b3e\u91d1\u989d\u5e94\u5c0f\u4e8e0\u3002");
                return;
            }
            paramLocaleString = new LocaleString("\u9000\u6b3e\u4e2d...");
        }
        PaymentRecord payRecord = new PaymentRecord();
        payRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)saleOrder).longValue());
        payRecord.setBillNo(saleOrder.getString("billno"));
        long payFlowId = CommonUtil.formatObejctToLong((Object)this.getModel().getValue("payflowid"));
        payRecord.setPayFlowId(payFlowId);
        payRecord.setSourcebillId(DynamicObjectUtil.getLong((DynamicObject)saleOrder, (String)"sourcebillid"));
        payRecord.setOrderNo(authCode);
        DynamicObject payCurrency = saleOrder.getDynamicObject("currencyid");
        long payCurrencyId = Long.parseLong(payCurrency.getPkValue().toString());
        payRecord.setPayCurrency(payCurrency);
        DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)payWayId, (String)"ocdbd_paymode");
        payRecord.setPayWay(payWay);
        DynamicObject payType = StringUtils.equals((CharSequence)"1", (CharSequence)saleOption) ? SaleOrderHelper.getPayWayType((DynamicObject)payWay, (String)authCode) : ((payWayTypeId = CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("paywaytypeid"))) > 0L ? BusinessDataServiceHelper.loadSingle((Object)payWayTypeId, (String)"ocdbd_paywaytype") : SaleOrderHelper.getPayWayType((DynamicObject)payWay));
        payRecord.setPayWayType(payType);
        payRecord.setPaytime(TimeServiceHelper.now());
        payRecord.setAmount(totalAmount);
        this.getView().showLoading(paramLocaleString);
        JSONObject payResult = SaleOrderHelper.callUnifyElecSettle((DynamicObject)saleOrder, (PaymentRecord)payRecord, (String)saleOption);
        String suceessMsg = "";
        String failMsg = "";
        if (payResult.getBoolean("success").booleanValue()) {
            DynamicObjectCollection finEntryEntity = saleOrder.getDynamicObjectCollection("finentity");
            DynamicObject newFinEntity = finEntryEntity.addNew();
            if (StringUtils.equals((CharSequence)"1", (CharSequence)saleOption)) {
                SaleOrderHelper.updateSaleOrderAfterPayment((DynamicObject)saleOrder, (DynamicObject)newFinEntity, (PaymentRecord)payRecord, null);
                suceessMsg = "\u652f\u4ed8\u6210\u529f";
            } else {
                SaleOrderHelper.updateSaleOrderAfterRefund((DynamicObject)saleOrder, (DynamicObject)newFinEntity, (PaymentRecord)payRecord, null);
                suceessMsg = "\u9000\u6b3e\u6210\u529f";
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
            HashMap<String, Serializable> map = new HashMap<String, Serializable>(0);
            map.put("showamount", payRecord.getAmount());
            map.put("paycurrency", Long.valueOf(payCurrencyId));
            map.put("payway", (Serializable)payRecord.getPayWay());
            map.put("paywaytype", (Serializable)payRecord.getPayWayType());
            map.put("payflowid", Long.valueOf(payFlowId));
            map.put("paytime", payRecord.getPaytime());
            if (finalWipeAmount.compareTo(BigDecimal.ZERO) > 0) {
                map.put("wipeamount", finalWipeAmount);
            }
            this.getView().showConfirm(suceessMsg, MessageBoxOptions.OK);
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else {
            failMsg = StringUtils.equals((CharSequence)"1", (CharSequence)saleOption) ? "\u652f\u4ed8\u5931\u8d25:" + payResult.getString("errorMsg") : "\u9000\u6b3e\u5931\u8d25:" + payResult.getString("errorMsg");
            this.getView().showConfirm(failMsg, MessageBoxOptions.OK);
            this.getModel().setValue(AUTHCODE, null);
            this.getPageCache().put("isfail", "1");
        }
        this.getView().hideLoading();
    }

    protected StringBuilder getPayErrorMsg(PayResult payResult) {
        return new StringBuilder();
    }

    protected StringBuilder getRefundErrorMsg(RefundResult refundResult) {
        return new StringBuilder();
    }
}

