/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.pay.payment.vo.PaymentRecord;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocdbd.business.helper.CreditMangageHelper;
import kd.occ.ocdbd.common.util.StringUtil;
import kd.occ.ocpos.business.commonhelper.AmountHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.SaleStatusEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DateUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.PayUtil;
import kd.occ.ocpos.formplugin.saleorder.pay.SaleOrderStagePayPlugin;

public class SaleOrderPayInfoPlugin
extends AbstractFormPlugin {
    private static final int PAYMODEDISPALYNUMBERMAX = 16;
    private static final String OTHERPAYWAY = "-1000";
    private static final String PAYMODEBTNFLEX = "paymodebtnflex";
    private static final String ACTION_CREDITPAYCLOSE = "creditpayclose";
    private static final Log LOG = LogFactory.getLog(SaleOrderPayInfoPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String strBtnKeyPayModeIdMap = this.getPageCache().get("btnKeyPayModeIdMap");
        if (StringUtils.isEmpty((CharSequence)strBtnKeyPayModeIdMap)) {
            return;
        }
        Map btnKeyPayModeIdMap = (Map)JSONObject.parseObject((String)strBtnKeyPayModeIdMap, Map.class);
        if (!CollectionUtils.isEmpty((Map)btnKeyPayModeIdMap)) {
            this.addClickListeners(btnKeyPayModeIdMap.keySet().toArray(new String[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"creditpay"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        if (saleOrderId != null) {
            this.loadUsedMainPayMode();
            String entityId = this.getView().getParentView().getEntityId();
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)entityId, (String)this.getSelectFields(entityId));
            this.setValueBySaleOrder(saleOrder);
        }
    }

    private String getSelectFields(String entityId) {
        String selectFields = "id,biztype,bizorgid,salebranchid,customerid,basebilltype,currencyid,locurrencyid,sumbalamount,sumamount,sumdiscount,receivableamount,totalrealamount,depositamount,finentity.setllementid,finentity.paywaytypeid,finentity.settleamount,finentity.paytime,finentity.settlecurrid,finentity.bankstageactid";
        if (StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)"ocpos_salechange")) {
            selectFields = selectFields + "," + "changeitemtype";
        }
        return selectFields;
    }

    public void loadUsedMainPayMode() {
        String btnPayModeKey;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        long cashierRoleId = CommonUtil.formatObejctToLong((Object)parameter.getCustomParam("cashierid"));
        long posId = CommonUtil.formatObejctToLong((Object)parameter.getCustomParam("pos"));
        List displayPayModes = PayUtil.getDisplayPayModeData((long)cashierRoleId, (long)posId, (String)"main", (String)"1");
        HashMap<String, String> btnKeyPayModeIdMap = new HashMap<String, String>(0);
        ArrayList<String> mainOverPayModeIds = new ArrayList<String>(0);
        ArrayList<String> allowFinalPayModeIds = new ArrayList<String>(0);
        int payModeIndex = 1;
        if (!CollectionUtils.isEmpty((Collection)displayPayModes)) {
            for (JSONObject payMode : displayPayModes) {
                String payModeId = String.valueOf(payMode.getLongValue("id"));
                boolean isAllowFinalPay = payMode.getBooleanValue("isallowfinalpay");
                if (isAllowFinalPay) {
                    allowFinalPayModeIds.add(payModeId);
                }
                if (payModeIndex >= 16) {
                    mainOverPayModeIds.add(payModeId);
                    continue;
                }
                String payModeName = payMode.getString("name");
                btnPayModeKey = "btn_paymode_" + payModeIndex;
                HashMap<String, String> itemMap = new HashMap<String, String>(1);
                itemMap.put("zh_CN", payModeName);
                HashMap<String, Object> fieldMap = new HashMap<String, Object>(1);
                fieldMap.put("text", itemMap);
                String color = payMode.getBooleanValue("isdefault") ? "#FF0000" : "#000000";
                fieldMap.put("fc", color);
                this.getView().updateControlMetadata(btnPayModeKey, fieldMap);
                btnKeyPayModeIdMap.put(btnPayModeKey, payModeId);
                ++payModeIndex;
            }
        }
        btnPayModeKey = "btn_paymode_" + payModeIndex;
        HashMap<String, String> moreItemMap = new HashMap<String, String>();
        moreItemMap.put("zh_CN", "\u66f4\u591a\u652f\u4ed8\u65b9\u5f0f");
        HashMap<String, HashMap<String, String>> moreFieldMap = new HashMap<String, HashMap<String, String>>();
        moreFieldMap.put("text", moreItemMap);
        this.getView().updateControlMetadata(btnPayModeKey, moreFieldMap);
        btnKeyPayModeIdMap.put(btnPayModeKey, OTHERPAYWAY);
        if (++payModeIndex <= 16) {
            for (int i = payModeIndex; i <= 16; ++i) {
                btnPayModeKey = "btn_paymode_" + i;
                this.getView().setVisible(Boolean.FALSE, new String[]{btnPayModeKey});
            }
        }
        this.getPageCache().put("btnKeyPayModeIdMap", JSONObject.toJSONString(btnKeyPayModeIdMap));
        this.getPageCache().put("mainOverPayModeIds", JSONObject.toJSONString(mainOverPayModeIds));
        this.getPageCache().put("allowFinalPayModeIds", JSONObject.toJSONString(allowFinalPayModeIds));
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        String btnPayModeKey = ctrl.getKey();
        String strBtnKeyPayModeIdMap = this.getPageCache().get("btnKeyPayModeIdMap");
        if (StringUtils.isEmpty((CharSequence)strBtnKeyPayModeIdMap)) {
            return;
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{PAYMODEBTNFLEX});
        Map btnKeyPayModeIdMap = (Map)JSONObject.parseObject((String)strBtnKeyPayModeIdMap, Map.class);
        String payModeId = (String)btnKeyPayModeIdMap.get(btnPayModeKey);
        if (StringUtils.equals((CharSequence)payModeId, (CharSequence)OTHERPAYWAY)) {
            this.openOtherPayView(payModeId);
            return;
        }
        this.openPayViewById(payModeId);
    }

    private void openPayViewById(String payModeId) {
        this.getView().setEnable(Boolean.FALSE, new String[]{PAYMODEBTNFLEX});
        boolean isLockPayModeFlex = true;
        switch (payModeId) {
            case "1": {
                this.openScanPaymentPayView("ocpos_wechatpay", "elec_paymentclose", payModeId);
                break;
            }
            case "2": {
                this.openScanPaymentPayView("ocpos_alipay", "elec_paymentclose", payModeId);
                break;
            }
            case "3": {
                this.openCashCustomPayView("ocpos_cashpay", "cashcustomclose", payModeId, "");
                break;
            }
            case "4": {
                this.openCouponPayView("ocpos_ticketpay", "couponclose", payModeId);
                break;
            }
            case "7": {
                isLockPayModeFlex = false;
                this.getView().showMessage("\u62b9\u96f6\u6b63\u5728\u5f00\u53d1\u4e2d\u3002");
                break;
            }
            case "12": {
                this.openCashCustomPayView("ocpos_cashpay", "cashcustomclose", payModeId, "\u652f\u7968\u652f\u4ed8");
                break;
            }
            case "14": {
                isLockPayModeFlex = false;
                this.getView().showMessage("\u8ba2\u91d1\u6b63\u5728\u5f00\u53d1\u4e2d\u3002");
                break;
            }
            case "15": {
                isLockPayModeFlex = false;
                this.getView().showMessage("\u5e94\u6536\u8d26\u6b3e\u652f\u4ed8\uff0c\u8bf7\u70b9\u51fb\u83dc\u5355\uff1a\u8d4a\u9500\u6536\u6b3e\u3002");
                break;
            }
            case "19": 
            case "20": 
            case "21": {
                isLockPayModeFlex = false;
                this.getView().showMessage("\u4e0d\u80fd\u7528\u4e8e\u652f\u4ed8\u3002");
                break;
            }
            case "22": {
                this.openPosPayView(payModeId, "ocpos_abcpos", "abcClose");
                break;
            }
            case "23": {
                this.openPosPayView(payModeId, "ocpos_bocpos", "bocClose");
                break;
            }
            case "24": {
                this.openPosPayView(payModeId, "ocpos_ccbpos", "ccbClose");
                break;
            }
            case "25": {
                this.openPosPayView(payModeId, "ocpos_umspos", "umsClose");
                break;
            }
            case "26": {
                this.openStagePayView(payModeId);
                break;
            }
            case "27": {
                isLockPayModeFlex = false;
                this.getView().showMessage("\u6362\u8d27\u62b5\u6263\u4e0d\u80fd\u7528\u4e8e\u652f\u4ed8\u3002");
                break;
            }
            case "28": {
                this.openPosPayView(payModeId, "ocpos_scanpay", "ccbClose");
                break;
            }
            case "29": {
                this.openScanPaymentPayView("ocpos_kingdeefinancepay", "elec_paymentclose", payModeId);
                break;
            }
            case "31": {
                this.openPosPayView(payModeId, "ocpos_abcscan", "abcClose");
                break;
            }
            case "32": {
                this.openPosPayView(payModeId, "ocpos_umsscan", "elec_paymentclose");
                break;
            }
            case "33": {
                this.openPosPayView(payModeId, "ocpos_bocscan", "bocClose");
                break;
            }
            case "5": 
            case "6": 
            case "8": 
            case "9": 
            case "18": {
                isLockPayModeFlex = false;
                this.getView().showMessage("\u6b63\u5728\u5f00\u53d1\u4e2d\u3002");
                break;
            }
            default: {
                DynamicObject customPayment = BusinessDataServiceHelper.loadSingle((Object)payModeId, (String)"ocdbd_paymode");
                if (!customPayment.getBoolean("iselectronicpay")) {
                    this.openCashCustomPayView("ocpos_cashpay", "cashcustomclose", payModeId, customPayment.getString("name"));
                    break;
                }
                isLockPayModeFlex = false;
                this.getView().showMessage("\u6b63\u5728\u5f00\u53d1\u4e2d\u3002");
            }
        }
        if (!isLockPayModeFlex) {
            this.getView().setEnable(Boolean.TRUE, new String[]{PAYMODEBTNFLEX});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        long baseBillTypeId = CommonUtil.formatObejctToLong(customParams.get("basebilltype"));
        if (baseBillTypeId == 1041369866768349184L || baseBillTypeId == 1041370234709475328L || baseBillTypeId == 1041370619880798208L) {
            String strAllowFinalPayModeIds = this.getPageCache().get("allowFinalPayModeIds");
            if (StringUtils.isEmpty((CharSequence)strAllowFinalPayModeIds)) {
                return;
            }
            List allowFinalPayModeIds = (List)JSONObject.parseObject((String)strAllowFinalPayModeIds, List.class);
            String strBtnKeyPayModeIdMap = this.getPageCache().get("btnKeyPayModeIdMap");
            if (StringUtils.isEmpty((CharSequence)strBtnKeyPayModeIdMap)) {
                return;
            }
            Map btnKeyPayModeIdMap = (Map)JSONObject.parseObject((String)strBtnKeyPayModeIdMap, Map.class);
            allowFinalPayModeIds.add(OTHERPAYWAY);
            for (Map.Entry entry : btnKeyPayModeIdMap.entrySet()) {
                String payModeId = (String)entry.getValue();
                if (allowFinalPayModeIds.contains(payModeId)) continue;
                this.getView().setEnable(Boolean.FALSE, new String[]{(String)entry.getKey()});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        if ("paybill".equals(key)) {
            DynamicObjectCollection payList = this.getModel().getEntryEntity("payrecords");
            String errorMsg = this.checkBeforePayConfirm(saleOrderId, payList);
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            this.clickPayBtnExecuteSettle(formShowParameter, saleOrderId, payList);
        } else if (StringUtils.equals((CharSequence)"creditpay", (CharSequence)key)) {
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)this.getView().getParentView().getEntityId());
            this.showCreditPayForm(saleOrder);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("No".equals(messageBoxClosedEvent.getResultValue())) {
            return;
        }
        if (StringUtils.equals((CharSequence)"paybill", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object saleOrderId = formShowParameter.getCustomParam("Id");
            DynamicObjectCollection payList = this.getModel().getEntryEntity("payrecords");
            ArrayList<String> payRecordKeys = new ArrayList<String>(payList.size());
            DynamicObjectCollection repeatPayRecords = new DynamicObjectCollection();
            BigDecimal repeatAmount = BigDecimal.ZERO;
            for (DynamicObject payrecord : payList) {
                String paywayidstr = DynamicObjectUtils.getStrPkValue((DynamicObject)payrecord, (String)"payway");
                String cardno = payrecord.getString("cardno");
                String showamountstr = payrecord.getString("showamount");
                String paytimestr = payrecord.getString("paytime");
                String payrecordKey = paywayidstr + "-" + cardno + "-" + showamountstr + "-" + paytimestr;
                if (payRecordKeys.contains(payrecordKey)) {
                    repeatPayRecords.add((Object)payrecord);
                    repeatAmount = repeatAmount.add(payrecord.getBigDecimal("showamount"));
                }
                payRecordKeys.add(payrecordKey);
            }
            if (!CollectionUtils.isEmpty((Collection)repeatPayRecords)) {
                payList.removeAll((Collection)repeatPayRecords);
                BigDecimal needPayAmount = (BigDecimal)this.getView().getModel().getValue("needpayamount");
                this.getModel().setValue("needpayamount", (Object)needPayAmount.add(repeatAmount));
                this.getView().updateView();
            }
            this.clickPayBtnExecuteSettle(formShowParameter, saleOrderId, payList);
        }
    }

    public void clickPayBtnExecuteSettle(FormShowParameter formShowParameter, Object saleOrderId, DynamicObjectCollection payList) {
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)this.getView().getParentView().getEntityId());
        String saleStatus = saleOrder.getString("salestatus");
        if (StringUtils.equals((CharSequence)saleStatus, (CharSequence)SaleStatusEnum.STATUS_S.getValue())) {
            this.getView().showErrorNotification("\u5df2\u7ed3\u7b97\u5b8c\u6210\u3002\u8bf7\u5173\u95ed\u652f\u4ed8\u4fe1\u606f\u754c\u9762\u3002");
            return;
        }
        String billNo = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal needPayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
        if (payList != null && payList.size() > 0 && needPayAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.getView().showErrorNotification(String.format("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\uff1a%.2f\u5143\u3002", needPayAmount));
            return;
        }
        Map<String, Object> result = this.checkCreditAmount(dataEntity);
        if (!CommonUtil.formatObjectToBoolean((Object)result.get("result"))) {
            this.getView().showErrorNotification(CommonUtil.formatStringToEmpty((Object)result.get("msg")));
            this.getView().setVisible(Boolean.TRUE, new String[]{"creditpay"});
            return;
        }
        try {
            BigDecimal returnCashAmount;
            BigDecimal payBackAmount = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)payList)) {
                int rowSum = payList.size();
                int row = 1;
                for (DynamicObject record : payList) {
                    payBackAmount = payBackAmount.add(record.getBigDecimal("paybackamount"));
                    DynamicObject payWay = DynamicObjectUtils.getDynamicObject((DynamicObject)record, (String)"payway");
                    String payWayName = DynamicObjectUtils.getString((DynamicObject)payWay, (String)"name");
                    BigDecimal showamount = DynamicObjectUtils.getBigDecimal((DynamicObject)record, (String)"showamount");
                    LOG.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7ed3\u7b97\u652f\u4ed8\u5217\u8868\u5171%d\u884c\u7b2c%d\u884c%s\u91d1\u989d%.2f\u5143", billNo, rowSum, row++, payWayName, showamount));
                }
            }
            if (payBackAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showConfirm(String.format("\u8fd8\u9700\u627e\u96f6%.2f\u5143\u3002", payBackAmount), MessageBoxOptions.OK);
            }
            HashMap<String, String> discountHandleMap = new HashMap<String, String>(5);
            String ticketDiscountType = (String)formShowParameter.getCustomParam("ticketdiscounttype");
            discountHandleMap.put("ticketdiscounttype", ticketDiscountType);
            String integralDiscountType = (String)formShowParameter.getCustomParam("integraldiscounttype");
            discountHandleMap.put("integraldiscounttype", integralDiscountType);
            String giftDiscountType = (String)formShowParameter.getCustomParam("giftdiscounttype");
            discountHandleMap.put("giftdiscounttype", giftDiscountType);
            String giftValueData = (String)formShowParameter.getCustomParam("giftvalue");
            discountHandleMap.put("giftvalue", giftValueData);
            LOG.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7ed3\u7b97\u4fdd\u5b58\u7ed3\u7b97\u8bb0\u5f55", billNo));
            SaleOrderHelper.savePayRecordAfterSettleOp((DynamicObject)saleOrder, (DynamicObjectCollection)payList, discountHandleMap);
            String bizType = formShowParameter.getCustomParam("biztype").toString();
            if (StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)BizTypeEnum.CHANGE.getValue())) {
                BigDecimal exchangePayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"exchangepayamount");
                this.getView().getParentView().getModel().setValue("exchangepayamount", (Object)exchangePayAmount);
            }
            if ((returnCashAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"returncashamount")).compareTo(BigDecimal.ZERO) < 0) {
                HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
                returnMap.put("cashpay", "Success");
                returnMap.put("returncash", needPayAmount);
                this.getView().returnDataToParent(returnMap);
            } else {
                this.getView().returnDataToParent((Object)"Success");
            }
            LOG.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7ed3\u7b97\u786e\u8ba4\u6210\u529f", billNo));
            this.getView().close();
        }
        catch (Exception ex) {
            LOG.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7ed3\u7b97\u786e\u8ba4\u5f02\u5e38:%s", billNo, ex.getMessage()));
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        this.getView().setEnable(Boolean.TRUE, new String[]{PAYMODEBTNFLEX});
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        Map data = returnData instanceof String ? (Map)JSON.parse((String)((String)returnData)) : (returnData instanceof JSONObject ? (Map)JSONObject.toJavaObject((JSON)((JSON)returnData), Map.class) : (HashMap)returnData);
        this.getView().updateView("payrecords");
        switch (actionId = e.getActionId()) {
            case "cashcustomclose": {
                this.cashCustomPayBackClosedBack(data);
                break;
            }
            case "elec_paymentclose": {
                this.elecPayBackClosedBack(data);
                break;
            }
            case "couponclose": {
                this.ticketCloseCallBack(data);
                break;
            }
            case "ccbClose": 
            case "umsClose": 
            case "abcClose": 
            case "bocClose": {
                this.posCloseCallback(data, actionId);
                break;
            }
            case "stageClose": {
                this.stageCloseCallback(data);
                break;
            }
            case "custompay": {
                Object payModeId = data.get("payway");
                if (payModeId == null) break;
                this.openPayViewById(String.valueOf(payModeId));
                break;
            }
            case "creditpayclose": {
                this.creditPayClose(returnData);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] eRowIndexes;
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"payrecords") && (eRowIndexes = e.getRowIndexs()) != null) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            BigDecimal needPayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
            DynamicObjectCollection docRecordEntry = dataEntity.getDynamicObjectCollection("payrecords");
            DynamicObjectCollection docTicketPayEntry = dataEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)docRecordEntry)) {
                return;
            }
            DynamicObjectCollection docFinEntry = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("finentity");
            for (int rowIndex : eRowIndexes) {
                DynamicObject doRecordEntry = (DynamicObject)docRecordEntry.get(rowIndex);
                DynamicObject doPayWay = DynamicObjectUtils.getDynamicObject((DynamicObject)doRecordEntry, (String)"payway");
                long payWayId = DynamicObjectUtils.getPkValue((DynamicObject)doPayWay);
                boolean isCanDel = doRecordEntry.getBoolean("iscandel");
                if (doPayWay.getBoolean("iselectronicpay") || !isCanDel) {
                    e.setCancel(true);
                    this.getView().showMessage("\u7535\u5b50\u652f\u4ed8\u53ca\u5df2\u6709\u652f\u4ed8\u6d41\u6c34\u7684\u91d1\u989d\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
                    return;
                }
                if (payWayId == PaymentModeEnum.coupon.getKey() && !CollectionUtils.isEmpty((Collection)docTicketPayEntry)) {
                    docTicketPayEntry.removeIf(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"eticketid") == DynamicObjectUtils.getLong((DynamicObject)doRecordEntry, (String)"payticketinfoid"));
                }
                if (!CollectionUtils.isEmpty((Collection)docFinEntry)) {
                    docFinEntry.removeIf(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"setllementid") == payWayId);
                }
                needPayAmount = needPayAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doRecordEntry, (String)"showamount"));
                if (payWayId != PaymentModeEnum.cashpay.getKey()) continue;
                this.getModel().setValue("returncashamount", (Object)BigDecimal.ZERO);
            }
            this.getModel().setValue("needpayamount", (Object)needPayAmount);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal needPayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
        if (needPayAmount.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObjectCollection docPayRecords = this.getView().getModel().getEntryEntity("payrecords");
            for (DynamicObject doPayRecord : docPayRecords) {
                DynamicObject doPayWay = doPayRecord.getDynamicObject("payway");
                if (!DynamicObjectUtils.getBoolean((DynamicObject)doPayWay, (String)"iselectronicpay")) continue;
                e.setCancel(true);
                this.getView().showMessage("\u5b58\u5728\u7535\u5b50\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed");
                break;
            }
        } else {
            String entityId;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object saleOrderId = formShowParameter.getCustomParam("Id");
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)(entityId = this.getView().getParentView().getEntityId()), (String)"salestatus");
            String saleStatus = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"salestatus");
            if (!StringUtils.equalsIgnoreCase((CharSequence)saleStatus, (CharSequence)"S")) {
                e.setCancel(true);
                this.getView().showMessage("\u652f\u4ed8\u5b8c\u6210\uff0c\u8bf7\u70b9\u51fb\u201c\u7ed3\u7b97\u201d");
            }
        }
    }

    private void setValueBySaleOrder(DynamicObject saleOrder) {
        DynamicObject payFormEntity = this.getModel().getDataEntity(true);
        DynamicObject currency = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"currencyid");
        payFormEntity.set("currency", (Object)currency);
        BigDecimal sumBalAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"sumbalamount");
        payFormEntity.set("actualprice", (Object)sumBalAmount.toPlainString());
        BigDecimal sumAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"sumamount");
        payFormEntity.set("totalprice", (Object)sumAmount.toPlainString());
        BigDecimal discountAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"sumdiscount");
        payFormEntity.set("discountamount", (Object)discountAmount.toPlainString());
        DynamicObject locCurrency = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"locurrencyid");
        payFormEntity.set("locurrency", (Object)locCurrency);
        DynamicObject customer = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"customerid");
        payFormEntity.set("customer", (Object)customer);
        this.getModel().setValue("biztype", (Object)DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"biztype"));
        this.getModel().setValue("bizorgid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid"));
        this.setPayRecordOfSaleOrder(saleOrder, payFormEntity);
        this.getView().updateView();
    }

    private void setPayRecordOfSaleOrder(DynamicObject saleOrder, DynamicObject payFormEntity) {
        BigDecimal depositAmount;
        BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"receivableamount");
        BigDecimal totalRealAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"totalrealamount");
        BigDecimal creditAmount = this.getCreditAmount();
        BigDecimal needPayAmount = receivableAmount.subtract(totalRealAmount).subtract(creditAmount);
        payFormEntity.set("needpayamount", (Object)needPayAmount);
        payFormEntity.set("receivableamount", (Object)receivableAmount);
        DynamicObjectCollection payRecordList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)payFormEntity, (String)"payrecords");
        this.addCreditRecordEntry();
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        BigDecimal wipeAmount = needPayAmount.subtract(AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (long)branchId, (BigDecimal)needPayAmount));
        this.addWipeRecordEntry(payFormEntity, wipeAmount);
        String bizType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"biztype");
        boolean isExistDepositPayWay = false;
        DynamicObjectCollection finEntity = saleOrder.getDynamicObjectCollection("finentity");
        if (finEntity.size() > 0) {
            for (DynamicObject finEntry : finEntity) {
                DynamicObject payWay = DynamicObjectUtils.getDynamicObject((DynamicObject)finEntry, (String)"setllementid");
                if (DynamicObjectUtils.getPkValue((DynamicObject)payWay) == 14L) {
                    isExistDepositPayWay = true;
                }
                DynamicObject payRecord = payRecordList.addNew();
                payRecord.set("payway", (Object)payWay);
                payRecord.set("paywaytype", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)finEntry, (String)"paywaytypeid"));
                payRecord.set("showamount", DynamicObjectUtils.get((DynamicObject)finEntry, (String)"settleamount"));
                payRecord.set("paytime", DynamicObjectUtils.get((DynamicObject)finEntry, (String)"paytime"));
                payRecord.set("paycurrency", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)finEntry, (String)"settlecurrid"));
                DynamicObject bankstageact = DynamicObjectUtils.getDynamicObject((DynamicObject)finEntry, (String)"bankstageactid");
                if (bankstageact != null) {
                    payRecord.set("stageid", (Object)bankstageact);
                }
                payRecord.set("iscandel", (Object)Boolean.FALSE);
            }
        }
        boolean isConvert = StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.ORDERCONVERTSALE.getValue());
        long baseBillType = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
        if (!isExistDepositPayWay && isConvert && baseBillType != BillTypeEnum.CREDIT.getId() && (depositAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"depositamount")).compareTo(BigDecimal.ZERO) > 0) {
            DynamicObject payRecord = payRecordList.addNew();
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"deposit"), (String)"ocdbd_paymode");
            payRecord.set("payway", (Object)payWay);
            DynamicObject payWayType = SaleOrderHelper.getPayWayType((DynamicObject)payWay);
            payRecord.set("paywaytype", (Object)payWayType);
            payRecord.set("showamount", (Object)depositAmount);
            Date payDate = TimeServiceHelper.now();
            payRecord.set("paytime", (Object)payDate);
            DynamicObject payCurrency = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"currencyid");
            payRecord.set("paycurrency", (Object)payCurrency);
            payRecord.set("iscandel", (Object)Boolean.FALSE);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BigDecimal discountValueDed = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("discountvalueded"));
        if (StringUtils.equals((CharSequence)BizTypeEnum.CHANGE.getValue(), (CharSequence)bizType)) {
            String changeItemType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"changeitemtype");
            if (StringUtils.equals((CharSequence)changeItemType, (CharSequence)"2")) {
                this.doDiscountTypeHandle(saleOrder, payRecordList);
            }
        } else if (discountValueDed.compareTo(BigDecimal.ZERO) < 0) {
            this.doDiscountTypeHandle(saleOrder, payRecordList);
        }
        this.getView().updateView("payrecords");
    }

    private void doDiscountTypeHandle(DynamicObject saleOrder, DynamicObjectCollection payRecordList) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BigDecimal discountValueDed = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("discountvalueded"));
        BigDecimal discountCustCpst = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("discountcustcpst"));
        if (discountValueDed.abs().compareTo(BigDecimal.ZERO) > 0) {
            this.addDiscountTypeRow(saleOrder, "equalvaluepay", discountValueDed, payRecordList);
            BigDecimal needPayAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("needpayamount"));
            BigDecimal receivableAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("receivableamount"));
            this.getModel().setValue("receivableamount", (Object)receivableAmount.add(discountValueDed.abs()));
            this.getModel().setValue("needpayamount", (Object)needPayAmount.add(discountValueDed.abs()));
        }
        if (discountCustCpst.abs().compareTo(BigDecimal.ZERO) > 0) {
            this.addDiscountTypeRow(saleOrder, "customercompensation", discountCustCpst, payRecordList);
        }
    }

    private void addDiscountTypeRow(DynamicObject saleOrder, String payModeKey, BigDecimal discountAmt, DynamicObjectCollection payRecordList) {
        DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)payModeKey), (String)"ocdbd_paymode");
        DynamicObject payRecord = payRecordList.addNew();
        payRecord.set("payway", (Object)payWay);
        DynamicObject payWayType = SaleOrderHelper.getPayWayType((DynamicObject)payWay);
        payRecord.set("paywaytype", (Object)payWayType);
        payRecord.set("showamount", (Object)discountAmt);
        Date payDate = TimeServiceHelper.now();
        payRecord.set("paytime", (Object)payDate);
        DynamicObject payCurrency = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"currencyid");
        payRecord.set("paycurrency", (Object)payCurrency);
        payRecord.set("iscandel", (Object)Boolean.FALSE);
    }

    private void addWipeRecordEntry(DynamicObject dataEntity, BigDecimal wipeAmount) {
        if (wipeAmount.abs().compareTo(BigDecimal.ZERO) > 0) {
            int index = this.getModel().createNewEntryRow("payrecords");
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"ignoredecimal"), (String)"ocdbd_paymode");
            this.getModel().setValue("payway", (Object)payWay, index);
            DynamicObject payWayType = SaleOrderHelper.getPayWayType((DynamicObject)payWay);
            this.getModel().setValue("paywaytype", (Object)payWayType, index);
            this.getModel().setValue("paytime", (Object)TimeServiceHelper.now(), index);
            this.getModel().setValue("showamount", (Object)wipeAmount, index);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            this.getModel().setValue("paycurrency", currency.getPkValue(), index);
            this.getModel().setValue("paybackamount", (Object)BigDecimal.ZERO, index);
        }
        BigDecimal needPayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
        dataEntity.set("needpayamount", (Object)needPayAmount.subtract(wipeAmount));
    }

    private void addCreditRecordEntry() {
        BigDecimal creditAmount = this.getCreditAmount();
        if (creditAmount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        int index = this.getModel().createNewEntryRow("payrecords");
        DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"tosettleaccounts"), (String)"ocdbd_paymode");
        this.getModel().setValue("payway", (Object)payWay, index);
        DynamicObject payWayType = SaleOrderHelper.getPayWayType((DynamicObject)payWay);
        this.getModel().setValue("paywaytype", (Object)payWayType, index);
        this.getModel().setValue("paytime", (Object)TimeServiceHelper.now(), index);
        this.getModel().setValue("showamount", (Object)creditAmount, index);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        this.getModel().setValue("paycurrency", currency.getPkValue(), index);
        this.getModel().setValue("paybackamount", (Object)BigDecimal.ZERO, index);
        long creditAccountId = CommonUtil.formatObejctToLong((Object)this.getView().getFormShowParameter().getCustomParam("creditaccountid"));
        this.getModel().setValue("creditaccountid", (Object)creditAccountId);
        this.getModel().setValue("iscandel", (Object)Boolean.FALSE);
    }

    private void addPaymentRecordEntry(BigDecimal showNeedAmount, DynamicObjectCollection docTicketEntry) {
        BigDecimal paymentAmount = BigDecimal.ZERO;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)this.getView().getParentView().getEntityId());
        if (saleOrder != null && !CollectionUtils.isEmpty((Collection)docTicketEntry)) {
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"giftvoucherpay"), (String)"ocdbd_paymode");
            DynamicObject payWayType = SaleOrderHelper.getPayWayType((DynamicObject)payWay);
            for (DynamicObject doTicketEntry : docTicketEntry) {
                paymentAmount = paymentAmount.add(CommonUtil.formatObjectToDecimal((Object)doTicketEntry.get("payamount")));
                int index = this.getModel().createNewEntryRow("payrecords");
                this.getModel().setValue("payway", (Object)payWay, index);
                this.getModel().setValue("paywaytype", (Object)payWayType, index);
                this.getModel().setValue("paytime", (Object)TimeServiceHelper.now(), index);
                this.getModel().setValue("showamount", doTicketEntry.get("payamount"), index);
                this.getModel().setValue("paycurrency", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"currencyid"), index);
                this.getModel().setValue("cardno", doTicketEntry.get("ticketnumber"), index);
                this.getModel().setValue("paytickettypeid", doTicketEntry.get("tickettypeid"), index);
                this.getModel().setValue("payticketinfoid", doTicketEntry.get("eticketid"), index);
            }
            this.getModel().setValue("needpayamount", (Object)showNeedAmount.subtract(paymentAmount));
        }
    }

    private void openCashCustomPayView(String paymentFormId, String closeCallBackId, String payWayId, String caption) {
        BigDecimal needPayAmount = this.getNeedPayAmount(Long.parseLong(payWayId));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object pkId = formShowParameter.getCustomParam("Id");
        DynamicObject dataEntry = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)this.getView().getParentView().getEntityId(), (String)"billno");
        String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntry, (String)"billno");
        LOG.info(String.format("\u96f6\u552e\u5355\u53f7%s\u70b9\u51fb\u652f\u4ed8\u65b9\u5f0f%s\u91d1\u989d%.2f\u5143", billNo, payWayId, needPayAmount));
        HashMap<String, Object> customParams = new HashMap<String, Object>(6);
        customParams.put("saleoption", "1");
        customParams.put("needpayamount", needPayAmount);
        customParams.put("bizorgid", this.getModel().getValue("bizorgid"));
        customParams.put("salebranchid", this.getView().getFormShowParameter().getCustomParam("salebranchid"));
        customParams.put("paycurrencyid", this.getModel().getValue("currency_id"));
        customParams.put("paywayid", payWayId);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)caption, (String)paymentFormId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(parameter);
    }

    private void openScanPaymentPayView(String paymentFormId, String closeCallBackId, String payWayId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(6);
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        String entityId = this.getView().getParentView().getEntityId();
        Object needPayAmount = this.getModel().getValue("needpayamount");
        DynamicObjectCollection payRecords = this.getModel().getEntryEntity("payrecords");
        BigDecimal hasPayAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)payRecords)) {
            for (DynamicObject payRecord : payRecords) {
                DynamicObject payWay = payRecord.getDynamicObject("payway");
                if (payWay.getBoolean("iselectronicpay")) continue;
                hasPayAmount = hasPayAmount.add(payRecord.getBigDecimal("showamount"));
            }
        }
        customParams.put("saleoption", "1");
        customParams.put("entityid", entityId);
        customParams.put("haspayamount", needPayAmount);
        customParams.put("paywayid", payWayId);
        customParams.put("Id", saleOrderId);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)paymentFormId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(parameter);
    }

    private void openCouponPayView(String paymentFormId, String closeCallBackId, String payWayId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(6);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal needPayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
        customParams.put("needpayamount", needPayAmount);
        customParams.put("entityid", this.getView().getParentView().getEntityId());
        if (StringUtils.equals((CharSequence)payWayId, (CharSequence)"15")) {
            customParams.put("creditaccountid", this.getView().getPageCache().get("creditaccountid"));
        } else if (StringUtils.equals((CharSequence)payWayId, (CharSequence)"4")) {
            DynamicObjectCollection docTicketEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            customParams.put("ticketid", docTicketEntry);
        }
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        Object memberId = formShowParameter.getCustomParam("member");
        Object branchId = formShowParameter.getCustomParam("salebranchid");
        Object currencyId = formShowParameter.getCustomParam("currencyid");
        Object goodsData = formShowParameter.getCustomParam("goodsentryentity");
        customParams.put("saleoption", "1");
        customParams.put("Id", saleOrderId);
        customParams.put("payway", payWayId);
        customParams.put("member", memberId);
        customParams.put("salebranchid", branchId);
        customParams.put("currencyid", currencyId);
        customParams.put("goodsentryentity", goodsData);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)paymentFormId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(parameter);
    }

    private void openOtherPayView(String payWayId) {
        ArrayList<String> mainOverPayModeIds = new ArrayList<String>(20);
        String strMainOverPayModeIds = this.getPageCache().get("mainOverPayModeIds");
        if (!StringUtils.isEmpty((CharSequence)strMainOverPayModeIds)) {
            mainOverPayModeIds.addAll(JSONObject.parseArray((String)strMainOverPayModeIds, String.class));
        }
        boolean isSaleFinalBill = false;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long baseBillTypeId = CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("basebilltype"));
        if (baseBillTypeId == 1041369866768349184L || baseBillTypeId == 1041370234709475328L || baseBillTypeId == 1041370619880798208L) {
            isSaleFinalBill = true;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(6);
        customParams.put("entityid", this.getView().getParentView().getEntityId());
        long cashierRoleId = CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("cashierid"));
        long posId = CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("pos"));
        List payModeLst = PayUtil.getDisplayPayModeData((long)cashierRoleId, (long)posId, (String)"more", (String)"1");
        if (isSaleFinalBill) {
            Object allowFinalPayModeIds;
            String strAllowFinalPayModeIds = this.getPageCache().get("allowFinalPayModeIds");
            if (!StringUtils.isEmpty((CharSequence)strAllowFinalPayModeIds) && !CollectionUtils.isEmpty((Collection)(allowFinalPayModeIds = (List)JSONObject.parseObject((String)strAllowFinalPayModeIds, List.class)))) {
                mainOverPayModeIds.retainAll((Collection<?>)allowFinalPayModeIds);
            }
            payModeLst.forEach(payMode -> {
                boolean isAllowFinalPay = payMode.getBoolean("isallowfinalpay");
                if (isAllowFinalPay) {
                    mainOverPayModeIds.add(payMode.getString("id"));
                }
            });
        } else {
            payModeLst.forEach(payMode -> mainOverPayModeIds.add(payMode.getString("id")));
        }
        if (CollectionUtils.isEmpty(mainOverPayModeIds)) {
            mainOverPayModeIds.add("-1");
        }
        ArrayList<Long> lMainOverPayModeIds = new ArrayList<Long>(mainOverPayModeIds.size());
        for (String mainOverPayModeId : mainOverPayModeIds) {
            lMainOverPayModeIds.add(Long.valueOf(mainOverPayModeId));
        }
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        customParams.put("saleoption", "1");
        customParams.put("Id", saleOrderId);
        customParams.put("payway", lMainOverPayModeIds);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_otherpaylist", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "custompay"));
        this.getView().showForm(parameter);
    }

    private void openStagePayView(String payWayId) {
        BigDecimal needPayAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("needpayamount"));
        if (needPayAmount.compareTo(new BigDecimal(1000)) < 0) {
            this.getView().setEnable(Boolean.TRUE, new String[]{PAYMODEBTNFLEX});
            NotificationUtil.showDefaultTipNotify((String)"\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u4e0d\u8db31000\u5143\uff0c\u4e0d\u5141\u8bb8\u5206\u671f\u652f\u4ed8", (IFormView)this.getView());
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(6);
        customParams.put("saleoption", "1");
        customParams.put("entityid", this.getView().getParentView().getEntityId());
        customParams.put("haspayamount", needPayAmount);
        customParams.put("paywayid", payWayId);
        DynamicObject parentEntity = this.getView().getParentView().getModel().getDataEntity(true);
        DynamicObjectCollection goodsList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)parentEntity, (String)"goodsentryentity");
        customParams.put("goodsList", goodsList);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)parentEntity, (String)"salebranchid");
        customParams.put("branchId", branchId);
        customParams.put("Id", formShowParameter.getCustomParam("Id"));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_stagepay", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "stageClose"));
        this.getView().showForm(parameter);
    }

    private void openPosPayView(String payWayId, String payFormId, String closeCallBackFormId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(6);
        customParams.put("saleoption", "1");
        customParams.put("entityid", this.getView().getParentView().getEntityId());
        Object needPayAmount = this.getModel().getValue("needpayamount");
        customParams.put("haspayamount", needPayAmount);
        customParams.put("paywayid", payWayId);
        customParams.put("Id", formShowParameter.getCustomParam("Id"));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)payFormId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackFormId));
        this.getView().showForm(parameter);
    }

    private void ticketCloseCallBack(Map<String, Object> data) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection payList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"payrecords");
        DynamicObjectCollection docTicketEntry = (DynamicObjectCollection)data.get("ticketid");
        if (docTicketEntry == null || docTicketEntry.getRowCount() == 0) {
            return;
        }
        for (int i = payList.getRowCount() - 1; i >= 0; --i) {
            DynamicObject payItem = (DynamicObject)payList.get(i);
            if (PaymentModeEnum.getKey((String)"giftvoucherpay") != DynamicObjectUtils.getPkValue((DynamicObject)payItem, (String)"payway")) continue;
            this.getModel().deleteEntryRow("payrecords", i);
        }
        BigDecimal showNeedAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("needpayamount"));
        this.addPaymentRecordEntry(showNeedAmount, docTicketEntry);
        this.getView().getFormShowParameter().setCustomParam("ticketid", (Object)docTicketEntry);
        DynamicObjectCollection ticketEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        ticketEntities.clear();
        for (DynamicObject doTicketEntry : docTicketEntry) {
            DynamicObject ticketEntity = ticketEntities.addNew();
            ticketEntity.set("eticketid", doTicketEntry.get("eticketid"));
            ticketEntity.set("ticketnumber", doTicketEntry.get("ticketnumber"));
            ticketEntity.set("ticketvalue", doTicketEntry.get("ticketvalue"));
            ticketEntity.set("useamount", doTicketEntry.get("useamount"));
            ticketEntity.set("payamount", doTicketEntry.get("payamount"));
            ticketEntity.set("tickettype", doTicketEntry.get("tickettype"));
            ticketEntity.set("tickettypeid", doTicketEntry.get("tickettypeid"));
            ticketEntity.set("usagemode", doTicketEntry.get("usagemode"));
            ticketEntity.set("discountrate", doTicketEntry.get("discountrate"));
        }
    }

    private void posCloseCallback(Map<String, Object> data, String actionId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)this.getView().getParentView().getEntityId());
        String callBackCode = data.get("code").toString();
        JSONObject callBackData = (JSONObject)JSON.toJSON((Object)data.get("data"));
        if (StringUtils.equals((CharSequence)callBackCode, (CharSequence)"00")) {
            int index = this.getModel().createNewEntryRow("payrecords");
            BigDecimal showNeedAmount = callBackData.getBigDecimal("needpayamount");
            BigDecimal amount = callBackData.getBigDecimal("amount").divide(new BigDecimal(100), 2, RoundingMode.DOWN);
            this.getModel().setValue("payway", callBackData.get((Object)"payway"), index);
            this.getModel().setValue("showamount", (Object)amount, index);
            this.getModel().setValue("paycurrency", (Object)1, index);
            this.getModel().setValue("paywaytype", (Object)SaleOrderPayInfoPlugin.getPayWayType(callBackData), index);
            this.getModel().setValue("needpayamount", (Object)showNeedAmount.subtract(amount));
            this.getModel().setValue("iscandel", (Object)Boolean.FALSE);
            this.getModel().setValue("paytime", (Object)new Date(), index);
            String cardNo = "";
            String orderNo = "";
            String bankExchangeNo = "";
            switch (actionId) {
                case "ccbClose": {
                    cardNo = callBackData.getString("cardNo");
                    orderNo = callBackData.getString("trace");
                    if (callBackData.getLong("payway") == 24L) {
                        bankExchangeNo = callBackData.getString("refer");
                    }
                    if (callBackData.getLong("payway") != 28L) break;
                    bankExchangeNo = callBackData.getString("rsv");
                    break;
                }
                case "abcClose": {
                    cardNo = callBackData.getString("cardNo");
                    orderNo = callBackData.getString("traceNum");
                    if (callBackData.getLong("payway") == 22L) {
                        bankExchangeNo = callBackData.getString("referNum");
                    }
                    if (callBackData.getLong("payway") != 31L) break;
                    bankExchangeNo = callBackData.getString("codeOrderNum");
                    break;
                }
                case "umsClose": {
                    cardNo = callBackData.getString("cardNo");
                    orderNo = callBackData.getString("voucherNum");
                    break;
                }
                case "bocClose": {
                    cardNo = callBackData.getString("cardNo");
                    if (callBackData.getLong("payway") == 23L) {
                        orderNo = callBackData.getString("invoiceNo");
                        break;
                    }
                    if (callBackData.getLong("payway") != 33L) break;
                    Integer payCh = callBackData.getInteger("payCh");
                    orderNo = payCh == 2 || payCh == 3 ? callBackData.getString("orderNo") : callBackData.getString("payNo");
                }
            }
            this.getModel().setValue("cardno", (Object)cardNo, index);
            this.getModel().setValue("orderno", (Object)orderNo, index);
            DynamicObject pay = (DynamicObject)this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("payrecords").get(index);
            PaymentRecord paymentRecord = new PaymentRecord();
            paymentRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)saleOrder).longValue());
            paymentRecord.setBillNo(saleOrder.getString("billno"));
            paymentRecord.setPayWay(pay.getDynamicObject("payway"));
            paymentRecord.setPayWayType(pay.getDynamicObject("paywaytype"));
            paymentRecord.setCardNo(pay.getString("cardno"));
            paymentRecord.setOrderNo(pay.getString("orderno"));
            paymentRecord.setPayCurrency(pay.getDynamicObject("paycurrency"));
            paymentRecord.setPaytime(TimeServiceHelper.now());
            paymentRecord.setAmount(pay.getBigDecimal("showamount"));
            paymentRecord.setBankExchangeNo(bankExchangeNo);
            paymentRecord.setPayStatus("A");
            DynamicObjectCollection finEntryEntity = saleOrder.getDynamicObjectCollection("finentity");
            DynamicObject newFinEntity = finEntryEntity.addNew();
            SaleOrderHelper.updateSaleOrderAfterPayment((DynamicObject)saleOrder, (DynamicObject)newFinEntity, (PaymentRecord)paymentRecord, data);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
            NotificationUtil.showDefaultSuccessNotification((String)"\u652f\u4ed8\u6210\u529f", (IFormView)this.getView());
        } else {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(callBackCode).append(" ");
            switch (actionId) {
                case "ccbClose": 
                case "umsClose": {
                    if (!StringUtils.isNotBlank((CharSequence)callBackData.getString("errorDesc"))) break;
                    errorMsg.append(callBackData.getString("errorDesc"));
                    break;
                }
                case "abcClose": 
                case "bocClose": {
                    if (!StringUtils.isNotBlank((CharSequence)callBackData.getString("retMsg"))) break;
                    errorMsg.append(callBackData.getString("retMsg"));
                }
            }
            this.getView().showTipNotification(errorMsg.toString());
        }
    }

    private void cashCustomPayBackClosedBack(Map<String, Object> payResultData) {
        if (payResultData == null || payResultData.size() == 0) {
            this.getView().showErrorNotification("\u9000\u6b3e\u56de\u8c03\u6570\u636e\u4e3a\u7a7a\u3002");
            return;
        }
        DynamicObject backPayWay = (DynamicObject)payResultData.get("payway");
        long backPayWayId = DynamicObjectUtils.getPkValue((DynamicObject)backPayWay);
        int payRecordIndex = -1;
        DynamicObjectCollection payRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
        if (!CollectionUtils.isEmpty((Collection)payRecords)) {
            for (DynamicObject payRecord : payRecords) {
                DynamicObject payWay = payRecord.getDynamicObject("payway");
                long payWayId = payWay.getLong("id");
                String cardno = payRecord.getString("cardno");
                if (backPayWayId != payWayId || !StringUtils.isEmpty((CharSequence)cardno) || payWay.getBoolean("iselectronicpay")) continue;
                payRecordIndex = payRecords.indexOf((Object)payRecord);
            }
        }
        if (payRecordIndex < 0) {
            payRecordIndex = this.getModel().createNewEntryRow("payrecords");
        }
        this.getModel().setValue("payway", (Object)backPayWay, payRecordIndex);
        DynamicObject payWayType = SaleOrderHelper.getPayWayType((DynamicObject)backPayWay);
        this.getModel().setValue("paywaytype", (Object)payWayType, payRecordIndex);
        this.getModel().setValue("paytime", payResultData.get("paytime"), payRecordIndex);
        this.getModel().setValue("showamount", payResultData.get("showamount"), payRecordIndex);
        this.getModel().setValue("paycurrency", payResultData.get("paycurrency"), payRecordIndex);
        this.getModel().setValue("paybackamount", payResultData.get("paybackamount"), payRecordIndex);
        BigDecimal wipeAmount = CommonUtil.formatObjectToDecimal((Object)payResultData.get("wipeamount"));
        if (wipeAmount.abs().compareTo(BigDecimal.ZERO) > 0) {
            int index = this.getModel().createNewEntryRow("payrecords");
            this.getModel().setValue("payway", (Object)PaymentModeEnum.getKey((String)"ignoredecimal"), index);
            this.getModel().setValue("paytime", (Object)TimeServiceHelper.now(), index);
            this.getModel().setValue("showamount", (Object)wipeAmount, index);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            this.getModel().setValue("paycurrency", currency.getPkValue(), index);
            this.getModel().setValue("paybackamount", (Object)BigDecimal.ZERO, index);
        }
        BigDecimal receivableAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("receivableamount"));
        BigDecimal newNeedPayAmount = SaleAmountHelper.calculateSalePayNeedPayAmount((BigDecimal)receivableAmount, (DynamicObjectCollection)payRecords);
        this.getModel().setValue("needpayamount", (Object)newNeedPayAmount);
        if (backPayWayId == 3L) {
            this.getModel().setValue("returncashamount", payResultData.get("returncashamount"));
        }
    }

    private void elecPayBackClosedBack(Map<String, Object> payResultData) {
        if (payResultData == null || payResultData.size() == 0) {
            this.getView().showErrorNotification("\u9000\u6b3e\u56de\u8c03\u6570\u636e\u4e3a\u7a7a\u3002");
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject payWay = (DynamicObject)payResultData.get("payway");
        DynamicObject payWayType = (DynamicObject)payResultData.get("paywaytype");
        if (payWayType == null) {
            payWayType = SaleOrderHelper.getPayWayType((DynamicObject)payWay);
        }
        int payRecordIndex = this.getModel().createNewEntryRow("payrecords");
        this.getModel().setValue("payway", (Object)payWay, payRecordIndex);
        this.getModel().setValue("paywaytype", (Object)payWayType, payRecordIndex);
        this.getModel().setValue("paytime", payResultData.get("paytime"), payRecordIndex);
        BigDecimal amount = new BigDecimal(payResultData.get("showamount").toString());
        this.getModel().setValue("showamount", payResultData.get("showamount"), payRecordIndex);
        this.getModel().setValue("paycurrency", payResultData.get("paycurrency"), payRecordIndex);
        this.getModel().setValue("paybackamount", payResultData.get("paybackamount"), payRecordIndex);
        BigDecimal showNeedAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
        this.getModel().setValue("needpayamount", (Object)showNeedAmount.subtract(amount));
    }

    private BigDecimal getNeedPayAmount(long backPayWayId) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal needPayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
        DynamicObjectCollection payRecords = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"payrecords");
        for (DynamicObject payRecord : payRecords) {
            DynamicObject payWay = payRecord.getDynamicObject("payway");
            long payWayId = payWay.getLong("id");
            String cardno = payRecord.getString("cardno");
            BigDecimal showAmount = payRecord.getBigDecimal("showamount");
            if (backPayWayId != payWayId || !StringUtils.isEmpty((CharSequence)cardno) || payWay.getBoolean("iselectronicpay")) continue;
            needPayAmount = needPayAmount.add(showAmount);
            break;
        }
        if (needPayAmount.compareTo(BigDecimal.ZERO) < 0) {
            needPayAmount = BigDecimal.ZERO;
        }
        return needPayAmount;
    }

    private BigDecimal getCreditAmount() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return CommonUtil.formatObjectToDecimal((Object)customParams.getOrDefault("creditamount", BigDecimal.ZERO));
    }

    private String checkBeforePayConfirm(Object saleOrderId, DynamicObjectCollection payList) {
        BigDecimal receivableAmount;
        if (!CollectionUtils.isEmpty((Collection)payList) && payList.size() > 1) {
            ArrayList<String> payRecordKeys = new ArrayList<String>(payList.size());
            for (DynamicObject payrecord : payList) {
                String paywayidstr = DynamicObjectUtils.getStrPkValue((DynamicObject)payrecord, (String)"payway");
                String showamountstr = payrecord.getString("showamount");
                String paytimestr = payrecord.getString("paytime");
                String payrecordKey = paywayidstr + "-" + showamountstr + "-" + paytimestr;
                if (payRecordKeys.contains(payrecordKey)) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("paybill", (IFormPlugin)this);
                    this.getView().showConfirm("\u5b58\u5728\u91cd\u590d\u7684\u652f\u4ed8\u8bb0\u5f55\uff0c\u662f\u5426\u5220\u9664\u91cd\u590d\u8bb0\u5f55\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    break;
                }
                payRecordKeys.add(payrecordKey);
            }
        }
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)this.getView().getParentView().getEntityId());
        String mergeBillType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"ismergebill");
        String bizType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"biztype");
        BigDecimal stillNeedToPay = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"stillneedtopay");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (!(StringUtils.equalsIgnoreCase((CharSequence)mergeBillType, (CharSequence)"0") || StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"C") && stillNeedToPay.compareTo(BigDecimal.ZERO) == 0 || payList.size() != 0 || (receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"receivableamount")).compareTo(BigDecimal.ZERO) <= 0)) {
            return "\u8bf7\u9009\u62e9\u4e00\u79cd\u652f\u4ed8\u65b9\u5f0f\u5e76\u652f\u4ed8\u3002";
        }
        BigDecimal needPayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
        if (needPayAmount.compareTo(BigDecimal.ZERO) > 0) {
            return "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u7ed3\u7b97\u3002";
        }
        return "";
    }

    private void stageCloseCallback(Map<String, Object> data) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)this.getView().getParentView().getEntityId());
        String callBackCode = data.get("code").toString();
        JSONObject callBackData = (JSONObject)JSON.toJSON((Object)data.get("data"));
        Integer payWayId = callBackData.getInteger("payway");
        Date payTime = new Date();
        if (StringUtils.equals((CharSequence)callBackCode, (CharSequence)"00")) {
            String orderNo;
            String cardNo;
            int index = this.getModel().createNewEntryRow("payrecords");
            String bankExchangeNo = "";
            switch (payWayId) {
                case 34: {
                    try {
                        payTime = DateUtil.stringDateFormat((String)callBackData.getString("date"));
                    }
                    catch (ParseException e) {
                        LOG.info(StringUtil.getErrorMsg((Exception)e));
                    }
                    cardNo = callBackData.getString("cardNo");
                    orderNo = callBackData.getString("trace");
                    bankExchangeNo = callBackData.getString("refer");
                    break;
                }
                case 35: {
                    try {
                        payTime = DateUtil.stringDateFormat((String)callBackData.getString("actualTime"));
                    }
                    catch (ParseException e) {
                        LOG.info(StringUtil.getErrorMsg((Exception)e));
                    }
                    cardNo = callBackData.getString("cardNo");
                    orderNo = callBackData.getString("traceNum");
                    bankExchangeNo = callBackData.getString("referNum");
                    break;
                }
                case 36: {
                    try {
                        if (StringUtils.isNotEmpty((CharSequence)callBackData.getString("tranDate")) && StringUtils.isNotEmpty((CharSequence)callBackData.getString("tranTime"))) {
                            payTime = DateUtil.stringDateFormat((String)(callBackData.getString("tranDate") + callBackData.getString("tranTime")));
                        }
                    }
                    catch (ParseException e) {
                        LOG.info(StringUtil.getErrorMsg((Exception)e));
                    }
                    cardNo = callBackData.getString("cardNo");
                    orderNo = callBackData.getString("traceNo");
                    break;
                }
                default: {
                    return;
                }
            }
            BigDecimal showNeedAmount = callBackData.getBigDecimal("needpayamount");
            BigDecimal amount = callBackData.getBigDecimal("amount").divide(new BigDecimal(100), 2, RoundingMode.DOWN);
            this.getModel().setValue("payway", (Object)payWayId, index);
            this.getModel().setValue("paytime", (Object)payTime, index);
            this.getModel().setValue("cardno", (Object)cardNo, index);
            this.getModel().setValue("orderno", (Object)orderNo, index);
            this.getModel().setValue("showamount", (Object)amount, index);
            this.getModel().setValue("paycurrency", (Object)1, index);
            this.getModel().setValue("stageid", (Object)callBackData.getLong("stageid"), index);
            this.getModel().setValue("stagenum", (Object)callBackData.getInteger("stagenum"), index);
            this.getModel().setValue("stagefee", (Object)callBackData.getBigDecimal("stagefee"), index);
            showNeedAmount = SaleOrderStagePayPlugin.savePaymentFlow(this.getView(), saleOrder, data, showNeedAmount);
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)payWayId, (String)"ocdbd_paymode");
            this.getModel().setValue("paywaytype", (Object)SaleOrderHelper.getPayWayType((DynamicObject)payWay), index);
            this.getModel().setValue("needpayamount", (Object)showNeedAmount.subtract(amount));
            this.getModel().setValue("iscandel", (Object)Boolean.FALSE);
            DynamicObject pay = (DynamicObject)this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("payrecords").get(index);
            PaymentRecord paymentRecord = new PaymentRecord();
            paymentRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)saleOrder).longValue());
            paymentRecord.setBillNo(saleOrder.getString("billno"));
            paymentRecord.setPayWay(pay.getDynamicObject("payway"));
            paymentRecord.setPayWayType(pay.getDynamicObject("paywaytype"));
            paymentRecord.setCardNo(pay.getString("cardno"));
            paymentRecord.setOrderNo(pay.getString("orderno"));
            paymentRecord.setPayCurrency(pay.getDynamicObject("paycurrency"));
            paymentRecord.setPaytime(payTime);
            paymentRecord.setAmount(pay.getBigDecimal("showamount"));
            paymentRecord.setBankExchangeNo(bankExchangeNo);
            paymentRecord.setBankStageActId(pay.getLong("stageid"));
            paymentRecord.setStageNums((long)pay.getInt("stagenum"));
            paymentRecord.setStageFee(pay.getBigDecimal("stagefee"));
            paymentRecord.setPayStatus("A");
            DynamicObjectCollection finEntryEntity = saleOrder.getDynamicObjectCollection("finentity");
            DynamicObject newFinEntity = finEntryEntity.addNew();
            SaleOrderHelper.updateSaleOrderAfterPayment((DynamicObject)saleOrder, (DynamicObject)newFinEntity, (PaymentRecord)paymentRecord, data);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
            NotificationUtil.showDefaultSuccessNotification((String)"\u652f\u4ed8\u6210\u529f", (IFormView)this.getView());
        } else {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(callBackCode).append(" ");
            switch (payWayId) {
                case 34: {
                    if (!StringUtils.isNotBlank((CharSequence)callBackData.getString("errorDesc"))) break;
                    errorMsg.append(callBackData.getString("errorDesc"));
                    break;
                }
                case 35: 
                case 36: {
                    if (!StringUtils.isNotBlank((CharSequence)callBackData.getString("retMsg"))) break;
                    errorMsg.append(callBackData.getString("retMsg"));
                }
            }
            this.getView().showTipNotification(errorMsg.toString());
        }
    }

    public static DynamicObject getPayWayType(JSONObject callBackData) {
        Integer payWayId = callBackData.getInteger("payway");
        List<Integer> bankCardList = Arrays.asList(22, 23, 24, 25);
        if (payWayId == 28) {
            Integer channelType = callBackData.getInteger("channelType");
            if (channelType == 0) {
                return BusinessDataServiceHelper.loadSingle((Object)1117388809705865216L, (String)"ocdbd_paywaytype");
            }
            if (channelType == 1) {
                return BusinessDataServiceHelper.loadSingle((Object)960797054941170688L, (String)"ocdbd_paywaytype");
            }
            if (channelType == 2) {
                return BusinessDataServiceHelper.loadSingle((Object)960797923925358592L, (String)"ocdbd_paywaytype");
            }
            if (channelType == 3) {
                return BusinessDataServiceHelper.loadSingle((Object)1117388809705865216L, (String)"ocdbd_paywaytype");
            }
        } else if (payWayId == 31) {
            Integer settleType = callBackData.getInteger("settleType");
            if (settleType == 0) {
                return BusinessDataServiceHelper.loadSingle((Object)960800111724760064L, (String)"ocdbd_paywaytype");
            }
            if (settleType == 1) {
                return BusinessDataServiceHelper.loadSingle((Object)960797054941170688L, (String)"ocdbd_paywaytype");
            }
            if (settleType == 2) {
                return BusinessDataServiceHelper.loadSingle((Object)960797923925358592L, (String)"ocdbd_paywaytype");
            }
            if (settleType == 3) {
                return BusinessDataServiceHelper.loadSingle((Object)1117388809705865216L, (String)"ocdbd_paywaytype");
            }
        } else {
            if (payWayId == 33) {
                Integer payCh = callBackData.getInteger("payCh");
                if (payCh == 2) {
                    return BusinessDataServiceHelper.loadSingle((Object)960797054941170688L, (String)"ocdbd_paywaytype");
                }
                if (payCh == 3) {
                    return BusinessDataServiceHelper.loadSingle((Object)960797923925358592L, (String)"ocdbd_paywaytype");
                }
                return BusinessDataServiceHelper.loadSingle((Object)1117388809705865216L, (String)"ocdbd_paywaytype");
            }
            if (bankCardList.contains(payWayId)) {
                return BusinessDataServiceHelper.loadSingle((Object)960800111724760064L, (String)"ocdbd_paywaytype");
            }
        }
        return null;
    }

    private Map<String, Object> checkCreditAmount(DynamicObject dataEntity) {
        HashMap<String, Object> result = new HashMap<String, Object>(0);
        DynamicObjectCollection payRecordList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"payrecords");
        if (payRecordList != null && payRecordList.size() > 0) {
            DynamicObject payRecord = payRecordList.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"payway") == PaymentModeEnum.creditpay.getKey()).findFirst().orElse(null);
            if (payRecord == null) {
                result.put("result", true);
                result.put("msg", "success");
                return result;
            }
            long settlementId = DynamicObjectUtils.getPkValue((DynamicObject)payRecord, (String)"payway");
            if (settlementId == PaymentModeEnum.creditpay.getKey()) {
                BigDecimal creditAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)payRecord, (String)"showamount");
                long creditAccountId = DynamicObjectUtils.getLong((DynamicObject)payRecord, (String)"creditaccountid");
                return this.checkCreditAmount(creditAccountId, creditAmount);
            }
        }
        result.put("result", true);
        result.put("msg", "success");
        return result;
    }

    private Map<String, Object> checkCreditAmount(Long creditAccountId, BigDecimal creditAmount) {
        HashMap<String, Object> result = new HashMap<String, Object>(0);
        DynamicObject creditAccount = BusinessDataServiceHelper.loadSingle((Object)creditAccountId, (String)"ocdbd_credit_accountinfo");
        if (creditAccount == null) {
            result.put("result", false);
            result.put("msg", "\u672a\u67e5\u8be2\u5230\u4fe1\u7528\u8d26\u6237");
            return result;
        }
        DynamicObject creditRule = DynamicObjectUtils.getDynamicObject((DynamicObject)creditAccount, (String)"creditruleid");
        String accountName = DynamicObjectUtils.getString((DynamicObject)creditAccount, (String)"name");
        DynamicObjectCollection ruleEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)creditRule, (String)"entity");
        if (CollectionUtils.isEmpty((Collection)ruleEntity)) {
            result.put("result", false);
            result.put("msg", String.format("\u5f53\u524d\u95e8\u5e97\u4fe1\u7528\u8d26\u6237%s\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u660e\u7ec6\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", accountName));
            return result;
        }
        DynamicObject ruleEntityRow = ruleEntity.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getStrPkValue((DynamicObject)x, (String)"billid"), (CharSequence)"ocpos_saleorder")).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)ruleEntityRow)) {
            result.put("result", false);
            result.put("msg", String.format("\u5f53\u524d\u95e8\u5e97\u4fe1\u7528\u8d26\u6237%s\u4fe1\u7528\u68c0\u67e5\u89c4\u5219\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d4a\u9500\u6536\u6b3e\u3002", accountName));
            return result;
        }
        BigDecimal overDueDays = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"overduedays");
        BigDecimal overDueAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"overdueamount");
        BigDecimal limitBalance = DynamicObjectUtils.getBigDecimal((DynamicObject)creditAccount, (String)"limitbalance");
        boolean isCheckOverDays = DynamicObjectUtils.getBoolean((DynamicObject)ruleEntityRow, (String)"isckoverdays");
        boolean isCheckOverLimit = DynamicObjectUtils.getBoolean((DynamicObject)ruleEntityRow, (String)"isckoverlimit");
        boolean daysIsOverDue = isCheckOverDays && overDueDays.compareTo(BigDecimal.ZERO) > 0;
        boolean limitIsOver = isCheckOverLimit && overDueAmount.compareTo(BigDecimal.ZERO) > 0;
        boolean balanceIsNull = limitBalance.compareTo(BigDecimal.ZERO) <= 0;
        boolean isOverDue = daysIsOverDue || limitIsOver || balanceIsNull;
        boolean isAllOverDue = daysIsOverDue && limitIsOver && balanceIsNull;
        String overProOfGist = DynamicObjectUtils.getString((DynamicObject)ruleEntityRow, (String)"overproofgist");
        boolean overDue = isOverDue && StringUtils.equals((CharSequence)"A", (CharSequence)overProOfGist);
        boolean allOverDue = isAllOverDue && StringUtils.equals((CharSequence)"B", (CharSequence)overProOfGist);
        String ctrlGrade = DynamicObjectUtils.getString((DynamicObject)ruleEntityRow, (String)"controlgrade");
        if ((overDue || allOverDue) && StringUtils.equals((CharSequence)ctrlGrade, (CharSequence)"B")) {
            result.put("result", false);
            result.put("msg", "\u8d4a\u9500\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u6216\u5b58\u5728\u903e\u671f\u5e94\u6536\u8d26\u6b3e\uff0c\u4e0d\u5141\u8bb8\u8d4a\u9500\u6536\u6b3e");
            return result;
        }
        if (limitBalance.compareTo(creditAmount) < 0) {
            result.put("result", false);
            result.put("msg", String.format("\u4fe1\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u76ee\u524d\u4fe1\u7528\u4f59\u989d%.2f\uff0c\u672c\u6b21\u7ed3\u7b97\u91d1\u989d%.2f", limitBalance, creditAmount));
            return result;
        }
        result.put("result", true);
        result.put("msg", "success");
        return result;
    }

    private void showCreditPayForm(DynamicObject saleOrder) {
        HashMap<String, Number> customParams = new HashMap<String, Number>(2);
        BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"receivableamount");
        customParams.put("receivableamount", receivableAmount);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        DynamicObject creditAccount = CreditMangageHelper.getCreditAccountInfo((long)branchId);
        customParams.put("creditaccountid", DynamicObjectUtils.getPkValue((DynamicObject)creditAccount));
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"currencyid");
        customParams.put("settlecurrid", currencyId);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"\u8d4a\u9500\u6536\u6b3e", (String)"ocpos_creditpayment", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_CREDITPAYCLOSE));
        this.getView().showForm(parameter);
    }

    private void creditPayClose(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            if (ObjectUtils.isEmpty((Object)data)) {
                return;
            }
            this.updateCreditPayRecord(data);
        }
    }

    private void updateCreditPayRecord(Map<String, Object> data) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)this.getView().getParentView().getEntityId());
        BigDecimal creditAmount = CommonUtil.formatObjectToDecimal((Object)data.getOrDefault("settleamount", BigDecimal.ZERO));
        saleOrder.set("creditamount", (Object)creditAmount);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
        formShowParameter.getCustomParams().put("creditamount", creditAmount);
        DynamicObjectCollection payRecordList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"payrecords");
        if (payRecordList != null) {
            BigDecimal needPayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
            DynamicObject payRecord = payRecordList.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"payway") == PaymentModeEnum.creditpay.getKey()).findFirst().orElse(null);
            if (payRecord != null) {
                BigDecimal showAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)payRecord, (String)"showamount");
                needPayAmount = needPayAmount.add(showAmount).subtract(creditAmount);
                payRecord.set("paytime", (Object)TimeServiceHelper.now());
                payRecord.set("showamount", (Object)creditAmount);
                payRecordList.removeIf(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"payway") == PaymentModeEnum.creditpay.getKey() && DynamicObjectUtils.getBigDecimal((DynamicObject)x, (String)"showamount").compareTo(BigDecimal.ZERO) == 0);
            } else {
                this.addCreditRecordEntry();
                needPayAmount = needPayAmount.subtract(creditAmount);
            }
            dataEntity.set("needpayamount", (Object)needPayAmount);
            this.getView().updateView("payrecords");
            this.getView().updateView("needpayamount");
        }
        this.getView().getParentView().updateView("creditamount");
    }
}

