/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.ocpos.business.commonhelper.AmountHelper;
import kd.occ.ocpos.business.pay.PosPayLogHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class SaleOrderPosPlugin
extends OcbaseFormPlugin {
    public static final String BTN_OK = "btnok";
    public static final String PAYAMOUNT = "payamount";
    public static final String SALEOPTION = "saleoption";
    public static final String ORDERNO = "orderno";
    public static final String PAYFLOWID = "payflowid";
    public static final Log log = LogFactory.getLog(SaleOrderPosPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        if (customcontrol.getData() != null) {
            e.setCancel(true);
            this.getView().showMessage("\u652f\u4ed8\u4e2d,\u8bf7\u52ff\u5173\u95ed");
            return;
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityId = (String)formShowParameter.getCustomParam("entityid");
        String saleOption = formShowParameter.getCustomParam(SALEOPTION) == null ? "1" : (String)formShowParameter.getCustomParam(SALEOPTION);
        this.getModel().setValue(SALEOPTION, (Object)saleOption);
        this.getModel().setValue(ORDERNO, formShowParameter.getCustomParam(ORDERNO));
        this.getModel().setValue(PAYFLOWID, formShowParameter.getCustomParam(PAYFLOWID));
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)entityId);
        BigDecimal hasPayAmount = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("haspayamount"));
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        if (saleOption.equalsIgnoreCase("0")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{PAYAMOUNT});
            this.getModel().setValue(PAYAMOUNT, (Object)hasPayAmount);
        } else {
            this.getModel().setValue(PAYAMOUNT, (Object)AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (long)branchId, (BigDecimal)hasPayAmount));
        }
    }

    public void closePosForm(IFormView view, int payWayId) {
        Object returnData = view.getReturnData();
        if (!(returnData instanceof String)) {
            return;
        }
        String returnString = JSON.toJSONString((Object)returnData);
        JSONObject returnDataJson = JSONObject.parseObject((String)returnData.toString());
        if (returnDataJson == null) {
            return;
        }
        JSONObject data = returnDataJson.getJSONObject("data");
        BigDecimal showNeedAmount = new BigDecimal(view.getParentView().getModel().getValue("needpayamount").toString());
        if (data != null) {
            data.put("needpayamount", (Object)showNeedAmount);
            data.put("payway", (Object)payWayId);
            data.put(PAYFLOWID, view.getModel().getValue(PAYFLOWID));
            if (payWayId == 25) {
                data.put("transDate", (Object)(DateUtil.getYearFormat((Date)new Date()) + data.getString("transDate")));
                returnDataJson.put("data", (Object)data);
                returnString = JSON.toJSONString((Object)returnDataJson);
            }
        } else {
            log.info("\u6570\u636e\u5305\u5f02\u5e38\uff1a" + returnString);
        }
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String entityId = (String)formShowParameter.getCustomParam("entityid");
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)entityId);
        String billNo = DynamicObjectUtil.getString((DynamicObject)saleOrder, (String)"billno");
        PosPayLogHelper.savePayLog((String)billNo, (String)returnString, (int)0);
        SaleOrderPosPlugin.printPayLog(payWayId, returnString);
        CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap");
        customcontrol.setData(null);
        view.returnDataToParent((Object)returnDataJson);
        view.hideLoading();
        view.close();
    }

    private static void printPayLog(int payWayId, String returnString) {
        switch (payWayId) {
            case 22: {
                log.info("\u519c\u884cPOS\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            case 23: {
                log.info("\u4e2d\u884cPOS\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            case 24: {
                log.info("\u5efa\u884cPOS\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            case 25: {
                log.info("\u94f6\u8054POS\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            case 28: {
                log.info("\u5efa\u884c\u626b\u7801\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            case 31: {
                log.info("\u519c\u884c\u626b\u7801\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            case 32: {
                log.info("\u94f6\u8054\u626b\u7801\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            case 33: {
                log.info("\u4e2d\u884c\u626b\u7801\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            case 34: {
                log.info("\u5efa\u884c\u5206\u671f\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            case 35: {
                log.info("\u519c\u884c\u5206\u671f\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            case 36: {
                log.info("\u4e2d\u884c\u5206\u671f\u8fd4\u56de\u6570\u636e\u5305\uff1a" + returnString);
                break;
            }
            default: {
                log.info("\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728");
            }
        }
    }

    public static boolean checkPayAmount(IFormView view, BigDecimal payAmt, BigDecimal hasPayAmount, String saleOption) {
        payAmt = payAmt.abs().stripTrailingZeros();
        hasPayAmount = hasPayAmount.abs().stripTrailingZeros();
        if (payAmt.compareTo(BigDecimal.ZERO) <= 0) {
            view.showErrorNotification("\u652f\u4ed8\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
            view.hideLoading();
            return false;
        }
        if (payAmt.compareTo(hasPayAmount) > 0 && StringUtils.equals((CharSequence)saleOption, (CharSequence)"1")) {
            view.showErrorNotification("\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u3002");
            view.hideLoading();
            return false;
        }
        if (hasPayAmount.compareTo(BigDecimal.ZERO) == 0) {
            view.showErrorNotification("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u4e3a0\uff0c\u8bf7\u52ff\u64cd\u4f5c\u3002");
            view.hideLoading();
            return false;
        }
        return true;
    }
}

