/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.payhelper.PaymentFlowHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.pay.payment.vo.PaymentRecord;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.business.saleorder.TicketAmountHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.SaleStatusEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.FormViewUtil;
import kd.occ.ocpos.common.util.PayUtil;
import kd.occ.ocpos.formplugin.saleorder.pay.SaleOrderPayInfoPlugin;

public class SaleOrderRefundInfoPlugin
extends AbstractFormPlugin {
    private static final int PAYMODEDISPALYNUMBERMAX = 12;
    private static final String OTHERPAYWAY = "-1000";
    private static final String PAYMODEBTNFLEX = "paymodebtnflex";
    private static final Log log = LogFactory.getLog(SaleOrderRefundInfoPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String strBtnKeyPayModeIdMap = this.getPageCache().get("btnKeyPayModeIdMap");
        if (StringUtils.isEmpty((CharSequence)strBtnKeyPayModeIdMap)) {
            return;
        }
        Map btnKeyPayModeIdMap = (Map)JSONObject.parseObject((String)strBtnKeyPayModeIdMap, Map.class);
        if (!CollectionUtils.isEmpty((Map)btnKeyPayModeIdMap)) {
            this.addClickListeners(btnKeyPayModeIdMap.keySet().toArray(new String[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleReturnId = formShowParameter.getCustomParam("Id");
        if (saleReturnId != null) {
            this.loadUsedPayMode();
            String entityId = this.getView().getParentView().getEntityId();
            DynamicObject saleReturn = BusinessDataServiceHelper.loadSingle((Object)saleReturnId, (String)entityId, (String)this.getSelectFields(entityId));
            this.setFormHeadFieldValue(saleReturn);
            this.loadRefundRecordInfoPaymentFlows(saleReturn);
        }
    }

    private String getSelectFields(String entityId) {
        String selectFields = "id,sourcebillid,biztype,bizorgid,customerid,currencyid,locurrencyid,sumbalamount,sumamount,sumdiscount,receivableamount,totalrealamount";
        if (StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)"ocpos_salechange")) {
            selectFields = selectFields + "," + "changeitemtype";
        }
        return selectFields;
    }

    public void loadUsedPayMode() {
        HashMap<String, String> btnKeyPayModeIdMap = new HashMap<String, String>(20);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        long cashierRoleId = CommonUtil.formatObejctToLong((Object)parameter.getCustomParam("cashierid"));
        long posId = CommonUtil.formatObejctToLong((Object)parameter.getCustomParam("pos"));
        List displayPayModes = PayUtil.getDisplayPayModeData((long)cashierRoleId, (long)posId, (String)"main", (String)"0");
        int mapSize = displayPayModes.size();
        ArrayList<Long> mainOverPayModeIds = new ArrayList<Long>(mapSize);
        int payModeIndex = 1;
        String btnPayModeKey = "";
        if (!CollectionUtils.isEmpty((Collection)displayPayModes)) {
            for (JSONObject payMode : displayPayModes) {
                long payModeId = payMode.getLong("id");
                if (payModeIndex >= 12) {
                    mainOverPayModeIds.add(payModeId);
                    continue;
                }
                String payModeName = payMode.getString("name");
                btnPayModeKey = "btn_paymode_" + payModeIndex;
                HashMap<String, String> itemMap = new HashMap<String, String>();
                itemMap.put("zh_CN", payModeName);
                HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                fieldMap.put("text", itemMap);
                String color = payMode.getBooleanValue("isdefault") ? "#FF0000" : "#000000";
                fieldMap.put("fc", color);
                this.getView().updateControlMetadata(btnPayModeKey, fieldMap);
                btnKeyPayModeIdMap.put(btnPayModeKey, String.valueOf(payModeId));
                ++payModeIndex;
            }
        }
        btnPayModeKey = "btn_paymode_" + payModeIndex;
        HashMap<String, String> moreItemMap = new HashMap<String, String>();
        moreItemMap.put("zh_CN", "\u66f4\u591a\u652f\u4ed8\u65b9\u5f0f");
        HashMap<String, HashMap<String, String>> moreFieldMap = new HashMap<String, HashMap<String, String>>();
        moreFieldMap.put("text", moreItemMap);
        this.getView().updateControlMetadata(btnPayModeKey, moreFieldMap);
        btnKeyPayModeIdMap.put(btnPayModeKey, OTHERPAYWAY);
        if (++payModeIndex <= 12) {
            for (int i = payModeIndex; i <= 12; ++i) {
                btnPayModeKey = "btn_paymode_" + i;
                this.getView().setVisible(Boolean.FALSE, new String[]{btnPayModeKey});
            }
        }
        this.getPageCache().put("btnKeyPayModeIdMap", JSONObject.toJSONString(btnKeyPayModeIdMap));
        this.getPageCache().put("mainOverPayModeIds", JSONObject.toJSONString(mainOverPayModeIds));
    }

    private void setFormHeadFieldValue(DynamicObject saleReturn) {
        this.getModel().setValue("currency", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"currencyid"));
        this.getModel().setValue("actualprice", (Object)saleReturn.getBigDecimal("sumbalamount").toPlainString());
        this.getModel().setValue("totalprice", (Object)saleReturn.getBigDecimal("sumamount").toPlainString());
        this.getModel().setValue("discountamount", (Object)saleReturn.getBigDecimal("sumdiscount").toPlainString());
        this.getModel().setValue("locurrency", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"locurrencyid"));
        this.getModel().setValue("customer", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"customerid"));
        this.getModel().setValue("biztype", (Object)DynamicObjectUtils.getString((DynamicObject)saleReturn, (String)"biztype"));
        this.getModel().setValue("bizorgid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"bizorgid"));
    }

    private void loadRefundRecordInfoPaymentFlows(DynamicObject saleReturn) {
        DynamicObject[] refundFlowObjects;
        if (saleReturn == null) {
            return;
        }
        BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleReturn, (String)"receivableamount");
        BigDecimal needPayAmount = receivableAmount.subtract(saleReturn.getBigDecimal("totalrealamount"));
        this.getModel().setValue("needpayamount", (Object)needPayAmount);
        this.getModel().setValue("receivableamount", (Object)receivableAmount);
        long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)saleReturn, (String)"sourcebillid");
        String bizType = DynamicObjectUtils.getString((DynamicObject)saleReturn, (String)"biztype");
        if (sourceBillId == 0L || StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) {
            this.getModel().setValue("needpayamount", (Object)needPayAmount);
            return;
        }
        String changeItemType = "";
        DynamicObjectCollection payRecordList = this.getModel().getEntryEntity("payrecords");
        DynamicObjectCollection backRecordList = this.getModel().getEntryEntity("returnpayrecords");
        if (StringUtils.equals((CharSequence)BizTypeEnum.CHANGE.getValue(), (CharSequence)bizType)) {
            changeItemType = DynamicObjectUtils.getString((DynamicObject)saleReturn, (String)"changeitemtype");
        }
        if (StringUtils.equals((CharSequence)BizTypeEnum.SALERETURN.getValue(), (CharSequence)bizType) || StringUtils.equals((CharSequence)"2", (CharSequence)changeItemType)) {
            this.doDiscountTypeHandle(needPayAmount);
            needPayAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("needpayamount"));
        }
        BigDecimal needRefundAmount = needPayAmount;
        BigDecimal wipeAmount = BigDecimal.ZERO;
        boolean isExistPosPay = false;
        DynamicObjectCollection iniPaymentFlows = new DynamicObjectCollection();
        HashMap<Long, DynamicObject> iniBillIdAlterPayWayMap = new HashMap<Long, DynamicObject>(0);
        ArrayList<String> payFlowPayWayIds = new ArrayList<String>(0);
        ArrayList<Long> lockRetIniBillIds = new ArrayList<Long>(0);
        this.getIniPaymentFlows(saleReturn, iniPaymentFlows, iniBillIdAlterPayWayMap, lockRetIniBillIds);
        if (iniPaymentFlows.size() == 0 || needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        DynamicObjectCollection sortIniPaymentFlows = new DynamicObjectCollection();
        this.getSortIniPaymentFlows(iniPaymentFlows, sortIniPaymentFlows, lockRetIniBillIds);
        int seq = 0;
        for (DynamicObject iniPaymentFlow : sortIniPaymentFlows) {
            DynamicObject rePayWay;
            String paymentCode;
            DynamicObject payWay = iniPaymentFlow.getDynamicObject("settlement");
            payFlowPayWayIds.add(String.valueOf(DynamicObjectUtil.getPkValue((DynamicObject)payWay)));
            long billId = DynamicObjectUtil.getLong((DynamicObject)iniPaymentFlow, (String)"billid");
            if (lockRetIniBillIds.contains(billId)) {
                this.getView().setEnable(Boolean.FALSE, seq, new String[]{"paybackamount"});
            }
            DynamicObject payRecord = null;
            switch (paymentCode = payWay.getString("number").toLowerCase()) {
                case "equalvaluepay": 
                case "customercompensation": {
                    break;
                }
                case "ignoredecimal": {
                    BigDecimal settleAmount = iniPaymentFlow.getBigDecimal("settleamount").negate();
                    payRecord = payRecordList.addNew();
                    BigDecimal payBackAmount = this.addPayRecordEntity(payRecord, settleAmount, null, iniPaymentFlow, seq, false, BigDecimal.ZERO);
                    needRefundAmount = needRefundAmount.subtract(payBackAmount);
                    ++seq;
                    DynamicObject backRecord = backRecordList.addNew();
                    this.addRefundRecordEntity(backRecord, payBackAmount, iniPaymentFlow);
                    break;
                }
                case "ccbpos": 
                case "bocpos": 
                case "abcpos": 
                case "unionpaypos": 
                case "ccbscan": 
                case "bocscan": 
                case "abcscan": 
                case "umsscan": {
                    payRecord = payRecordList.addNew();
                    BigDecimal payBackAmount = this.addPayRecordEntity(payRecord, needRefundAmount, null, iniPaymentFlow, seq, false, BigDecimal.ZERO);
                    needRefundAmount = needRefundAmount.subtract(payBackAmount);
                    isExistPosPay = true;
                    ++seq;
                    break;
                }
                case "giftvoucherpay": {
                    String cardNo = DynamicObjectUtils.getString((DynamicObject)iniPaymentFlow, (String)"cardno");
                    BigDecimal settleAmount = TicketAmountHelper.calcTicketRetAmount((String)cardNo, (BigDecimal)needRefundAmount, (DynamicObject)saleReturn);
                    payRecord = payRecordList.addNew();
                    BigDecimal payBackAmount = this.addPayRecordEntity(payRecord, settleAmount, null, iniPaymentFlow, seq, false, BigDecimal.ZERO);
                    needRefundAmount = needRefundAmount.subtract(payBackAmount);
                    ++seq;
                    break;
                }
                default: {
                    payRecord = payRecordList.addNew();
                    BigDecimal payBackAmount = this.addPayRecordEntity(payRecord, needRefundAmount, null, iniPaymentFlow, seq, false, BigDecimal.ZERO);
                    needRefundAmount = needRefundAmount.subtract(payBackAmount);
                    ++seq;
                }
            }
            if (payRecord == null || (rePayWay = (DynamicObject)iniBillIdAlterPayWayMap.get(billId)) == null) continue;
            payRecord.set("paywayname", (Object)(payRecord.getString("paywayname") + "\u3010" + rePayWay.getString("name") + "\u3011"));
        }
        this.getView().updateView("payrecords");
        this.getPageCache().put("payFlowPayWayIds", JSONObject.toJSONString(payFlowPayWayIds));
        BigDecimal formLoadSumAmount = BigDecimal.ZERO;
        for (DynamicObject refundFlow : refundFlowObjects = PaymentFlowHelper.getAllPaymentFlow((Object)DynamicObjectUtil.getPkValue((DynamicObject)saleReturn))) {
            String payOption = refundFlow.getString("payoption");
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)payOption)) continue;
            DynamicObject currency = refundFlow.getDynamicObject("currency");
            BigDecimal settleAmount = refundFlow.getBigDecimal("settleamount");
            DynamicObject payWay = refundFlow.getDynamicObject("settlement");
            DynamicObject payWayType = refundFlow.getDynamicObject("paywaytype");
            Date payTime = refundFlow.getDate("paytime");
            formLoadSumAmount = formLoadSumAmount.add(settleAmount);
            DynamicObject backRecord = backRecordList.addNew();
            backRecord.set("returnpayway", (Object)payWay);
            backRecord.set("paywaytype", (Object)payWayType);
            backRecord.set("hasreturnamount", (Object)settleAmount);
            backRecord.set("returntime", (Object)payTime);
            backRecord.set("returncurrency", (Object)currency);
            backRecord.set("returnstatus", (Object)"1");
            backRecord.set("returnenrtyid", (Object)refundFlow.getLong("billid"));
        }
        this.getView().updateView("returnpayrecords");
        this.getModel().setValue("formloadsumamount", (Object)formLoadSumAmount);
        needPayAmount = needPayAmount.subtract(wipeAmount);
        if (StringUtils.equals((CharSequence)BizTypeEnum.REDRUSH.getValue(), (CharSequence)bizType) && !isExistPosPay) {
            needPayAmount = needRefundAmount;
        }
        this.getModel().setValue("needpayamount", (Object)needPayAmount);
    }

    private void getIniPaymentFlows(DynamicObject saleReturn, DynamicObjectCollection iniPaymentFlows, Map<Long, DynamicObject> iniBillIdAlterPayWayMap, List<Long> lockRetIniBillIds) {
        long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)saleReturn, (String)"sourcebillid");
        if (sourceBillId == 0L) {
            return;
        }
        HashSet<Long> doBillIds = new HashSet<Long>(0);
        HashMap<Long, DynamicObject> billIdDataEntityMap = new HashMap<Long, DynamicObject>(0);
        String saleOrderSelectFields = "sourcebillid,finalbillid,finalbillids,srcbiztype";
        String saleChangeSelectFields = "sourcebillid,finalbillid,finalbillids";
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ocpos_saleorder", (String)saleOrderSelectFields);
        billIdDataEntityMap.put(sourceBillId, sourceBill);
        BigDecimal receivableamount = DynamicObjectUtil.getBigDecimal((DynamicObject)saleReturn, (String)"receivableamount");
        if (receivableamount.compareTo(BigDecimal.ZERO) != 0) {
            doBillIds.add(sourceBillId);
        }
        if (doBillIds.isEmpty()) {
            return;
        }
        while (!doBillIds.isEmpty()) {
            HashSet<Long> finalDoBillIds = new HashSet<Long>(0);
            for (Long doBillId : doBillIds) {
                HashSet targetBillIdSet;
                Map targetBills;
                DynamicObject doBill = (DynamicObject)billIdDataEntityMap.get(doBillId);
                long finalbillid = DynamicObjectUtil.getLong((DynamicObject)doBill, (String)"finalbillid");
                if (finalbillid <= 0L || (targetBills = BFTrackerServiceHelper.findTargetBills((String)"ocpos_saleorder", (Long[])new Long[]{doBillId})) == null || targetBills.size() <= 0 || (targetBillIdSet = (HashSet)targetBills.get("ocpos_saleorder_final")).isEmpty() || billIdDataEntityMap.size() <= 0) continue;
                HashSet<Long> removeTargetIds = new HashSet<Long>(0);
                for (Long targetBillId : targetBillIdSet) {
                    if (targetBillId <= 0L || !billIdDataEntityMap.containsKey(targetBillId)) continue;
                    removeTargetIds.add(targetBillId);
                }
                if (!removeTargetIds.isEmpty()) {
                    targetBillIdSet.removeAll(removeTargetIds);
                }
                if (targetBillIdSet.isEmpty()) continue;
                for (Long targetBillId : targetBillIdSet) {
                    DynamicObject finalBill;
                    long baseBillTypeId;
                    if (targetBillId <= 0L || (baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)(finalBill = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)"ocpos_saleorder_final", (String)"basebilltype,sourcebillid")), (String)"basebilltype")) != BillTypeEnum.FINAL.getId() && baseBillTypeId != BillTypeEnum.RESERVEFINAL.getId()) continue;
                    finalDoBillIds.add(targetBillId);
                    billIdDataEntityMap.put(targetBillId, finalBill);
                }
            }
            if (!finalDoBillIds.isEmpty()) {
                doBillIds.addAll(finalDoBillIds);
            }
            DynamicObject[] paymentFlows = PaymentFlowHelper.getRedRefundFlowByIds(doBillIds);
            doBillIds.clear();
            block14: for (DynamicObject paymentFlow : paymentFlows) {
                long billId = DynamicObjectUtil.getLong((DynamicObject)paymentFlow, (String)"billid");
                DynamicObject payWay = paymentFlow.getDynamicObject("settlement");
                String paymentCode = DynamicObjectUtil.getString((DynamicObject)payWay, (String)"number").toLowerCase();
                DynamicObject doBill = (DynamicObject)billIdDataEntityMap.get(billId);
                switch (paymentCode) {
                    case "deposit": {
                        lockRetIniBillIds.add(billId);
                        long depositBillId = DynamicObjectUtil.getLong((DynamicObject)doBill, (String)"sourcebillid");
                        if (depositBillId <= 0L) continue block14;
                        doBillIds.add(depositBillId);
                        DynamicObject depositBill = BusinessDataServiceHelper.loadSingle((Object)depositBillId, (String)"ocpos_saleorder", (String)saleOrderSelectFields);
                        billIdDataEntityMap.put(depositBillId, depositBill);
                        iniBillIdAlterPayWayMap.put(depositBillId, payWay);
                        continue block14;
                    }
                    case "exchangepay": {
                        long changeBillId;
                        String srcbiztype = DynamicObjectUtil.getString((DynamicObject)doBill, (String)"srcbiztype");
                        if (!StringUtils.equalsIgnoreCase((CharSequence)srcbiztype, (CharSequence)BizTypeEnum.CHANGE.getValue()) || (changeBillId = DynamicObjectUtils.getLong((DynamicObject)doBill, (String)"sourcebillid")) <= 0L) continue block14;
                        lockRetIniBillIds.add(changeBillId);
                        doBillIds.add(changeBillId);
                        DynamicObject changeBill = BusinessDataServiceHelper.loadSingle((Object)changeBillId, (String)"ocpos_salechange", (String)saleChangeSelectFields);
                        billIdDataEntityMap.put(changeBillId, changeBill);
                        long saleBillId = DynamicObjectUtils.getLong((DynamicObject)changeBill, (String)"sourcebillid");
                        if (saleBillId <= 0L) continue block14;
                        doBillIds.add(saleBillId);
                        DynamicObject saleBill = BusinessDataServiceHelper.loadSingle((Object)saleBillId, (String)"ocpos_saleorder");
                        billIdDataEntityMap.put(saleBillId, saleBill);
                        continue block14;
                    }
                    case "tosettleaccounts": {
                        HashSet targetBillIdSet;
                        Map targetBills;
                        String srcFinalBillids = DynamicObjectUtils.getString((DynamicObject)doBill, (String)"finalbillids");
                        if (StringUtils.isNotEmpty((CharSequence)srcFinalBillids) && (targetBills = BFTrackerServiceHelper.findTargetBills((String)"ocpos_saleorder", (Long[])new Long[]{billId})) != null && targetBills.size() > 0 && (targetBillIdSet = (HashSet)targetBills.get("ocpos_saleorder_final")) != null && targetBillIdSet.size() > 0 && billIdDataEntityMap.size() > 0) {
                            HashSet<Long> removeTargetIds = new HashSet<Long>(0);
                            for (Long targetBillId : targetBillIdSet) {
                                if (targetBillId <= 0L || !billIdDataEntityMap.containsKey(targetBillId)) continue;
                                removeTargetIds.add(targetBillId);
                            }
                            if (removeTargetIds.size() > 0) {
                                targetBillIdSet.removeAll(removeTargetIds);
                            }
                            if (targetBillIdSet.size() > 0) {
                                for (Long targetBillId : targetBillIdSet) {
                                    DynamicObject targetBill;
                                    long baseBillTypeId;
                                    if (targetBillId <= 0L || (baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)(targetBill = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)"ocpos_saleorder_final", (String)"basebilltype,sourcebillid")), (String)"basebilltype")) != BillTypeEnum.CREDIT.getId()) continue;
                                    doBillIds.add(targetBillId);
                                    billIdDataEntityMap.put(targetBillId, targetBill);
                                    iniBillIdAlterPayWayMap.put(targetBillId, payWay);
                                }
                            }
                        }
                        iniPaymentFlows.add((Object)paymentFlow);
                        continue block14;
                    }
                    default: {
                        iniPaymentFlows.add((Object)paymentFlow);
                    }
                }
            }
        }
    }

    private void getSortIniPaymentFlows(DynamicObjectCollection iniPaymentFlows, DynamicObjectCollection sortIniPaymentFlows, List<Long> lockRetIniBillIds) {
        int flowsSize = iniPaymentFlows.size();
        ArrayList<DynamicObject> lockPayWayList_one = new ArrayList<DynamicObject>(flowsSize);
        ArrayList<DynamicObject> lockPayWayList_two = new ArrayList<DynamicObject>(flowsSize);
        ArrayList<DynamicObject> unlockPayWayList_one = new ArrayList<DynamicObject>(flowsSize);
        ArrayList<DynamicObject> lastPayWayList = new ArrayList<DynamicObject>(flowsSize);
        for (DynamicObject paymentFlow : iniPaymentFlows) {
            long billId = DynamicObjectUtil.getLong((DynamicObject)paymentFlow, (String)"billid");
            DynamicObject payWay = paymentFlow.getDynamicObject("settlement");
            if (lockRetIniBillIds.contains(billId)) {
                if (DynamicObjectUtils.getPkValue((DynamicObject)payWay) == PaymentModeEnum.creditpay.getKey() || DynamicObjectUtils.getPkValue((DynamicObject)payWay) == PaymentModeEnum.coupon.getKey()) {
                    lockPayWayList_one.add(paymentFlow);
                    continue;
                }
                lockPayWayList_two.add(paymentFlow);
                continue;
            }
            if (DynamicObjectUtils.getPkValue((DynamicObject)payWay) == PaymentModeEnum.coupon.getKey()) {
                unlockPayWayList_one.add(paymentFlow);
                continue;
            }
            lastPayWayList.add(paymentFlow);
        }
        sortIniPaymentFlows.addAll(lockPayWayList_one);
        sortIniPaymentFlows.addAll(lockPayWayList_two);
        sortIniPaymentFlows.addAll(unlockPayWayList_one);
        sortIniPaymentFlows.addAll(lastPayWayList);
    }

    public void afterBindData(EventObject e) {
        block6: {
            String bizType;
            Map btnKeyPayModeIdMap;
            ArrayList<String> payFlowPayWayIds;
            block5: {
                String strBtnKeyPayModeIdMap;
                super.afterBindData(e);
                payFlowPayWayIds = new ArrayList<String>(10);
                String strPayFlowPayWayIds = this.getPageCache().get("payFlowPayWayIds");
                if (!StringUtils.isEmpty((CharSequence)strPayFlowPayWayIds)) {
                    payFlowPayWayIds.addAll((Collection)JSONObject.parseObject((String)strPayFlowPayWayIds, List.class));
                }
                if (StringUtils.isEmpty((CharSequence)(strBtnKeyPayModeIdMap = this.getPageCache().get("btnKeyPayModeIdMap")))) {
                    return;
                }
                btnKeyPayModeIdMap = (Map)JSONObject.parseObject((String)strBtnKeyPayModeIdMap, Map.class);
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Map customParams = formShowParameter.getCustomParams();
                bizType = CommonUtil.formatStringToEmpty((Object)customParams.getOrDefault("biztype", BizTypeEnum.SALERETURN.getValue()));
                if (!StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.REDRUSH.getValue())) break block5;
                this.getView().setEnable(Boolean.FALSE, new String[]{"payrecords"});
                ArrayList<String> displays = new ArrayList<String>(Arrays.asList("22", "23", "24", "25", "28", "31", "32", "33"));
                payFlowPayWayIds.retainAll(displays);
                if (payFlowPayWayIds.size() > 0) {
                    payFlowPayWayIds.add(OTHERPAYWAY);
                }
                for (Map.Entry entry : btnKeyPayModeIdMap.entrySet()) {
                    String payModeId = (String)entry.getValue();
                    if (!CollectionUtils.isEmpty(payFlowPayWayIds) && payFlowPayWayIds.contains(payModeId)) continue;
                    this.getView().setEnable(Boolean.FALSE, new String[]{(String)entry.getKey()});
                }
                break block6;
            }
            if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) break block6;
            payFlowPayWayIds.add(OTHERPAYWAY);
            for (Map.Entry entry : btnKeyPayModeIdMap.entrySet()) {
                String payModeId = (String)entry.getValue();
                if (!CollectionUtils.isEmpty(payFlowPayWayIds) && payFlowPayWayIds.contains(payModeId)) continue;
                this.getView().setEnable(Boolean.FALSE, new String[]{(String)entry.getKey()});
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        String btnPayModeKey = ctrl.getKey();
        String strBtnKeyPayModeIdMap = this.getPageCache().get("btnKeyPayModeIdMap");
        if (StringUtils.isEmpty((CharSequence)strBtnKeyPayModeIdMap)) {
            return;
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{PAYMODEBTNFLEX});
        Map btnKeyPayModeIdMap = (Map)JSONObject.parseObject((String)strBtnKeyPayModeIdMap, Map.class);
        String payModeId = (String)btnKeyPayModeIdMap.get(btnPayModeKey);
        if (StringUtils.equals((CharSequence)payModeId, (CharSequence)OTHERPAYWAY)) {
            this.openOtherPayView();
            return;
        }
        this.openMainPayView(payModeId, false);
    }

    private void openMainPayView(String payModeId, boolean isReplacePay) {
        List<Map<String, Object>> refundPayInfoMaps = this.getRefundPayInfoMaps(payModeId, isReplacePay);
        if (CollectionUtils.isEmpty(refundPayInfoMaps)) {
            return;
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{PAYMODEBTNFLEX});
        boolean isLockPayModeFlex = true;
        switch (payModeId) {
            case "1": {
                this.openRefundPayView("ocpos_wechatpay", "elec_paymentclose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "2": {
                this.openRefundPayView("ocpos_alipay", "elec_paymentclose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "3": {
                this.openCashCustomPayView("ocpos_cashpay", "casecustomclose", payModeId, refundPayInfoMaps, "");
                break;
            }
            case "4": {
                this.openCouponPayView("ocpos_ticketrefund", "couponclose", refundPayInfoMaps);
                break;
            }
            case "7": {
                isLockPayModeFlex = false;
                this.getView().showMessage("\u62b9\u96f6\u6b63\u5728\u5f00\u53d1\u4e2d\u3002");
                break;
            }
            case "12": {
                this.openCashCustomPayView("ocpos_cashpay", "casecustomclose", payModeId, refundPayInfoMaps, "\u652f\u7968\u652f\u4ed8");
                break;
            }
            case "14": {
                this.openCashCustomPayView("ocpos_cashpay", "casecustomclose", payModeId, refundPayInfoMaps, "\u8ba2\u91d1\u652f\u4ed8");
                break;
            }
            case "15": {
                if (this.getModel().getValue("customer") == null) {
                    this.openCreditCustomerPayView("ocpos_creditcustomer", "creditclose");
                    break;
                }
                this.openCreditAccountPayView("ocpos_creditpay", "noelectronicclose", refundPayInfoMaps);
                break;
            }
            case "19": 
            case "20": {
                isLockPayModeFlex = false;
                this.getView().showMessage("\u4e0d\u80fd\u7528\u4e8e\u652f\u4ed8\u3002");
                break;
            }
            case "21": {
                this.openCustcomPensationPayView("ocpos_custcompensation", "custompay", refundPayInfoMaps);
                break;
            }
            case "22": {
                this.openRefundPayView("ocpos_abcpos", "abcClose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "23": {
                this.openRefundPayView("ocpos_bocpos", "bocClose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "24": {
                this.openRefundPayView("ocpos_ccbpos", "ccbClose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "28": {
                this.openRefundPayView("ocpos_scanpay", "ccbClose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "25": {
                this.openRefundPayView("ocpos_umspos", "umsClose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "27": {
                isLockPayModeFlex = false;
                this.getView().showMessage("\u6362\u8d27\u62b5\u6263\u4e0d\u80fd\u7528\u4e8e\u652f\u4ed8\u3002");
                break;
            }
            case "29": {
                this.openRefundPayView("ocpos_kingdeefinancepay", "elec_paymentclose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "31": {
                this.openRefundPayView("ocpos_abcscan", "abcClose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "32": {
                this.openRefundPayView("ocpos_umsscan", "elec_paymentclose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "33": {
                this.openRefundPayView("ocpos_bocscan", "bocClose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "34": 
            case "35": 
            case "36": {
                DynamicObject customPayment = BusinessDataServiceHelper.loadSingle((Object)payModeId, (String)"ocdbd_paymode");
                this.openRefundPayView("ocpos_stagerefund", "stageRefundClose", refundPayInfoMaps, customPayment.getString("name"));
                break;
            }
            case "37": {
                this.openRefundPayView("ocpos_channelpreference", "channelPreferenceClose", refundPayInfoMaps, new String[0]);
                break;
            }
            case "5": 
            case "6": 
            case "8": 
            case "9": 
            case "18": 
            case "26": {
                isLockPayModeFlex = false;
                this.getView().showMessage("\u6b63\u5728\u5f00\u53d1\u4e2d\u3002");
                break;
            }
            default: {
                DynamicObject custom = BusinessDataServiceHelper.loadSingle((Object)payModeId, (String)"ocdbd_paymode");
                if (!custom.getBoolean("iselectronicpay")) {
                    this.openCashCustomPayView("ocpos_cashpay", "casecustomclose", payModeId, refundPayInfoMaps, custom.getString("name"));
                    break;
                }
                isLockPayModeFlex = false;
                this.getView().showMessage("\u6b63\u5728\u5f00\u53d1\u4e2d\u3002");
            }
        }
        if (!isLockPayModeFlex) {
            this.getView().setEnable(Boolean.TRUE, new String[]{PAYMODEBTNFLEX});
        }
    }

    private List<Map<String, Object>> getRefundPayInfoMaps(String payModeId, boolean isReplacePay) {
        ArrayList<Map<String, Object>> refundPayInfoMaps = new ArrayList<Map<String, Object>>(0);
        String bizType = CommonUtil.formatStringToEmpty((Object)this.getView().getParentView().getModel().getValue("biztype"));
        if (isReplacePay && !StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"N")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("payrecords");
            if (rowIndex < 0) {
                throw new KDBizException("\u672a\u9009\u4e2d\u9000\u6b3e\u8bb0\u5f55\u884c\u3002");
            }
            DynamicObject payFlowRecord = this.getModel().getEntryRowEntity("payrecords", rowIndex);
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)payModeId, (String)"ocdbd_paymode");
            DynamicObject payWayType = this.getPayWayType(payWay);
            HashMap<String, Object> refundPayInfoMap = new HashMap<String, Object>(10);
            refundPayInfoMap.put("payway", payWay);
            refundPayInfoMap.put("paywaytype", payWayType);
            refundPayInfoMap.put("srcreplacepaywayid", payFlowRecord.getDynamicObject("payway").getLong("id"));
            refundPayInfoMap.put("payflowid", payFlowRecord.getLong("payflowid"));
            refundPayInfoMap.put("paybillid", payFlowRecord.getLong("paybillid"));
            refundPayInfoMap.put("sourcebillno", payFlowRecord.getString("sourcebillno"));
            refundPayInfoMap.put("cardno", payFlowRecord.getString("cardno"));
            refundPayInfoMap.put("creditaccountid", payFlowRecord.getLong("creditaccountid"));
            refundPayInfoMap.put("haspayamount", payFlowRecord.getBigDecimal("paybackamount"));
            refundPayInfoMap.put("paytime", payFlowRecord.getDate("paytime"));
            refundPayInfoMaps.add(refundPayInfoMap);
            return refundPayInfoMaps;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"N")) {
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)payModeId, (String)"ocdbd_paymode");
            DynamicObject payWayType = this.getPayWayType(payWay);
            BigDecimal needPayAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("needpayamount"));
            BigDecimal returnAmount = this.getPayWayCanCoverAmount(payWay.getLong("id"));
            needPayAmount = needPayAmount.add(returnAmount);
            HashMap<String, Object> refundPayInfoMap = new HashMap<String, Object>(10);
            refundPayInfoMap.put("payway", payWay);
            refundPayInfoMap.put("paywaytype", payWayType);
            refundPayInfoMap.put("payflowid", 0L);
            refundPayInfoMap.put("orgid", 0L);
            refundPayInfoMap.put("sourcebillno", "");
            refundPayInfoMap.put("cardno", "");
            refundPayInfoMap.put("creditaccountid", 0L);
            refundPayInfoMap.put("haspayamount", needPayAmount);
            refundPayInfoMaps.add(refundPayInfoMap);
            return refundPayInfoMaps;
        }
        List<DynamicObject> selectedPayRecords = this.getSelectedPayRecord(payModeId);
        if (CollectionUtils.isEmpty(selectedPayRecords)) {
            throw new KDBizException("\u5f85\u9000\u91d1\u989d\u4e3a0 \u6216\u8005 \u5df2\u9000\u3002");
        }
        for (DynamicObject selectedPayRecord : selectedPayRecords) {
            DynamicObject payWay = DynamicObjectUtils.getDynamicObject((DynamicObject)selectedPayRecord, (String)"payway");
            BigDecimal paybackAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)selectedPayRecord, (String)"paybackamount");
            if (paybackAmount.compareTo(BigDecimal.ZERO) >= 0) {
                throw new KDBizException(String.format("\u3010%s\u3011\u53ef\u9000\u91d1\u989d\u4e3a0\u3002", payWay.getString("name")));
            }
            BigDecimal canRefundAmount = selectedPayRecord.getBigDecimal("showamount").subtract(selectedPayRecord.getBigDecimal("hasrefundamount").negate()).negate();
            if (paybackAmount.compareTo(canRefundAmount) < 0) {
                throw new KDBizException(String.format("\u3010%s\u3011\u5269\u4f59\u53ef\u9000\u91d1\u989d\u4e3a%s\uff0c\u8bf7\u4fee\u6539\u9000\u6b3e\u91d1\u989d\u3002", payWay.getString("name"), canRefundAmount.stripTrailingZeros().toPlainString()));
            }
            HashMap<String, Object> refundPayInfoMap = new HashMap<String, Object>(10);
            refundPayInfoMap.put("payway", selectedPayRecord.getDynamicObject("payway"));
            refundPayInfoMap.put("paywaytype", selectedPayRecord.getDynamicObject("srcpaywaytype"));
            refundPayInfoMap.put("payflowid", selectedPayRecord.getLong("payflowid"));
            refundPayInfoMap.put("paybillid", selectedPayRecord.getLong("paybillid"));
            refundPayInfoMap.put("sourcebillno", selectedPayRecord.getString("sourcebillno"));
            refundPayInfoMap.put("cardno", selectedPayRecord.getString("cardno"));
            refundPayInfoMap.put("creditaccountid", selectedPayRecord.getLong("creditaccountid"));
            refundPayInfoMap.put("haspayamount", selectedPayRecord.getBigDecimal("paybackamount"));
            refundPayInfoMap.put("paytime", selectedPayRecord.getDate("paytime"));
            refundPayInfoMaps.add(refundPayInfoMap);
        }
        return refundPayInfoMaps;
    }

    private BigDecimal getPayWayCanCoverAmount(long backPayWayId) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal hasReturnAmount = BigDecimal.ZERO;
        DynamicObjectCollection returnPayRecords = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"returnpayrecords");
        for (DynamicObject returnPayRecord : returnPayRecords) {
            DynamicObject returnPayWay = returnPayRecord.getDynamicObject("returnpayway");
            long returnPayWayId = returnPayWay.getLong("id");
            String retCardNo = returnPayRecord.getString("retcardno");
            if (backPayWayId != returnPayWayId || !StringUtils.isEmpty((CharSequence)retCardNo) || returnPayWay.getBoolean("iselectronicpay")) continue;
            hasReturnAmount = returnPayRecord.getBigDecimal("hasreturnamount");
            break;
        }
        if (hasReturnAmount.compareTo(BigDecimal.ZERO) > 0) {
            hasReturnAmount = BigDecimal.ZERO;
        }
        return hasReturnAmount;
    }

    private List<DynamicObject> getSelectedPayRecord(String payModeId) {
        BigDecimal receivableAmount;
        ArrayList<DynamicObject> selectedPayRecords = null;
        BigDecimal paybackAmountSum = BigDecimal.ZERO;
        DynamicObjectCollection payFlowRecords = this.getModel().getEntryEntity("payrecords");
        if (!CollectionUtils.isEmpty((Collection)payFlowRecords)) {
            selectedPayRecords = new ArrayList<DynamicObject>(payFlowRecords.size());
            for (DynamicObject payFlow : payFlowRecords) {
                boolean isAllRefund = payFlow.getBoolean("isallrefund");
                BigDecimal paybackAmount = payFlow.getBigDecimal("paybackamount");
                DynamicObject payWay = payFlow.getDynamicObject("payway");
                if (isAllRefund || paybackAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                paybackAmountSum = paybackAmountSum.add(paybackAmount);
                boolean isrefundedthistimes = payFlow.getBoolean("isrefundedthistimes");
                if (isrefundedthistimes || DynamicObjectUtil.getPkValue((DynamicObject)payWay) != CommonUtil.formatStringToLong((String)payModeId)) continue;
                boolean isEachRefundOneRecord = true;
                if (!payWay.getBoolean("iselectronicpay")) {
                    isEachRefundOneRecord = false;
                }
                if (!isEachRefundOneRecord) {
                    selectedPayRecords.add(payFlow);
                    continue;
                }
                if (!isEachRefundOneRecord || !CollectionUtils.isEmpty(selectedPayRecords)) continue;
                selectedPayRecords.add(payFlow);
            }
        }
        BigDecimal equalValueAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("equalvalueamount"));
        paybackAmountSum = paybackAmountSum.add(equalValueAmount);
        BigDecimal formLoadSumAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("formloadsumamount"));
        if ((paybackAmountSum = paybackAmountSum.add(formLoadSumAmount)).compareTo(receivableAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("receivableamount"))) != 0) {
            throw new KDBizException(String.format("\u5408\u8ba1\u9000\u6b3e\u91d1\u989d\uff1a%s \u4e0d\u7b49\u4e8e\u5e94\u9000\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u5f85\u9000\u91d1\u989d\u3002", paybackAmountSum.stripTrailingZeros().toPlainString()));
        }
        return selectedPayRecords;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (!operationResult.isSuccess()) {
            this.getView().showOperationResult(operationResult);
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleReturnId = formShowParameter.getCustomParam("Id");
        if ("returnpay".equals(key)) {
            try {
                String message = this.checkBeforeReturnPay();
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    this.getView().showErrorNotification(message);
                    return;
                }
                DynamicObject saleReturn = null;
                String bizType = formShowParameter.getCustomParam("biztype").toString();
                saleReturn = StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)BizTypeEnum.CHANGE.getValue()) ? BusinessDataServiceHelper.loadSingle((Object)saleReturnId, (String)"ocpos_salechange") : BusinessDataServiceHelper.loadSingle((Object)saleReturnId, (String)"ocpos_saleorder_return");
                Map<String, String> recordsField = SaleOrderRefundInfoPlugin.getRecordsField(saleReturn);
                List<PaymentRecord> paymentRecords = this.getPaymentInfoForRefund(saleReturn, recordsField);
                if (StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"R")) {
                    this.replacePaymentInfoForRefund(paymentRecords);
                }
                HashMap<String, String> discountHandleMap = new HashMap<String, String>(5);
                String ticketDiscountType = (String)formShowParameter.getCustomParam("ticketdiscounttype");
                discountHandleMap.put("ticketdiscounttype", ticketDiscountType);
                String integralDiscountType = (String)formShowParameter.getCustomParam("integraldiscounttype");
                discountHandleMap.put("integraldiscounttype", integralDiscountType);
                String giftDiscountType = (String)formShowParameter.getCustomParam("giftdiscounttype");
                discountHandleMap.put("giftdiscounttype", giftDiscountType);
                String giftValueData = (String)formShowParameter.getCustomParam("giftvalue");
                discountHandleMap.put("giftvalue", giftValueData);
                SaleOrderHelper.saveRefundRecordAfterSettleOp((DynamicObject)saleReturn, paymentRecords, discountHandleMap);
                BigDecimal returnCashAmount = (BigDecimal)this.getModel().getValue("returncashamount");
                if (returnCashAmount.compareTo(BigDecimal.ZERO) > 0) {
                    HashMap<String, Object> returnmap = new HashMap<String, Object>(2);
                    returnmap.put("success", "Success");
                    returnmap.put("returncashamount", returnCashAmount);
                    this.getView().returnDataToParent(returnmap);
                } else {
                    this.getView().returnDataToParent((Object)"Success");
                }
                this.getView().getParentView().getModel().setValue("salestatus", (Object)SaleStatusEnum.STATUS_S.getValue());
                if (StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)BizTypeEnum.CHANGE.getValue())) {
                    BigDecimal exchangePayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleReturn, (String)"exchangepayamount");
                    this.getView().getParentView().getModel().setValue("exchangepayamount", (Object)exchangePayAmount);
                }
                this.getView().close();
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        } else if (key.equals("replacepayway")) {
            Object cashierid = formShowParameter.getCustomParam("cashierid");
            if (!ObjectUtils.isEmpty((Object)cashierid)) {
                boolean isreplacepayway;
                int rowIndex = this.getModel().getEntryCurrentRowIndex("payrecords");
                if (rowIndex < 0) {
                    NotificationUtil.showErrorNotification((String)"\u672a\u9009\u4e2d\u9000\u6b3e\u8bb0\u5f55\u884c\u3002", (IFormView)this.getView());
                    return;
                }
                DynamicObject payFlowRecord = this.getModel().getEntryRowEntity("payrecords", rowIndex);
                boolean isrefundedthistimes = payFlowRecord.getBoolean("isrefundedthistimes");
                if (isrefundedthistimes) {
                    NotificationUtil.showErrorNotification((String)"\u672c\u884c\u5df2\u9000\u3002", (IFormView)this.getView());
                    return;
                }
                DynamicObjectCollection returnPayRecords = this.getModel().getEntryEntity("returnpayrecords");
                for (DynamicObject returnPayRecord : returnPayRecords) {
                    Map refundMap;
                    String returnStatus = returnPayRecord.getString("returnstatus");
                    if (!StringUtils.equals((CharSequence)returnStatus, (CharSequence)"1")) continue;
                    long payFlowId = payFlowRecord.getLong("payflowid");
                    if (payFlowId == returnPayRecord.getLong("srcpayflowid")) {
                        NotificationUtil.showErrorNotification((String)"\u672c\u884c\u5df2\u9000\u3002", (IFormView)this.getView());
                        return;
                    }
                    String strRefundMap = returnPayRecord.getString("refundmap");
                    if (!StringUtils.isNotEmpty((CharSequence)strRefundMap) || (refundMap = (Map)JSONObject.parseObject((String)strRefundMap, Map.class)).get(payFlowId) == null) continue;
                    NotificationUtil.showErrorNotification((String)"\u672c\u884c\u5df2\u9000\u3002", (IFormView)this.getView());
                    return;
                }
                ArrayList<Long> replacePayModeIds = null;
                DynamicObject cashier = BusinessDataServiceHelper.loadSingle((Object)cashierid, (String)"ocdbd_cashierrole");
                DynamicObjectCollection replaceWayEntity = cashier.getDynamicObjectCollection("replacewayentity");
                if (!CollectionUtils.isEmpty((Collection)replaceWayEntity)) {
                    replacePayModeIds = new ArrayList<Long>(replaceWayEntity.size());
                    for (DynamicObject entry : replaceWayEntity) {
                        DynamicObject payWay = entry.getDynamicObject("payway");
                        if (payWay == null) continue;
                        replacePayModeIds.add(DynamicObjectUtils.getPkValue((DynamicObject)payWay));
                    }
                }
                if (CollectionUtils.isEmpty(replacePayModeIds)) {
                    NotificationUtil.showErrorNotification((String)String.format("\u6536\u94f6\u5458\uff1a%s \u6ca1\u6709\u66f4\u6539\u9000\u6b3e\u65b9\u5f0f\u7684\u6743\u9650\u3002", cashier.getString("name")), (IFormView)this.getView());
                    return;
                }
                DynamicObject payway = DynamicObjectUtils.getDynamicObject((DynamicObject)payFlowRecord, (String)"payway");
                if (payway != null && !(isreplacepayway = DynamicObjectUtils.getBoolean((DynamicObject)payway, (String)"isreplacepayway"))) {
                    NotificationUtil.showErrorNotification((String)"\u8be5\u6536\u6b3e\u65b9\u5f0f\u4e0d\u5141\u8bb8\u66f4\u6362\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c", (IFormView)this.getView());
                    return;
                }
                this.openOtherPayListView("replacepay", replacePayModeIds, "\u66f4\u6539\u9000\u6b3e\u65b9\u5f0f");
                return;
            }
            NotificationUtil.showErrorNotification((String)"\u6536\u94f6\u5458\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u9000\u6b3e\u65b9\u5f0f\u3002", (IFormView)this.getView());
            return;
        }
    }

    public static Map<String, String> getRecordsField(DynamicObject saleReturn) {
        String bizType;
        HashMap<String, String> fieldMap = new HashMap<String, String>(8);
        switch (bizType = saleReturn.getString("biztype")) {
            case "R": {
                fieldMap.put("payflowid", "payflowid");
                fieldMap.put("payway", "payway");
                fieldMap.put("paywaytype", "srcpaywaytype");
                fieldMap.put("currency", "paycurrency");
                fieldMap.put("refundamount", "paybackamount");
                fieldMap.put("cardno", "cardno");
                fieldMap.put("creditaccountid", "creditaccountid");
                fieldMap.put("orderno", "sourcebillno");
                fieldMap.put("paybillid", "paybillid");
                fieldMap.put("entitykey", "payrecords");
                break;
            }
            case "B": 
            case "Q": 
            case "H": 
            case "N": {
                fieldMap.put("payflowid", "srcpayflowid");
                fieldMap.put("payway", "returnpayway");
                fieldMap.put("paywaytype", "paywaytype");
                fieldMap.put("currency", "returncurrency");
                fieldMap.put("refundamount", "hasreturnamount");
                fieldMap.put("cardno", "retcardno");
                fieldMap.put("creditaccountid", "retcreditaccountid");
                fieldMap.put("orderno", "returnorderno");
                fieldMap.put("paybillid", "retpaybillid");
                fieldMap.put("entitykey", "returnpayrecords");
                break;
            }
            default: {
                throw new KDBizException("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728\uff01");
            }
        }
        return fieldMap;
    }

    public List<PaymentRecord> getPaymentInfoForRefund(DynamicObject saleReturn, Map<String, String> fieldMap) {
        ArrayList<PaymentRecord> paymentRecords = new ArrayList<PaymentRecord>();
        String entityKey = fieldMap.get("entitykey");
        DynamicObjectCollection paymentFlowRecords = this.getModel().getEntryEntity(entityKey);
        long billId = DynamicObjectUtil.getPkValue((DynamicObject)saleReturn);
        String billNo = saleReturn.getString("billno");
        for (DynamicObject paymentFlowRecord : paymentFlowRecords) {
            long payFlowId = paymentFlowRecord.getLong(fieldMap.get("payflowid"));
            BigDecimal settleAmount = paymentFlowRecord.getBigDecimal(fieldMap.get("refundamount"));
            if (settleAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            String cardNo = paymentFlowRecord.getString(fieldMap.get("cardno"));
            long creditAccountId = paymentFlowRecord.getLong(fieldMap.get("creditaccountid"));
            DynamicObject currency = paymentFlowRecord.getDynamicObject(fieldMap.get("currency"));
            String orderNo = paymentFlowRecord.getString(fieldMap.get("orderno"));
            String strRefundMap = DynamicObjectUtils.getString((DynamicObject)paymentFlowRecord, (String)"refundmap");
            DynamicObject payWay = paymentFlowRecord.getDynamicObject(fieldMap.get("payway"));
            DynamicObject payWayType = paymentFlowRecord.getDynamicObject(fieldMap.get("paywaytype"));
            long payBillId = paymentFlowRecord.getLong(fieldMap.get("paybillid"));
            if (StringUtils.isNotEmpty((CharSequence)strRefundMap)) {
                Map refundMap = (Map)JSONObject.parseObject((String)strRefundMap, Map.class);
                for (Map.Entry entry : refundMap.entrySet()) {
                    payFlowId = (Long)entry.getKey();
                    settleAmount = (BigDecimal)entry.getValue();
                    PaymentRecord paymentRecord = new PaymentRecord();
                    paymentRecord.setBillId(billId);
                    paymentRecord.setBillNo(billNo);
                    paymentRecord.setPayFlowId(payFlowId);
                    paymentRecord.setSourcebillId(payBillId);
                    paymentRecord.setPayCurrency(currency);
                    paymentRecord.setPayWay(payWay);
                    paymentRecord.setPayWayType(payWayType);
                    paymentRecord.setAmount(settleAmount);
                    paymentRecord.setCardNo(cardNo);
                    paymentRecord.setPaytime(TimeServiceHelper.now());
                    paymentRecord.setCreditAccountId(creditAccountId);
                    paymentRecord.setOrderNo(orderNo);
                    paymentRecord.setPayStatus("A");
                    paymentRecords.add(paymentRecord);
                }
                continue;
            }
            PaymentRecord paymentRecord = new PaymentRecord();
            paymentRecord.setBillId(billId);
            paymentRecord.setBillNo(billNo);
            paymentRecord.setPayFlowId(payFlowId);
            paymentRecord.setSourcebillId(payBillId);
            paymentRecord.setPayCurrency(currency);
            paymentRecord.setPayWay(payWay);
            paymentRecord.setPayWayType(payWayType);
            paymentRecord.setAmount(settleAmount);
            paymentRecord.setCardNo(cardNo);
            paymentRecord.setPaytime(TimeServiceHelper.now());
            paymentRecord.setCreditAccountId(creditAccountId);
            paymentRecord.setOrderNo(orderNo);
            paymentRecord.setPayStatus("A");
            paymentRecords.add(paymentRecord);
        }
        return paymentRecords;
    }

    private void replacePaymentInfoForRefund(List<PaymentRecord> paymentRecords) {
        if (paymentRecords != null && paymentRecords.size() > 0) {
            HashMap<Long, PaymentRecord> payFlowIdRecordMap = new HashMap<Long, PaymentRecord>(0);
            for (PaymentRecord paymentRecord : paymentRecords) {
                payFlowIdRecordMap.put(paymentRecord.getPayFlowId(), paymentRecord);
            }
            if (payFlowIdRecordMap.size() > 0) {
                ArrayList<PaymentRecord> removePaymentRecords = new ArrayList<PaymentRecord>();
                DynamicObjectCollection returnPayRecords = this.getModel().getEntryEntity("returnpayrecords");
                for (DynamicObject returnPayRecord : returnPayRecords) {
                    long srcPayFlowId = DynamicObjectUtils.getLong((DynamicObject)returnPayRecord, (String)"srcpayflowid");
                    PaymentRecord replacePaymentRecord = (PaymentRecord)payFlowIdRecordMap.get(srcPayFlowId);
                    if (replacePaymentRecord == null) continue;
                    DynamicObject payWay = returnPayRecord.getDynamicObject("returnpayway");
                    if (!DynamicObjectUtils.getBoolean((DynamicObject)payWay, (String)"iselectronicpay")) {
                        DynamicObject payWayType = returnPayRecord.getDynamicObject("paywaytype");
                        BigDecimal settleAmount = returnPayRecord.getBigDecimal("hasreturnamount");
                        replacePaymentRecord.setPayWay(payWay);
                        replacePaymentRecord.setPayWayType(payWayType);
                        replacePaymentRecord.setAmount(settleAmount);
                        replacePaymentRecord.setCardNo(returnPayRecord.getString("retcardno"));
                        replacePaymentRecord.setOrderNo(returnPayRecord.getString("returnorderno"));
                        replacePaymentRecord.setCreditAccountId(returnPayRecord.getLong("retcreditaccountid"));
                        continue;
                    }
                    removePaymentRecords.add(replacePaymentRecord);
                }
                if (removePaymentRecords.size() > 0) {
                    paymentRecords.removeAll(removePaymentRecords);
                }
            }
        }
    }

    public DynamicObject getPayWayType(DynamicObject payWay) {
        DynamicObjectCollection payWayTypeList = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)payWay, (String)"paywaytype");
        if (CollectionUtils.isEmpty((Collection)payWayTypeList)) {
            return null;
        }
        DynamicObject payWayTypeObj = (DynamicObject)payWayTypeList.get(0);
        return DynamicObjectUtil.getDynamicObject((DynamicObject)payWayTypeObj, (String)"fbasedataid");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal needPayAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
        if (needPayAmount.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObjectCollection returnPayRecords = this.getModel().getEntryEntity("returnpayrecords");
            if (returnPayRecords == null || returnPayRecords.isEmpty()) {
                return;
            }
            for (DynamicObject doReturnPayRecord : returnPayRecords) {
                String returnStatus;
                DynamicObject payWay = doReturnPayRecord.getDynamicObject("returnpayway");
                if (!payWay.getBoolean("iselectronicpay") || !StringUtils.equals((CharSequence)(returnStatus = doReturnPayRecord.getString("returnstatus")), (CharSequence)"1")) continue;
                e.setCancel(true);
                this.getView().showMessage("\u7535\u5b50\u652f\u4ed8\u5df2\u9000\u6b3e\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed");
                break;
            }
        } else {
            String entityId;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object saleReturnId = formShowParameter.getCustomParam("Id");
            DynamicObject saleReturn = BusinessDataServiceHelper.loadSingle((Object)saleReturnId, (String)(entityId = this.getView().getParentView().getEntityId()), (String)"salestatus");
            String saleStatus = DynamicObjectUtils.getString((DynamicObject)saleReturn, (String)"salestatus");
            if (!StringUtils.equalsIgnoreCase((CharSequence)saleStatus, (CharSequence)"S")) {
                e.setCancel(true);
                this.getView().showMessage("\u9000\u6b3e\u5b8c\u6210\uff0c\u8bf7\u70b9\u51fb\u201c\u9000\u6b3e\u201d");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection payFlowRecords;
        super.closedCallBack(closedCallBackEvent);
        this.getView().setEnable(Boolean.TRUE, new String[]{PAYMODEBTNFLEX});
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        Map data = closedCallBackEvent.getReturnData() instanceof String ? (Map)JSON.parse((String)((String)closedCallBackEvent.getReturnData())) : (closedCallBackEvent.getReturnData() instanceof JSONObject ? (Map)JSONObject.toJavaObject((JSON)((JSON)closedCallBackEvent.getReturnData()), Map.class) : (HashMap)closedCallBackEvent.getReturnData());
        this.getView().updateView("returnpayrecords");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String bizType = this.getModel().getValue("biztype").toString();
        if (!StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"N") && !CollectionUtils.isEmpty((Collection)(payFlowRecords = dataEntity.getDynamicObjectCollection("payrecords")))) {
            for (int i = 0; i < payFlowRecords.size(); ++i) {
                FormViewUtil.setUnEnable((IFormView)this.getView(), (int)i, (String[])new String[]{"paybackamount"});
            }
        }
        BigDecimal showNeedAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"needpayamount");
        switch (closedCallBackEvent.getActionId()) {
            case "noelectronicclose": 
            case "casecustomclose": {
                this.caseCustomPayBackClosedBack(data, showNeedAmount);
                break;
            }
            case "elec_paymentclose": {
                this.elecPayBackClosedBack(data, showNeedAmount);
                break;
            }
            case "custompay": {
                Object payModeId = data.get("payway");
                if (payModeId == null) break;
                this.openMainPayView(String.valueOf(payModeId), false);
                break;
            }
            case "replacepay": {
                Object payModeId = data.get("payway");
                if (payModeId == null) break;
                this.openMainPayView(String.valueOf(payModeId), true);
                break;
            }
            case "creditclose": {
                if (data.size() <= 0) break;
                this.getModel().setValue("customer", data.get("customer"));
                break;
            }
            case "couponclose": {
                this.couponClosedBack(dataEntity, data, showNeedAmount);
                break;
            }
            case "ccbClose": {
                this.payCcbClosedBack(data, showNeedAmount);
                break;
            }
            case "umsClose": {
                this.payUmsClosedBack(data, showNeedAmount);
                break;
            }
            case "abcClose": {
                this.payAbcClosedBack(data, showNeedAmount);
                break;
            }
            case "bocClose": {
                this.payBocClosedBack(data, showNeedAmount);
                break;
            }
            case "channelPreferenceClose": {
                this.payChannelClosedBack(data, showNeedAmount);
                break;
            }
            case "stageRefundClose": {
                this.payStageClosedBack(data, showNeedAmount);
                break;
            }
        }
        this.getView().updateView("payrecords");
    }

    private void doDiscountTypeHandle(BigDecimal needPayAmount) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BigDecimal discountValueDed = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("discountvalueded"));
        BigDecimal discountCustCpst = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("discountcustcpst"));
        if (discountValueDed.compareTo(BigDecimal.ZERO) < 0) {
            this.addDiscountTypeRow("equalvaluepay", discountValueDed, needPayAmount);
        }
        if (discountCustCpst.compareTo(BigDecimal.ZERO) < 0) {
            this.addDiscountTypeRow("customercompensation", discountCustCpst, needPayAmount);
        }
    }

    private void addDiscountTypeRow(String payModeKey, BigDecimal discountAmt, BigDecimal showNeedAmount) {
        DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)payModeKey), (String)"ocdbd_paymode");
        Map<String, Object> payMap = this.getPayModeMap(payWay, discountAmt);
        this.caseCustomPayBackClosedBack(payMap, showNeedAmount);
    }

    private Map<String, Object> getPayModeMap(Object payWay, BigDecimal payAmount) {
        DynamicObject payCurrency = (DynamicObject)this.getModel().getValue("currency");
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        map.put("showamount", payAmount);
        map.put("paybackamount", BigDecimal.ZERO);
        map.put("paycurrency", payCurrency.getPkValue());
        map.put("payway", payWay);
        map.put("paytime", TimeServiceHelper.now());
        map.put("payseq", this.getModel().getValue("payseq"));
        return map;
    }

    private BigDecimal addPayRecordEntity(DynamicObject payRecord, BigDecimal needRefundAmount, DynamicObject priceCurrency, DynamicObject paymentFlow, int seq, boolean isCustomerCompensation, BigDecimal discountAmt) {
        BigDecimal payBackAmount;
        DynamicObject payWay;
        DynamicObject currency;
        Date payTime;
        DynamicObject payWayType = null;
        String cardNo = "";
        long creditAccountId = 0L;
        long payBillId = 0L;
        String orderNo = "";
        boolean isAllRefund = true;
        long payFlowId = 0L;
        BigDecimal settleAmount = BigDecimal.ZERO;
        BigDecimal recCreditAmount = BigDecimal.ZERO;
        BigDecimal refundAmount = BigDecimal.ZERO;
        if (!isCustomerCompensation) {
            payTime = paymentFlow.getDate("paytime");
            currency = paymentFlow.getDynamicObject("currency");
            payWay = paymentFlow.getDynamicObject("settlement");
            payWayType = paymentFlow.getDynamicObject("paywaytype");
            settleAmount = paymentFlow.getBigDecimal("settleamount");
            recCreditAmount = paymentFlow.getBigDecimal("reccreditamount");
            refundAmount = paymentFlow.getBigDecimal("refundamount");
            if (recCreditAmount.compareTo(BigDecimal.ZERO) > 0) {
                settleAmount = settleAmount.subtract(recCreditAmount);
            }
            payBackAmount = settleAmount.add(refundAmount).negate();
            cardNo = DynamicObjectUtils.getString((DynamicObject)paymentFlow, (String)"cardno");
            creditAccountId = DynamicObjectUtils.getLong((DynamicObject)paymentFlow, (String)"creditaccountid");
            orderNo = DynamicObjectUtils.getString((DynamicObject)paymentFlow, (String)"orderno");
            payBillId = DynamicObjectUtils.getLong((DynamicObject)paymentFlow, (String)"billid");
            if (DynamicObjectUtils.getLong((DynamicObject)payWay, (String)"id") == 31L || DynamicObjectUtils.getLong((DynamicObject)payWay, (String)"id") == 28L) {
                orderNo = DynamicObjectUtils.getString((DynamicObject)paymentFlow, (String)"tradereference");
            }
            if (DynamicObjectUtils.getLong((DynamicObject)payWay, (String)"id") == 22L || DynamicObjectUtils.getLong((DynamicObject)payWay, (String)"id") == 24L || DynamicObjectUtils.getLong((DynamicObject)payWay, (String)"id") == 34L || DynamicObjectUtils.getLong((DynamicObject)payWay, (String)"id") == 35L) {
                boolean isSecondDay = DateUtil.comparePayDate((String)DateUtil.getDateFormat((Date)payTime));
                boolean isEqualPayAmount = CommonUtils.checkReturnEqualPayAmount((BigDecimal)needRefundAmount, (String)DynamicObjectUtils.getString((DynamicObject)paymentFlow, (String)"id"));
                if (isSecondDay || !isEqualPayAmount) {
                    orderNo = DynamicObjectUtils.getString((DynamicObject)paymentFlow, (String)"tradereference");
                }
            }
            isAllRefund = DynamicObjectUtils.getBoolean((DynamicObject)paymentFlow, (String)"isallrefund");
            payFlowId = DynamicObjectUtils.getPkValue((DynamicObject)paymentFlow);
        } else {
            payTime = TimeServiceHelper.now();
            payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"customercompensation"), (String)"ocdbd_paymode");
            payBackAmount = discountAmt;
            currency = priceCurrency;
            FormViewUtil.setUnEnable((IFormView)this.getView(), (int)seq, (String[])new String[]{"paybackamount"});
            Map<String, Object> payMap = this.getPayModeMap(payWay, payBackAmount);
            BigDecimal showNeedAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("needpayamount"));
            this.caseCustomPayBackClosedBack(payMap, showNeedAmount);
        }
        if (payWay.getBoolean("iselectronicpay") && payBackAmount.compareTo(BigDecimal.ZERO) >= 0 || DynamicObjectUtils.getPkValue((DynamicObject)payWay) == PaymentModeEnum.getKey((String)"ignoredecimal")) {
            FormViewUtil.setUnEnable((IFormView)this.getView(), (int)seq, (String[])new String[]{"paybackamount"});
        } else if (needRefundAmount.compareTo(payBackAmount) > 0) {
            payBackAmount = needRefundAmount;
        }
        if (payBackAmount.compareTo(BigDecimal.ZERO) > 0) {
            payBackAmount = BigDecimal.ZERO;
        }
        if (payWayType == null) {
            payWayType = this.getPayWayType(payWay);
        }
        payRecord.set("payway", (Object)payWay);
        payRecord.set("srcpaywaytype", (Object)payWayType);
        payRecord.set("paywayname", (Object)payWay.getString("name"));
        payRecord.set("showamount", (Object)settleAmount);
        payRecord.set("paybackamount", (Object)payBackAmount);
        payRecord.set("hasrefundamount", (Object)refundAmount);
        payRecord.set("paytime", (Object)payTime);
        payRecord.set("paycurrency", (Object)currency);
        payRecord.set("cardno", (Object)cardNo);
        payRecord.set("creditaccountid", (Object)creditAccountId);
        payRecord.set("sourcebillno", (Object)orderNo);
        payRecord.set("paybillid", (Object)payBillId);
        payRecord.set("isallrefund", (Object)isAllRefund);
        payRecord.set("payflowid", (Object)payFlowId);
        payRecord.set("payseq", (Object)seq);
        return payBackAmount;
    }

    private void addRefundRecordEntity(DynamicObject backRecord, BigDecimal settleAmount, DynamicObject paymentFlow) {
        long payFlowId = DynamicObjectUtils.getPkValue((DynamicObject)paymentFlow);
        Date payTime = paymentFlow.getDate("paytime");
        long payBillId = paymentFlow.getLong("billid");
        DynamicObject currency = paymentFlow.getDynamicObject("currency");
        DynamicObject payWay = paymentFlow.getDynamicObject("settlement");
        DynamicObject payWayType = paymentFlow.getDynamicObject("paywaytype");
        if (payWayType == null) {
            payWayType = this.getPayWayType(payWay);
        }
        backRecord.set("srcpayflowid", (Object)payFlowId);
        backRecord.set("returnpayway", (Object)payWay);
        backRecord.set("paywaytype", (Object)payWayType);
        backRecord.set("hasreturnamount", (Object)settleAmount);
        backRecord.set("returntime", (Object)payTime);
        backRecord.set("returncurrency", (Object)currency);
        backRecord.set("retpaybillid", (Object)payBillId);
        backRecord.set("returnstatus", (Object)"1");
    }

    private String checkBeforeReturnPay() {
        BigDecimal needPayAmount = (BigDecimal)this.getModel().getValue("needpayamount");
        if (needPayAmount.compareTo(BigDecimal.ZERO) < 0) {
            return "\u9000\u6b3e\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u7ed3\u7b97\u3002";
        }
        return null;
    }

    private void openRefundPayView(String paymentFormId, String closeCallBackId, List<Map<String, Object>> refundInfoMaps, String ... caption) {
        Map<String, Object> refundInfoMap = refundInfoMaps.get(0);
        DynamicObject payWay = (DynamicObject)refundInfoMap.get("payway");
        DynamicObject payWayType = (DynamicObject)refundInfoMap.get("paywaytype");
        long srcreplacepaywayid = CommonUtil.formatObejctToLong((Object)refundInfoMap.get("srcreplacepaywayid"));
        BigDecimal refundAmount = CommonUtil.formatObjectToDecimal((Object)refundInfoMap.get("haspayamount"));
        HashMap<String, Object> customParams = new HashMap<String, Object>(7);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        customParams.put("Id", formShowParameter.getCustomParam("Id"));
        customParams.put("saleoption", "0");
        customParams.put("payflowid", refundInfoMap.get("payflowid"));
        customParams.put("orderno", refundInfoMap.get("sourcebillno"));
        customParams.put("haspayamount", refundAmount);
        customParams.put("needpayamount", refundAmount);
        customParams.put("entityid", this.getView().getParentView().getEntityId());
        customParams.put("paywayid", DynamicObjectUtils.getPkValue((DynamicObject)payWay));
        customParams.put("paywaytypeid", DynamicObjectUtils.getPkValue((DynamicObject)payWayType));
        customParams.put("srcreplacepaywayid", srcreplacepaywayid);
        customParams.put("paytime", refundInfoMap.get("paytime"));
        customParams.put("refundmap", "");
        FormShowParameter parameter = FormShowUtils.openNewForm((String)(caption.length > 0 ? caption[0] : ""), (String)paymentFormId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(parameter);
    }

    private void openCashCustomPayView(String paymentFormId, String closeCallBackId, String payModeId, List<Map<String, Object>> refundInfoMaps, String caption) {
        BigDecimal needPayAmount = BigDecimal.ZERO;
        long payFlowId = 0L;
        long srcreplacepaywayid = 0L;
        String strRefundMap = "";
        int mapSize = refundInfoMaps.size();
        HashMap<Long, BigDecimal> refundMap = new HashMap<Long, BigDecimal>(mapSize);
        for (Map<String, Object> refundInfoMap : refundInfoMaps) {
            payFlowId = CommonUtil.formatObejctToLong((Object)refundInfoMap.get("payflowid"));
            srcreplacepaywayid = CommonUtil.formatObejctToLong((Object)refundInfoMap.get("srcreplacepaywayid"));
            BigDecimal refundAmount = CommonUtil.formatObjectToDecimal((Object)refundInfoMap.get("haspayamount"));
            refundMap.put(payFlowId, refundAmount);
            needPayAmount = needPayAmount.add(refundAmount);
        }
        if (mapSize > 1) {
            strRefundMap = JSONObject.toJSONString(refundMap);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object pkId = formShowParameter.getCustomParam("Id");
        DynamicObject dataEntry = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)this.getView().getParentView().getEntityId(), (String)"billno");
        String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntry, (String)"billno");
        log.info(String.format("\u96f6\u552e\u5355\u53f7%s\u70b9\u51fb\u652f\u4ed8\u65b9\u5f0f%s\u91d1\u989d%.2f\u5143", billNo, payModeId, needPayAmount));
        HashMap<String, Object> customParams = new HashMap<String, Object>(6);
        customParams.put("saleoption", "0");
        customParams.put("payflowid", payFlowId);
        customParams.put("needpayamount", needPayAmount);
        customParams.put("bizorgid", this.getModel().getValue("bizorgid"));
        customParams.put("paycurrencyid", this.getModel().getValue("currency_id"));
        customParams.put("paywayid", payModeId);
        customParams.put("srcreplacepaywayid", srcreplacepaywayid);
        customParams.put("refundmap", strRefundMap);
        customParams.put("salebranchid", this.getView().getFormShowParameter().getCustomParam("salebranchid"));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)caption, (String)paymentFormId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(parameter);
    }

    private void openCustcomPensationPayView(String paymentFormId, String closeCallBackId, List<Map<String, Object>> refundInfoMaps) {
        BigDecimal needPayAmount = BigDecimal.ZERO;
        long payFlowId = 0L;
        long srcreplacepaywayid = 0L;
        Object payWay = null;
        HashMap<Long, BigDecimal> refundMap = new HashMap<Long, BigDecimal>(refundInfoMaps.size());
        for (Map<String, Object> refundInfoMap : refundInfoMaps) {
            if (ObjectUtils.isEmpty(payWay)) {
                payWay = refundInfoMap.get("payway");
            }
            payFlowId = CommonUtil.formatObejctToLong((Object)refundInfoMap.get("payflowid"));
            srcreplacepaywayid = CommonUtil.formatObejctToLong((Object)refundInfoMap.get("srcreplacepaywayid"));
            BigDecimal refundAmount = CommonUtil.formatObjectToDecimal((Object)refundInfoMap.get("haspayamount"));
            refundMap.put(payFlowId, refundAmount);
            needPayAmount = needPayAmount.add(refundAmount);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(7);
        customParams.put("saleoption", "0");
        customParams.put("payflowid", payFlowId);
        customParams.put("entityid", this.getView().getParentView().getEntityId());
        customParams.put("org", formShowParameter.getCustomParam("org"));
        customParams.put("needpayamount", needPayAmount);
        customParams.put("Id", formShowParameter.getCustomParam("Id"));
        customParams.put("payway", payWay);
        customParams.put("srcreplacepaywayid", srcreplacepaywayid);
        customParams.put("refundmap", JSONObject.toJSONString(refundMap));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)paymentFormId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(parameter);
    }

    private void openCreditCustomerPayView(String paymentFormId, String closeCallBackId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(10);
        customParams.put("saleoption", "0");
        customParams.put("entityid", this.getView().getParentView().getEntityId());
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        customParams.put("Id", saleOrderId);
        customParams.put("org", formShowParameter.getCustomParam("org"));
        customParams.put("salebranchid", formShowParameter.getCustomParam("salebranchid"));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)paymentFormId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(parameter);
    }

    private void openCreditAccountPayView(String paymentFormId, String closeCallBackId, List<Map<String, Object>> refundInfoMaps) {
        BigDecimal needPayAmount = BigDecimal.ZERO;
        long payFlowId = 0L;
        long payBillId = 0L;
        Object creditAccountId = null;
        Object payWay = null;
        long srcreplacepaywayid = 0L;
        HashMap<Long, BigDecimal> refundMap = new HashMap<Long, BigDecimal>(refundInfoMaps.size());
        for (Map<String, Object> refundInfoMap : refundInfoMaps) {
            payFlowId = CommonUtil.formatObejctToLong((Object)refundInfoMap.get("payflowid"));
            payBillId = CommonUtil.formatObejctToLong((Object)refundInfoMap.get("paybillid"));
            srcreplacepaywayid = CommonUtil.formatObejctToLong((Object)refundInfoMap.get("srcreplacepaywayid"));
            BigDecimal refundAmount = CommonUtil.formatObjectToDecimal((Object)refundInfoMap.get("haspayamount"));
            refundMap.put(payFlowId, refundAmount);
            if (ObjectUtils.isEmpty(payWay)) {
                payWay = refundInfoMap.get("payway");
            }
            if (ObjectUtils.isEmpty(creditAccountId)) {
                creditAccountId = refundInfoMap.get("creditaccountid");
            }
            needPayAmount = needPayAmount.add(refundAmount);
        }
        if (needPayAmount.compareTo(BigDecimal.ZERO) >= 0) {
            this.getView().showErrorNotification("\u672c\u652f\u4ed8\u65b9\u5f0f\u53ef\u9000\u91d1\u989d\u4e3a0\u3002");
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(10);
        customParams.put("creditaccountid", creditAccountId);
        customParams.put("needpayamount", needPayAmount);
        customParams.put("refundmap", JSONObject.toJSONString(refundMap));
        customParams.put("payway", payWay);
        customParams.put("srcreplacepaywayid", srcreplacepaywayid);
        customParams.put("saleoption", "0");
        customParams.put("payflowid", payFlowId);
        customParams.put("paybillid", payBillId);
        customParams.put("entityid", this.getView().getParentView().getEntityId());
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        customParams.put("Id", saleOrderId);
        customParams.put("org", formShowParameter.getCustomParam("org"));
        customParams.put("salebranchid", formShowParameter.getCustomParam("salebranchid"));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)paymentFormId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(parameter);
    }

    private void openCouponPayView(String paymentFormId, String closeCallBackId, List<Map<String, Object>> refundInfoMaps) {
        String bizType = CommonUtil.formatStringToEmpty((Object)this.getView().getParentView().getModel().getValue("biztype"));
        if (StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"N")) {
            this.getView().showErrorNotification("\u65e0\u6e90\u5355\u9000\u8d27\u4e0d\u652f\u6301\u4f18\u60e0\u5238\u9000\u6b3e\u3002");
            return;
        }
        ArrayList<String> retCardnos = new ArrayList<String>();
        DynamicObjectCollection returnPayRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("returnpayrecords");
        if (!CollectionUtils.isEmpty((Collection)returnPayRecords)) {
            for (DynamicObject returnPayRecord : returnPayRecords) {
                String returnStatus = returnPayRecord.getString("returnstatus");
                if (!StringUtils.equals((CharSequence)returnStatus, (CharSequence)"1")) continue;
                long returnPayWayId = returnPayRecord.getDynamicObject("returnpayway").getLong("id");
                String retcardno = returnPayRecord.getString("retcardno");
                if (returnPayWayId != 4L || !StringUtils.isNotEmpty((CharSequence)retcardno)) continue;
                retCardnos.add(retcardno);
            }
        }
        BigDecimal needPayAmount = BigDecimal.ZERO;
        JSONArray ticketarray = new JSONArray();
        for (Map<String, Object> refundInfoMap : refundInfoMaps) {
            String cardno = CommonUtil.formatStringToEmpty((Object)refundInfoMap.get("cardno"));
            if (retCardnos.contains(cardno)) continue;
            JSONObject ticketJson = new JSONObject();
            long payflowid = CommonUtil.formatObejctToLong((Object)refundInfoMap.get("payflowid"));
            long srcreplacepaywayid = CommonUtil.formatObejctToLong((Object)refundInfoMap.get("srcreplacepaywayid"));
            BigDecimal refundamount = CommonUtil.formatObjectToDecimal((Object)refundInfoMap.get("haspayamount"));
            ticketJson.put("payflowid", (Object)payflowid);
            ticketJson.put("cardno", (Object)cardno);
            ticketJson.put("srcreplacepaywayid", (Object)srcreplacepaywayid);
            ticketJson.put("refundamount", (Object)refundamount);
            ticketarray.add((Object)ticketJson);
            needPayAmount = needPayAmount.add(refundamount);
        }
        HashMap<String, BigDecimal> customParams = new HashMap<String, BigDecimal>(2);
        customParams.put("needpayamount", needPayAmount);
        customParams.put("ticketarray", (BigDecimal)ticketarray);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)paymentFormId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(parameter);
    }

    private void openOtherPayView() {
        ArrayList mainOverPayModeIds = new ArrayList(20);
        String strMainOverPayModeIds = this.getPageCache().get("mainOverPayModeIds");
        if (!StringUtils.isEmpty((CharSequence)strMainOverPayModeIds)) {
            mainOverPayModeIds.addAll(JSONObject.parseArray((String)strMainOverPayModeIds, String.class));
        }
        ArrayList payFlowPayWayIds = new ArrayList(20);
        String strPayFlowPayWayIds = this.getPageCache().get("payFlowPayWayIds");
        if (!StringUtils.isEmpty((CharSequence)strPayFlowPayWayIds)) {
            payFlowPayWayIds.addAll(JSONObject.parseArray((String)strPayFlowPayWayIds, String.class));
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long cashierRoleId = CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("cashierid"));
        long posId = CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("pos"));
        List payModeLst = PayUtil.getDisplayPayModeData((long)cashierRoleId, (long)posId, (String)"more", (String)"0");
        payModeLst.forEach(payMode -> mainOverPayModeIds.add(String.valueOf(payMode.getLong("id"))));
        String bizType = CommonUtil.formatStringToEmpty((Object)this.getView().getParentView().getModel().getValue("biztype"));
        if (!StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) {
            mainOverPayModeIds.retainAll(payFlowPayWayIds);
        }
        ArrayList<Long> lMainOverPayModeIds = new ArrayList<Long>(mainOverPayModeIds.size());
        for (String mainOverPayModeId : mainOverPayModeIds) {
            lMainOverPayModeIds.add(Long.valueOf(mainOverPayModeId));
        }
        this.openOtherPayListView("custompay", lMainOverPayModeIds, "\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f");
    }

    private void openOtherPayListView(String closeCallBackId, List<Long> otherPayModeIds, String caption) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(10);
        if (CollectionUtils.isEmpty(otherPayModeIds)) {
            otherPayModeIds = Collections.singletonList(-1L);
        }
        customParams.put("saleoption", "0");
        customParams.put("payway", otherPayModeIds);
        customParams.put("entityid", this.getView().getParentView().getEntityId());
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        customParams.put("Id", saleOrderId);
        customParams.put("org", formShowParameter.getCustomParam("org"));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)caption, (String)"ocpos_otherpaylist", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(parameter);
    }

    private void caseCustomPayBackClosedBack(Map<String, Object> refundResultData, BigDecimal needpayamount) {
        if (refundResultData == null || refundResultData.size() == 0) {
            this.getView().showErrorNotification("\u9000\u6b3e\u56de\u8c03\u6570\u636e\u4e3a\u7a7a\u3002");
            return;
        }
        String bizType = this.getModel().getValue("biztype").toString();
        int returnPayRecordIndex = -1;
        DynamicObject payWay = (DynamicObject)refundResultData.get("payway");
        long payWayId = payWay.getLong("id");
        long srcreplacepaywayid = CommonUtil.formatObejctToLong((Object)refundResultData.get("srcreplacepaywayid"));
        if (srcreplacepaywayid > 0L) {
            long payflowid = CommonUtil.formatObejctToLong((Object)refundResultData.get("payflowid"));
            DynamicObjectCollection payFlowRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
            if (payflowid > 0L && !CollectionUtils.isEmpty((Collection)payFlowRecords)) {
                for (DynamicObject payFlowRecord : payFlowRecords) {
                    if (payflowid != payFlowRecord.getLong("payflowid")) continue;
                    payFlowRecord.set("isrefundedthistimes", (Object)Boolean.TRUE);
                    break;
                }
            }
        } else {
            DynamicObjectCollection returnPayRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("returnpayrecords");
            if (!CollectionUtils.isEmpty((Collection)returnPayRecords)) {
                for (DynamicObject returnPayRecord : returnPayRecords) {
                    String returnStatus = returnPayRecord.getString("returnstatus");
                    if (!StringUtils.equals((CharSequence)returnStatus, (CharSequence)"1")) continue;
                    long returnPayWayId = returnPayRecord.getDynamicObject("returnpayway").getLong("id");
                    String retcardno = returnPayRecord.getString("retcardno");
                    if (returnPayWayId != payWayId || !StringUtils.isEmpty((CharSequence)retcardno) || payWay.getBoolean("iselectronicpay")) continue;
                    returnPayRecordIndex = returnPayRecords.indexOf((Object)returnPayRecord);
                }
            }
        }
        BigDecimal receivableAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("receivableamount"));
        if (returnPayRecordIndex < 0) {
            returnPayRecordIndex = this.getModel().createNewEntryRow("returnpayrecords");
        }
        this.getModel().setValue("returnpayway", (Object)payWay, returnPayRecordIndex);
        this.getModel().setValue("paywaytype", refundResultData.get("srcpaywaytype"), returnPayRecordIndex);
        long srcReplacePayWayId = CommonUtil.formatObejctToLong((Object)refundResultData.get("srcreplacepaywayid"));
        this.getModel().setValue("srcreplacepaywayid", (Object)srcReplacePayWayId, returnPayRecordIndex);
        this.getModel().setValue("returntime", (Object)TimeServiceHelper.now(), returnPayRecordIndex);
        BigDecimal refundAmount = CommonUtil.formatObjectToDecimal((Object)refundResultData.get("showamount"));
        this.getModel().setValue("hasreturnamount", (Object)refundAmount, returnPayRecordIndex);
        this.getModel().setValue("returncurrency", refundResultData.get("paycurrency"), returnPayRecordIndex);
        this.getModel().setValue("retcardno", refundResultData.get("cardno"), returnPayRecordIndex);
        this.getModel().setValue("retcreditaccountid", refundResultData.get("creditaccountid"), returnPayRecordIndex);
        this.getModel().setValue("srcpayflowid", refundResultData.get("payflowid"), returnPayRecordIndex);
        this.getModel().setValue("retpaybillid", refundResultData.get("paybillid"), returnPayRecordIndex);
        this.getModel().setValue("refundmap", refundResultData.get("refundmap"), returnPayRecordIndex);
        this.getModel().setValue("returnstatus", (Object)"1", returnPayRecordIndex);
        BigDecimal hasReturnAmountSum = BigDecimal.ZERO;
        BigDecimal custCompensationSum = BigDecimal.ZERO;
        BigDecimal equalValueAmountSum = BigDecimal.ZERO;
        DynamicObjectCollection returnPayRecords1 = this.getModel().getDataEntity(true).getDynamicObjectCollection("returnpayrecords");
        if (!CollectionUtils.isEmpty((Collection)returnPayRecords1)) {
            for (DynamicObject returnPayRecord : returnPayRecords1) {
                String returnStatus = returnPayRecord.getString("returnstatus");
                if (!StringUtils.equals((CharSequence)returnStatus, (CharSequence)"1")) continue;
                BigDecimal hasReturnAmount = returnPayRecord.getBigDecimal("hasreturnamount");
                long returnPayWayId = DynamicObjectUtils.getPkValue((DynamicObject)returnPayRecord, (String)"returnpayway");
                if (returnPayWayId == PaymentModeEnum.EqualValuePay.getKey()) {
                    equalValueAmountSum = equalValueAmountSum.add(hasReturnAmount);
                }
                if (returnPayWayId == PaymentModeEnum.CustomerCompensation.getKey()) {
                    custCompensationSum = hasReturnAmountSum.add(hasReturnAmount);
                    continue;
                }
                hasReturnAmountSum = hasReturnAmountSum.add(hasReturnAmount);
            }
        }
        this.getModel().setValue("equalvalueamount", (Object)equalValueAmountSum);
        BigDecimal needPayAmount = receivableAmount.subtract(hasReturnAmountSum);
        if (StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"R")) {
            needPayAmount = BigDecimal.ZERO;
        }
        this.getModel().setValue("needpayamount", (Object)needPayAmount);
        if (custCompensationSum.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("needpayamount", (Object)needPayAmount.add(custCompensationSum));
        }
        if (payWayId == 3L) {
            this.getModel().setValue("returncashamount", refundResultData.get("returncashamount"));
        }
    }

    private void elecPayBackClosedBack(Map<String, Object> refundResultData, BigDecimal needpayamount) {
        if (refundResultData == null || refundResultData.size() == 0) {
            this.getView().showErrorNotification("\u9000\u6b3e\u56de\u8c03\u6570\u636e\u4e3a\u7a7a\u3002");
            return;
        }
        DynamicObject payWay = (DynamicObject)refundResultData.get("payway");
        String bizType = this.getModel().getValue("biztype").toString();
        if (!StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"N") && payWay.getBoolean("iselectronicpay")) {
            long payFlowId = (Long)refundResultData.get("payflowid");
            DynamicObjectCollection payRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
            if (!CollectionUtils.isEmpty((Collection)payRecords)) {
                Object payRecord = null;
                payRecord = payFlowId > 0L ? (DynamicObject)payRecords.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"payflowid") == payFlowId).findFirst().orElse(null) : (DynamicObject)payRecords.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"payway") == DynamicObjectUtils.getPkValue((DynamicObject)payWay)).findFirst().orElse(null);
                if (payRecord != null) {
                    payRecord.set("isrefundedthistimes", (Object)Boolean.TRUE);
                }
            }
        }
        int index = this.getModel().createNewEntryRow("returnpayrecords");
        this.getModel().setValue("returnpayway", (Object)payWay, index);
        this.getModel().setValue("paywaytype", refundResultData.get("paywaytype"), index);
        this.getModel().setValue("returntime", (Object)TimeServiceHelper.now(), index);
        this.getModel().setValue("hasreturnamount", refundResultData.get("showamount"), index);
        this.getModel().setValue("returncurrency", refundResultData.get("paycurrency"), index);
        this.getModel().setValue("srcpayflowid", refundResultData.get("payflowid"), index);
        this.getModel().setValue("refundmap", refundResultData.get("refundmap"), index);
        this.getModel().setValue("returnstatus", (Object)"1", index);
        BigDecimal hasReturnAmountSum = BigDecimal.ZERO;
        DynamicObjectCollection returnPayRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("returnpayrecords");
        if (!CollectionUtils.isEmpty((Collection)returnPayRecords)) {
            for (DynamicObject returnPayRecord : returnPayRecords) {
                String returnStatus = returnPayRecord.getString("returnstatus");
                if (!StringUtils.equals((CharSequence)returnStatus, (CharSequence)"1")) continue;
                BigDecimal hasReturnAmount = returnPayRecord.getBigDecimal("hasreturnamount");
                hasReturnAmountSum = hasReturnAmountSum.add(hasReturnAmount);
            }
        }
        BigDecimal receivableAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("receivableamount"));
        this.getModel().setValue("needpayamount", (Object)receivableAmount.subtract(hasReturnAmountSum));
    }

    private void addPaymentRecordEntry(DynamicObjectCollection docTicketEntry) {
        BigDecimal actualAmount = BigDecimal.ZERO;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)this.getView().getParentView().getEntityId());
        BigDecimal showNeedAmount = new BigDecimal(this.getModel().getValue("needpayamount").toString());
        if (saleOrder != null && docTicketEntry != null && docTicketEntry.getRowCount() > 0) {
            for (DynamicObject doTicketEntry : docTicketEntry) {
                int index = this.getModel().createNewEntryRow("payrecords");
                this.getModel().setValue("payway", (Object)PaymentModeEnum.getKey((String)"giftvoucherpay"), index);
                this.getModel().setValue("paytime", (Object)TimeServiceHelper.now(), index);
                this.getModel().setValue("showamount", doTicketEntry.get("payamount"), index);
                this.getModel().setValue("paycurrency", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"currencyid"), index);
                this.getModel().setValue("cardno", doTicketEntry.get("ticketnumber"), index);
                this.getModel().setValue("paytickettypeid", doTicketEntry.get("tickettypeid"), index);
                this.getModel().setValue("payticketinfoid", doTicketEntry.get("eticketid"), index);
            }
            this.getModel().setValue("needpayamount", (Object)showNeedAmount.subtract(actualAmount));
        }
    }

    private void payCcbClosedBack(Map<String, Object> data, BigDecimal showNeedAmount) {
        String callBackCode = data.get("code").toString();
        JSONObject callBackData = (JSONObject)JSON.toJSON((Object)data.get("data"));
        if (StringUtils.equals((CharSequence)callBackCode, (CharSequence)"00")) {
            int index = this.getModel().createNewEntryRow("returnpayrecords");
            long payWayId = CommonUtil.formatObejctToLong((Object)callBackData.get((Object)"payway"));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            BigDecimal inputAmount = callBackData.getBigDecimal("amount");
            inputAmount = inputAmount.divide(new BigDecimal(-100), 2, RoundingMode.DOWN);
            if (!StringUtils.equals((CharSequence)formShowParameter.getFormId(), (CharSequence)"ocpos_nosrcreturnpay")) {
                DynamicObjectCollection docPayRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
                if (CollectionUtils.isEmpty((Collection)docPayRecords)) {
                    return;
                }
                this.getModel().setValue("retcardno", callBackData.get((Object)"cardNo"), index);
                this.getModel().setValue("srcpayflowid", (Object)callBackData.getString("payflowid"), index);
                BigDecimal payAmount = BigDecimalUtil.toBigDecimal((Object)inputAmount);
                List lstNoElectronicPayWay = CommonUtils.getNoElectricPayList();
                for (int i = 0; i < docPayRecords.getRowCount(); ++i) {
                    if (DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"payway") != payWayId) continue;
                    BigDecimal showAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"showamount");
                    BigDecimal hasRefundAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"hasrefundamount");
                    BigDecimal hasNeedAmount = showAmount.subtract(hasRefundAmount);
                    if (payAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    if (hasNeedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    payAmount = payAmount.abs().compareTo(hasNeedAmount) <= 0 ? BigDecimal.ZERO : payAmount.add(hasNeedAmount);
                    if (lstNoElectronicPayWay.contains(payWayId)) continue;
                    this.getModel().setValue("hasrefundamount", (Object)hasNeedAmount.add(hasRefundAmount), i);
                    this.getModel().setValue("isrefundedthistimes", (Object)Boolean.TRUE, i);
                }
            }
            this.getModel().setValue("returnpayway", callBackData.get((Object)"payway"), index);
            this.getModel().setValue("paywaytype", (Object)SaleOrderPayInfoPlugin.getPayWayType(callBackData), index);
            this.getModel().setValue("returntime", (Object)callBackData.getDate("date"), index);
            BigDecimal needPayAmount = showNeedAmount.subtract(inputAmount);
            this.getModel().setValue("returncashamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("hasreturnamount", (Object)inputAmount, index);
            this.getModel().setValue("needpayamount", (Object)needPayAmount);
            this.getModel().setValue("returncurrency", (Object)1, index);
            this.getModel().setValue("returnstatus", (Object)"1", index);
            this.setPaymentRecord(formShowParameter, index, callBackData, data);
            NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u6210\u529f", (IFormView)this.getView());
        } else {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(callBackCode).append(" ");
            if (StringUtils.isNotBlank((CharSequence)callBackData.getString("errorDesc"))) {
                errorMsg.append(callBackData.getString("errorDesc"));
            }
            this.getView().showTipNotification(errorMsg.toString());
        }
    }

    private void payUmsClosedBack(Map<String, Object> data, BigDecimal showNeedAmount) {
        String callBackCode = data.get("code").toString();
        JSONObject callBackData = (JSONObject)JSON.toJSON((Object)data.get("data"));
        if (StringUtils.equals((CharSequence)callBackCode, (CharSequence)"00")) {
            int index = this.getModel().createNewEntryRow("returnpayrecords");
            long payWayId = CommonUtil.formatObejctToLong((Object)callBackData.get((Object)"payway"));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            BigDecimal inputAmount = callBackData.getBigDecimal("amount");
            inputAmount = inputAmount.divide(new BigDecimal(-100), 2, RoundingMode.DOWN);
            if (!StringUtils.equals((CharSequence)formShowParameter.getFormId(), (CharSequence)"ocpos_nosrcreturnpay")) {
                DynamicObjectCollection docPayRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
                if (CollectionUtils.isEmpty((Collection)docPayRecords)) {
                    return;
                }
                this.getModel().setValue("retcardno", callBackData.get((Object)"cardNo"), index);
                this.getModel().setValue("srcpayflowid", (Object)callBackData.getString("payflowid"), index);
                BigDecimal payAmount = BigDecimalUtil.toBigDecimal((Object)inputAmount);
                List lstNoElectronicPayWay = CommonUtils.getNoElectricPayList();
                for (int i = 0; i < docPayRecords.getRowCount(); ++i) {
                    if (DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"payway") != payWayId) continue;
                    BigDecimal showAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"showamount");
                    BigDecimal hasRefundAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"hasrefundamount");
                    BigDecimal hasNeedAmount = showAmount.subtract(hasRefundAmount);
                    if (payAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    if (hasNeedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    payAmount = payAmount.abs().compareTo(hasNeedAmount) <= 0 ? BigDecimal.ZERO : payAmount.add(hasNeedAmount);
                    if (lstNoElectronicPayWay.contains(payWayId)) continue;
                    this.getModel().setValue("hasrefundamount", (Object)hasNeedAmount.add(hasRefundAmount), i);
                    this.getModel().setValue("isrefundedthistimes", (Object)Boolean.TRUE, i);
                }
            }
            this.getModel().setValue("returnpayway", callBackData.get((Object)"payway"), index);
            this.getModel().setValue("paywaytype", (Object)SaleOrderPayInfoPlugin.getPayWayType(callBackData), index);
            this.getModel().setValue("returntime", (Object)new Date(), index);
            BigDecimal needPayAmount = showNeedAmount.subtract(inputAmount);
            this.getModel().setValue("returncashamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("hasreturnamount", (Object)inputAmount, index);
            this.getModel().setValue("needpayamount", (Object)needPayAmount);
            this.getModel().setValue("returncurrency", (Object)1, index);
            this.getModel().setValue("returnstatus", (Object)"1", index);
            this.setPaymentRecord(formShowParameter, index, callBackData, data);
            NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u6210\u529f", (IFormView)this.getView());
        } else {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(callBackCode).append(" ");
            if (StringUtils.isNotBlank((CharSequence)callBackData.getString("errorDesc"))) {
                errorMsg.append(callBackData.getString("errorDesc"));
            }
            this.getView().showTipNotification(errorMsg.toString());
        }
    }

    private void payAbcClosedBack(Map<String, Object> data, BigDecimal showNeedAmount) {
        String callBackCode = data.get("code").toString();
        JSONObject callBackData = (JSONObject)JSON.toJSON((Object)data.get("data"));
        if (StringUtils.equals((CharSequence)callBackCode, (CharSequence)"00")) {
            int index = this.getModel().createNewEntryRow("returnpayrecords");
            long payWayId = CommonUtil.formatObejctToLong((Object)callBackData.get((Object)"payway"));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            BigDecimal inputAmount = callBackData.getBigDecimal("amount");
            inputAmount = inputAmount.divide(new BigDecimal(-100), 2, RoundingMode.DOWN);
            if (!StringUtils.equals((CharSequence)formShowParameter.getFormId(), (CharSequence)"ocpos_nosrcreturnpay")) {
                DynamicObjectCollection docPayRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
                if (CollectionUtils.isEmpty((Collection)docPayRecords)) {
                    return;
                }
                this.getModel().setValue("retcardno", callBackData.get((Object)"cardNo"), index);
                this.getModel().setValue("srcpayflowid", (Object)callBackData.getString("payflowid"), index);
                BigDecimal payAmount = BigDecimalUtil.toBigDecimal((Object)inputAmount);
                List lstNoElectronicPayWay = CommonUtils.getNoElectricPayList();
                for (int i = 0; i < docPayRecords.getRowCount(); ++i) {
                    if (DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"payway") != payWayId) continue;
                    BigDecimal showAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"showamount");
                    BigDecimal hasRefundAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"hasrefundamount");
                    BigDecimal hasNeedAmount = showAmount.subtract(hasRefundAmount);
                    if (payAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    if (hasNeedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    payAmount = payAmount.abs().compareTo(hasNeedAmount) <= 0 ? BigDecimal.ZERO : payAmount.add(hasNeedAmount);
                    if (lstNoElectronicPayWay.contains(payWayId)) continue;
                    this.getModel().setValue("hasrefundamount", (Object)hasNeedAmount.add(hasRefundAmount), i);
                    this.getModel().setValue("isrefundedthistimes", (Object)Boolean.TRUE, i);
                }
            }
            this.getModel().setValue("returnpayway", callBackData.get((Object)"payway"), index);
            this.getModel().setValue("paywaytype", (Object)SaleOrderPayInfoPlugin.getPayWayType(callBackData), index);
            this.getModel().setValue("returntime", (Object)callBackData.getDate("actualTime"), index);
            BigDecimal needPayAmount = showNeedAmount.subtract(inputAmount);
            this.getModel().setValue("returncashamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("hasreturnamount", (Object)inputAmount, index);
            this.getModel().setValue("needpayamount", (Object)needPayAmount);
            this.getModel().setValue("returncurrency", (Object)1, index);
            this.getModel().setValue("returnstatus", (Object)"1", index);
            this.setPaymentRecord(formShowParameter, index, callBackData, data);
            NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u6210\u529f", (IFormView)this.getView());
        } else {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(callBackCode).append(" ");
            if (StringUtils.isNotBlank((CharSequence)callBackData.getString("retMsg"))) {
                errorMsg.append(callBackData.getString("retMsg"));
            }
            this.getView().showTipNotification(errorMsg.toString());
        }
    }

    private void payBocClosedBack(Map<String, Object> data, BigDecimal showNeedAmount) {
        String callBackCode = data.get("code").toString();
        JSONObject callBackData = (JSONObject)JSON.toJSON((Object)data.get("data"));
        if (StringUtils.equals((CharSequence)callBackCode, (CharSequence)"00")) {
            int index = this.getModel().createNewEntryRow("returnpayrecords");
            long payWayId = CommonUtil.formatObejctToLong((Object)callBackData.get((Object)"payway"));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            BigDecimal inputAmount = callBackData.getBigDecimal("amount");
            inputAmount = inputAmount.divide(new BigDecimal(-100), 2, RoundingMode.DOWN);
            if (!StringUtils.equals((CharSequence)formShowParameter.getFormId(), (CharSequence)"ocpos_nosrcreturnpay")) {
                DynamicObjectCollection docPayRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
                if (CollectionUtils.isEmpty((Collection)docPayRecords)) {
                    return;
                }
                this.getModel().setValue("retcardno", callBackData.get((Object)"cardNo"), index);
                this.getModel().setValue("srcpayflowid", (Object)callBackData.getString("payflowid"), index);
                BigDecimal payAmount = BigDecimalUtil.toBigDecimal((Object)inputAmount);
                List lstNoElectronicPayWay = CommonUtils.getNoElectricPayList();
                for (int i = 0; i < docPayRecords.getRowCount(); ++i) {
                    if (DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"payway") != payWayId) continue;
                    BigDecimal showAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"showamount");
                    BigDecimal hasRefundAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"hasrefundamount");
                    BigDecimal hasNeedAmount = showAmount.subtract(hasRefundAmount);
                    if (payAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    if (hasNeedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    payAmount = payAmount.abs().compareTo(hasNeedAmount) <= 0 ? BigDecimal.ZERO : payAmount.add(hasNeedAmount);
                    if (lstNoElectronicPayWay.contains(payWayId)) continue;
                    this.getModel().setValue("hasrefundamount", (Object)hasNeedAmount.add(hasRefundAmount), i);
                    this.getModel().setValue("isrefundedthistimes", (Object)Boolean.TRUE, i);
                }
            }
            this.getModel().setValue("returnpayway", callBackData.get((Object)"payway"), index);
            this.getModel().setValue("paywaytype", (Object)SaleOrderPayInfoPlugin.getPayWayType(callBackData), index);
            this.getModel().setValue("returntime", (Object)new Date(), index);
            BigDecimal needPayAmount = showNeedAmount.subtract(inputAmount);
            if (callBackData.getLong("payway") == 23L) {
                this.getModel().setValue("returnorderno", (Object)callBackData.getString("invoiceNo"), index);
            } else {
                Integer payCh = callBackData.getInteger("payCh");
                if (payCh == 2 || payCh == 3) {
                    this.getModel().setValue("returnorderno", (Object)callBackData.getString("orderNo"), index);
                } else {
                    this.getModel().setValue("returnorderno", (Object)callBackData.getString("payNo"), index);
                }
            }
            this.getModel().setValue("returncashamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("hasreturnamount", (Object)inputAmount, index);
            this.getModel().setValue("needpayamount", (Object)needPayAmount);
            this.getModel().setValue("returncurrency", (Object)1, index);
            this.getModel().setValue("returnstatus", (Object)"1", index);
            this.setPaymentRecord(formShowParameter, index, callBackData, data);
            NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u6210\u529f", (IFormView)this.getView());
        } else {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(callBackCode).append(" ");
            if (StringUtils.isNotBlank((CharSequence)callBackData.getString("retMsg"))) {
                errorMsg.append(callBackData.getString("retMsg"));
            }
            this.getView().showTipNotification(errorMsg.toString());
        }
    }

    private void payChannelClosedBack(Map<String, Object> refundResultData, BigDecimal showNeedAmount) {
        if (refundResultData == null || refundResultData.size() == 0) {
            this.getView().showErrorNotification("\u9000\u6b3e\u56de\u8c03\u6570\u636e\u4e3a\u7a7a\u3002");
            return;
        }
        int index = this.getModel().createNewEntryRow("returnpayrecords");
        long payWayId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)refundResultData.get("payway")));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BigDecimal inputAmount = (BigDecimal)refundResultData.get("showamount");
        if (!StringUtils.equals((CharSequence)formShowParameter.getFormId(), (CharSequence)"ocpos_nosrcreturnpay")) {
            DynamicObjectCollection docPayRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
            if (CollectionUtils.isEmpty((Collection)docPayRecords)) {
                return;
            }
            this.getModel().setValue("retcardno", refundResultData.get("cardNo"), index);
            this.getModel().setValue("srcpayflowid", refundResultData.get("payflowid"), index);
            BigDecimal payAmount = BigDecimalUtil.toBigDecimal((Object)inputAmount);
            List lstNoElectronicPayWay = CommonUtils.getNoElectricPayList();
            for (int i = 0; i < docPayRecords.getRowCount(); ++i) {
                if (DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"payway") != payWayId) continue;
                BigDecimal showAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"showamount");
                BigDecimal hasRefundAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"hasrefundamount");
                BigDecimal hasNeedAmount = showAmount.subtract(hasRefundAmount);
                if (payAmount.compareTo(BigDecimal.ZERO) == 0) break;
                if (hasNeedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                payAmount = payAmount.abs().compareTo(hasNeedAmount) <= 0 ? BigDecimal.ZERO : payAmount.add(hasNeedAmount);
                if (lstNoElectronicPayWay.contains(payWayId)) continue;
                this.getModel().setValue("hasrefundamount", (Object)hasNeedAmount.add(hasRefundAmount), i);
                this.getModel().setValue("isrefundedthistimes", (Object)Boolean.TRUE, i);
            }
        }
        this.getModel().setValue("returnpayway", refundResultData.get("payway"), index);
        DynamicObject payFlow = CommonUtils.getPaymentFlow((String)refundResultData.get("payflowid").toString());
        this.getModel().setValue("paywaytype", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)payFlow, (String)"paywaytype"), index);
        this.getModel().setValue("returntime", (Object)new Date(), index);
        BigDecimal needPayAmount = showNeedAmount.subtract(inputAmount);
        this.getModel().setValue("returncashamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("hasreturnamount", (Object)inputAmount, index);
        this.getModel().setValue("needpayamount", (Object)needPayAmount);
        this.getModel().setValue("returncurrency", (Object)1, index);
        this.getModel().setValue("returnstatus", (Object)"1", index);
        this.setPaymentRecord(formShowParameter, index, null, refundResultData);
        NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u6210\u529f", (IFormView)this.getView());
    }

    private void payStageClosedBack(Map<String, Object> data, BigDecimal showNeedAmount) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String callBackCode = data.get("code").toString();
        JSONObject callBackData = (JSONObject)JSON.toJSON((Object)data.get("data"));
        Long payWayId = callBackData.getLong("payway");
        if (StringUtils.equals((CharSequence)callBackCode, (CharSequence)"00")) {
            int index = this.getModel().createNewEntryRow("returnpayrecords");
            BigDecimal inputAmount = callBackData.getBigDecimal("amount");
            inputAmount = inputAmount.divide(new BigDecimal(-100), 2, RoundingMode.DOWN);
            if (!StringUtils.equals((CharSequence)formShowParameter.getFormId(), (CharSequence)"ocpos_nosrcreturnpay")) {
                DynamicObjectCollection docPayRecords = this.getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
                if (CollectionUtils.isEmpty((Collection)docPayRecords)) {
                    return;
                }
                this.getModel().setValue("retcardno", callBackData.get((Object)"cardNo"), index);
                this.getModel().setValue("srcpayflowid", (Object)callBackData.getString("payflowid"), index);
                BigDecimal payAmount = BigDecimalUtil.toBigDecimal((Object)inputAmount);
                List lstNoElectronicPayWay = CommonUtils.getNoElectricPayList();
                for (int i = 0; i < docPayRecords.getRowCount(); ++i) {
                    if (DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"payway") != payWayId) continue;
                    BigDecimal showAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"showamount");
                    BigDecimal hasRefundAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)docPayRecords.get(i)), (String)"hasrefundamount");
                    BigDecimal hasNeedAmount = showAmount.subtract(hasRefundAmount);
                    if (payAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    if (hasNeedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    payAmount = payAmount.abs().compareTo(hasNeedAmount) <= 0 ? BigDecimal.ZERO : payAmount.add(hasNeedAmount);
                    if (lstNoElectronicPayWay.contains(payWayId)) continue;
                    this.getModel().setValue("hasrefundamount", (Object)hasNeedAmount.add(hasRefundAmount), i);
                    this.getModel().setValue("isrefundedthistimes", (Object)Boolean.TRUE, i);
                }
            }
            this.getModel().setValue("returnpayway", callBackData.get((Object)"payway"), index);
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)payWayId, (String)"ocdbd_paymode");
            this.getModel().setValue("paywaytype", (Object)SaleOrderHelper.getPayWayType((DynamicObject)payWay), index);
            this.getModel().setValue("returntime", (Object)new Date(), index);
            BigDecimal needPayAmount = showNeedAmount.subtract(inputAmount);
            this.getModel().setValue("returncashamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("hasreturnamount", (Object)inputAmount, index);
            this.getModel().setValue("needpayamount", (Object)needPayAmount);
            this.getModel().setValue("returncurrency", (Object)1, index);
            this.getModel().setValue("returnstatus", (Object)"1", index);
            this.setPaymentRecord(formShowParameter, index, callBackData, data);
            NotificationUtil.showDefaultSuccessNotification((String)"\u9000\u6b3e\u6210\u529f", (IFormView)this.getView());
        } else {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(callBackCode).append(" ");
            if (payWayId == 34L && StringUtils.isNotBlank((CharSequence)callBackData.getString("errorDesc"))) {
                errorMsg.append(callBackData.getString("errorDesc"));
            }
            if ((payWayId == 35L || payWayId == 36L) && StringUtils.isNotBlank((CharSequence)callBackData.getString("retMsg"))) {
                errorMsg.append(callBackData.getString("retMsg"));
            }
            this.getView().showTipNotification(errorMsg.toString());
        }
    }

    private void couponClosedBack(DynamicObject dataEntity, Map<String, Object> data, BigDecimal showNeedAmount) {
        DynamicObjectCollection ticketEntity = (DynamicObjectCollection)data.get("ticketid");
        if (CollectionUtils.isEmpty((Collection)ticketEntity)) {
            return;
        }
        long paywayid = CommonUtil.formatObejctToLong((Object)data.get("payway"));
        if (paywayid <= 0L) {
            return;
        }
        DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)paywayid, (String)"ocdbd_paymode");
        for (DynamicObject ticketEntry : ticketEntity) {
            HashMap<String, Object> map = new HashMap<String, Object>(0);
            map.put("showamount", ticketEntry.getBigDecimal("payamount"));
            map.put("paycurrency", this.getModel().getValue("currency"));
            map.put("payflowid", ticketEntry.getLong("payflowid"));
            map.put("cardno", ticketEntry.getString("ticketnumber"));
            map.put("payway", payWay);
            map.put("srcpaywaytype", SaleOrderHelper.getPayWayType((DynamicObject)payWay));
            map.put("srcreplacepaywayid", ticketEntry.getLong("srcreplacepaywayid"));
            map.put("paytime", TimeServiceHelper.now());
            this.caseCustomPayBackClosedBack(map, showNeedAmount);
        }
    }

    private void setPaymentRecord(FormShowParameter formShowParameter, int index, JSONObject callBackData, Map<String, Object> data) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection pays = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"returnpayrecords");
        if (CollectionUtils.isEmpty((Collection)pays)) {
            return;
        }
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        DynamicObject saleReturnOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)this.getView().getParentView().getEntityId());
        DynamicObject pay = (DynamicObject)pays.get(index);
        PaymentRecord paymentRecord = new PaymentRecord();
        paymentRecord.setPayFlowId(DynamicObjectUtils.getLong((DynamicObject)pay, (String)"srcpayflowid"));
        paymentRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)saleReturnOrder).longValue());
        paymentRecord.setBillNo(DynamicObjectUtils.getString((DynamicObject)saleReturnOrder, (String)"billno"));
        paymentRecord.setPayWay(DynamicObjectUtils.getDynamicObject((DynamicObject)pay, (String)"returnpayway"));
        paymentRecord.setPayWayType(DynamicObjectUtils.getDynamicObject((DynamicObject)pay, (String)"paywaytype"));
        paymentRecord.setPayCurrency(DynamicObjectUtils.getDynamicObject((DynamicObject)pay, (String)"returncurrency"));
        paymentRecord.setPaytime(TimeServiceHelper.now());
        paymentRecord.setAmount(DynamicObjectUtils.getBigDecimal((DynamicObject)pay, (String)"hasreturnamount"));
        paymentRecord.setCardNo(DynamicObjectUtils.getString((DynamicObject)pay, (String)"retcardno"));
        if (callBackData != null) {
            paymentRecord.setBankExchangeNo(callBackData.getString("referNum"));
            if (StringUtils.isNotEmpty((CharSequence)callBackData.getString("trace"))) {
                paymentRecord.setOrderNo(callBackData.getString("trace"));
                if (StringUtils.isNotEmpty((CharSequence)callBackData.getString("rsv"))) {
                    paymentRecord.setBankExchangeNo(callBackData.getString("rsv"));
                }
                if (StringUtils.isNotEmpty((CharSequence)callBackData.getString("refer"))) {
                    paymentRecord.setBankExchangeNo(callBackData.getString("refer"));
                }
            } else if (StringUtils.isNotEmpty((CharSequence)callBackData.getString("voucherNum"))) {
                paymentRecord.setOrderNo(callBackData.getString("voucherNum"));
            } else if (StringUtils.isNotEmpty((CharSequence)callBackData.getString("traceNum"))) {
                paymentRecord.setOrderNo(callBackData.getString("traceNum"));
            } else if (StringUtils.isNotEmpty((CharSequence)callBackData.getString("payNo"))) {
                paymentRecord.setOrderNo(callBackData.getString("payNo"));
            } else if (StringUtils.isNotEmpty((CharSequence)callBackData.getString("orderNo"))) {
                paymentRecord.setOrderNo(callBackData.getString("orderNo"));
            } else if (StringUtils.isNotEmpty((CharSequence)callBackData.getString("invoiceNo"))) {
                paymentRecord.setOrderNo(callBackData.getString("invoiceNo"));
            }
        }
        paymentRecord.setPayStatus("A");
        DynamicObjectCollection finEntryEntity = saleReturnOrder.getDynamicObjectCollection("finentity");
        DynamicObject newFinEntity = finEntryEntity.addNew();
        SaleOrderHelper.updateSaleOrderAfterRefund((DynamicObject)saleReturnOrder, (DynamicObject)newFinEntity, (PaymentRecord)paymentRecord, data);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleReturnOrder});
    }
}

