/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.StageCostBearingTypeEnum;
import kd.occ.ocbase.common.pay.payment.vo.PaymentRecord;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.pay.PosPayLogHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderStageHelper;
import kd.occ.ocpos.common.enums.CcbTranTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.vo.AbcPosRequestVo;
import kd.occ.ocpos.common.vo.BocPosRequestVo;
import kd.occ.ocpos.common.vo.CcbPosRequestVo;

public class SaleOrderStagePayPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String BTN_OK = "btnok";
    private static final Log log = LogFactory.getLog(SaleOrderStagePayPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BigDecimal hasPayAmount = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("haspayamount"));
        String goodsList = formShowParameter.getCustomParam("goodsList").toString();
        long branchId = (Long)formShowParameter.getCustomParam("branchId");
        List stagePayList = SaleOrderStageHelper.getStagePayList((BigDecimal)hasPayAmount, (JSONArray)JSONArray.parseArray((String)goodsList), (long)branchId);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection stagesPayList = dataEntity.getDynamicObjectCollection("entryentity");
        for (JSONObject stagePay : stagePayList) {
            DynamicObject bankStage = (DynamicObject)stagePay.get((Object)"bankstageid");
            DynamicObject stage = (DynamicObject)stagePay.get((Object)"stagesid");
            DynamicObject stagesPay = stagesPayList.addNew();
            stagesPay.set("bankstageid", (Object)bankStage);
            stagesPay.set("cooperbank", stagePay.get((Object)"cooperbank"));
            stagesPay.set("stagesid", (Object)stage);
            stagesPay.set("stageplatform", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)bankStage, (String)"stageplatform"));
            stagesPay.set("stageamount", (Object)hasPayAmount);
            stagesPay.set("exceptfee", (Object)hasPayAmount.multiply(stage.getBigDecimal("interestrate")).divide(new BigDecimal(100).setScale(2, 4)));
        }
        this.getView().updateView("entryentity");
    }

    public void registerListener(EventObject e) {
        BasedataEdit bEdit;
        super.registerListener(e);
        if (CommonUtils.isExistField((IFormView)this.getView(), (String)"stagesid") && !ObjectUtils.isEmpty((Object)(bEdit = (BasedataEdit)this.getView().getControl("stagesid")))) {
            bEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{BTN_OK});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject stage = (DynamicObject)dataEntity.getDynamicObjectCollection("entryentity").get(e.getRow());
        if (key.equals("stagesid")) {
            QFilter qFilter = new QFilter("stageid", "=", (Object)stage.getDynamicObject("bankstageid").getLong("id"));
            qFilter.and("minimumamount", "<=", (Object)stage.getBigDecimal("stageamount"));
            F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject stagePay = changeData.getDataEntity();
        DynamicObject stage = stagePay.getDynamicObject("stagesid");
        if (stage == null) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        switch (key = e.getProperty().getName()) {
            case "stagesid": 
            case "stageamount": {
                this.getModel().setValue("exceptfee", (Object)stagePay.getBigDecimal("stageamount").multiply(stage.getBigDecimal("interestrate")).divide(new BigDecimal(100).setScale(2, 4)), rowIndex);
                if (!StringUtils.equals((CharSequence)key, (CharSequence)"stageamount")) break;
                BigDecimal stageAmount = (BigDecimal)changeData.getNewValue();
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                BigDecimal hasPayAmount = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("haspayamount"));
                if (stageAmount.compareTo(stage.getBigDecimal("minimumamount")) < 0) {
                    this.getView().showErrorNotification("\u5206\u671f\u91d1\u989d\uff0c\u4e0d\u80fd\u4f4e\u4e8e\u6700\u4f4e\u6d88\u8d39\u91d1\u989d");
                    this.getModel().setValue("stageamount", changeData.getOldValue());
                } else if (stageAmount.compareTo(hasPayAmount) > 0) {
                    this.getView().showErrorNotification("\u5206\u671f\u91d1\u989d\uff0c\u4e0d\u80fd\u9ad8\u4e8e\u5e94\u652f\u4ed8\u91d1\u989d");
                    this.getModel().setValue("stageamount", changeData.getOldValue());
                }
                DynamicObjectCollection preferentialEntityList = stagePay.getDynamicObject("bankstageid").getDynamicObjectCollection("preferentialentity");
                String profitPreferential = this.getProfitPreferential((List<DynamicObject>)preferentialEntityList, stagePay.getBigDecimal("stageamount"));
                if (!StringUtils.isNotEmpty((CharSequence)profitPreferential)) break;
                dataEntity.set("preferential", (Object)profitPreferential);
                break;
            }
        }
        this.getView().updateView("preferential");
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        DynamicObject dataEntity = ((Control)evt.getSource()).getModel().getDataEntity(true);
        DynamicObjectCollection stageEntityList = dataEntity.getDynamicObjectCollection("entryentity");
        int rowIndex = evt.getRow();
        if (rowIndex < 0) {
            dataEntity.set("preferential", null);
            this.getView().updateView("preferential");
            return;
        }
        DynamicObject stageEntity = (DynamicObject)stageEntityList.get(rowIndex);
        DynamicObjectCollection preferentialEntityList = stageEntity.getDynamicObject("bankstageid").getDynamicObjectCollection("preferentialentity");
        switch (key) {
            case "entryentity": {
                String profitPreferential = this.getProfitPreferential((List<DynamicObject>)preferentialEntityList, stageEntity.getBigDecimal("stageamount"));
                if (!StringUtils.isNotEmpty((CharSequence)profitPreferential)) break;
                BigDecimal stageAmount = SaleOrderStagePayPlugin.judgeCostbearing(stageEntity.getBigDecimal("stageamount"), stageEntity.getDynamicObject("bankstageid"));
                if (stageAmount.compareTo(new BigDecimal(1000)) < 0) {
                    EntryGrid entryControl = (EntryGrid)this.getView().getControl("entryentity");
                    entryControl.selectRows(-1);
                    NotificationUtil.showDefaultTipNotify((String)"\u5206\u671f\u91d1\u989d\u51cf\u53bb\u4f18\u60e0\u91d1\u989d\u5c0f\u4e8e1000\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u671f\u652f\u4ed8", (IFormView)this.getView());
                }
                dataEntity.set("preferential", (Object)profitPreferential);
                this.getView().updateView("preferential");
                break;
            }
        }
    }

    private String getProfitPreferential(List<DynamicObject> preferentialEntityList, BigDecimal stageAmount) {
        String profitPreferential = null;
        BigDecimal fullAmount = BigDecimal.ZERO;
        for (DynamicObject preferentialEntity : preferentialEntityList) {
            if (stageAmount.compareTo(preferentialEntity.getBigDecimal("fullamount")) < 0 || preferentialEntity.getBigDecimal("fullamount").compareTo(fullAmount) <= 0) continue;
            fullAmount = preferentialEntity.getBigDecimal("fullamount");
            profitPreferential = String.format("\u5f53\u524d\u5206\u671f\u6d3b\u52a8\uff0c\u4eab\u53d7\u6ee1%s\u7acb\u51cf%s", fullAmount.setScale(2, 7), preferentialEntity.getBigDecimal("reduceamount").setScale(2, 7));
        }
        return profitPreferential;
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTN_OK)) {
            this.getView().showLoading(new LocaleString("\u652f\u4ed8\u4e2d"));
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
            JSONObject requestData = this.buildStageRequest();
            if (null == requestData) {
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String entityId = (String)formShowParameter.getCustomParam("entityid");
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)entityId);
            String billNo = DynamicObjectUtil.getString((DynamicObject)saleOrder, (String)"billno");
            PosPayLogHelper.savePayLog((String)billNo, (String)JSON.toJSONString((Object)requestData), (int)1);
            customcontrol.setData((Object)JSON.toJSONString((Object)requestData));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        if (customcontrol.getData() != null) {
            e.setCancel(true);
            this.getView().showMessage("\u652f\u4ed8\u4e2d,\u8bf7\u52ff\u5173\u95ed");
            return;
        }
    }

    public void customEvent(CustomEventArgs e) {
        String outPutData = e.getEventArgs();
        String eventName = e.getEventName();
        Integer payWayId = 0;
        if (StringUtils.equals((CharSequence)eventName, (CharSequence)"getRequestDataByCCB")) {
            payWayId = 34;
        } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"getRequestDataByABC")) {
            payWayId = 35;
        } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"getRequestDataByBOC")) {
            payWayId = 36;
        }
        this.getView().setReturnData((Object)outPutData);
        this.closeStageForm(payWayId);
    }

    public void closeStageForm(Integer payWayId) {
        IFormView view = this.getView();
        Object returnData = view.getReturnData();
        if (returnData != null) {
            JSONObject returnDataJson = JSONObject.parseObject((String)returnData.toString());
            switch (payWayId) {
                case 34: {
                    log.info("\u5efa\u884c\u5206\u671f\u652f\u4ed8\u8fd4\u56de\u6570\u636e\u5305\uff1a" + JSON.toJSONString((Object)returnData));
                    break;
                }
                case 35: {
                    log.info("\u519c\u884c\u5206\u671f\u652f\u4ed8\u8fd4\u56de\u6570\u636e\u5305\uff1a" + JSON.toJSONString((Object)returnData));
                    break;
                }
                case 36: {
                    log.info("\u4e2d\u884c\u5206\u671f\u652f\u4ed8\u8fd4\u56de\u6570\u636e\u5305\uff1a" + JSON.toJSONString((Object)returnData));
                }
            }
            JSONObject backData = returnDataJson.getJSONObject("data");
            if (backData != null) {
                this.buildCloseCallBackData(backData, payWayId);
            }
            view.returnDataToParent((Object)returnDataJson);
            view.hideLoading();
            FormShowParameter formShowParameter = view.getFormShowParameter();
            String entityId = (String)formShowParameter.getCustomParam("entityid");
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)entityId);
            String billNo = DynamicObjectUtil.getString((DynamicObject)saleOrder, (String)"billno");
            PosPayLogHelper.savePayLog((String)billNo, (String)JSON.toJSONString((Object)returnDataJson), (int)0);
            CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap");
            customcontrol.setData(null);
            view.close();
        }
    }

    private void buildCloseCallBackData(JSONObject backData, Integer payWayId) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject stagePayDynamicObject = (DynamicObject)dataEntity.getDynamicObjectCollection("entryentity").get(selectRows[0]);
        DynamicObject stage = stagePayDynamicObject.getDynamicObject("stagesid");
        DynamicObject bankStage = stagePayDynamicObject.getDynamicObject("bankstageid");
        backData.put("stagenum", (Object)stage.getInt("stages"));
        backData.put("stageid", (Object)bankStage.getLong("id"));
        backData.put("stagefee", (Object)stagePayDynamicObject.getBigDecimal("exceptfee"));
        backData.put("stagetotalamount", (Object)stagePayDynamicObject.getBigDecimal("stageamount"));
        BigDecimal showNeedAmount = new BigDecimal(this.getView().getParentView().getModel().getValue("needpayamount").toString());
        backData.put("needpayamount", (Object)showNeedAmount);
        backData.put("payway", (Object)payWayId);
    }

    public JSONObject buildStageRequest() {
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            view.showErrorNotification("\u8bf7\u9009\u4e2d\u5206\u671f\u6d3b\u52a8\u65b9\u6848!");
            view.hideLoading();
            return null;
        }
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        DynamicObject stagePayDynamicObject = (DynamicObject)dataEntity.getDynamicObjectCollection("entryentity").get(selectRows[0]);
        DynamicObject stage = stagePayDynamicObject.getDynamicObject("stagesid");
        BigDecimal stageAmount = SaleOrderStagePayPlugin.judgeCostbearing(stagePayDynamicObject.getBigDecimal("stageamount"), stagePayDynamicObject.getDynamicObject("bankstageid"));
        DynamicObject stagePlatform = DynamicObjectUtil.getDynamicObject((DynamicObject)stagePayDynamicObject, (String)"stageplatform");
        if (stagePlatform != null) {
            if (StringUtils.equals((CharSequence)"001", (CharSequence)DynamicObjectUtil.getString((DynamicObject)stagePlatform, (String)"number"))) {
                CcbPosRequestVo ccbRequest = new CcbPosRequestVo();
                ccbRequest.setMethodname("HTTPCCBInterFace");
                ccbRequest.setGoodscode("000000000015");
                ccbRequest.setSettleType(CcbTranTypeEnum.MARKETSTAGE.getNumber());
                ccbRequest.setNum(stage.getInt("stages"));
                ccbRequest.setPayAmt(stageAmount);
                log.info("\u5efa\u884c\u5206\u671f\u652f\u4ed8\u8bf7\u6c42\u6570\u636e\u5305\uff1a" + JSON.toJSONString((Object)ccbRequest));
                return (JSONObject)JSONObject.toJSON((Object)ccbRequest);
            }
            if (StringUtils.equals((CharSequence)"002", (CharSequence)DynamicObjectUtil.getString((DynamicObject)stagePlatform, (String)"number"))) {
                BocPosRequestVo bocRequest = new BocPosRequestVo();
                bocRequest.setMethodname("HTTPBOCInterFace");
                bocRequest.setTranType("06");
                bocRequest.setFenQiNum(stage.getString("stages"));
                bocRequest.setPayAmt(stageAmount);
                log.info("\u4e2d\u884c\u5206\u671f\u652f\u4ed8\u8bf7\u6c42\u6570\u636e\u5305\uff1a" + JSON.toJSONString((Object)bocRequest));
                return (JSONObject)JSONObject.toJSON((Object)bocRequest);
            }
            if (StringUtils.equals((CharSequence)"005", (CharSequence)DynamicObjectUtil.getString((DynamicObject)stagePlatform, (String)"number"))) {
                AbcPosRequestVo abcRequest = new AbcPosRequestVo();
                abcRequest.setMethodname("HTTPABCInterFace");
                abcRequest.setTranType("S03");
                abcRequest.setStageNum(stage.getString("stages"));
                if (StringUtils.equals((CharSequence)"6", (CharSequence)stage.getString("stages"))) {
                    abcRequest.setStageProjectCode("20001049");
                } else if (StringUtils.equals((CharSequence)"12", (CharSequence)stage.getString("stages"))) {
                    abcRequest.setStageProjectCode("20001076");
                }
                abcRequest.setPayAmt(stageAmount);
                log.info("\u519c\u884c\u5206\u671f\u652f\u4ed8\u8bf7\u6c42\u6570\u636e\u5305\uff1a" + JSON.toJSONString((Object)abcRequest));
                return (JSONObject)JSONObject.toJSON((Object)abcRequest);
            }
            view.showErrorNotification("\u5f53\u524d\u5206\u671f\u5e73\u53f0\u672a\u5bf9\u63a5,\u8bf7\u9009\u62e9\u53ef\u7528\u5206\u671f\u65b9\u6848");
            view.hideLoading();
            return null;
        }
        return null;
    }

    private static BigDecimal judgeCostbearing(BigDecimal stageAmount, DynamicObject bankStage) {
        if (bankStage != null) {
            DynamicObjectCollection costBearingEntityList = bankStage.getDynamicObjectCollection("costbearingentity");
            BigDecimal fullAmount = BigDecimal.ZERO;
            BigDecimal matchAmount = stageAmount;
            for (DynamicObject costBearing : costBearingEntityList) {
                BigDecimal reduceAmount = BigDecimal.ZERO;
                BigDecimal costProportion = costBearing.getBigDecimal("costproportion").divide(new BigDecimal(100), 2, 4);
                String objectType = costBearing.getString("objecttype");
                if (StageCostBearingTypeEnum.BOS_ORG.getValue().equals(objectType) || StageCostBearingTypeEnum.BD_SUPPLIER.getValue().equals(objectType)) {
                    DynamicObjectCollection preferentialEntityList = bankStage.getDynamicObjectCollection("preferentialentity");
                    for (DynamicObject preferentialEntity : preferentialEntityList) {
                        if (matchAmount.compareTo(preferentialEntity.getBigDecimal("fullamount")) < 0 || preferentialEntity.getBigDecimal("fullamount").compareTo(fullAmount) < 0) continue;
                        fullAmount = preferentialEntity.getBigDecimal("fullamount");
                        reduceAmount = preferentialEntity.getBigDecimal("reduceamount").setScale(2, 7);
                    }
                }
                reduceAmount = reduceAmount.multiply(costProportion).setScale(2, 7);
                stageAmount = stageAmount.subtract(reduceAmount);
            }
        }
        return stageAmount;
    }

    public static BigDecimal savePaymentFlow(IFormView view, DynamicObject saleOrder, Map<String, Object> data, BigDecimal showNeedAmount) {
        JSONObject callBackData = (JSONObject)JSON.toJSON((Object)data.get("data"));
        BigDecimal stageTotalAmount = callBackData.getBigDecimal("stagetotalamount");
        BigDecimal amount = callBackData.getBigDecimal("amount").divide(new BigDecimal(100), 2, RoundingMode.DOWN);
        DynamicObject bankStage = BusinessDataServiceHelper.loadSingle((Object)callBackData.getLong("stageid"), (String)"ocdbd_bankstage");
        if (stageTotalAmount.compareTo(SaleOrderStagePayPlugin.getStageAmountSubReduceAmount(stageTotalAmount, bankStage)) > 0) {
            DynamicObjectCollection costBearingEntityList = bankStage.getDynamicObjectCollection("costbearingentity");
            long payWayTypeId = 0L;
            for (DynamicObject costBearing : costBearingEntityList) {
                String objectType = costBearing.getString("objecttype");
                if ((StageCostBearingTypeEnum.BD_FINORGINFO.getValue().equals(objectType) || StageCostBearingTypeEnum.BD_CUSTOMER.getValue().equals(objectType)) && stageTotalAmount.compareTo(amount) == 0) continue;
                int index = view.getModel().createNewEntryRow("payrecords");
                BigDecimal reduceAmount = BigDecimal.ZERO;
                BigDecimal costProportion = costBearing.getBigDecimal("costproportion").divide(new BigDecimal(100), 2, 4);
                payWayTypeId = costBearing.getDynamicObject("bookingpaymentid") != null ? costBearing.getDynamicObject("bookingpaymentid").getLong("id") : payWayTypeId;
                DynamicObjectCollection preferentialEntityList = bankStage.getDynamicObjectCollection("preferentialentity");
                BigDecimal fullAmount = BigDecimal.ZERO;
                for (DynamicObject preferentialEntity : preferentialEntityList) {
                    if (stageTotalAmount.compareTo(preferentialEntity.getBigDecimal("fullamount")) < 0 || preferentialEntity.getBigDecimal("fullamount").compareTo(fullAmount) < 0) continue;
                    fullAmount = preferentialEntity.getBigDecimal("fullamount");
                    reduceAmount = preferentialEntity.getBigDecimal("reduceamount").setScale(2, 7);
                }
                view.getModel().setValue("payway", (Object)37, index);
                BigDecimal reduce = reduceAmount.multiply(costProportion).setScale(2, 7);
                view.getModel().setValue("showamount", (Object)reduce, index);
                view.getModel().setValue("paytime", (Object)TimeServiceHelper.now(), index);
                view.getModel().setValue("paywaytype", (Object)payWayTypeId, index);
                view.getModel().setValue("paycurrency", (Object)1, index);
                view.getModel().setValue("cardno", (Object)callBackData.getString("cardNo"), index);
                view.getModel().setValue("orderno", (Object)callBackData.getString("trace"), index);
                view.getModel().setValue("stageid", (Object)callBackData.getLong("stageid"), index);
                view.getModel().setValue("stagenum", (Object)callBackData.getInteger("stagenum"), index);
                view.getModel().setValue("stagefee", (Object)callBackData.getBigDecimal("stagefee"), index);
                view.getModel().setValue("iscandel", (Object)Boolean.FALSE, index);
                DynamicObject pay = (DynamicObject)view.getModel().getDataEntity(true).getDynamicObjectCollection("payrecords").get(index);
                PaymentRecord paymentRecord = new PaymentRecord();
                paymentRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)saleOrder).longValue());
                paymentRecord.setBillNo(saleOrder.getString("billno"));
                paymentRecord.setPayWay(pay.getDynamicObject("payway"));
                SaleOrderHelper.setEachPaymentRecord((DynamicObject)saleOrder, (PaymentRecord)paymentRecord, (DynamicObject)pay);
                paymentRecord.setPayStatus("A");
                DynamicObjectCollection finEntryEntity = saleOrder.getDynamicObjectCollection("finentity");
                DynamicObject newFinEntity = finEntryEntity.addNew();
                SaleOrderHelper.updateSaleOrderAfterPayment((DynamicObject)saleOrder, (DynamicObject)newFinEntity, (PaymentRecord)paymentRecord, null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
                showNeedAmount = showNeedAmount.subtract(reduce);
            }
        }
        return showNeedAmount;
    }

    private static BigDecimal getStageAmountSubReduceAmount(BigDecimal stageAmount, DynamicObject bankStage) {
        if (bankStage != null) {
            DynamicObjectCollection costBearingEntityList = bankStage.getDynamicObjectCollection("costbearingentity");
            BigDecimal fullAmount = BigDecimal.ZERO;
            BigDecimal matchAmount = stageAmount;
            for (DynamicObject costBearing : costBearingEntityList) {
                BigDecimal reduceAmount = BigDecimal.ZERO;
                BigDecimal costProportion = costBearing.getBigDecimal("costproportion").divide(new BigDecimal(100), 2, 4);
                DynamicObjectCollection preferentialEntityList = bankStage.getDynamicObjectCollection("preferentialentity");
                for (DynamicObject preferentialEntity : preferentialEntityList) {
                    if (matchAmount.compareTo(preferentialEntity.getBigDecimal("fullamount")) < 0 || preferentialEntity.getBigDecimal("fullamount").compareTo(fullAmount) < 0) continue;
                    fullAmount = preferentialEntity.getBigDecimal("fullamount");
                    reduceAmount = preferentialEntity.getBigDecimal("reduceamount").setScale(2, 7);
                }
                reduceAmount = reduceAmount.multiply(costProportion).setScale(2, 7);
                stageAmount = stageAmount.subtract(reduceAmount);
            }
        }
        return stageAmount;
    }
}

