/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocpos.business.commonhelper.AmountHelper;
import kd.occ.ocpos.business.pay.PosPayLogHelper;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.formplugin.saleorder.pay.SaleOrderPosPlugin;

public class SaleOrderStageRefundPlugin
extends SaleOrderPosPlugin {
    private static final String BTN_OK = "btnok";
    private static final String PAYWAY = "payway";
    private static final Log log = LogFactory.getLog(SaleOrderStageRefundPlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityId = (String)formShowParameter.getCustomParam("entityid");
        String saleOption = formShowParameter.getCustomParam("saleoption") == null ? "1" : (String)formShowParameter.getCustomParam("saleoption");
        this.getModel().setValue("saleoption", (Object)saleOption);
        this.getModel().setValue("orderno", formShowParameter.getCustomParam("orderno"));
        this.getModel().setValue("payflowid", formShowParameter.getCustomParam("payflowid"));
        this.getModel().setValue(PAYWAY, formShowParameter.getCustomParam("paywayid"));
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)entityId);
        BigDecimal hasPayAmount = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("haspayamount"));
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        if (saleOption.equalsIgnoreCase("0")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"payamount"});
            this.getModel().setValue("payamount", (Object)hasPayAmount);
        } else {
            this.getModel().setValue("payamount", (Object)AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (long)branchId, (BigDecimal)hasPayAmount));
        }
    }

    public void customEvent(CustomEventArgs e) {
        String outPutData = e.getEventArgs();
        String eventName = e.getEventName();
        Integer payWayId = 0;
        if (StringUtils.equals((CharSequence)eventName, (CharSequence)"getRequestDataByCCB")) {
            payWayId = 34;
        } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"getRequestDataByABC")) {
            payWayId = 35;
        } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"getRequestDataByBOC")) {
            payWayId = 36;
        }
        this.getView().setReturnData((Object)outPutData);
        this.closePosForm(this.getView(), payWayId);
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTN_OK)) {
            this.getView().showLoading(new LocaleString("\u652f\u4ed8\u4e2d"));
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Integer payWayId = (Integer)formShowParameter.getCustomParam("paywayid");
            BigDecimal payAmt = new BigDecimal(this.getModel().getValue("payamount").toString());
            boolean isSecondDay = DateUtil.comparePayDate((String)((String)formShowParameter.getCustomParam("paytime")));
            String billNo = "";
            JSONObject data = new JSONObject();
            switch (payWayId) {
                case 34: {
                    String settleType = "16";
                    String txtTrace = "";
                    String txtOldRefSys = "";
                    String oldDate = "";
                    if (!isSecondDay) {
                        txtTrace = this.getModel().getValue("orderno").toString();
                    } else {
                        settleType = "17";
                        if (formShowParameter.getCustomParam("paytime") != null) {
                            oldDate = formShowParameter.getCustomParam("paytime").toString().replace("-", "").substring(0, 8);
                        }
                        txtOldRefSys = this.getModel().getValue("orderno").toString();
                    }
                    data.put("settleType", (Object)settleType);
                    data.put("payAmt", (Object)payAmt.abs().toString());
                    data.put("txtTrace", (Object)txtTrace);
                    data.put("oldDate", (Object)oldDate);
                    data.put("txtOldRefSys", (Object)txtOldRefSys);
                    data.put("methodname", (Object)"HTTPCCBInterFace");
                    break;
                }
                case 35: {
                    String tranType;
                    String ogReferNum = "";
                    String ogSerialNum = "";
                    if (!isSecondDay) {
                        tranType = "V01";
                        ogSerialNum = this.getModel().getValue("orderno").toString();
                    } else {
                        tranType = "R01";
                        ogReferNum = this.getModel().getValue("orderno").toString();
                    }
                    data.put("tranType", (Object)tranType);
                    data.put("payAmt", (Object)payAmt.abs().toString());
                    data.put("ogReferNum", (Object)ogReferNum);
                    data.put("ogSerialNum", (Object)ogSerialNum);
                    data.put("methodname", (Object)"HTTPABCInterFace");
                    break;
                }
                case 36: {
                    String interfaceData;
                    DynamicObject payFlow = CommonUtils.getPaymentFlow((String)formShowParameter.getCustomParam("payflowid").toString());
                    if (payFlow == null || !StringUtils.isNotBlank((CharSequence)(interfaceData = DynamicObjectUtil.getString((DynamicObject)payFlow, (String)"interfacedata")))) break;
                    JSONObject resultData = JSON.parseObject((String)interfaceData);
                    JSONObject result = resultData.getJSONObject("data");
                    data.put("ogTraceNo", (Object)result.getString("traceNo"));
                    data.put("ogAuthNo", (Object)result.getString("authNo"));
                    data.put("ogTranDate", (Object)result.getString("tranDate"));
                    data.put("ogTranTime", (Object)result.getString("tranTime"));
                    data.put("tranType", (Object)"08");
                    data.put("payAmt", (Object)payAmt.abs().toString());
                    data.put("methodname", (Object)"HTTPBOCInterFace");
                }
            }
            String entityId = (String)formShowParameter.getCustomParam("entityid");
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)entityId);
            billNo = DynamicObjectUtil.getString((DynamicObject)saleOrder, (String)"billno");
            PosPayLogHelper.savePayLog((String)billNo, (String)JSON.toJSONString((Object)data), (int)1);
            customcontrol.setData((Object)JSON.toJSONString((Object)data));
        }
    }
}

