/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.commonhelper.AmountHelper;
import kd.occ.ocpos.business.promotion.SaleorderPromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.business.saleorder.TicketAmountHelper;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.util.CalculateUtil;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class SaleOrderTicketPayPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String NEEDPAYAMOUNT = "needpayamount";
    private static final int precision = 2;
    private DynamicObject saleOrder = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ticketEdit = (BasedataEdit)this.getView().getControl("ticketid");
        ticketEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
        JSONArray ticketArray = (JSONArray)frmShowParameter.getCustomParam("ticketid");
        DynamicObjectCollection docTicketEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (ticketArray != null && ticketArray.size() > 0) {
            for (int i = 0; i < ticketArray.size(); ++i) {
                DynamicObject doEntry = docTicketEntry.addNew();
                doEntry.set("eticketid", ticketArray.getJSONObject(i).get((Object)"eticketid"));
                doEntry.set("ticketnumber", ticketArray.getJSONObject(i).get((Object)"ticketnumber"));
                doEntry.set("ticketvalue", ticketArray.getJSONObject(i).get((Object)"ticketvalue"));
                doEntry.set("useamount", ticketArray.getJSONObject(i).get((Object)"useamount"));
                doEntry.set("payamount", ticketArray.getJSONObject(i).get((Object)"payamount"));
                doEntry.set("tickettype", ticketArray.getJSONObject(i).get((Object)"tickettype"));
                doEntry.set("tickettypeid", ticketArray.getJSONObject(i).get((Object)"tickettypeid"));
                doEntry.set("usagemode", ticketArray.getJSONObject(i).get((Object)"usagemode"));
                doEntry.set("discountrate", ticketArray.getJSONObject(i).get((Object)"discountrate"));
            }
        }
        BigDecimal needPayAmount = CommonUtil.formatObjectToDecimal((Object)frmShowParameter.getCustomParam(NEEDPAYAMOUNT));
        this.getPageCache().put(NEEDPAYAMOUNT, needPayAmount.toString());
        this.getView().getModel().setValue(NEEDPAYAMOUNT, (Object)needPayAmount);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
        if (this.saleOrder == null) {
            String entityId = (String)frmShowParameter.getCustomParam("entityid");
            Object saleOrderId = frmShowParameter.getCustomParam("Id");
            this.saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)entityId);
        }
        if (StringUtils.equals((CharSequence)proName, (CharSequence)"ticketid")) {
            this.getView().getPageCache().remove("ticketid");
            DynamicObject doTicket = (DynamicObject)this.getView().getModel().getValue("ticketid");
            DynamicObjectCollection docEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (doTicket != null) {
                Map mapRlt;
                Map.Entry entry;
                String goodsSeq;
                BigDecimal sumAmount;
                String ticketNo = DynamicObjectUtils.getString((DynamicObject)doTicket, (String)"number");
                if (docEntry.stream().anyMatch(x -> StringUtils.equals((CharSequence)x.getString("ticketnumber"), (CharSequence)doTicket.getString("number")))) {
                    this.getView().showMessage(String.format("\u793c\u5238\u7f16\u53f7%s\u5df2\u5b58\u5728\u3002", ticketNo));
                    this.clearTicket();
                    return;
                }
                BigDecimal needPayAmount = (BigDecimal)this.getView().getModel().getValue(NEEDPAYAMOUNT);
                if (needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                    this.getView().showErrorNotification("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u7ee7\u7eed\u652f\u4ed8\u3002");
                    this.clearTicket();
                    return;
                }
                boolean rlt = this.currencyMatch(this.saleOrder, doTicket);
                if (!rlt) {
                    return;
                }
                long ticketTypeId = DynamicObjectUtil.getPkValue((DynamicObject)doTicket.getDynamicObject("tickettypeid"));
                DynamicObject doTicketType = BusinessDataServiceHelper.loadSingle((Object)ticketTypeId, (String)"ocdbd_ticketstype");
                if (doTicketType == null) {
                    this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u5173\u8054\u7684\u793c\u5238\u7c7b\u578b\u65e0\u6548\u3002", ticketNo));
                    this.clearTicket();
                    return;
                }
                DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)this.saleOrder, (String)"goodsentryentity");
                String newAmtPriceWay = DynamicObjectUtils.getString((DynamicObject)doTicketType, (String)"newamtpriceway");
                String lowAmtCountWay = DynamicObjectUtils.getString((DynamicObject)doTicketType, (String)"lowamtcountway");
                boolean singleItemAmt = DynamicObjectUtils.getBoolean((DynamicObject)doTicketType, (String)"singleitemamt");
                boolean singleItemQty = DynamicObjectUtils.getBoolean((DynamicObject)doTicketType, (String)"singleitemqty");
                if (StringUtils.equals((CharSequence)lowAmtCountWay, (CharSequence)"1")) {
                    sumAmount = StringUtils.equals((CharSequence)newAmtPriceWay, (CharSequence)"1") ? DynamicObjectUtils.getBigDecimal((DynamicObject)this.saleOrder, (String)"sumamount") : DynamicObjectUtils.getBigDecimal((DynamicObject)this.saleOrder, (String)"sumbalamount");
                    goodsSeq = TicketAmountHelper.getGoodsSeq((List)docGoodsEntry);
                } else {
                    goodsSeq = TicketAmountHelper.getGoodsSeq((List)docGoodsEntry, (DynamicObject)doTicketType, (String)newAmtPriceWay);
                    sumAmount = TicketAmountHelper.getApplyGoodsAmount((List)docGoodsEntry, (String)newAmtPriceWay, (String)goodsSeq);
                }
                BigDecimal minConsumeAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketType, (String)"minconsumeamount");
                if (minConsumeAmount.compareTo(BigDecimal.ZERO) > 0) {
                    rlt = this.isMinConsumeAmount(sumAmount, ticketNo, minConsumeAmount);
                }
                if (!rlt) {
                    return;
                }
                if (singleItemAmt && (entry = (Map.Entry)(mapRlt = TicketAmountHelper.isMatchSingleItemAmt((List)docGoodsEntry, (DynamicObject)doTicketType, (String)ticketNo, (String)newAmtPriceWay)).entrySet().stream().findFirst().orElse(null)) != null && !(rlt = ((Boolean)entry.getKey()).booleanValue())) {
                    this.getView().showErrorNotification((String)entry.getValue());
                    this.clearTicket();
                }
                if (singleItemQty && (entry = (Map.Entry)(mapRlt = TicketAmountHelper.isMatchSingleItemQty((List)docGoodsEntry, (DynamicObject)doTicketType, (String)ticketNo)).entrySet().stream().findFirst().orElse(null)) != null && !(rlt = ((Boolean)entry.getKey()).booleanValue())) {
                    this.getView().showErrorNotification((String)entry.getValue());
                    this.clearTicket();
                }
                if (!rlt) {
                    return;
                }
                rlt = this.validateEndDate(doTicket);
                if (!rlt) {
                    this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u672a\u751f\u6548\u6216\u5df2\u8fc7\u671f\u3002", ticketNo));
                    this.clearTicket();
                    return;
                }
                rlt = this.isCondition(sumAmount, docEntry, docGoodsEntry, doTicketType, ticketNo, minConsumeAmount, newAmtPriceWay, singleItemAmt, singleItemQty, goodsSeq);
                if (!rlt) {
                    this.clearTicket();
                    return;
                }
                StringBuilder msg = new StringBuilder();
                rlt = SaleorderPromotionHelper.checkTicketSexclusive((DynamicObject)this.saleOrder, (DynamicObjectCollection)docEntry, null, (long)ticketTypeId, (long)0L, (StringBuilder)msg);
                if (!rlt) {
                    if (msg.length() > 0) {
                        this.getView().showErrorNotification(msg.toString());
                        this.clearTicket();
                    }
                    return;
                }
                DynamicObject doEntry = docEntry.addNew();
                doEntry.set("eticketid", doTicket.getPkValue());
                doEntry.set("ticketnumber", doTicket.get("number"));
                doEntry.set("ticketvalue", doTicket.get("ticketvalue"));
                doEntry.set("useamount", doTicket.get("ticketvalue"));
                doEntry.set("tickettype", (Object)DynamicObjectUtil.getString((DynamicObject)doTicketType, (String)"name"));
                doEntry.set("tickettypeid", (Object)ticketTypeId);
                doEntry.set("usagemode", (Object)DynamicObjectUtil.getString((DynamicObject)doTicketType, (String)"usagemode"));
                doEntry.set("discountrate", (Object)DynamicObjectUtil.getString((DynamicObject)doTicketType, (String)"discountrate"));
                this.updateTicketRecord(this.saleOrder, doEntry, doTicket, doTicketType);
                if (needPayAmount.compareTo(doEntry.getBigDecimal("payamount")) > 0) {
                    needPayAmount = needPayAmount.subtract(doEntry.getBigDecimal("payamount"));
                } else {
                    doEntry.set("payamount", (Object)needPayAmount);
                    needPayAmount = BigDecimal.ZERO;
                }
                this.getView().getModel().setValue(NEEDPAYAMOUNT, (Object)needPayAmount);
            }
            this.clearTicket();
            this.getView().updateView("entryentity");
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName())) {
            DynamicObjectCollection docEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            BigDecimal needPayAmount = new BigDecimal(this.getPageCache().get(NEEDPAYAMOUNT));
            if (!ObjectUtils.isEmpty((Object)docEntry)) {
                for (DynamicObject doEntry : docEntry) {
                    BigDecimal payAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doEntry, (String)"payamount");
                    needPayAmount = needPayAmount.subtract(payAmount);
                    this.getView().getModel().setValue(NEEDPAYAMOUNT, (Object)needPayAmount);
                }
            } else {
                this.getView().getModel().setValue(NEEDPAYAMOUNT, (Object)needPayAmount);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        BasedataEdit ticketBe = (BasedataEdit)this.getView().getControl("ticketid");
        if (ticketBe == null) {
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"ticketid")) {
            List lstId;
            String numberFilter = "";
            FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
            if (ticketBe.getSearchFilter() != null) {
                String searchFilter = ticketBe.getSearchFilter().getValue().toString();
                if (StringUtils.isNotEmpty((CharSequence)searchFilter)) {
                    numberFilter = searchFilter.substring(searchFilter.indexOf("#") + 1);
                }
            } else {
                numberFilter = this.getView().getPageCache().get("ticketid");
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            long memberId = CommonUtil.formatObejctToLong((Object)frmShowParameter.getCustomParam("member"));
            long branchId = CommonUtil.formatObejctToLong((Object)frmShowParameter.getCustomParam("salebranchid"));
            List<DynamicObject> docGoodsEntry = this.getGoodsEntry(frmShowParameter);
            if (CollectionUtils.isEmpty(docGoodsEntry)) {
                NotificationUtil.showDefaultTipNotify((String)"\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (IFormView)this.getView());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObjectCollection ticketEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            ArrayList lstTicketId = new ArrayList(0);
            if (!CollectionUtils.isEmpty((Collection)ticketEntry)) {
                ticketEntry.forEach(x -> lstTicketId.add(DynamicObjectUtils.getLong((DynamicObject)x, (String)"eticketid")));
            }
            QFilter qFilter = new QFilter("ticketstatus", "=", (Object)"P");
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("cancelstatus", "=", (Object)"A");
            qFilter.and("tickettypeid.isinsalesincome", "=", (Object)Boolean.TRUE);
            if (StringUtils.isNotEmpty((CharSequence)numberFilter)) {
                qFilter.and("number", "=", (Object)numberFilter);
            } else if (memberId > 0L) {
                qFilter.and("vipid", "=", (Object)memberId);
            } else {
                qFilter.and("'1'", "<>", (Object)"1");
            }
            if (!CollectionUtils.isEmpty(lstTicketId)) {
                qFilter.and("id", "not in", (Object)lstTicketId.toArray());
            }
            if (!CollectionUtils.isEmpty((Collection)(lstId = TicketAmountHelper.getMemberTicketInfo((QFilter)qFilter, docGoodsEntry, (long)branchId, (long)memberId, (String)numberFilter)))) {
                this.getView().getPageCache().put("ticketid", numberFilter);
            }
            qFilter = new QFilter("id", "in", (Object)lstId.toArray());
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            DynamicObjectCollection docTicketEntry;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (this.saleOrder == null) {
                String entityId = (String)formShowParameter.getCustomParam("entityid");
                if (StringUtils.isEmpty((CharSequence)entityId)) {
                    this.getView().showErrorNotification("\u672a\u83b7\u53d6\u5230\u5b9e\u4f53\u6807\u8bc6\u3002");
                    return;
                }
                Object saleOrderId = formShowParameter.getCustomParam("Id");
                this.saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)entityId);
            }
            if ((docTicketEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity")) == null || docTicketEntry.getRowCount() == 0) {
                this.getView().showErrorNotification("\u672a\u9009\u62e9\u652f\u4ed8\u793c\u5238\u3002");
                return;
            }
            BigDecimal rate = BigDecimal.ONE;
            BigDecimal payAmount = BigDecimal.ZERO;
            for (DynamicObject doTicketEntry : docTicketEntry) {
                payAmount = payAmount.add(doTicketEntry.getBigDecimal("payamount"));
            }
            BigDecimal financeExchangeRate = this.saleOrder.getBigDecimal("financeexchangerate");
            BigDecimal needPayAmount = (BigDecimal)this.getView().getModel().getValue(NEEDPAYAMOUNT);
            BigDecimal exAmount = needPayAmount.multiply(financeExchangeRate).divide(rate, 2);
            DynamicObject payCurrency = DynamicObjectUtil.getDynamicObject((DynamicObject)this.saleOrder, (String)"currencyid");
            BigDecimal finalWipeAmount = BigDecimal.ZERO;
            long orgId = DynamicObjectUtil.getPkValue((DynamicObject)this.saleOrder, (String)"bizorgid");
            long branchId = DynamicObjectUtil.getPkValue((DynamicObject)this.saleOrder, (String)"salebranchid");
            String billType = this.saleOrder.getString("biztype");
            if (!billType.equalsIgnoreCase(BizTypeEnum.SALERETURN.getValue())) {
                BigDecimal wipeExAmount = AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (long)branchId, (BigDecimal)exAmount);
                BigDecimal actualWipeAmount = exAmount.subtract(wipeExAmount);
                finalWipeAmount = CalculateUtil.divideSetScale((BigDecimal)actualWipeAmount.multiply(rate), (BigDecimal)financeExchangeRate, (int)2);
            }
            HashMap<String, Object> map = new HashMap<String, Object>(0);
            if (finalWipeAmount.abs().compareTo(BigDecimal.ZERO) > 0) {
                map.put("wipeamount", finalWipeAmount);
            }
            map.put("showamount", payAmount);
            map.put("paycurrency", payCurrency.getPkValue());
            map.put("payway", PaymentModeEnum.getKey((String)"giftvoucherpay"));
            map.put("srcreplacepaywayid", CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("srcreplacepaywayid")));
            map.put("paytime", TimeServiceHelper.now());
            map.put("ticketid", docTicketEntry);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private boolean isCondition(BigDecimal sumBalAmount, DynamicObjectCollection docEntry, DynamicObjectCollection docGoodsEntry, DynamicObject doTicketType, String ticketNo, BigDecimal minConsumeAmount, String newAmtPriceWay, boolean singleItemAmt, boolean singleItemQty, String goodsSeq) {
        long ticketTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doTicketType);
        String condition = DynamicObjectUtils.getString((DynamicObject)doTicketType, (String)"condition");
        if (StringUtils.equals((CharSequence)"0", (CharSequence)condition)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)condition)) {
            if (!CollectionUtils.isEmpty((Collection)docEntry)) {
                boolean rlt = docEntry.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"tickettype") == ticketTypeId);
                if (!rlt) {
                    this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u4e0d\u6ee1\u8db3\u89c4\u5219\u6761\u4ef6\uff0c\u53ea\u80fd\u4f7f\u7528\u4e00\u5f20\u3002", ticketNo));
                }
                return rlt;
            }
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)condition)) {
            boolean rlt;
            long qty = 0L;
            long cnt = 0L;
            if (!CollectionUtils.isEmpty((Collection)docEntry)) {
                cnt += docEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"tickettypeid") == ticketTypeId).count();
            }
            if (cnt == 0L) {
                return true;
            }
            if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
                this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u4e0d\u6ee1\u8db3\u89c4\u5219\u6761\u4ef6\uff0c\u672a\u5339\u914d\u5230\u9002\u7528\u5546\u54c1\u3002", ticketNo));
                return false;
            }
            if (singleItemAmt && singleItemQty) {
                long amtCnt = TicketAmountHelper.getTicketQty((List)docGoodsEntry, (DynamicObject)doTicketType, (String)goodsSeq, (String)newAmtPriceWay, (String)"1");
                long qtyCnt = TicketAmountHelper.getTicketQty((List)docGoodsEntry, (DynamicObject)doTicketType, (String)goodsSeq, (String)newAmtPriceWay, (String)"2");
                qty = Math.min(amtCnt, qtyCnt);
            } else if (singleItemAmt) {
                qty = TicketAmountHelper.getTicketQty((List)docGoodsEntry, (DynamicObject)doTicketType, (String)goodsSeq, (String)newAmtPriceWay, (String)"1");
            } else if (singleItemQty) {
                qty = TicketAmountHelper.getTicketQty((List)docGoodsEntry, (DynamicObject)doTicketType, (String)goodsSeq, (String)newAmtPriceWay, (String)"2");
            }
            if (minConsumeAmount.compareTo(BigDecimal.ZERO) > 0) {
                long minConsumeQty = CommonUtil.formatObejctToLong((Object)sumBalAmount.divideAndRemainder(minConsumeAmount)[0]);
                qty = Math.min(minConsumeQty, qty);
            }
            boolean bl = rlt = qty > cnt;
            if (!rlt) {
                if (qty == 0L) {
                    this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u4e0d\u6ee1\u8db3\u89c4\u5219\u6761\u4ef6\u7d2f\u52a0\u4f7f\u7528\uff0c\u8d2d\u4e70\u5546\u54c1\u672a\u6ee1\u8db3\u6210\u500d\u7d2f\u52a0\u89c4\u5219\u3002", ticketNo));
                } else {
                    this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u8d85\u8fc7\u7d2f\u52a0\u4f7f\u7528\u5f20\u6570\u3002", ticketNo));
                }
            }
            return rlt;
        }
        return true;
    }

    private void updateTicketRecord(DynamicObject saleOrder, DynamicObject doEntry, DynamicObject doTicket, DynamicObject doTicketType) {
        String usageMode = doTicketType.getString("usagemode");
        boolean isAllGoods = doTicketType.getBoolean("isallgoods");
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return;
        }
        switch (usageMode) {
            case "0": {
                doEntry.set("payamount", doTicket.get("ticketvalue"));
                break;
            }
            case "1": {
                BigDecimal sumBalAmount = BigDecimal.ZERO;
                BigDecimal discountRate = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketType, (String)"discountrate");
                if (isAllGoods) {
                    sumBalAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)saleOrder, (String)"sumbalamount");
                } else {
                    Map mapResult = SaleOrderHelper.calcGoodsAmount((List)docGoodsEntry, (DynamicObject)doTicketType, (String)usageMode);
                    if (mapResult.size() > 0) {
                        sumBalAmount = (BigDecimal)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getValue();
                    }
                }
                if (sumBalAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal discountAmt = sumBalAmount.multiply(discountRate).divide(new BigDecimal(100), 2, 4);
                doEntry.set("useamount", (Object)sumBalAmount.subtract(discountAmt));
                doEntry.set("payamount", (Object)sumBalAmount.subtract(discountAmt));
                break;
            }
            case "2": {
                BigDecimal sumAmount = BigDecimal.ZERO;
                if (isAllGoods) {
                    DynamicObject doGoodsEntry = docGoodsEntry.stream().findFirst().orElse(null);
                    if (doGoodsEntry != null) {
                        sumAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
                    }
                } else {
                    Map mapResult = SaleOrderHelper.calcGoodsAmount((List)docGoodsEntry, (DynamicObject)doTicketType, (String)usageMode);
                    if (mapResult.size() > 0) {
                        sumAmount = (BigDecimal)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getValue();
                    }
                }
                doEntry.set("payamount", (Object)sumAmount);
                doEntry.set("useamount", (Object)sumAmount);
                break;
            }
        }
    }

    private void clearTicket() {
        this.getView().getModel().setValue("ticketid", null);
        this.getView().updateView("ticketid");
    }

    private boolean validateEndDate(DynamicObject doTicket) {
        boolean rlt = true;
        Object sStartDate = DynamicObjectUtil.get((DynamicObject)doTicket, (String)"starttime");
        Object sEndDate = DynamicObjectUtil.get((DynamicObject)doTicket, (String)"endtime");
        try {
            Date endDate;
            Date startDate;
            if (!ObjectUtils.isEmpty((Object)sStartDate) && (startDate = (Date)sStartDate).after(TimeServiceHelper.now())) {
                this.clearTicket();
                rlt = false;
            }
            if (!ObjectUtils.isEmpty((Object)sEndDate) && (endDate = (Date)sEndDate).before(TimeServiceHelper.now())) {
                this.clearTicket();
                rlt = false;
            }
        }
        catch (Exception e1) {
            rlt = false;
        }
        return rlt;
    }

    private boolean currencyMatch(DynamicObject saleOrder, DynamicObject doTicket) {
        long ticketCurrencyId;
        boolean rlt = true;
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"currencyid");
        if (currencyId != (ticketCurrencyId = DynamicObjectUtil.getPkValue((DynamicObject)doTicket, (String)"ticketcurrencyid"))) {
            this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u5238\u9762\u5e01\u522b\u4e0e\u95e8\u5e97\u5b9a\u4ef7\u5e01\u522b\u4e0d\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u3002", doTicket.get("number")));
            this.clearTicket();
            rlt = false;
        }
        return rlt;
    }

    private boolean isMinConsumeAmount(BigDecimal sumBalAmount, String ticketNo, BigDecimal minConsumeAmount) {
        boolean rlt = true;
        if (minConsumeAmount.compareTo(BigDecimal.ZERO) > 0 && sumBalAmount.compareTo(minConsumeAmount) < 0) {
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u6700\u4f4e\u6d88\u8d39\u989d\u4e0d\u80fd\u4f4e\u4e8e%s\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u3002", ticketNo, decimalFormat.format(minConsumeAmount)));
            this.clearTicket();
            rlt = false;
        }
        return rlt;
    }

    private List<DynamicObject> getGoodsEntry(FormShowParameter frmShowParameter) {
        DynamicObjectType goodsEntryDyt;
        ArrayList<DynamicObject> lstGoodEntry = new ArrayList<DynamicObject>(0);
        Object oGoodsEntryData = frmShowParameter.getCustomParam("goodsentryentity");
        if (oGoodsEntryData == null) {
            return lstGoodEntry;
        }
        String goodsEntryData = oGoodsEntryData.toString();
        Object[] objGoodsEntry = DynamicObjectSerializeUtil.deserialize((String)goodsEntryData, (DynamicObjectType)(goodsEntryDyt = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_saleorder.goodsentryentity")));
        if (objGoodsEntry == null || objGoodsEntry.length == 0) {
            return null;
        }
        for (Object item : objGoodsEntry) {
            if (!(item instanceof DynamicObject)) continue;
            DynamicObject goodsItem = (DynamicObject)item;
            lstGoodEntry.add(goodsItem);
        }
        return lstGoodEntry;
    }
}

