/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSONArray;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class SaleOrderTicketRefundPlugin
extends AbstractBillPlugIn {
    private static final String NEEDPAYAMOUNT = "needpayamount";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
        JSONArray ticketArray = (JSONArray)frmShowParameter.getCustomParam("ticketarray");
        DynamicObjectCollection docTicketEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (ticketArray != null && ticketArray.size() > 0) {
            for (int i = 0; i < ticketArray.size(); ++i) {
                DynamicObject doEntry = docTicketEntry.addNew();
                doEntry.set("ticketnumber", ticketArray.getJSONObject(i).get((Object)"cardno"));
                doEntry.set("payamount", ticketArray.getJSONObject(i).get((Object)"refundamount"));
                doEntry.set("payflowid", ticketArray.getJSONObject(i).get((Object)"payflowid"));
                doEntry.set("srcreplacepaywayid", ticketArray.getJSONObject(i).get((Object)"srcreplacepaywayid"));
            }
        }
        BigDecimal needPayAmount = CommonUtil.formatObjectToDecimal((Object)frmShowParameter.getCustomParam(NEEDPAYAMOUNT));
        this.getPageCache().put(NEEDPAYAMOUNT, needPayAmount.toString());
        this.getView().getModel().setValue(NEEDPAYAMOUNT, (Object)needPayAmount);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName())) {
            DynamicObjectCollection docEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            BigDecimal needPayAmount = new BigDecimal(this.getPageCache().get(NEEDPAYAMOUNT));
            if (!ObjectUtils.isEmpty((Object)docEntry)) {
                for (DynamicObject doEntry : docEntry) {
                    BigDecimal payAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doEntry, (String)"payamount");
                    needPayAmount = needPayAmount.subtract(payAmount);
                    this.getView().getModel().setValue(NEEDPAYAMOUNT, (Object)needPayAmount);
                }
            } else {
                this.getView().getModel().setValue(NEEDPAYAMOUNT, (Object)needPayAmount);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            DynamicObjectCollection docTicketEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (docTicketEntry == null || docTicketEntry.getRowCount() == 0) {
                this.getView().showErrorNotification("\u672a\u9009\u62e9\u652f\u4ed8\u793c\u5238\u3002");
                return;
            }
            BigDecimal payAmount = BigDecimal.ZERO;
            for (DynamicObject doTicketEntry : docTicketEntry) {
                payAmount = payAmount.add(doTicketEntry.getBigDecimal("payamount"));
            }
            HashMap<String, Serializable> map = new HashMap<String, Serializable>(0);
            map.put("showamount", payAmount);
            map.put("payway", Long.valueOf(PaymentModeEnum.getKey((String)"giftvoucherpay")));
            map.put("paytime", TimeServiceHelper.now());
            map.put("ticketid", (Serializable)docTicketEntry);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }
}

