/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.pay;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.pay.payment.vo.PaymentRecord;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.ocpos.business.commonhelper.AmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class SaleOrderUmsScanPlugin
extends OcbaseFormPlugin {
    private static final String QRCODE = "qrcode";
    public static final String BTN_OK = "btnok";
    public static final String PAYAMOUNT = "payamount";
    public static final String SALEOPTION = "saleoption";
    public static final String ORDERNO = "orderno";
    public static final String PAYFLOWID = "payflowid";
    private static Log logger = LogFactory.getLog(SaleOrderHelper.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityId = (String)formShowParameter.getCustomParam("entityid");
        String saleOption = formShowParameter.getCustomParam(SALEOPTION) == null ? "1" : (String)formShowParameter.getCustomParam(SALEOPTION);
        this.getModel().setValue(SALEOPTION, (Object)saleOption);
        this.getModel().setValue(ORDERNO, formShowParameter.getCustomParam(ORDERNO));
        this.getModel().setValue(PAYFLOWID, formShowParameter.getCustomParam(PAYFLOWID));
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)entityId);
        BigDecimal hasPayAmount = CommonUtil.formatObjectToDecimal((Object)formShowParameter.getCustomParam("haspayamount"));
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        if (saleOption.equalsIgnoreCase("0")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{PAYAMOUNT});
            this.getModel().setValue(PAYAMOUNT, (Object)hasPayAmount);
            this.getModel().setValue(QRCODE, formShowParameter.getCustomParam(ORDERNO));
        } else {
            this.getModel().setValue(PAYAMOUNT, (Object)AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (long)branchId, (BigDecimal)hasPayAmount));
        }
    }

    public void afterBindData(EventObject e) {
        String saleOption;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String string = saleOption = formShowParameter.getCustomParam(SALEOPTION) == null ? "1" : (String)formShowParameter.getCustomParam(SALEOPTION);
        if (StringUtils.equals((CharSequence)"0", (CharSequence)saleOption)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{QRCODE});
        } else {
            TextEdit qrCode = (TextEdit)this.getView().getControl(QRCODE);
            qrCode.setFocus(true);
            qrCode.setFireFocus(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)QRCODE)) {
            this.umsScanPay();
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTN_OK)) {
            String saleOption;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String string = saleOption = formShowParameter.getCustomParam(SALEOPTION) == null ? "1" : (String)formShowParameter.getCustomParam(SALEOPTION);
            if (StringUtils.equals((CharSequence)"0", (CharSequence)saleOption)) {
                this.umsScanPay();
            }
        }
    }

    private void umsScanPay() {
        LocaleString paramLocaleString;
        BigDecimal totalAmount = BigDecimalUtil.toBigDecimal((Object)this.getModel().getValue(PAYAMOUNT));
        String authCode = (String)this.getModel().getDataEntity(true).get(QRCODE);
        if (StringUtils.isEmpty((CharSequence)authCode)) {
            return;
        }
        String isFail = this.getPageCache().get("isfail");
        if (StringUtils.equals((CharSequence)isFail, (CharSequence)"1")) {
            this.getPageCache().put("isfail", "0");
            this.getModel().setValue(QRCODE, null);
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        String entityId = (String)formShowParameter.getCustomParam("entityid");
        long payWayId = CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("paywayid"));
        long payWayTypeId = CommonUtil.formatObejctToLong((Object)formShowParameter.getCustomParam("paywaytypeid"));
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)entityId);
        String hasPayAmountStr = formShowParameter.getCustomParam("haspayamount").toString();
        BigDecimal needPayAmount = new BigDecimal(hasPayAmountStr);
        String saleOption = formShowParameter.getCustomParam(SALEOPTION) == null ? "1" : (String)formShowParameter.getCustomParam(SALEOPTION);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        BigDecimal finalWipeAmount = BigDecimal.ZERO;
        PaymentRecord payRecord = new PaymentRecord();
        if (needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showErrorNotification("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u53d1\u8d77\u652f\u4ed8\u3002");
            return;
        }
        if (totalAmount.abs().compareTo(needPayAmount.abs()) > 0) {
            this.getView().showErrorNotification("\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u3002");
            return;
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)saleOption)) {
            if (totalAmount.compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showErrorNotification("\u652f\u4ed8\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
                return;
            }
            payRecord.setPaytime(TimeServiceHelper.now());
            paramLocaleString = new LocaleString("\u652f\u4ed8\u4e2d...");
        } else {
            if (totalAmount.compareTo(BigDecimal.ZERO) >= 0) {
                this.getView().showErrorNotification("\u9000\u6b3e\u91d1\u989d\u5e94\u5c0f\u4e8e0\u3002");
                return;
            }
            payRecord.setPaytime(DateUtil.getDateTimeFormat((String)formShowParameter.getCustomParam("paytime").toString()));
            paramLocaleString = new LocaleString("\u9000\u6b3e\u4e2d...");
        }
        payRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)saleOrder).longValue());
        payRecord.setBillNo(saleOrder.getString("billno"));
        long payFlowId = CommonUtil.formatObejctToLong((Object)this.getModel().getValue(PAYFLOWID));
        payRecord.setPayFlowId(payFlowId);
        payRecord.setSourcebillId(DynamicObjectUtil.getLong((DynamicObject)saleOrder, (String)"sourcebillid"));
        payRecord.setOrderNo(authCode);
        DynamicObject payCurrency = saleOrder.getDynamicObject("currencyid");
        long payCurrencyId = Long.parseLong(payCurrency.getPkValue().toString());
        payRecord.setPayCurrency(payCurrency);
        DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)payWayId, (String)"ocdbd_paymode");
        payRecord.setPayWay(payWay);
        DynamicObject payType = StringUtils.equals((CharSequence)"1", (CharSequence)saleOption) ? SaleOrderHelper.getPayWayType((DynamicObject)payWay, (String)authCode) : (payWayTypeId > 0L ? BusinessDataServiceHelper.loadSingle((Object)payWayTypeId, (String)"ocdbd_paywaytype") : SaleOrderHelper.getPayWayType((DynamicObject)payWay));
        payRecord.setPayWayType(payType);
        payRecord.setAmount(totalAmount);
        this.getView().showLoading(paramLocaleString);
        String failMsg = "";
        JSONObject payResult = SaleOrderHelper.callUnifyElecSettle((DynamicObject)saleOrder, (PaymentRecord)payRecord, (String)saleOption);
        logger.info("\u94f6\u8054\u626b\u7801\u8fd4\u56de\u7ed3\u679c:" + JSONObject.toJSONString((Object)payResult));
        boolean isSuccess = payResult.getBoolean("success");
        String suceessMsg = "";
        if (isSuccess) {
            DynamicObjectCollection finEntryEntity = saleOrder.getDynamicObjectCollection("finentity");
            DynamicObject newFinEntity = finEntryEntity.addNew();
            if (StringUtils.equals((CharSequence)"1", (CharSequence)saleOption)) {
                SaleOrderHelper.updateSaleOrderAfterPayment((DynamicObject)saleOrder, (DynamicObject)newFinEntity, (PaymentRecord)payRecord, (Map)payResult.getJSONObject("payResponse"));
                suceessMsg = "\u652f\u4ed8\u6210\u529f";
            } else {
                SaleOrderHelper.updateSaleOrderAfterRefund((DynamicObject)saleOrder, (DynamicObject)newFinEntity, (PaymentRecord)payRecord, (Map)payResult.getJSONObject("payResponse"));
                suceessMsg = "\u9000\u6b3e\u6210\u529f";
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
            HashMap<String, Serializable> map = new HashMap<String, Serializable>(0);
            map.put("showamount", payRecord.getAmount());
            map.put("paycurrency", Long.valueOf(payCurrencyId));
            map.put("payway", (Serializable)payRecord.getPayWay());
            map.put("paywaytype", (Serializable)payRecord.getPayWayType());
            map.put(PAYFLOWID, Long.valueOf(payFlowId));
            map.put("paytime", payRecord.getPaytime());
            if (finalWipeAmount.compareTo(BigDecimal.ZERO) > 0) {
                map.put("wipeamount", finalWipeAmount);
            }
            this.getView().showConfirm(suceessMsg, MessageBoxOptions.OK);
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else {
            failMsg = StringUtils.equals((CharSequence)"1", (CharSequence)saleOption) ? "\u652f\u4ed8\u5931\u8d25" + payResult.getString("errorMsg") : "\u9000\u6b3e\u5931\u8d25" + payResult.getString("errorMsg");
            this.getView().showConfirm(failMsg, MessageBoxOptions.OK);
            this.getModel().setValue(QRCODE, null);
            this.getPageCache().put("isfail", "1");
        }
        this.getView().hideLoading();
    }
}

