/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.enums.ReturnModelEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.FormViewUtil;

public class DiscountHandleFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        BigDecimal giftDiscountAmt = CommonUtil.formatObjectToDecimal((Object)parameter.getCustomParam("giftdiscountamount"));
        BigDecimal ticketDiscountAmt = CommonUtil.formatObjectToDecimal((Object)parameter.getCustomParam("coupondiscount"));
        BigDecimal integralDiscountAmt = CommonUtil.formatObjectToDecimal((Object)parameter.getCustomParam("integraldistamount"));
        BigDecimal srcAmount = CommonUtil.formatObjectToDecimal((Object)parameter.getCustomParam("srcamount"));
        String pointReturnMode = (String)parameter.getCustomParam("pointreturnmode");
        String ticketReturnMode = (String)parameter.getCustomParam("cashcouponreturnmode");
        DynamicObjectCollection docEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (docEntry == null) {
            return;
        }
        String retDiscountHandleWay = (String)parameter.getCustomParam("retdiscounthandleway");
        if (ticketDiscountAmt.abs().compareTo(BigDecimal.ZERO) > 0) {
            this.createNewTicketEntry(docEntry, ticketDiscountAmt, srcAmount, ticketReturnMode, retDiscountHandleWay);
        }
        if (integralDiscountAmt.abs().compareTo(BigDecimal.ZERO) > 0) {
            this.createNewPointEntry(docEntry, integralDiscountAmt, srcAmount, pointReturnMode, retDiscountHandleWay);
        }
        if (giftDiscountAmt.abs().compareTo(BigDecimal.ZERO) > 0) {
            this.createNewGiftEntry(docEntry, giftDiscountAmt, srcAmount, retDiscountHandleWay);
        }
        this.getView().updateView("entryentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            DynamicObjectCollection docEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)docEntry)) {
                return;
            }
            ArrayList<DynamicObject> lstSelRow = new ArrayList<DynamicObject>(0);
            StringBuilder sbMsg = new StringBuilder();
            for (DynamicObject doEntry : docEntry) {
                boolean isSelect = DynamicObjectUtils.getBoolean((DynamicObject)doEntry, (String)"chkselect");
                String distSrcType = DynamicObjectUtils.getString((DynamicObject)doEntry, (String)"distsrctype");
                if (!isSelect) continue;
                if (lstSelRow.stream().anyMatch(x -> distSrcType.equals(DynamicObjectUtils.getString((DynamicObject)x, (String)"distsrctype")))) {
                    if (sbMsg.length() > 0) {
                        sbMsg.append("\r\n");
                    }
                    if ("1".equals(distSrcType)) {
                        sbMsg.append("\u5238\u4f18\u60e0\u989d\u53ea\u80fd\u9009\u62e9\u4e00\u79cd\u4f18\u60e0\u5904\u7406\u65b9\u5f0f");
                    } else if ("2".equals(distSrcType)) {
                        sbMsg.append("\u79ef\u5206\u4f18\u60e0\u989d\u53ea\u80fd\u9009\u62e9\u4e00\u79cd\u4f18\u60e0\u5904\u7406\u65b9\u5f0f");
                    } else {
                        sbMsg.append("\u8d60\u54c1\u4f18\u60e0\u989d\u53ea\u80fd\u9009\u62e9\u4e00\u79cd\u4f18\u60e0\u5904\u7406\u65b9\u5f0f");
                    }
                }
                lstSelRow.add(doEntry);
            }
            if (docEntry.stream().anyMatch(x -> "1".equals(DynamicObjectUtils.getString((DynamicObject)x, (String)"distsrctype"))) && docEntry.stream().noneMatch(x -> "1".equals(DynamicObjectUtils.getString((DynamicObject)x, (String)"distsrctype")) && DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"chkselect"))) {
                if (sbMsg.length() > 0) {
                    sbMsg.append("\r\n");
                }
                sbMsg.append("\u8bf7\u9009\u62e9\u5238\u4f18\u60e0\u989d\u5904\u7406\u65b9\u5f0f");
            }
            if (docEntry.stream().anyMatch(x -> "2".equals(DynamicObjectUtils.getString((DynamicObject)x, (String)"distsrctype"))) && docEntry.stream().noneMatch(x -> "2".equals(DynamicObjectUtils.getString((DynamicObject)x, (String)"distsrctype")) && DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"chkselect"))) {
                if (sbMsg.length() > 0) {
                    sbMsg.append("\r\n");
                }
                sbMsg.append("\u8bf7\u9009\u62e9\u79ef\u5206\u4f18\u60e0\u989d\u5904\u7406\u65b9\u5f0f");
            }
            if (docEntry.stream().anyMatch(x -> "3".equals(DynamicObjectUtils.getString((DynamicObject)x, (String)"distsrctype"))) && docEntry.stream().noneMatch(x -> "3".equals(DynamicObjectUtils.getString((DynamicObject)x, (String)"distsrctype")) && DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"chkselect"))) {
                if (sbMsg.length() > 0) {
                    sbMsg.append("\r\n");
                }
                sbMsg.append("\u8bf7\u9009\u62e9\u8d60\u54c1\u4f18\u60e0\u989d\u5904\u7406\u65b9\u5f0f");
            }
            if (sbMsg.length() > 0) {
                NotificationUtil.showDefaultTipNotify((String)sbMsg.toString(), (IFormView)this.getView());
                return;
            }
            if (lstSelRow.size() == 0) {
                this.getView().showErrorNotification("\u8bf7\u9009\u62e9\u4f18\u60e0\u5904\u7406\u65b9\u5f0f\u3002");
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>(0);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String giftValueData = (String)parameter.getCustomParam("giftvalue");
            data.put("data", lstSelRow);
            data.put("giftvalue", giftValueData);
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }

    private void createNewPointEntry(DynamicObjectCollection docEntry, BigDecimal discountAmt, BigDecimal srcAmount, String pointReturnMode, String retDiscountHandleWay) {
        if (pointReturnMode.equals(ReturnModelEnum.DeductionByValue.getValue())) {
            this.createNewEntry(docEntry, "1", discountAmt, srcAmount, "2", retDiscountHandleWay, true);
        } else if (pointReturnMode.equals(ReturnModelEnum.CustomerCompensation.getValue())) {
            this.createNewEntry(docEntry, "2", discountAmt, srcAmount, "2", retDiscountHandleWay, true);
        } else {
            this.createNewEntry(docEntry, "1", discountAmt, srcAmount, "2", retDiscountHandleWay, false);
            this.createNewEntry(docEntry, "2", discountAmt, srcAmount, "2", retDiscountHandleWay, false);
        }
    }

    private void createNewTicketEntry(DynamicObjectCollection docEntry, BigDecimal discountAmt, BigDecimal srcAmount, String ticketReturnMode, String retDiscountHandleWay) {
        if (ticketReturnMode.equals(ReturnModelEnum.DeductionByValue.getValue())) {
            this.createNewEntry(docEntry, "1", discountAmt, srcAmount, "1", retDiscountHandleWay, true);
        } else if (ticketReturnMode.equals(ReturnModelEnum.CustomerCompensation.getValue())) {
            this.createNewEntry(docEntry, "2", discountAmt, srcAmount, "1", retDiscountHandleWay, true);
        } else {
            this.createNewEntry(docEntry, "1", discountAmt, srcAmount, "1", retDiscountHandleWay, false);
            this.createNewEntry(docEntry, "2", discountAmt, srcAmount, "1", retDiscountHandleWay, false);
        }
    }

    private void createNewGiftEntry(DynamicObjectCollection docEntry, BigDecimal discountAmt, BigDecimal srcAmount, String retDiscountHandleWay) {
        this.createNewEntry(docEntry, "1", discountAmt, srcAmount, "3", retDiscountHandleWay, false);
        this.createNewEntry(docEntry, "2", discountAmt, srcAmount, "3", retDiscountHandleWay, false);
    }

    private void createNewEntry(DynamicObjectCollection docEntry, String discountType, BigDecimal discountAmt, BigDecimal srcAmount, String distSrcType, String retDiscountHandleWay, boolean isSelect) {
        DynamicObject doEntry = docEntry.addNew();
        if (isSelect) {
            doEntry.set("chkselect", (Object)Boolean.TRUE);
            FormViewUtil.setUnEnable((IFormView)this.getView(), (int)(docEntry.getRowCount() - 1), (String[])new String[]{"chkselect"});
        }
        doEntry.set("discounttype", (Object)discountType);
        doEntry.set("discountamount", (Object)discountAmt);
        if (StringUtils.equals((CharSequence)retDiscountHandleWay, (CharSequence)"C")) {
            discountAmt = discountAmt.setScale(0, 1);
        }
        doEntry.set("afdiscountamount", (Object)discountAmt);
        doEntry.set("srcamount", (Object)srcAmount);
        doEntry.set("distsrctype", (Object)distSrcType);
    }
}

