/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.AbstractFormPlugin;

public class DiscountWayEditPlugin
extends AbstractFormPlugin {
    private static final String KEY_DISCOUNT = "rdodiscount";
    private static final String KEY_DISCOUNTVALUE = "discountvalue";
    private static final String KEY_BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getView().getControl(KEY_BTNOK);
        btnOk.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        this.getModel().setValue("basebilltype", customParams.get("basebilltype"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)KEY_DISCOUNT, (CharSequence)key)) {
            String discountWay = String.valueOf(e.getChangeSet()[0].getNewValue());
            DecimalEdit de = (DecimalEdit)this.getControl(KEY_DISCOUNTVALUE);
            switch (discountWay) {
                case "1": {
                    de.setCaption(new LocaleString("\u6574\u5355\u6298\u7387(%)"));
                    break;
                }
                case "2": {
                    de.setCaption(new LocaleString("\u6574\u5355\u91d1\u989d"));
                    break;
                }
                case "3": {
                    if (!this.isSelectGoods(discountWay)) {
                        return;
                    }
                    de.setCaption(new LocaleString("\u5355\u54c1\u5b9e\u4ef7"));
                    break;
                }
                case "4": {
                    if (!this.isSelectGoods(discountWay)) {
                        return;
                    }
                    de.setCaption(new LocaleString("\u6298\u6263\u7387(%)"));
                    break;
                }
            }
            this.getView().updateView(KEY_DISCOUNTVALUE);
        }
    }

    private boolean isSelectGoods(String discountWay) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getParentView().getControl("goodsentryentity");
        int[] selRow = entryGrid.getSelectRows();
        if (selRow.length == 0) {
            this.getView().getModel().setValue(KEY_DISCOUNT, (Object)"1");
            if (StringUtils.equals((CharSequence)"3", (CharSequence)discountWay)) {
                this.getView().showErrorNotification("\u6ca1\u6709\u9009\u62e9\u5546\u54c1\u884c\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u5355\u54c1\u5b9a\u4ef7\u3002");
            } else if (StringUtils.equals((CharSequence)"4", (CharSequence)discountWay)) {
                this.getView().showErrorNotification("\u6ca1\u6709\u9009\u62e9\u5546\u54c1\u884c\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u5355\u54c1\u6298\u6263\u3002");
            }
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BTNOK)) {
            String discountWay = String.valueOf(this.getModel().getValue(KEY_DISCOUNT));
            BigDecimal discountValue = (BigDecimal)this.getModel().getValue(KEY_DISCOUNTVALUE);
            if (discountValue.compareTo(BigDecimal.ZERO) > 0) {
                HashMap<String, Object> mapDiscount = new HashMap<String, Object>(2);
                mapDiscount.put("discountWay", discountWay);
                mapDiscount.put("discountValue", discountValue);
                this.getView().returnDataToParent(mapDiscount);
                this.getView().close();
            } else {
                switch (discountWay) {
                    case "1": {
                        this.getView().showErrorNotification("\u8bf7\u8f93\u5165\u6574\u5355\u6298\u7387(%)\u3002");
                        break;
                    }
                    case "2": {
                        this.getView().showErrorNotification("\u8bf7\u8f93\u5165\u6574\u5355\u91d1\u989d\u3002");
                        break;
                    }
                    case "3": {
                        this.getView().showErrorNotification("\u8bf7\u8f93\u5165\u5355\u54c1\u5b9e\u4ef7\u3002");
                        break;
                    }
                    case "4": {
                        this.getView().showErrorNotification("\u8bf7\u8f93\u5165\u6298\u6263\u7387(%)\u3002");
                        break;
                    }
                }
            }
        }
    }
}

